/* switcher.c - on/off switcher functions
 * 
 * Copyright (C) 2004, 2005 Anderson Lizardo
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#include "geniusvp2-parport.h"
#include "geniusvp2-switcher.h"

static int
switcher (unsigned char sequence, unsigned char onoff)
{
    int offset, bit;

    sane_geniusvp2_pp_write (PP_CONTROL, 0xc4);
    sane_geniusvp2_pp_write (PP_DATA, 0xff);
    sane_geniusvp2_pp_write (PP_DATA, 0xfe);
    sane_geniusvp2_pp_write (PP_DATA, 0xff);

    for (bit = 7; bit >= 0; bit--)
    {
        offset = ((sequence >> bit) & 0x01) << 1;
        offset |= onoff;
        sane_geniusvp2_pp_write (PP_DATA, 0x71 + offset);      /* send a double clock pulse */
        sane_geniusvp2_pp_write (PP_DATA, 0xf1 + offset);
        sane_geniusvp2_pp_write (PP_DATA, 0x71 + offset);
        sane_geniusvp2_pp_write (PP_DATA, 0xf1 + offset);
        sane_geniusvp2_pp_write (PP_DATA, 0x71 + offset);
    }

    sane_geniusvp2_pp_write (PP_DATA, 0xff);

    if (onoff == 0x04)
    {                           /* scanner is online */
        sane_geniusvp2_pp_write (PP_DATA, 0xfe);       /* let the ASIC work */
        sane_geniusvp2_pp_write (PP_DATA, 0xff);
    }

    return 0;
}

int
sane_geniusvp2_scanner_on (void)
{
    return switcher (0xf9, 0x04);
}

int
sane_geniusvp2_scanner_off (void)
{
    return switcher (0xf0, 0x00);
}
