#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc CreateGraphs {} {
    global graph
    global graphHorz
    global graphVert
    global canvas

    # we need to manually set the plot bg color, i.e. use the default bg
    set plotColor [.ds9 cget -background]

    set graph(spacer) [frame .ds9.spacer \
			   -width $graph(marginX) -height $graph(marginY)]

    set graphHorz(name) [blt::graph .ds9.horz \
			     -width $canvas(width) -height $graph(size) \
			     -bd 0 -plotborderwidth 2 -plotrelief groove \
			     -title "" \
			     -plotpadx 0 -plotpady 0 \
			     -leftmargin 1 -topmargin 4 \
			     -rightmargin $graph(marginX) \
			     -bottommargin 8 -plotbackground $plotColor \
			     -takefocus 0 \
			    ]

    # wee need to manually set the element foreground color, i.e. use graph fg
    set fgColor [$graphHorz(name) cget -foreground]

    # Horizontal Graph

    $graphHorz(name) element create line1 \
	-xdata graphHorzX -ydata graphHorzY -color $fgColor -symbol ""
    $graphHorz(name) legend configure -hide yes
    $graphHorz(name) xaxis configure -title "" -hide yes
    $graphHorz(name) x2axis configure -title "" -hide yes
    $graphHorz(name) yaxis configure -title "" -hide yes
    $graphHorz(name) y2axis configure -title "" -hide no -color $fgColor \
	-ticklength 4 -tickfont $graph(font)
    $graphHorz(name) grid configure -mapy y -dashes ""
    $graphHorz(name) crosshairs configure -color green
    $graphHorz(name) element configure line1 -hide yes

    bind $graphHorz(name) <Enter> [list EnterGraph $graphHorz(name) 1]
    bind $graphHorz(name) <Leave> [list LeaveGraph $graphHorz(name)]
    bind $graphHorz(name) <Button-1> \
	[list MotionGraph $graphHorz(name) %x %y 1]
    bind $graphHorz(name) <B1-Motion> \
	[list MotionGraph $graphHorz(name) %x %y 1]
    bind $graphHorz(name) <Up> [list ArrowKeyGraph $graphHorz(name) 0 -1 1]
    bind $graphHorz(name) <Down> [list ArrowKeyGraph $graphHorz(name) 0 1 1]
    bind $graphHorz(name) <Left> [list ArrowKeyGraph $graphHorz(name) -1 0 1]
    bind $graphHorz(name) <Right> [list ArrowKeyGraph $graphHorz(name) 1 0 1]

    # Vertical Graph

    set graphVert(name) [blt::graph .ds9.vert \
			     -width $graph(size) -height $canvas(height) \
			     -bd 0 -plotborderwidth 2 -plotrelief groove \
			     -title "" -invertxy yes \
			     -plotpadx 0 -plotpady 0 \
			     -leftmargin 8 -topmargin 1 \
			     -bottommargin $graph(marginY) \
			     -rightmargin 4 -plotbackground $plotColor \
			     -takefocus 0 \
			    ]

    $graphVert(name) element create line1 \
	-xdata graphVertX -ydata graphVertY -color $fgColor -symbol ""
    $graphVert(name) legend configure -hide yes
    $graphVert(name) xaxis configure -title "" -hide yes -descending 1
    $graphVert(name) x2axis configure -title "" -hide yes -descending 1
    $graphVert(name) yaxis configure -title "" -hide no \
	-descending yes -color $fgColor -ticklength 4 -tickfont $graph(font)
    $graphVert(name) y2axis configure -title "" -hide yes -descending yes
    $graphVert(name) grid configure -mapy y -dashes ""
    $graphVert(name) crosshairs configure -color green
    $graphVert(name) element configure line1 -hide yes

    bind $graphVert(name) <Enter> [list EnterGraph $graphVert(name) 0]
    bind $graphVert(name) <Leave> [list LeaveGraph $graphVert(name)]
    bind $graphVert(name) <Button-1> \
	[list MotionGraph $graphVert(name) %x %y 0]
    bind $graphVert(name) <B1-Motion> \
	[list MotionGraph $graphVert(name) %x %y 0]
    bind $graphVert(name) <Up> [list ArrowKeyGraph $graphVert(name) 0 -1 0]
    bind $graphVert(name) <Down> [list ArrowKeyGraph $graphVert(name) 0 1 0]
    bind $graphVert(name) <Left> [list ArrowKeyGraph $graphVert(name) -1 0 0]
    bind $graphVert(name) <Right> [list ArrowKeyGraph $graphVert(name) 1 0 0]

    UpdateGraphGrid
}

proc UpdateGraphGrid {} {
    global graphHorz
    global graphVert

    $graphHorz(name) grid configure -hide [expr !$graphHorz(grid)]
    $graphVert(name) grid configure -hide [expr !$graphVert(grid)]
}

proc UpdateGraphXAxis {} {
    global ds9
    global graphHorz
    global graphVert

    # if not xpa update, don't update
    if {!$ds9(xpa,idletasks)} {
	return
    }

    global debug
    if {$debug(tcl,update)} {
	puts "UpdateGraphXAxis"
    }

    if {$graphHorz(view) || $graphVert(view)} {
	global debug
	if {$debug(tcl,idletasks)} {
	    puts "UpdateGraphXAxis"
	}
	update idletasks
    }
    
    if {$graphHorz(view)} {
	UpdateGraphXAxisHV $graphHorz(name) graphHorzX graphHorzY 1
    }
    
    if {$graphVert(view)} {
	UpdateGraphXAxisHV $graphVert(name) graphVertX graphVertY 0
    }
}

proc UpdateGraphXAxisHV {which vectorX vectorY cut} {
    global current
    global graph
    global graphHorzX graphHorzY
    global graphVertX graphVertY

    if {$current(frame) != ""} {
	set xMin [expr "$$vectorX\(min\)"]
	set xMax [expr "$$vectorX\(max\)"]

	$which xaxis configure -min $xMin -max $xMax
	$which x2axis configure -min $xMin -max $xMax
    } else {
	$which xaxis configure -min $graph(xMin) -max $graph(xMax)
	$which x2axis configure -min $graph(xMin) -max $graph(xMax)
    }
}

proc UpdateGraphYAxis {} {
    global ds9
    global graphHorz
    global graphVert

    # if not xpa update, don't update
    if {!$ds9(xpa,idletasks)} {
	return
    }

    global debug
    if {$debug(tcl,update)} {
	puts "UpdateGraphYAxis"
    }

    if {$graphHorz(view) || $graphVert(view)} {
	global debug
	if {$debug(tcl,idletasks)} {
	    puts "UpdateGraphYAxis"
	}
	update idletasks
    }
    
    if {$graphHorz(view)} {
	UpdateGraphYAxisHV $graphHorz(name) $graphHorz(log)
    }

    if {$graphVert(view)} {
	UpdateGraphYAxisHV $graphVert(name) $graphVert(log)
    }
}

proc UpdateGraphYAxisHV {which log} {
    global current
    global graph

    if {$current(frame) != ""} {

	set minmax [$current(frame) get clip]
	set yMin [lindex $minmax 0]
	set yMax [lindex $minmax 1]

	if {$yMin >= $yMax} {
	    set yMax [expr $yMin + 1]
	}

	$which yaxis configure -min $yMin -max $yMax -logscale $log
	$which y2axis configure -min $yMin -max $yMax -logscale $log
    } else {
	$which yaxis configure -min $graph(yMin) -max $graph(yMax) \
	    -logscale $log
	$which y2axis configure -min $graph(yMin) -max $graph(yMax) \
	    -logscale $log
    }
}

proc ShowGraphData {} {
    global graphHorz
    global graphVert

    if {$graphHorz(view)} {
	ShowGraphDataHV $graphHorz(name)
    }
    if {$graphVert(view)} {
	ShowGraphDataHV $graphVert(name)
    }
}

proc ShowGraphDataHV {which} {
    global current

    if {$current(frame) != ""} {
	if {[$current(frame) has fits]} {
	    $which element configure line1 -hide no
	} else {
	    $which element configure line1 -hide yes
	}
    } else {
	$which element configure line1 -hide yes
    }
}

proc ClearGraphData {} {
    global graphHorz
    global graphVert

    if {$graphHorz(view)} {
	$graphHorz(name) element configure line1 -hide yes
    }    

    if {$graphVert(view)} {
	$graphVert(name) element configure line1 -hide yes
    }
}

proc UpdateGraph {which x y sys} {
    global graphHorz
    global graphVert

    if {[$which has fits]} {
	if {$graphHorz(view)} {
	    $which get horizontal cut graphHorzX graphHorzY $x $y $sys
	    $graphHorz(name) element configure line1 -hide no
	}

	if {$graphVert(view)} {
	    $which get vertical cut graphVertX graphVertY $x $y $sys
	    $graphVert(name) element configure line1 -hide no
	}
    }
}

proc EnterGraph {which horz} {
    global ds9
    global current

    focus $which
    $which crosshairs on

    if {$current(frame) != "" && $ds9(mode) == "crosshair"} {
	set cursor [$which crosshairs cget -position]
	scan $cursor "@%d,%d" x y

	set coord [$current(frame) get crosshair canvas]
	set X [lindex $coord 0]
	set Y [lindex $coord 1]

	if {$horz} {
	    EnterInfoBox $current(frame) $x $Y canvas
	    UpdatePixelTable $current(frame) $x $Y canvas
	} else {
	    EnterInfoBox $current(frame) $X $y canvas
	    UpdatePixelTable $current(frame) $X $y canvas
	}
    }
}

proc LeaveGraph {which} {
    focus {}
    $which crosshairs off

    LeaveInfoBox
    ClearPixelTable
}

proc MotionGraph {which x y horz} {
    global ds9
    global current

    $which crosshairs configure -position "@$x,$y"

    if {$current(frame) != "" && $ds9(mode) == "crosshair"} {

	set coord [$current(frame) get crosshair canvas]
	set X [lindex $coord 0]
	set Y [lindex $coord 1]

	if {$horz} {
	    MotionInfoBox $current(frame) $x $Y canvas
	    UpdatePixelTable $current(frame) $x $Y canvas
	} else {
	    MotionInfoBox $current(frame) $X $y canvas
	    UpdatePixelTable $current(frame) $X $y canvas
	}
    }    
}

proc ArrowKeyGraph {which x y horz} {
    set cursor [$which crosshairs cget -position]
    scan $cursor "@%d,%d" cx cy

    set cx [expr $cx+$x]
    set cy [expr $cy+$y]

    MotionGraph $which $cx $cy $horz
}
