// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "colorbarbase.h"

// Parser Stuff

#undef yyFlexLexer
#define yyFlexLexer cbFlexLexer
#include <FlexLexer.h>

static cbFlexLexer* lex = NULL;    // used by cblex
static ColorbarBase* cb = NULL;        // used by cberror
extern int cbparse(void*);

// Non-Member Functions

int cblex()
{
  return (lex ? lex->yylex() : 0);
}

void cberror(const char* m)
{
  if (cb) {
    cb->error(m);
    const char* cmd = lex ? lex->YYText() : (const char*)NULL;
    if (cmd && cmd[0] != '\n') {
      cb->error(": ");
      cb->error(cmd);
    }
  }
}

// Public Member Functions

ColorbarBase::ColorbarBase(Tcl_Interp* i, Tk_Canvas c, Tk_Item* item) 
  : Widget(i, c, item)
{
  colorCells = NULL;
  colorCount = 0;
}

ColorbarBase::~ColorbarBase()
{
  if (colorCells)
    delete [] colorCells;
}

// Required Virtual Functions

#if __GNUC__ >= 3
int ColorbarBase::parse(istringstream& istr)
#else
int ColorbarBase::parse(istrstream& istr)
#endif
{
  result = TCL_OK;
  lex = new cbFlexLexer(&istr);
  cb = this;
  cbparse(this);

  delete lex;
  return result;
}

int ColorbarBase::configure(int argc, const char* argv[], int flags)
{
  if (Widget::configure(argc, argv, flags) == TCL_ERROR)
    return TCL_ERROR;

  // only valid for the initial configuration call

  if (flags != TK_CONFIG_ARGV_ONLY)
    return initColormap();
  else
    return TCL_OK;
}



