// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "outfits.h"
#include "util.h"

OutFitsStream::OutFitsStream()
{
  valid_ = 0;
}

OutFitsStream::~OutFitsStream()
{
}

int OutFitsStream::writeSwap(char* d, int s, int bitpix)
{
  char r[8];

  switch (bitpix) {
  case 8:
    write(d, s);
    break;
  case 16:
  case -16:
    {
      for (int i=0; i<s; i+=2) {
	swap2(d+i,r);
	write(r, 2);
      }
    }
  break;
  case 32:
  case -32:
    {
      for (int i=0; i<s; i+=4) {
	swap4(d+i,r);
	write(r, 4);
      }
    }
  break;
  case -64:
    {
      for (int i=0; i<s; i+=8) {
	swap8(d+i,r);
	write(r, 8);
      }
    }
  break;
  }

  return s;
}
