
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Krishnan Subramani  
//          Umesh Kumar V. Rajasekaran
//	    Magnus Danielson	cfmd@swipnet.se

#include "IIRScram.hh"
#include "IIR_AssertionStatement.hh"
#include "IIR_Identifier.hh"
#include "IIR_AboveAttribute.hh"
#include "IIR_Label.hh"

IIRScram_AssertionStatement::~IIRScram_AssertionStatement(){}

void 
IIRScram_AssertionStatement::_publish_vhdl(ostream &_vhdl_out) {

  _publish_vhdl_stmt_label(_vhdl_out);

  _vhdl_out << "  assert (";
  get_assertion_condition()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ")";

  if(get_report_expression() != NULL) {
    _vhdl_out << "\n  report ";
    get_report_expression()->_publish_vhdl(_vhdl_out);
  }

  if(get_severity_expression() != NULL) {
    _vhdl_out << "\n  severity ";
    get_severity_expression()->_publish_vhdl(_vhdl_out);
  }
}

void 
IIRScram_AssertionStatement::_publish_cc( published_file &_cc_out ) {
  _publish_cc_assertion_or_report_statement( _cc_out );
}

void 
IIRScram_AssertionStatement::_type_check(){
  // This code was copied too IIRScram_ConcurrentAssertionStatement.
  // Any changes here need to be made there, too.

  if( get_assertion_condition() != NULL ){
    _type_check_assertion_condition();
  }

  if( get_report_expression() != NULL ){
    _type_check_report_expression();
  }

  if( get_severity_expression() != NULL ){
    _type_check_severity_expression();
  }
}

void
IIRScram_AssertionStatement::_get_list_of_input_signals( set<IIR> *list ){
  get_assertion_condition()->_get_list_of_input_signals(list);
  if( get_report_expression() != NULL ){
    get_report_expression()->_get_list_of_input_signals(list);
  }
  if( get_severity_expression() != NULL ){
    get_severity_expression()->_get_list_of_input_signals(list);
  }
}

IIR_Boolean
IIRScram_AssertionStatement::_is_above_attribute_found() {
  IIR_Boolean retval = FALSE;
  retval = get_assertion_condition()->_is_above_attribute_found();
  if(get_report_expression() != NULL) {
    retval = retval || get_report_expression();
  }
  if(get_severity_expression() != NULL) {
    retval = retval || get_severity_expression();
  }
  return retval;
}

void
IIRScram_AssertionStatement::_build_above_attribute_set(set<IIR_AboveAttribute> *to_build) {
  get_assertion_condition()->_build_above_attribute_set(to_build);
  if(get_report_expression() != NULL) {
    get_report_expression()->_build_above_attribute_set(to_build);
  }
  if(get_severity_expression() != NULL) {
    get_severity_expression()->_build_above_attribute_set(to_build);
  }
}

IIR*
IIRScram_AssertionStatement::_clone() {
  IIR_AssertionStatement *clone = new IIR_AssertionStatement();
  IIR_SequentialStatement::_clone( clone );

  clone->set_assertion_condition( get_assertion_condition()->_clone() );
  clone->set_report_expression( get_report_expression()->_clone() );
  clone->set_severity_expression( get_severity_expression()->_clone() );

  return clone;
}

visitor_return_type *IIRScram_AssertionStatement::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_AssertionStatement(this, arg);
};
