
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Timothy J. McBrayer 
//          Krishnan Subramani  
//          Umesh Kumar V. Rajasekaran
//          Radharamanan Radhakrishnan
//          Narayanan Thondugulam
//	    Magnus Danielson	cfmd@swipnet.se
 
#include "IIR_SignalDeclaration.hh"
#include "IIR_Attribute.hh"
#include "IIR_ConcurrentStatement.hh"
#include "IIR_AboveAttribute.hh"
#include "IIR_TextLiteral.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "error_func.hh"
#include "savant.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_SignalDeclaration::IIRScram_SignalDeclaration() {
  register int i;
  implemented_attributes_in_constructor = new IIR_Boolean[numSignalAttributes];
  implemented_attributes_in_state = new IIR_Boolean[numSignalAttributes];
  implemented_attributes_in_initstate = new IIR_Boolean[numSignalAttributes];
  for(i = 0; i < numSignalAttributes; i++) {
    implemented_attributes_in_constructor[i] = FALSE;
    implemented_attributes_in_state[i] = FALSE;
    implemented_attributes_in_initstate[i] = FALSE;
  }
  _my_clone = NULL;
  _driver_addition_flag = FALSE;
  _passed_through_out_port = FALSE;
  _stmt_signal_index = -1;
}

IIRScram_SignalDeclaration::~IIRScram_SignalDeclaration() { 
  delete [] implemented_attributes_in_constructor;
  delete [] implemented_attributes_in_state;
  delete [] implemented_attributes_in_initstate;
}

void 
IIRScram_SignalDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {

  ASSERT ( _get_declarative_region() != NULL );
  
  _vhdl_out << "signal ";
  _publish_vhdl_declarator_with_colon(_vhdl_out);
  _publish_vhdl_subtype_indication(_vhdl_out);
  _publish_vhdl_signal_kind(_vhdl_out);
  _publish_vhdl_expression(_vhdl_out);
  _vhdl_out << ";\n";
}

void 
IIRScram_SignalDeclaration::_publish_cc_lvalue( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_SignalDeclaration::_publish_cc" );
  
  ASSERT( get_declarator()->get_kind() == IIR_IDENTIFIER );

  // cgen_sym_tab_ptr will be NULL during elaboration, hence this check.
  if( cgen_sym_tab_ptr != NULL ){
    if( get_value() != NULL ){
      get_value()->_add_decl_into_cgen_symbol_table();
    }
    if( !cgen_sym_tab_ptr->in_scope(this) ){
      cgen_sym_tab_ptr->add_declaration(this);
    }
  }
  if( _is_implicit_declaration() == true ){
    if( _get_attribute_name() != NULL ){
      _get_attribute_name()->_publish_cc_lvalue( _cc_out );
      return;
    } 
  }
  IIRScram_Declaration::_set_scoping_prefix();
  IIRScram::_publish_cc_prefix_string( _cc_out );
  _get_declarator()->_publish_cc_lvalue( _cc_out );
  IIRScram_Declaration::_reset_scoping_prefix();
}

void
IIRScram_SignalDeclaration::_publish_cc_value( published_file &_cc_out ) {
  _publish_cc_rvalue( _cc_out );
}

void
IIRScram_SignalDeclaration::_publish_cc_sigdest( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SignalDeclaration::_publish_cc_sigdest" );
  
  ASSERT(cgen_sym_tab_ptr != NULL);
  ASSERT(get_declarator()->get_kind() == IIR_IDENTIFIER);

  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  _cc_out << "getState()->";
  _get_declarator()->_publish_cc_lvalue( _cc_out );
}

void 
IIRScram_SignalDeclaration::_publish_cc_decl( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SignalDeclaration::_publish_cc_decl" );
  
  if( _get_attribute_name() != NULL ) {
    // Publish the implict declaration and also other declarations needed
    // for this
    _get_attribute_name()->_publish_cc_necessary_decl_in_state( _cc_out );
  }
  else {
    IIRScram_ObjectDeclaration::_publish_cc_decl( _cc_out );
  }
}

void
IIRScram_SignalDeclaration::_publish_cc_init( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SignalDeclaration::_publish_cc_init" );
  
  //Reset the index counter since, a new signal interface declaration
  //is initialized
  _set_index_level( 0 );

  ASSERT((_is_implicit_declaration() == FALSE)||
         ((_get_attribute_name() != NULL) &&
          _get_attribute_name()->get_kind() == IIR_ABOVE_ATTRIBUTE));
  _publish_cc_init_signal( _cc_out );
}

void
IIRScram_SignalDeclaration::_publish_cc_init_for_ams(published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SignalDeclaration::_publish_cc_init_for_ams" );

  //Reset the index counter since, a new signal interface declaration
  //is initialized
  _set_index_level( 0 );

  ASSERT((_is_implicit_declaration() == FALSE)||
         ((_get_attribute_name() != NULL) &&
          _get_attribute_name()->get_kind() == IIR_ABOVE_ATTRIBUTE));

  _publish_cc_init_signal_for_ams( _cc_out );
}

IIR_Boolean
IIRScram_SignalDeclaration::_is_above_attribute_found() {
  if(_is_implicit_declaration() == TRUE && _get_attribute_name() != NULL) {
    if(_get_attribute_name()->_is_above_attribute() == TRUE) {
      return TRUE;
    }
    else
      return FALSE;
  }
  else
    return FALSE;
}

void
IIRScram_SignalDeclaration::
_build_above_attribute_set(set<IIR_AboveAttribute> *to_build) {
  if(_is_implicit_declaration() == TRUE && _get_attribute_name() != NULL) {
    if(_get_attribute_name()->_is_above_attribute() == TRUE) {
      to_build->add(((IIR_AboveAttribute*)_get_attribute_name()));
    }
  }

}

void
IIRScram_SignalDeclaration::_publish_cc_init_signal_for_ams( published_file &_cc_out ) {
}

void
IIRScram_SignalDeclaration::_publish_cc_data( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SignalDeclaration::_publish_cc_data" );
  
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  _cc_out << "getState()->"; 
  _get_declarator()->_publish_cc_lvalue( _cc_out );
}

IIRScram_Declaration::declaration_type 
IIRScram_SignalDeclaration::_get_type(){
  return SIGNAL;
}

void
IIRScram_SignalDeclaration::_publish_cc_elaborate( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_SignalDeclaration::_publish_cc_elaborate" );
  
  _get_declarator()->_publish_cc_lvalue( _cc_out );
  _cc_out << "_info";
}

IIR_Declaration*
IIRScram_SignalDeclaration::_get_signal_decl() {
  IIR_Attribute* attached_attribute;
  attached_attribute = _get_attribute_name();
  set<IIR_Declaration> *attached_to = attached_attribute->get_prefix()->_symbol_lookup();

  if( attached_to == NULL ){
    ostringstream err;
    err << *(attached_attribute->get_prefix()) << " undefined";
    report_error( this, err.str() );
  }

  IIR_Declaration *current_decl = attached_to->get_element();
  while( current_decl != NULL ){
    if( current_decl->_is_signal() == false && current_decl->_is_quantity() == false ) {
      attached_to->remove( current_decl );
    }
    current_decl = attached_to->get_next_element();
  }

  IIR_Declaration *signal_decl = NULL;
  switch( attached_to->num_elements() ){
  case 1:{
    signal_decl = attached_to->get_element();
    break;
  }
  case 0:
  default:
    cerr << "Internal error in overload resolution in "
	 << "IIRScram_Attribute::_symbol_lookup() - got "
	 << attached_to->num_elements() << " possibilities.\n";
    abort();
  }
  return signal_decl;
}

void
IIRScram_SignalDeclaration::_publish_cc_wait_data( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SignalDeclaration::_publish_cc_wait_data" );
  
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  _cc_out << "s->"; 
  _get_declarator()->_publish_cc_lvalue( _cc_out );
}

void
IIRScram_SignalDeclaration::_publish_cc_state_object_init( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_SignalDeclaration::_publish_cc_state_object_init" );
  
  // If this is an implicit signal and it is QUIET attribute, we have to
  // add initialization for LAST_ACTIVE attribute.  Similarly for ACTIVE,
  // STABLE and EVENT attributes.  Before we add, we have to check if
  // LAST_ACTIVE (or LAST_EVENT) attribute is already initialized.  To do
  // this we maintain a boolean array
  // "implemented_attributes_in_constructor" which is set using the method
  // _add_published_attribute_in_constructor(SignalAttribute) and checked
  // using the method
  // _is_published_attribute_in_constructor(SignalAttribute).  The enum
  // SignalAttribute is defined in IIRScram_Declaration.hh

  if(_is_implicit_declaration()) {
    _get_attribute_name()->_publish_cc_state_object_init( _cc_out );
  }
  else {
    IIR_ObjectDeclaration::_publish_cc_state_object_init( _cc_out );
  }
}

const string
IIRScram_SignalDeclaration::_get_cc_object_type(){
  if(_is_implicit_declaration() == TRUE) {
    return "IMPLICIT_SIGNAL";
  } 
  else {
    return "SIGNAL";
  }
}

void
IIRScram_SignalDeclaration::_publish_cc_include(published_file &_cc_out) {
  ASSERT ( get_subtype() != NULL );
  get_subtype()->_publish_cc_include(_cc_out);
}

IIR_Boolean
IIRScram_SignalDeclaration::_is_guard_signal() {
  ASSERT ( get_declarator() != NULL );
  if (IIR_TextLiteral::_cmp( get_declarator(), "guard") == 0) {
    return TRUE;
  }

  return FALSE;
}

void
IIRScram_SignalDeclaration::_publish_cc_necessary_copying( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SignalDeclaration::_publish_cc_necessary_copying" );
  
  if(_is_implicit_declaration() == TRUE) {
    _get_attribute_name()->_publish_cc_necessary_copying( _cc_out );
  }
  else {
    _cc_out << "  this->";
    _get_declarator()->_publish_cc_lvalue( _cc_out );
    _cc_out << " = s.";
    _get_declarator()->_publish_cc_lvalue( _cc_out );    
    _cc_out << ";\n";
  }
}

void
IIRScram_SignalDeclaration::_publish_cc_read_or_write( published_file &_cc_out,
						       const string &fName, 
						       const string &sName ){

  SCRAM_CC_REF( _cc_out, "IIRScram_SignalDeclaration::_publish_cc_read_or_write" );
  
  if(_is_implicit_declaration() == TRUE) {
    _get_attribute_name()->_publish_cc_read_or_write( _cc_out, fName, sName );
  }
  else {
    _cc_out << fName << "(NULL, " << sName << ", ";
    _get_declarator()->_publish_cc_lvalue( _cc_out );
    _cc_out << ");\n";
  }
}

IIR_SignalKind
IIRScram_SignalDeclaration::_get_signal_kind(){
  return get_signal_kind();
}

void
IIRScram_SignalDeclaration::_publish_cc_ams_function(published_file &_cc_out) {
  if(_get_currently_publishing_unit() == SIMULTANEOUS_IF) {
   _get_declarator()->_publish_cc_lvalue(_cc_out);
  }
  else if(_get_currently_publishing_unit() == SIMULTANEOUS_STATEMENT)
    _cc_out << " currentEquation->getSignal(" << _get_stmt_signal_index() << ")";
}

IIR*
IIRScram_SignalDeclaration::_clone() {
  if (_my_clone == NULL) {
    _my_clone = new IIR_SignalDeclaration();
    IIRScram_ObjectDeclaration::_clone(_my_clone);

    _my_clone->_set_driver_addition_flag( _driver_addition_flag );
    _my_clone->_set_passed_through_out_port( _passed_through_out_port );
    _my_clone->set_value(get_value());
    _my_clone->set_signal_kind(get_signal_kind());
  }
  return _my_clone;
}

visitor_return_type *IIRScram_SignalDeclaration::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_SignalDeclaration(this, arg);
};

// ams additions

void
IIRScram_SignalDeclaration::_set_stmt_signal_index(IIR_Int32 *index,
                                                   set<IIR_Declaration> *signal_set) {
  if( _get_stmt_signal_index() == -1 ) {
    _stmt_signal_index = *index;
    (*index)++;
  }
  // add ourselves into the set
  signal_set->add(this);
} 

void
IIRScram_SignalDeclaration::_flush_stmt_index() {
  // The signal index must be reset after publishing has completed for a
  // simultaneous statement. 
 _stmt_signal_index = -1;
}

