
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Malolan Chetlur    
//          Krishnan Subramani 
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam

#include "IIR_WhileLoopStatement.hh"
#include "IIR_AboveAttribute.hh"
#include "IIR_Label.hh"
#include "savant.hh"
#include "published_file.hh"

extern bool parse_error;

IIRScram_WhileLoopStatement::~IIRScram_WhileLoopStatement() {}

void
IIRScram_WhileLoopStatement::_publish_vhdl(ostream &_vhdl_out) {

  _publish_vhdl_stmt_label(_vhdl_out);

  if(get_while_condition() != NULL) {
    ASSERT(get_while_condition()->_is_resolved() == TRUE);
    _vhdl_out << "while ";
    get_while_condition()->_publish_vhdl(_vhdl_out);
    _vhdl_out << "  ";
  }
    
  _vhdl_out << "loop\n";

  if (sequence_of_statements.num_elements() != 0) {
    sequence_of_statements._publish_vhdl(_vhdl_out);
  }
  _vhdl_out << "end loop";
}

void
IIRScram_WhileLoopStatement::_publish_cc( published_file &_cc_out ) {
  _cc_out << *_get_label() << ":;\n";

  _publish_cc_next_label( _cc_out );
  // Semicolon necessary because empty VHDL while loop is possible but a
  // label MUST be followed by a statement in C++.
  _cc_out << ":;\n";

  _cc_out << "while (";
  if(get_while_condition() == NULL) { // it is a vhdl loop statement
    _cc_out << "true";
  } else {			// it is a vhdl while loop statement
    ASSERT(get_while_condition()->_is_resolved() == TRUE);
    _cc_out << "SAVANT_BOOLEAN_TRUE  == ";
    get_while_condition()->_publish_cc_lvalue( _cc_out );
  }
  _cc_out << ") {\n";

  if (sequence_of_statements.num_elements() != 0) {
    sequence_of_statements._publish_cc( _cc_out );
  } else {
    _cc_out << ";\n";
  }
  
  _cc_out << "}\n";

  _publish_cc_exit_label( _cc_out );
  _cc_out << ":;\n";
}

void
IIRScram_WhileLoopStatement::_publish_cc_decl_for_loop_iterator( published_file &_cc_out ) {
  sequence_of_statements._publish_cc_decl_for_loop_iterator( _cc_out );
}

void 
IIRScram_WhileLoopStatement::_type_check(){
  // Perform transformation on while condition.
  if( get_while_condition() != NULL ){
    set_while_condition( _type_check_and_resolve_boolean_condition( get_while_condition() ) );
    if( parse_error == FALSE ){
      ASSERT( get_while_condition()->_is_resolved() == TRUE );
    }
  }
}

void
IIRScram_WhileLoopStatement::_build_wait_list(dl_list<IIRScram_WaitStatement>* list) {
  sequence_of_statements._build_wait_list(list);
}

void 
IIRScram_WhileLoopStatement::_build_procedure_call_stmt_list(dl_list<IIR_ProcedureCallStatement> *list) {
  sequence_of_statements._build_procedure_call_stmt_list(list);
}

void
IIRScram_WhileLoopStatement::_get_list_of_input_signals( set<IIR> *list ){
  if( get_while_condition() != NULL ){
    get_while_condition()->_get_list_of_input_signals(list);
  }
  sequence_of_statements._get_list_of_input_signals(list);
}

void
IIRScram_WhileLoopStatement::_get_signal_source_info( set<IIR> *siginfo ){
  sequence_of_statements._get_signal_source_info(siginfo);
}

IIR_Boolean 
IIRScram_WhileLoopStatement::_type_check_return_statements( set<IIR_TypeDefinition> *context_set, IIR_SubprogramDeclaration *subprogram_decl ){
  IIR_Boolean retval = 
    IIR_SequentialStatement::_type_check_return_statements( context_set, &sequence_of_statements, subprogram_decl );

  return retval;
}

IIR_Boolean
IIRScram_WhileLoopStatement::_is_above_attribute_found() {
  IIR_Boolean retval = FALSE;
  if(get_while_condition() != NULL) {
    retval = retval || get_while_condition()->_is_above_attribute_found();
  }
  retval = retval || sequence_of_statements._is_above_attribute_found();
  return retval;
}

void
IIRScram_WhileLoopStatement::
_build_above_attribute_set(set<IIR_AboveAttribute> *to_build) {
  if(get_while_condition() != NULL) {
    get_while_condition()->_build_above_attribute_set(to_build);
  }
  sequence_of_statements._build_above_attribute_set(to_build);
}

IIR*
IIRScram_WhileLoopStatement::_clone() {
  IIR_WhileLoopStatement *whilestmt = new IIR_WhileLoopStatement();
  IIR *condition;
  
  IIR_SequentialStatement::_clone(whilestmt);
  condition = get_while_condition()->_clone();
  whilestmt->set_while_condition(condition);

  IIR_SequentialStatement *newstmt, *seqstmt = sequence_of_statements.first();
  while (seqstmt != NULL) {
    newstmt = (IIR_SequentialStatement*)seqstmt->_clone();
    whilestmt->sequence_of_statements.append(newstmt);
    seqstmt = sequence_of_statements.successor(seqstmt);
  }

  return whilestmt;
}

visitor_return_type *IIRScram_WhileLoopStatement::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_WhileLoopStatement(this, arg);
};
