
// Copyright (c) 1996-2001 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
// THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING
// OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found
// in the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Krishnan Subramani
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam
//          Radharamanan Radhakrishnan
//          Swaminathan Subramanian
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "StandardPackage.hh"

#include "IIR_EnumerationSubtypeDefinition.hh"
#include "IIR_IntegerSubtypeDefinition.hh"
#include "IIR_FloatingSubtypeDefinition.hh"
#include "IIR_PhysicalSubtypeDefinition.hh"
#include "IIR_ArraySubtypeDefinition.hh"
#include "IIR_AccessSubtypeDefinition.hh"
#include "IIR_RangeTypeDefinition.hh"
#include "IIR_AttributeDeclaration.hh"
#include "IIR_TypeDeclaration.hh"
#include "IIR_LibraryDeclaration.hh"
#include "IIR_SubtypeDeclaration.hh"
#include "IIR_FunctionDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_CharacterLiteral.hh"
#include "IIR_EnumerationLiteral.hh"
#include "IIR_IntegerLiteral32.hh"
#include "IIR_FloatingPointLiteral64.hh"
#include "hash_table.hh"
#include "IIRScram_String.hh"
#include "IIR_PhysicalUnit.hh"
#include "IIR_PhysicalLiteral.hh"
#include "IIR_UnitList.hh"
#include "IIR_EnumerationLiteralList.hh"

int 
StandardPackage::STD_INT_MAX(){
  return 2147483647;
}

int 
StandardPackage::STD_INT_MIN(){
  return -2147483647;
}

double 
StandardPackage::REAL_MAX(){
  return 0.179769313486231e+309;
}

double 
StandardPackage::REAL_MIN(){
  return -0.179769313486231e+309;
}

char *
StandardPackage::get_file_string(){
  return "scram built-in standard library";
}

IIR_Identifier *
StandardPackage::get_file_info(){
  static IIR_Identifier *file_info = IIR_Identifier::get( get_file_string(), 
							  strlen( get_file_string() ) );
  return file_info;
}


// Boolean has to be defined before anything else
IIR_EnumerationSubtypeDefinition *
StandardPackage::get_boolean_type(){
  return (IIR_EnumerationSubtypeDefinition *)get_boolean_decl()->get_type();
}

IIR_TypeDeclaration *
StandardPackage::get_boolean_decl(){
  static IIR_TypeDeclaration *bool_decl = init_boolean_decl();
  return bool_decl;
}

// Here are the builtin universal types.
IIR_IntegerSubtypeDefinition *
StandardPackage::get_savant_universal_integer(){
  static IIR_IntegerSubtypeDefinition *integer_type = init_integer_type();
  return integer_type;
}

IIR_FloatingSubtypeDefinition *
StandardPackage::get_savant_universal_real(){
  static IIR_FloatingSubtypeDefinition *universal_real = init_real_type();
  return universal_real;
}

// These types represent those declared in std.standard.
IIR_EnumerationSubtypeDefinition *
StandardPackage::get_bit_type(){
  return (IIR_EnumerationSubtypeDefinition *)get_bit_decl()->get_type();
}

IIR_TypeDeclaration *
StandardPackage::get_bit_decl(){
  static IIR_TypeDeclaration *bit_decl = init_bit_decl();
  return bit_decl;
}

IIR_IntegerSubtypeDefinition *
StandardPackage::get_integer_type(){
  return (IIR_IntegerSubtypeDefinition *)get_integer_decl()->get_type();
}

IIR_TypeDeclaration *
StandardPackage::get_integer_decl(){
  static IIR_TypeDeclaration *integer_decl = init_integer_decl();
  return integer_decl;
}

IIR_EnumerationSubtypeDefinition *
StandardPackage::get_character_type(){
  return (IIR_EnumerationSubtypeDefinition *)get_character_decl()->get_type();
}

IIR_TypeDeclaration *
StandardPackage::get_character_decl(){
  static IIR_TypeDeclaration *character_decl = init_character_decl();
  return character_decl;
}

IIR_IntegerSubtypeDefinition *
StandardPackage::get_positive_type(){
  return (IIR_IntegerSubtypeDefinition *)get_positive_decl()->get_subtype();
}

IIR_SubtypeDeclaration *
StandardPackage::get_positive_decl(){
  static IIR_SubtypeDeclaration *positive_type = init_subtype_decl( "positive", init_positive_type() );
  
  return positive_type;
}

IIR_ArraySubtypeDefinition *
StandardPackage::get_string_type(){
  return (IIR_ArraySubtypeDefinition *)get_string_decl()->get_type();
}

IIR_TypeDeclaration *
StandardPackage::get_string_decl(){
  static IIR_TypeDeclaration *string_decl = init_string_decl( );
  return string_decl;
}

IIR_EnumerationSubtypeDefinition *
StandardPackage::get_severity_level_type(){
  return (IIR_EnumerationSubtypeDefinition *)get_severity_level_decl()->get_type();
}

IIR_TypeDeclaration *
StandardPackage::get_severity_level_decl(){
  static IIR_TypeDeclaration *severity_level_decl = init_severity_level_decl();
  return severity_level_decl;
}

IIR_FloatingSubtypeDefinition *
StandardPackage::get_real_type(){
  return (IIR_FloatingSubtypeDefinition *)get_real_decl()->get_type();
}

IIR_TypeDeclaration *
StandardPackage::get_real_decl(){
  static IIR_TypeDeclaration *real_decl = init_real_decl();
  return real_decl;
}

IIR_PhysicalSubtypeDefinition *
StandardPackage::get_time_type(){
  return (IIR_PhysicalSubtypeDefinition *)get_time_decl()->get_type();
}

IIR_TypeDeclaration *
StandardPackage::get_time_decl(){
  static IIR_TypeDeclaration *time_decl = init_type_decl( "time", init_time_type() );
  return time_decl;
}

IIR_PhysicalSubtypeDefinition *
StandardPackage::get_delay_length_type(){
  return (IIR_PhysicalSubtypeDefinition *)get_delay_length_decl()->get_subtype();
}

IIR_SubtypeDeclaration *
StandardPackage::get_delay_length_decl(){
  static IIR_SubtypeDeclaration *delay_length_decl = init_delay_length_decl();
  return delay_length_decl;
}

IIR_IntegerSubtypeDefinition *
StandardPackage::get_natural_type(){
  return (IIR_IntegerSubtypeDefinition *)get_natural_decl()->get_subtype();
}

IIR_SubtypeDeclaration *
StandardPackage::get_natural_decl(){
  static IIR_SubtypeDeclaration *natural_decl
    = init_subtype_decl( "natural", init_natural_type() );
  return natural_decl;
}

IIR_ArraySubtypeDefinition *
StandardPackage::get_bit_vector_type(){
  return (IIR_ArraySubtypeDefinition *)get_bit_vector_decl()->get_type();
}

IIR_TypeDeclaration *
StandardPackage::get_bit_vector_decl(){
  static IIR_TypeDeclaration *bit_vector_decl = init_bit_vector_decl();
  return bit_vector_decl;
}

IIR_EnumerationSubtypeDefinition *
StandardPackage::get_file_open_kind_type(){
  return (IIR_EnumerationSubtypeDefinition *)get_file_open_kind_decl()->get_type();
}

IIR_TypeDeclaration *
StandardPackage::get_file_open_kind_decl(){
  static IIR_TypeDeclaration *file_open_kind_decl = init_file_open_kind_decl();
  return file_open_kind_decl;
}

IIR_EnumerationSubtypeDefinition *
StandardPackage::get_file_open_status_type(){
  return (IIR_EnumerationSubtypeDefinition *)get_file_open_status_decl()->get_type();
}

IIR_TypeDeclaration *
StandardPackage::get_file_open_status_decl(){
  static IIR_TypeDeclaration *file_open_status_decl = init_file_open_status_decl();
  return file_open_status_decl;
}

IIR_AttributeDeclaration *
StandardPackage::get_foreign_decl(){
  static IIR_AttributeDeclaration *foreign_decl  = init_foreign_decl();
  return foreign_decl;
}

IIR_FunctionDeclaration *
StandardPackage::get_now_decl(){
  static IIR_FunctionDeclaration *now_decl = init_now_decl();
  return now_decl;
}

IIR_LibraryDeclaration *
StandardPackage::get_std_decl(){
  static IIR_LibraryDeclaration *std_decl = init_std_decl();
  return std_decl;
}

IIR_AccessSubtypeDefinition *
StandardPackage::get_savant_null_type_definition(){
  static IIR_AccessSubtypeDefinition *null_type_definition = init_null_type();
  return null_type_definition;
}

void 
StandardPackage::fill_list( IIR_DeclarationList *list ){
  list->append( get_boolean_decl() );
  list->_append( &get_boolean_type()->enumeration_literals );
  list->append( get_bit_decl() );
  list->_append( &get_bit_type()->enumeration_literals );
  list->append( get_integer_decl() );
  list->append( get_character_decl() );
  list->_append( &get_character_type()->enumeration_literals );
  list->append( get_positive_decl() );
  list->append( get_string_decl() );
  list->append( get_severity_level_decl() );
  list->_append( &get_severity_level_type()->enumeration_literals );
  list->append( get_real_decl() );
  list->append( get_time_decl() );
  list->append( get_time_type()->get_primary_unit() );
  list->_append( &get_time_type()->units );
  list->append( get_delay_length_decl() );
  list->append( get_natural_decl() );
  list->append( get_bit_vector_decl() );
  list->append( get_file_open_kind_decl() );
  list->_append( &get_file_open_kind_type()->enumeration_literals );
  list->append( get_file_open_status_decl() );
  list->_append( &get_file_open_status_type()->enumeration_literals );
  list->append( get_foreign_decl() );
  list->append( get_now_decl() );
}

IIR_IntegerSubtypeDefinition *
StandardPackage::init_integer_type(){
  return init_integer_type( STD_INT_MIN(), STD_INT_MAX() );
}

IIR_IntegerSubtypeDefinition *
StandardPackage::init_positive_type(){
  IIR_IntegerSubtypeDefinition *retval = 0;

  IIR_RangeTypeDefinition *temp = new IIR_RangeTypeDefinition();

  temp->set_left( IIR_IntegerLiteral32::get( 1 ) );
  temp->set_direction( get_integer_type()->get_direction() );
  temp->set_right( IIR_IntegerLiteral32::get( STD_INT_MAX() ) );
  set_locator_info( temp );

  retval = (IIR_IntegerSubtypeDefinition *)get_integer_type()->_construct_new_subtype( 0, temp );
  retval->_set_type_mark( get_integer_type() );
  
  delete temp;

  return retval;
}

IIR_IntegerSubtypeDefinition *
StandardPackage::init_natural_type(){
  IIR_IntegerSubtypeDefinition *retval = 0;

  IIR_RangeTypeDefinition *temp = new IIR_RangeTypeDefinition();

  temp->set_left( IIR_IntegerLiteral32::get( 0 ) );
  temp->set_direction( get_integer_type()->get_direction() );
  temp->set_right( IIR_IntegerLiteral32::get( STD_INT_MAX() ) );
  set_locator_info( temp );

  retval = (IIR_IntegerSubtypeDefinition *)get_integer_type()->_construct_new_subtype( 0, temp );
  retval->_set_type_mark( get_integer_type() );

  delete temp;

  return retval;
}

IIR_FloatingSubtypeDefinition *
StandardPackage::init_real_type(){
  return init_real_type( REAL_MIN(), REAL_MAX() );
}

IIR_EnumerationLiteral *
StandardPackage::init_false_literal(){
  IIR_EnumerationLiteral *retval = new IIR_EnumerationLiteral();
  set_locator_info( retval );
  retval->set_declarator( IIR_Identifier::get( "false", strlen("false") ) );
  retval->set_position( IIR_IntegerLiteral32::get( 0 ) );

  return retval;
}

IIR_EnumerationLiteral *
StandardPackage::get_false_literal(){
  static IIR_EnumerationLiteral *false_literal = init_false_literal();
  return false_literal;
}

IIR_EnumerationLiteral *
StandardPackage::init_true_literal(){
  IIR_EnumerationLiteral *retval = new IIR_EnumerationLiteral();
  set_locator_info( retval );
  retval->set_declarator( IIR_Identifier::get( "true", strlen( "true" ) ) );
  retval->set_position( IIR_IntegerLiteral32::get( 1 ) );

  return retval;
}

IIR_EnumerationLiteral *
StandardPackage::get_true_literal(){
  static IIR_EnumerationLiteral *true_literal = init_true_literal();
  return true_literal;
}

IIR_TypeDeclaration *
StandardPackage::init_boolean_decl(){
  static IIR_TypeDeclaration *boolean_decl = init_type_decl( "boolean", init_boolean_type() );

  boolean_decl->get_type()->_set_declaration( boolean_decl );
  boolean_decl->get_type()->get_base_type()->_set_declaration( boolean_decl );

  return boolean_decl;
}

IIR_EnumerationSubtypeDefinition *
StandardPackage::init_boolean_type(){
  IIR_EnumerationSubtypeDefinition *retval = NULL;

  IIR_EnumerationLiteralList *literals = new IIR_EnumerationLiteralList();
  literals->append( get_false_literal() );
  literals->append( get_true_literal() );

  retval = init_enumeration_type( literals );

  delete literals;

  return retval;
}

IIR_TypeDeclaration *
StandardPackage::init_bit_decl(){
  static IIR_TypeDeclaration *bit_decl = init_type_decl( "bit", init_bit_type() );

  bit_decl->get_type()->_set_declaration( bit_decl );
  bit_decl->get_type()->get_base_type()->_set_declaration( bit_decl );
  
  return bit_decl;
}

IIR_EnumerationSubtypeDefinition *
StandardPackage::init_bit_type(){
  char *literals[] = { "'0'", "'1'", 0 };
  return init_enumeration_type( literals );
}

IIR_TypeDeclaration *
StandardPackage::init_character_decl(){
  static IIR_TypeDeclaration *character_decl 
    = init_type_decl( "character", init_character_type() );

  character_decl->get_type()->_set_declaration( character_decl );
  character_decl->get_type()->get_base_type()->_set_declaration( character_decl );

  return character_decl;
}

IIR_EnumerationSubtypeDefinition *
StandardPackage::init_character_type(){
  char *literals[] = {
    "nul",  "soh",  "stx",  "etx",  "eot",  "enq",  "ack",  "bel",
    "bs",   "ht",   "lf",   "vt",   "ff",   "cr",   "so",   "si",
    "dle",  "dc1",  "dc2",  "dc3",  "dc4",  "nak",  "syn",  "etb",
    "can",  "em",   "sub",  "esc",  "fsp",  "gsp",  "rsp",  "usp", 
    "' '",  "'!'",  "'\"'", "'#'",  "'$'",  "'%'",  "'&'",  "'''",  
    "'('",  "')'",  "'*'",  "'+'",  "','",  "'-'",  "'.'",  "'/'",
    "'0'",  "'1'",  "'2'",  "'3'",  "'4'",  "'5'",  "'6'",  "'7'",
    "'8'",  "'9'",  "':'",  "';'",  "'<'",  "'='",  "'>'",  "'?'",
    "'@'",  "'A'",  "'B'",  "'C'",  "'D'",  "'E'",  "'F'",  "'G'",
    "'H'",  "'I'",  "'J'",  "'K'",  "'L'",  "'M'",  "'N'",  "'O'",
    "'P'",  "'Q'",  "'R'",  "'S'",  "'T'",  "'U'",  "'V'",  "'W'",
    "'X'",  "'Y'",  "'Z'",  "'['",  "'\\'",  "']'",  "'^'",  "'_'",
    "'`'",  "'a'",  "'b'",  "'c'",  "'d'",  "'e'",  "'f'",  "'g'",
    "'h'",  "'i'",  "'j'",  "'k'",  "'l'",  "'m'",  "'n'",  "'o'",
    "'p'",  "'q'",  "'r'",  "'s'",  "'t'",  "'u'",  "'v'",  "'w'",
    "'x'",  "'y'",  "'z'",  "'{'",  "'|'",  "'}'",  "'~'",  "del",
    "c128", "c129", "c130", "c131", "c132", "c133", "c134", "c135",
    "c136", "c137", "c138", "c139", "c140", "c141", "c142", "c143",
    "c144", "c145", "c146", "c147", "c148", "c149", "c150", "c151",
    "c152", "c153", "c154", "c155", "c156", "c157", "c158", "c159",
    "''",  "''",  "''",  "''",  "''",  "''",  "''",  "''", 
    "''",  "''",  "''",  "''",  "''",  "''",  "''",  "''", 
    "''",  "''",  "''",  "''",  "''",  "''",  "''",  "''", 
    "''",  "''",  "''",  "''",  "''",  "''",  "''",  "''", 
    "''",  "''",  "''",  "''",  "''",  "''",  "''",  "''", 
    "''",  "''",  "''",  "''",  "''",  "''",  "''",  "''", 
    "''",  "''",  "''",  "''",  "''",  "''",  "''",  "''", 
    "''",  "''",  "''",  "''",  "''",  "''",  "''",  "''",
    "''",  "''",  "''",  "''",  "''",  "''",  "''",  "''",
    "''",  "''",  "''",  "''",  "''",  "''",  "''",  "''", 
    "''",  "''",  "''",  "''",  "''",  "''",  "''",  "''",
    "''",  "''",  "''",  "''",  "''",  "''",  "''",  "''", 
    0 };

  return init_enumeration_type( literals );
}

IIR_TypeDeclaration *
StandardPackage::init_severity_level_decl(){
  static IIR_TypeDeclaration *severity_level_decl = init_type_decl( "severity_level",
								    init_severity_level_type() );
  severity_level_decl->get_type()->_set_declaration( severity_level_decl );
  severity_level_decl->get_type()->get_base_type()->_set_declaration( severity_level_decl );

  return severity_level_decl;
}

IIR_EnumerationSubtypeDefinition *
StandardPackage::init_severity_level_type(){
  char *literals[] = {
    "note", 
    "warning", 
    "error", 
    "failure",
    0
  };

  return init_enumeration_type( literals );
}

IIR_TypeDeclaration *
StandardPackage::init_file_open_kind_decl(){
  static IIR_TypeDeclaration *file_open_kind_decl 
    = init_type_decl( "file_open_kind", init_file_open_kind_type() );

  file_open_kind_decl->get_type()->_set_declaration( file_open_kind_decl );
  file_open_kind_decl->get_type()->get_base_type()->_set_declaration( file_open_kind_decl );

  return file_open_kind_decl;
}

IIR_EnumerationSubtypeDefinition *
StandardPackage::init_file_open_kind_type(){
  char *literals[] = {
    "open_kind",	
    "status_error",   
    "name_error",	
    "mode_error",
    0
  };
  return init_enumeration_type( literals );
}

IIR_TypeDeclaration *
StandardPackage::init_file_open_status_decl(){
  static IIR_TypeDeclaration *file_open_status_decl 
    = init_type_decl( "file_open_status", init_file_open_status_type() );

  file_open_status_decl->get_type()->_set_declaration( file_open_status_decl );
  file_open_status_decl->get_type()->get_base_type()->_set_declaration( file_open_status_decl );

  return file_open_status_decl;
}
IIR_EnumerationSubtypeDefinition *
StandardPackage::init_file_open_status_type(){
  char *literals[] = {
    "open_kind",	
    "status_error",   
    "name_error",	
    "mode_error",
    0
  };
  return init_enumeration_type( literals );
}

IIR_TypeDeclaration *
StandardPackage::init_integer_decl(){
  IIR_TypeDeclaration *retval = init_type_decl( "integer", init_integer_type() );

  retval->get_type()->_set_declaration( retval );
  retval->get_type()->get_base_type()->_set_declaration( retval );

  return retval;
}

IIR_TypeDeclaration *
StandardPackage::init_real_decl(){
  IIR_TypeDeclaration *retval = init_type_decl( "real", init_real_type() );

  retval->get_type()->_set_declaration( retval );
  retval->get_type()->get_base_type()->_set_declaration( retval );

  return retval;
}

IIR_TypeDeclaration *
StandardPackage::init_string_decl(){
  IIR_TypeDeclaration *retval = init_type_decl( "string", 0 );  
  IIR_ArraySubtypeDefinition *string_type = 
    init_unconstrained_array_type( get_positive_type(), 
				   get_character_type(), 
				   retval );

  retval->set_type( string_type );

  return retval;
}

IIR_TypeDeclaration *
StandardPackage::init_bit_vector_decl(){
  IIR_TypeDeclaration *retval = init_type_decl( "bit_vector", 0 );  
  IIR_ArraySubtypeDefinition *bit_vector_type 
    = init_unconstrained_array_type( get_natural_type(), get_bit_type(), retval );
  retval->set_type( bit_vector_type );
  return retval;
}

IIR_PhysicalSubtypeDefinition *
StandardPackage::init_time_type(){
  struct unit units[] = {
    { "ps",  1000, "fs" },
    { "ns",  1000, "ps" },
    { "us",  1000, "ns" },
    { "ms",  1000, "us" },
    { "sec", 1000, "ms" },
    { "min", 60,   "sec" },
    { "hr",  60,   "min" },
    { 0, 0, 0 }
  };

  return init_physical_type( (int)STD_INT_MIN(), (int)STD_INT_MAX(), (char *)"fs", units );
}

IIR_SubtypeDeclaration *
StandardPackage::init_delay_length_decl(){
  IIR_SubtypeDeclaration *retval = init_subtype_decl( "delay_length", init_delay_length_type() );

  retval->get_subtype()->_set_declaration( retval );
  retval->get_subtype()->get_base_type()->_set_declaration( retval );

  return retval;
}

IIR_PhysicalSubtypeDefinition *
StandardPackage::init_delay_length_type(){
  IIR_PhysicalSubtypeDefinition *retval = new IIR_PhysicalSubtypeDefinition();
  retval->set_base_type( get_time_type()->get_base_type() );

  retval->set_left( IIR_FloatingPointLiteral64::get_value( 0.0 ) );
  retval->set_right( get_time_type()->get_right() );
  retval->set_direction( get_true_literal() );
    
  set_locator_info( retval );

  return retval;
}

IIR_AttributeDeclaration *
StandardPackage::init_foreign_decl(){
  IIR_AttributeDeclaration *retval;

  retval = new IIR_AttributeDeclaration();
  retval->set_declarator( IIR_Identifier::get( "foreign", strlen("foreign") ) );
  retval->set_subtype( get_string_type() );

  set_locator_info( retval );

  return retval;
}

IIR_FunctionDeclaration *
StandardPackage::init_now_decl(){
   IIR_FunctionDeclaration *retval;

   retval = new IIR_FunctionDeclaration();
   retval->set_declarator( IIR_Identifier::get( "now", strlen( "now" ) ) );
   retval->set_return_type( get_time_type() );
   retval->set_pure( IIR_IMPURE_FUNCTION );

   set_locator_info( retval );

   return retval;
}

IIR_TypeDeclaration *
StandardPackage::init_type_decl( char *id, IIR_TypeDefinition *subtype ){
  ASSERT( id != NULL );

  IIR_TypeDeclaration *retval = new IIR_TypeDeclaration();
  retval->set_declarator( IIR_Identifier::get( (IIR_Char *)id, strlen( id ) ) );
  retval->set_type( (IIR_TypeDefinition *)subtype );
  if( subtype != NULL ){
    subtype->_set_declaration( retval );
    subtype->get_base_type()->_set_declaration( retval );
  }

  set_locator_info( retval );

  return retval;
}

IIR_SubtypeDeclaration *
StandardPackage::init_subtype_decl( char *id, IIR_TypeDefinition *subtype ){
  ASSERT( id != NULL );
  ASSERT( subtype != NULL );

  IIR_SubtypeDeclaration *retval = new IIR_SubtypeDeclaration();
  retval->set_declarator( IIR_Identifier::get( id, strlen( id ) ) );
  retval->set_subtype( subtype );

  subtype->_set_declaration( retval );
  subtype->get_base_type()->_set_declaration( retval );

  set_locator_info( retval );

  return retval;
}

IIR_EnumerationLiteralList *
StandardPackage::build_literal_list( const char *const literals[] ){
  IIR_EnumerationLiteralList *retval = new IIR_EnumerationLiteralList();

  int i;
  for( i = 0; literals[i] != 0; i++ ){
    IIR_TextLiteral *literal_declarator;
    if( literals[i][0] == '\'' ){
      literal_declarator = IIR_CharacterLiteral::get( (char*)literals[i], strlen( literals[i] ) );
    }
    else{
      literal_declarator = IIR_Identifier::get( (char*)literals[i], strlen( literals[i] ) );
    }

    IIR_EnumerationLiteral *lit = new IIR_EnumerationLiteral();
    set_locator_info( lit );
    lit->set_declarator( literal_declarator );
    lit->set_position( IIR_IntegerLiteral32::get( i ) );
    retval->append( lit );
  }

  return retval;
}

IIR_EnumerationSubtypeDefinition *
StandardPackage::init_enumeration_type( const char *const literals[] ){
  IIR_EnumerationSubtypeDefinition *retval = NULL;
  
  IIR_EnumerationLiteralList *list = build_literal_list( literals );
  retval = init_enumeration_type( list );
  delete list;

  return retval;
}

IIR_EnumerationSubtypeDefinition *
StandardPackage::init_enumeration_type( IIR_EnumerationLiteralList *list ){
  IIR_EnumerationSubtypeDefinition *retval = NULL;
  IIR_TypeDeclaration *fake = new IIR_TypeDeclaration();
  set_locator_info( fake );
  retval = IIR_EnumerationTypeDefinition::_construct_new_type( list, fake );
  delete fake;

  return retval;
}

IIR_IntegerSubtypeDefinition *
StandardPackage::init_integer_type( int left_bound, 
				    int right_bound ){
  IIR_IntegerSubtypeDefinition *retval = 0;

  IIR_IntegerLiteral32 *left = IIR_IntegerLiteral32::get( left_bound );
  IIR_IntegerLiteral32 *right = IIR_IntegerLiteral32::get( right_bound );

  IIR_RangeTypeDefinition *temp = new IIR_RangeTypeDefinition();

  temp->set_left( left );
  temp->set_right( right );
  temp->set_direction( get_true_literal() );
  set_locator_info( temp );

  retval = IIR_IntegerTypeDefinition::_construct_new_type( temp, 0 );

  delete temp;

  return retval;
}

IIR_FloatingSubtypeDefinition *
StandardPackage::init_real_type( double left_bound, double right_bound ){
  IIR_FloatingSubtypeDefinition *retval = 0;

  IIR_FloatingPointLiteral64 *left = IIR_FloatingPointLiteral64::get_value( left_bound );
  IIR_FloatingPointLiteral64 *right = IIR_FloatingPointLiteral64::get_value( right_bound );

  IIR_RangeTypeDefinition *temp = new IIR_RangeTypeDefinition();
  temp->set_left( left );
  temp->set_right( right );
  temp->set_direction( get_true_literal() );
  set_locator_info( temp );

  retval = IIR_FloatingTypeDefinition::_construct_new_type( temp, 0 );

  delete temp;
  
  return retval;
}

IIR_PhysicalSubtypeDefinition *
StandardPackage::init_physical_type( int left_bound, 
				     int right_bound, 
				     char *base_unit_string, 
				     struct unit units[] ){

  IIR_PhysicalTypeDefinition *base_type = new IIR_PhysicalTypeDefinition();
  IIR_PhysicalSubtypeDefinition *retval = new IIR_PhysicalSubtypeDefinition();

  IIR_IntegerLiteral32 *left = IIR_IntegerLiteral32::get( left_bound );
  IIR_IntegerLiteral32 *right = IIR_IntegerLiteral32::get( right_bound );
  left->_set_subtype( retval );
  right->_set_subtype( retval );

  retval->set_base_type( base_type );
  retval->set_left( left );
  retval->set_right( right );
  retval->set_direction( get_true_literal() );

  base_type->set_left( left );
  base_type->set_right( left );
  base_type->set_direction( get_true_literal() );

  set_locator_info( retval );
  set_locator_info( base_type );

  IIR_PhysicalUnit *base_unit = new IIR_PhysicalUnit();
  set_locator_info( base_unit );

  base_unit->set_declarator( IIR_Identifier::get( base_unit_string, strlen(base_unit_string) ));
  base_unit->_set_physical_type( retval );

  IIR_IntegerLiteral32 *unity = IIR_IntegerLiteral32::get( 1 );
  base_unit->set_multiplier( unity );
  unity->_set_subtype( retval );
  retval->set_primary_unit( base_unit );


  IIR_PhysicalUnit *current_unit;
  int i = 0;
  while( units[i].unit_name != 0 ){
    current_unit = new IIR_PhysicalUnit();
    set_locator_info( current_unit );
    current_unit->set_declarator( IIR_Identifier::get( units[i].unit_name, 
						       strlen( units[i].unit_name ) ) );

    IIR_PhysicalLiteral *multiplier = new IIR_PhysicalLiteral();
    set_locator_info( multiplier );
    multiplier->set_abstract_literal( IIR_IntegerLiteral32::get( units[i].multiplier ) );
    multiplier->set_unit_name( find_unit( units[i].base_unit, retval ) );
    multiplier->set_subtype( retval );
    current_unit->set_multiplier( multiplier );

    // Set subtypes of the current unit/multiplier.
    current_unit->_set_physical_type( retval );
    ASSERT( current_unit->get_multiplier() != NULL &&
	    current_unit->get_multiplier()->get_kind() == IIR_PHYSICAL_LITERAL );
    ((IIR_PhysicalLiteral *)current_unit->get_multiplier())->set_subtype( retval );

    retval->units.append( current_unit );
    i++;
  }

  return retval;
}

IIR_ArraySubtypeDefinition *
StandardPackage::init_unconstrained_array_type( IIR_ScalarTypeDefinition *index_type,
						IIR_TypeDefinition *element_type,
						IIR_TypeDeclaration *type_decl ){
  IIR_ArraySubtypeDefinition *retval;
  IIR_RangeTypeDefinition *empty_range = new IIR_RangeTypeDefinition();

  set_locator_info( empty_range );
  empty_range->set_base_type( index_type->get_base_type() );

  IIR_ScalarTypeDefinition *unconstrained_index;
  unconstrained_index = 
    (IIR_ScalarTypeDefinition *)index_type->_construct_new_subtype( 0, empty_range );
  // So, we the subtype constructed we're done with this.
  delete empty_range;
  unconstrained_index->_set_type_mark( index_type );


  retval = (IIR_ArraySubtypeDefinition*)
    IIR_ArrayTypeDefinition::_construct_unconstrained( unconstrained_index, element_type, type_decl );
  set_locator_info( retval );

  return retval;
}

void
StandardPackage::set_locator_info( IIR *to_set_in ){
  to_set_in->set_file_name( get_file_info() );
  to_set_in->set_line_number( 0 );
}

IIR_PhysicalUnit *
StandardPackage::find_unit( char *name, IIR_PhysicalSubtypeDefinition *physical_type ){
  IIR_PhysicalUnit *retval = 0;

  IIR_Identifier *temp = IIR_Identifier::get( name, strlen( name ) );
  IIR_PhysicalUnit *current = physical_type->units.first();
  while( current != NULL ){
    if( IIR_TextLiteral::_cmp( current->_get_declarator(), name ) == 0 ){
      retval = current;
      break;
    }
    current = physical_type->units.successor( current );
  }

  if( retval == NULL ){
    // We had better check the primary unit!
    if( IIR_TextLiteral::_cmp( physical_type->get_primary_unit()->_get_declarator(), name ) == 0 ){
      retval = physical_type->get_primary_unit();
    }
  }

  delete temp;

  return retval;
}

IIR_LibraryDeclaration *
StandardPackage::init_std_decl(){
  IIR_LibraryDeclaration *retval = new IIR_LibraryDeclaration();
  retval->set_declarator( IIR_Identifier::get( "std", strlen("std") ) );
  set_locator_info( retval );
  return retval;
}

StandardPackage::StandardPackage(){
  char *id = "standard";
  set_declarator( IIR_Identifier::get( id, strlen( id ) ) );
  fill_list( &package_declarative_part );
}

StandardPackage *
StandardPackage::init_std_standard(){
  StandardPackage *retval = new StandardPackage();
  set_locator_info( retval );
  return retval;
}

IIR_AccessSubtypeDefinition *
StandardPackage::init_null_type(){
  IIR_AccessSubtypeDefinition *retval = IIR_AccessTypeDefinition::_construct_new_type( NULL, 
										       NULL );

  set_locator_info( retval );

  return retval;
}

StandardPackage *
StandardPackage::get_std_standard_decl(){
  static StandardPackage *std_standard = init_std_standard();
  return std_standard;
}
