/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <stdlib.h>
#include "sg_toggle_combos.h"
#include "sg.h"
#include "../pixmaps/pixmaps.h"

#define DATA_ROWS 3
#define DATA_COLS 4
#define SYMBOL_ROWS 4
#define SYMBOL_COLS 4

/*
static const gchar *data_text[DATA_ROWS][DATA_COLS] = 
                   {{"Scatter","Lines","Linepoints","Impulses"},
                    {"V Bars","H Bars","V Boxes","H Boxes"},
                    {"Vectors","Bubbles","Density","Contour"},
                   };
*/

static const gchar *symbol_text[SYMBOL_ROWS][SYMBOL_COLS] = 
                   {{"None","Squares","Circles","Up triangles"},
                    {"Down Triangles","Right Triangles","Left Triangles","Diamonds"},
                    {"Plus","Crosses","Stars","Dots"},
                    {"Impulses", "", "", ""},
                   };

static gchar **data_pixmaps[DATA_ROWS][DATA_COLS];
static gchar **symbol_pixmaps[SYMBOL_ROWS][SYMBOL_COLS];

static void sg_toggle_data_real_init		(GtkToggleCombo *combo, 
						 gint row, gint col,
                                                 gpointer data);
static void sg_toggle_symbol_real_init		(GtkToggleCombo *combo, 
						 gint row, gint col,
                                                 gpointer data);


GtkWidget *
sg_toggle_data_new(gint plot_type)
{
  GtkWidget *combo;
  GtkWidget *pixmap;
  GdkPixmap *tool;
  GdkBitmap *mask;
  GdkColormap *colormap;
  GtkTooltips *tooltips;
  gint i, j;
  gint nrows, ncols;

  switch(plot_type){
    case SG_LAYER_2D:
      data_pixmaps[0][0] = g_scatter_xpm; 
      data_pixmaps[0][1] = g_lines_xpm; 
      data_pixmaps[0][2] = g_lpoints_xpm; 
      data_pixmaps[0][3] = g_impulses_xpm; 
      data_pixmaps[1][0] = g_bars_xpm; 
      data_pixmaps[1][1] = g_hbars_xpm; 
      data_pixmaps[1][2] = g_boxes_xpm; 
      data_pixmaps[1][3] = g_hbox_xpm; 
      data_pixmaps[2][0] = g_bubbles_xpm; 
      data_pixmaps[2][1] = g_colors_xpm; 
      data_pixmaps[2][2] = g_vectors_xpm; 
      data_pixmaps[2][3] = g_contour_xpm; 
      nrows = 3;
      ncols = 4;
      break;
    case SG_LAYER_POLAR:
      data_pixmaps[0][0] = g_scatter_xpm; 
      data_pixmaps[0][1] = g_lines_xpm; 
      data_pixmaps[0][2] = g_lpoints_xpm; 
      data_pixmaps[1][0] = g_impulses_xpm; 
      data_pixmaps[1][1] = g_bubbles_xpm; 
      data_pixmaps[1][2] = g_colors_xpm; 
      nrows = 2;
      ncols = 3;
      break;
    case SG_LAYER_3D:
      data_pixmaps[0][0] = g_scatter3d_xpm; 
      data_pixmaps[0][1] = g_bubbles3d_xpm; 
      data_pixmaps[0][2] = g_colors3d_xpm; 
      data_pixmaps[1][0] = g_flux3d_xpm; 
      data_pixmaps[1][1] = g_surface_xpm; 
      data_pixmaps[1][2] = g_csurface_xpm; 
      nrows = 2;
      ncols = 3;
      break;
    case 4:
      data_pixmaps[0][0] = g_scatter3d_xpm; 
      data_pixmaps[0][1] = g_surface_xpm; 
      data_pixmaps[0][2] = g_csurface_xpm; 
      nrows = 1;
      ncols = 3;
      break;
    case 5:
      data_pixmaps[0][0] = g_contour_xpm; 
      data_pixmaps[0][1] = g_density_xpm; 
      data_pixmaps[0][2] = g_bubbles_xpm; 
      data_pixmaps[0][3] = g_colors_xpm; 
      nrows = 1;
      ncols = 4;
      break;
  }

  colormap = gdk_colormap_get_system();

  combo = gtk_toggle_combo_new(nrows, ncols);

  for(i = 0; i < nrows; i++)
    for(j = 0; j < ncols; j++){
      tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                 data_pixmaps[i][j]);
      pixmap = gtk_pixmap_new(tool, mask);

      gtk_container_add(GTK_CONTAINER(GTK_TOGGLE_COMBO(combo)->button[i][j]),
                    pixmap);
      gtk_widget_show(pixmap);
      gdk_pixmap_unref(tool);
      gdk_bitmap_unref(mask);

/*
      tooltips = gtk_tooltips_new();
      gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips),
                           GTK_TOGGLE_COMBO(combo)->button[i][j],
                           data_text[i][j],
                           data_text[i][j]);
      gtk_tooltips_enable(GTK_TOOLTIPS(tooltips));
      gtk_tooltips_set_delay(GTK_TOOLTIPS(tooltips), 0);
*/
    }

  gtk_signal_connect(GTK_OBJECT(combo), "changed", 
                     GTK_SIGNAL_FUNC(sg_toggle_data_real_init), data_pixmaps);

  sg_toggle_data_real_init(GTK_TOGGLE_COMBO(combo), 0, 0, data_pixmaps); 
  return combo;
}

void
sg_toggle_data_init(GtkWidget *widget, gint selection)
{
  GtkToggleCombo *combo;
  gint row, col;

  combo = GTK_TOGGLE_COMBO(widget);

  row = selection / combo->ncols;
  col = selection - row * combo->ncols;

  gtk_toggle_combo_select(combo, row, col);
}

gint
sg_toggle_data_get_selection(GtkWidget *widget)
{
  GtkToggleCombo *combo;

  combo = GTK_TOGGLE_COMBO(widget);
  return (combo->row * combo->ncols + combo->column);
}

static void
sg_toggle_data_real_init(GtkToggleCombo *combo, gint row, gint col, gpointer data)
{
  GtkWidget *pixmap;
  GdkPixmap *tool;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();


  if(GTK_BIN(GTK_COMBO_BOX(combo)->button)->child)
    gtk_container_remove(GTK_CONTAINER(GTK_COMBO_BOX(combo)->button),
                         GTK_BIN(GTK_COMBO_BOX(combo)->button)->child);
     

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             data_pixmaps[row][col]);
  pixmap = gtk_pixmap_new(tool, mask);

  gtk_container_add(GTK_CONTAINER(GTK_COMBO_BOX(combo)->button),
                    pixmap);
  gtk_widget_show(pixmap);
  gdk_pixmap_unref(tool);
}

GtkWidget *
sg_toggle_symbol_new()
{
  GtkWidget *combo;
  GtkWidget *pixmap;
  GdkPixmap *tool;
  GdkBitmap *mask;
  GdkColormap *colormap;
  GtkTooltips *tooltips;
  gint i, j;

  symbol_pixmaps[0][0] = symbol_none_xpm; 
  symbol_pixmaps[0][1] = symbol_square_xpm; 
  symbol_pixmaps[0][2] = symbol_circle_xpm; 
  symbol_pixmaps[0][3] = symbol_uptriangle_xpm; 
  symbol_pixmaps[1][0] = symbol_dntriangle_xpm; 
  symbol_pixmaps[1][1] = symbol_rtriangle_xpm; 
  symbol_pixmaps[1][2] = symbol_ltriangle_xpm; 
  symbol_pixmaps[1][3] = symbol_diamond_xpm; 
  symbol_pixmaps[2][0] = symbol_plus_xpm; 
  symbol_pixmaps[2][1] = symbol_cross_xpm; 
  symbol_pixmaps[2][2] = symbol_star_xpm; 
  symbol_pixmaps[2][3] = symbol_dot_xpm; 
  symbol_pixmaps[3][0] = symbol_impulse_xpm; 
  symbol_pixmaps[3][1] = NULL; 
  symbol_pixmaps[3][2] = NULL; 
  symbol_pixmaps[3][3] = NULL; 

  colormap = gdk_colormap_get_system();

  combo = gtk_toggle_combo_new(SYMBOL_ROWS, SYMBOL_COLS);

  for(i = 0; i < SYMBOL_ROWS; i++)
    for(j = 0; j < SYMBOL_COLS; j++){

      if(symbol_pixmaps[i][j]){
        tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                   symbol_pixmaps[i][j]);
        pixmap = gtk_pixmap_new(tool, mask);

        gtk_container_add(GTK_CONTAINER(GTK_TOGGLE_COMBO(combo)->button[i][j]),
                    pixmap);
        gtk_widget_show(pixmap);
        gdk_pixmap_unref(tool);
        gdk_bitmap_unref(mask);

        tooltips = gtk_tooltips_new();
        gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips),
                             GTK_TOGGLE_COMBO(combo)->button[i][j],
                             symbol_text[i][j],
                             symbol_text[i][j]);
        gtk_tooltips_enable(GTK_TOOLTIPS(tooltips));
        gtk_tooltips_set_delay(GTK_TOOLTIPS(tooltips), 0);
      }
    }

  gtk_signal_connect(GTK_OBJECT(combo), "changed", 
                     GTK_SIGNAL_FUNC(sg_toggle_symbol_real_init), symbol_pixmaps);

  sg_toggle_symbol_real_init(GTK_TOGGLE_COMBO(combo), 0, 0, symbol_pixmaps); 
  return combo;
}

void
sg_toggle_symbol_init(GtkWidget *widget, gint selection)
{
  GtkToggleCombo *combo;
  gint row, col;

  combo = GTK_TOGGLE_COMBO(widget);

  row = selection / combo->ncols;
  col = selection - row * combo->ncols;

  gtk_toggle_combo_select(combo, row, col);
}

gint
sg_toggle_symbol_get_selection(GtkWidget *widget)
{
  GtkToggleCombo *combo;

  combo = GTK_TOGGLE_COMBO(widget);
  return (combo->row * combo->ncols + combo->column);
}

static void
sg_toggle_symbol_real_init(GtkToggleCombo *combo, gint row, gint col, gpointer data)
{
  GtkWidget *pixmap;
  GdkPixmap *tool;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();


  if(GTK_BIN(GTK_COMBO_BOX(combo)->button)->child)
    gtk_container_remove(GTK_CONTAINER(GTK_COMBO_BOX(combo)->button),
                         GTK_BIN(GTK_COMBO_BOX(combo)->button)->child);
     

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             symbol_pixmaps[row][col]);
  pixmap = gtk_pixmap_new(tool, mask);

  gtk_container_add(GTK_CONTAINER(GTK_COMBO_BOX(combo)->button),
                    pixmap);
  gtk_widget_show(pixmap);
  gdk_pixmap_unref(tool);
}


