/***************************************************************************
                          track.h  -  description
                             -------------------
    begin                : Wed Sep 27 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TRACK_H
#define TRACK_H

#include "pattern.h"
#include "instrument.h"

/**Each Track
  *@author Juan Sebastian Linietsky
  */


class Track {
	struct Pattern_Config {

		int rowlength;
		int hlminor;
		int hlmajor;

		Pattern_Config() {
			// default values used since the amiga soundtracker ages :)
			rowlength=64;
			hlminor=4;
			hlmajor=16;
		}
	};

public:
	typedef vector<Pattern_Config> Pattern_Data;

protected:

	int columns;

	vector<Pattern*> pattern;

	Pattern_Data *pattern_data;

	Track() {};
public:

	/* Instrument info */
	Instrument instrument;
	/* Patterns Info */

	Pattern* get_pattern(int p_pattern);

	/* Column dealing methods */

	int get_width();
	void set_width(int p_width);

	void add_column();
	void delete_column();

	/* Pattern data stuff */

	void adjust_pattern_data();

	/* Ctor/Dtor */
	
	Track(Pattern_Data *p_pattern_data);
	~Track();
};

#endif
