/***************************************************************************
                          interface.h  -  description
                             -------------------
    begin                : Tue Sep 19 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACE_H
#define INTERFACE_H

#include <gtk--/window.h>
#include <gtk--/box.h>
#include <gtk--/pixmap.h>
#include <gtk--/label.h>
#include <gtk--/notebook.h>
#include <gtk--/main.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gtk--/accelgroup.h>
#include <gtk--/list.h>
#include <gtk--/clist.h>
#include <gtk--/viewport.h>
#include <gtk--/scrolledwindow.h>
#include <gtk--/entry.h>
#include <gtk--/button.h>
#include <gtk--/separator.h>
#include <gtk--/togglebutton.h>
#include <gtk--/combo.h>
#include <gtk--/spinbutton.h>
#include <gtk--/adjustment.h>
#include <gtk--/table.h>
#include <gtk--/frame.h>
#include <gtk--/text.h>
#include <gtk--/radiobutton.h>
#include <gtk--/fileselection.h>
#include <gtk--/fontselection.h>
#include <sigc++/bind.h>
#include "interface_status_widget.h"

#include "tracker.h"
#include "interface_widget_orderlist.h"
#include "player.h"
#include "interface_popups.h"
#include "interface_value.h"
#include "midi_file_export.h"
#include "midi_client.h"


#include "file_operation.h"

#define APP_NAME (string)"ShakeTracker " + (string)VERSION + (string)" (c) 2002 Juan Linietsky "

/**a
  *@author Juan Sebastian Linietsky
  */

/*

	GTK-- Bestiality for the interface.
	I would really like to know a simpler way to do this stuff..
*/


class Interface : public Gtk::Window {

private:

	enum main_notebook_pages {

		main_notebook_Help,
        	main_notebook_Patterns,
		main_notebook_Track_Properties,
		main_notebook_Order_List,
		main_notebook_Variables_and_Info,
		main_notebook_Virtual_Devices,
		main_notebook_System
	};
        char pressed_keys[256];
        vector<Initial_Value_Line*> initial_values;
	OrderlistWidget orderlist;
        // The... Widgets. huh huh.
	//A bit too many..
	//PAttern view

        Gtk::Viewport tracker_viewport;
        Gtk::Viewport logo_viewport;
        Gtk::Viewport info_frame_viewport;


	Popup_Pattern_Utils popup_pattern_utils;
	Window_File_Popup *window_file_popup;
	
	GdkPixmap *icon;
	GdkPixmap *icon_small;
	GdkBitmap *icon_mask;
	GdkBitmap *icon_small_mask;
	
	// Track Properties

	Gtk::Label *labelx;
        Gtk::CList *track_list;
        Gtk::Viewport *viewport2;
        Gtk::ScrolledWindow helpscroll;
        Gtk::ScrolledWindow *scrolledwindow2;
        Gtk::ScrolledWindow *scrolledwindow_track_patch;
        Gtk::ScrolledWindow *trackprops_idata_scrolledwindow;
        Gtk::Label *labelx2;
        Gtk::Entry *entry_track_name;
        Gtk::Button *button_track_moveup;
        Gtk::Button *button_track_movedown;
        Gtk::Button *button_track_clone;
        Gtk::VSeparator *vseparator2;
        Gtk::Button *button7;
        Gtk::ToggleButton *togglebutton_track_mute;
        Gtk::HBox *hbox9;
        Gtk::Button *button_track_remove;
        Gtk::Button *button_track_new;
        Gtk::HBox *hbox3;
        Gtk::VBox *vbox1;
        Gtk::VSeparator *vseparator1;
        Gtk::HBox *hbox2;
        Gtk::Label *label6;
        Gtk::HSeparator *hseparator1;
        Gtk::HSeparator *hseparator2;
        Gtk::Label *label10;
        Gtk::Combo *combo_track_devices;
        Gtk::Label *label11;
        Gtk::Combo *combo_track_banks;
        Gtk::Label *label12;
        Gtk::CList *clist_track_patches;
        Gtk::Entry *entry_track_selected_patch;
        Gtk::Viewport *viewport3;
        Gtk::ScrolledWindow *scrolledwindow3;
        Gtk::HSeparator *hseparator3;
        Gtk::Label *label13;
        Gtk::SpinButton *spinbutton_track_channel;
        Gtk::Adjustment *spinbutton_track_channel_adj;
        Gtk::HBox *hbox6;
        Gtk::Button *button4;
        Gtk::VBox *vbox6;
        Gtk::Label *label7;
        Gtk::HSeparator *hseparator4;
        Gtk::Label *label16;
        Gtk::SpinButton *spinbutton_track_def_volume;
        Gtk::Adjustment *spinbutton_track_def_volume_adj;
        Gtk::SpinButton *spinbutton_track_glb_volume;
        Gtk::Adjustment *spinbutton_track_glb_volume_adj;
        Gtk::Label *label15;
        Gtk::Table *table1;
        Gtk::SpinButton *spinbutton_track_bender_sens;
        Gtk::Adjustment *spinbutton_track_bender_sens_adj;
        Gtk::SpinButton *spinbutton_track_bender_def;
        Gtk::Adjustment *spinbutton_track_bender_def_adj;
        Gtk::HSeparator *hseparator5;
        Gtk::Label *label18;
        Gtk::Label *label17;
        Gtk::Table *table2;
        Gtk::HSeparator *hseparator6;
        Gtk::Label *label21;
        Gtk::HSeparator *hseparator9;
        Gtk::Label *label22;
        Gtk::Combo *combo3;
        Gtk::VBox *vbox12;
//        Gtk::Pixmap *pixmap1;
	
        Gtk::HBox *hbox10;
        Gtk::HSeparator *hseparator10;
        Gtk::Label *label23;
        Gtk::HSeparator *hseparator11;
        Gtk::Label *label24;
        Gtk::RadioButton *radiobutton_tracker_post_volume_nothing;
        Gtk::RadioButton *radiobutton_tracker_post_volume_note_aftertouch;
        Gtk::RadioButton *radiobutton_tracker_post_volume_channel_aftertouch;
        Gtk::RadioButton *radiobutton_tracker_post_volume_controller;
        Gtk::SpinButton *spinbutton_track_volume_post_controller;
        Gtk::Adjustment *spinbutton_track_volume_post_controller_adj;
        Gtk::HBox *hbox12;
        Gtk::VBox *vbox14;
        Gtk::HBox *hbox11;
        Gtk::HSeparator *hseparator12;
        Gtk::Label *label25;
        Gtk::RadioButton *radiobutton_track_volume_behavior_normal;
        Gtk::Label *label26;
        Gtk::RadioButton *radiobutton_track_volume_behavior_tracker;
        Gtk::VBox *vbox13;
        Gtk::VBox *vbox7;
        Gtk::Label *label8;
        Gtk::HSeparator *hseparator7;
        Gtk::Label *label27;
        Gtk::Label *label28;
        Gtk::Label *label29;
        Gtk::HBox *hbox13;
        Gtk::HSeparator *hseparator13;
        Gtk::Label *label_cont_number;
        Gtk::HBox *hbox_controller_line;
        Gtk::VBox *vbox10;
        Gtk::VBox *vbox9;
        Gtk::Viewport *viewport1;
        Gtk::ScrolledWindow *scrolledwindow1;
        Gtk::VBox *vbox8;
        Gtk::Label *label9;
        Gtk::HSeparator *hseparator8;
        Gtk::Entry *entry2;
        Gtk::HBox *hbox8;
        Gtk::VBox *vbox11;
        Gtk::Label *label14;
        Gtk::Notebook *notebook1;
        Gtk::VBox *vbox5;
        Gtk::HBox *hbox1;

	// Virtual Device Properties

        Gtk::FileSelection *fileselection_device_load;
	Gtk::Label *label30;
        Gtk::HSeparator *hseparator14;
        Gtk::CList *clist_virtual_devices;
        Gtk::Viewport *viewport4;
        Gtk::ScrolledWindow *scrolledwindow4;
        Gtk::Button *button_virtual_device_add;
        Gtk::Button *button_virtual_device_delete;
        Gtk::Label *label37;
        Gtk::Button *button_virtual_device_load;
        Gtk::Button *button_virtual_device_save;
        Gtk::HBox *hbox15;
        Gtk::Label *label31;
        Gtk::Entry *entry_virtual_device_name;
        Gtk::HSeparator *hseparator15;
        Gtk::Label *label32;
        Gtk::Combo *combo_virtual_device_hardware_output;
        Gtk::VBox *vbox16;
        Gtk::Frame *frame1;
        Gtk::VBox *vbox15;
        Gtk::VSeparator *vseparator3;
        Gtk::Label *label33;
        Gtk::HSeparator *hseparator16;
        Gtk::Label *label36;
        Gtk::CList *clist_aviable_banks;
        Gtk::Viewport *viewport5;
        Gtk::ScrolledWindow *scrolledwindow5;
        Gtk::Button *button_bank_add;
        Gtk::Button *button_bank_delete;
        Gtk::HBox *hbox17;
        Gtk::Label *label38;
        Gtk::Entry *entry_bank_name;
        Gtk::HSeparator *hseparator17;
        Gtk::Label *label39;
        Gtk::RadioButton *radio_bsm_option1;
        Gtk::RadioButton *radio_bsm_option2;
        Gtk::HBox *hbox20;
        Gtk::Label *label40;
        Gtk::Label *label41;
        Gtk::SpinButton *spinbutton_bank_lsb;
        Gtk::Adjustment *spinbutton_bank_lsb_adj;
        Gtk::SpinButton *spinbutton_bank_msb;
        Gtk::Adjustment *spinbutton_bank_msb_adj;
        Gtk::Table *table3;
        Gtk::RadioButton *radio_bsm_option3;
        Gtk::HBox *hbox21;
        Gtk::Entry *entry_bank_customstring;
        Gtk::VBox *vbox20;
        Gtk::Frame *frame2;
        Gtk::VBox *vbox19;
        Gtk::VSeparator *vseparator4;
        Gtk::CList *clist_bank_patchnames;
        Gtk::Viewport *viewport6;
        Gtk::ScrolledWindow *scrolledwindow6;
        Gtk::Label *label42;
        Gtk::Entry *entry_bank_patchname;
        Gtk::VBox *vbox22;
        Gtk::Frame *frame3;
        Gtk::HBox *hbox16;
        Gtk::VBox *vbox18;
        Gtk::Label *label34;
        Gtk::Label *label43;
        Gtk::CList *clist_bank_controller_names;
        Gtk::Viewport *viewport7;
        Gtk::ScrolledWindow *scrolledwindow7;
        Gtk::Label *label44;
        Gtk::Entry *entry_controller_name;
        Gtk::VBox *vbox23;
        Gtk::Label *label35;
        Gtk::Notebook *notebook2;
        Gtk::VBox *vbox17;
        Gtk::HBox *hbox14;                        	

// SONG variables/info

        Gtk::Label *label68;
        Gtk::HSeparator *hseparator22;
        Gtk::Label *label69;
        Gtk::Label *label70;
        Gtk::SpinButton *spinbutton_song_rpq;
        Gtk::Adjustment *spinbutton_song_rpq_adj;
        Gtk::SpinButton *spinbutton_song_tempo;
        Gtk::Adjustment *spinbutton_song_tempo_adj;
        Gtk::Table *table8;
        Gtk::HSeparator *hseparator24;
        Gtk::Pixmap *pixmap_shake_logo;
        Gtk::VBox *vbox29;
        Gtk::VSeparator *vseparator7;
        Gtk::Label *label71;
        Gtk::HSeparator *hseparator23;
        Gtk::Label *label72;
        Gtk::Entry *entry_song_title;
        Gtk::Label *label73;
        Gtk::Entry *entry_song_author;
        Gtk::Label *label74;
        Gtk::Text *textarea_song_comments;
        Gtk::Text textarea_help;
        Gtk::ScrolledWindow *scrolledwindow10;
        Gtk::VBox *vbox30;
        Gtk::HBox *hbox24;

//SYSYEM tab
        Gtk::Label *label45;
        Gtk::HSeparator *hseparator18;
        Gtk::CList *clist_drivers_list;
        Gtk::Viewport *viewport8;
        Gtk::ScrolledWindow *scrolledwindow8;
        Gtk::Label *label46;
        Gtk::Entry *entry_drivers_parent;
        Gtk::Label *label47;
        Gtk::Text *textarea_drivers_description;
        Gtk::ScrolledWindow *scrolledwindow9;
        Gtk::VBox *vbox26;
        Gtk::Frame *frame4;
        Gtk::Label *label53;
        Gtk::Entry *entry_drivers_resetstring;
        Gtk::SpinButton *spinbutton_drivers_delay;
        Gtk::Adjustment *spinbutton_drivers_delay_adj;
        Gtk::Label *label54;
        Gtk::Button *button_drivers_save_default;
        Gtk::Button *button_drivers_save_all;
        Gtk::CheckButton *checkbutton_drivers_disable;
        Gtk::Table *table7;
        Gtk::Frame *frame7;
        Gtk::VBox *vbox25;
        Gtk::VSeparator *vseparator5;
        Gtk::Label *label49;
        Gtk::HSeparator *hseparator19;
        Gtk::Label *label55;
        Gtk::SpinButton *spinbutton_system_preprocess;
        Gtk::Adjustment *spinbutton_system_preprocess_adj;
        Gtk::HBox *hbox23;
        Gtk::HSeparator *hseparator20;
        Gtk::Label *label52;
        Gtk::Label *label56;
        Gtk::Label *label57;
        Gtk::Label *label58;
        Gtk::Label *label59;
        Gtk::Label *label60;
        Gtk::Label *label61;
        Gtk::Label *label62;
        Gtk::Label *label63;
        Gtk::Label *label64;
        Gtk::Label *label65;
        Gtk::Label *label66;
        Gtk::Label *label_system_freemem;
        Gtk::Label *label_system_eventsused;
        Gtk::Label *label_system_totalevents;
        Gtk::Label *label_system_totalrows;
        Gtk::Label *label_system_totalpatterns;
        Gtk::Label *label_system_totaltracks;
        Gtk::Table *table6;
        Gtk::Frame *frame6;
        Gtk::Button *button_system_saveconfig;
        Gtk::VBox *vbox27;
        Gtk::VSeparator *vseparator6;
        Gtk::Label *label67;
        Gtk::HSeparator *hseparator21;
        Gtk::Button *button_config_widgetcolors;
        Gtk::Button *button_config_keyboardmap;
        Gtk::Button *button_config_commands;
        Gtk::VBox *vbox28;
        Gtk::HBox *hbox22;

//POPUPS -
//-=-=-=-=-=-=-=-

	PopUp_Pattern_Properties *popup_pattern_properties;
	void popup_pattern_properties_confirm();
	Window_Variables_Popup *variables_popup;
	Popup_Scale_Volume *popup_volume_scale;
	void popup_scale_volume_confirm();
	void popup_window_file();
	void popup_window_file_save_pressed();
	void popup_window_file_load_pressed();
	void popup_window_file_fileselection_save();
	void popup_window_file_fileselection_load();
	void popup_window_file_fileselection_export_midi();
	void popup_window_file_new_pressed();
	void popup_window_file_export_midi_pressed();
	void popup_window_file_save_current_pressed();
	void popup_window_file_quit();
	
	void popup_variables_ok_pressed();
	Gtk::FontSelection *font_selection;
	string current_font;
// CALLBACKS - OVERRIDES
//-=-=-=-=-=-=-=-=-=-=-
//
	gint key_press_callback(GdkEventKey* event);
	void main_notebook_page_switched(Gtk::Notebook_Helpers::Page *page,unsigned int page_number);

	// Pattern CALLBACKS
        // -=-=-=-=-=-=-=-=-=-=-=-=-=

	void pattern_popup_copy();
	void pattern_popup_paste();
	void pattern_popup_cut();
	void pattern_popup_zap();

	gint pattern_mouse_down_event(GdkEventButton *event);

	// TRACK Properties CALLBACKS
        // -=-=-=-=-=-=-=-=-=-=-=-=-=

	void button_track_new_pressed();
	void button_track_remove_pressed();
	void button_track_moveup_pressed();
	void button_track_movedown_pressed();
	void button_track_clone_pressed();
	void button_value_delete_pressed(int p_index);
	void combo_track_devices_changed();
	void combo_track_banks_changed();
	void entry_track_name_changed();
	void button_track_add_variables_pressed();
	void clist_track_patches_row_clicked(gint row,gint column,GdkEvent *event);
	void clist_track_list_row_clicked(gint row,gint column,GdkEvent *event);
	
	void spinbutton_track_channel_adj_changed();
	void spinbutton_track_def_volume_adj_changed();
	void spinbutton_track_glb_volume_adj_changed();
	void spinbutton_track_bender_sens_adj_changed();
	void spinbutton_track_bender_def_adj_changed();
	void spinbutton_track_volume_post_controller_adj_changed();
	void spinbutton_track_controller_list_adj_changed(int whichone);
	
	void radiobutton_tracker_post_volume_nothing_changed();
	void radiobutton_tracker_post_volume_note_aftertouch_changed();
	void radiobutton_tracker_post_volume_channel_aftertouch_changed();
	void radiobutton_tracker_post_volume_controller_changed();
	void radiobutton_track_volume_behavior_normal_changed();
	void radiobutton_track_volume_behavior_tracker_changed();

	void togglebutton_track_mute_pressed();
	gint patch_key_press_callback(GdkEventKey* event,bool release);

	// Virtual Devices Callbacks
        // -=-=-=-=-=-=-=-=-=-=-=-=-=

	void fileselection_device_load_ok();
	void fileselection_device_load_cancel();
	void fileselection_device_save_ok();

	void combo_virtual_device_hardware_output_changed();

	void button_virtual_device_add_pressed();
	void button_virtual_device_delete_pressed();
	void button_bank_add_pressed();
	void button_bank_delete_pressed();
	void button_virtual_device_load_pressed();
	void button_virtual_device_save_pressed();

	void clist_virtual_devices_clicked(gint row,gint column,GdkEvent *event);
	void clist_aviable_banks_clicked(gint row,gint column,GdkEvent *event);
	void clist_bank_patchnames_clicked(gint row,gint column,GdkEvent *event);
	void clist_bank_controller_names_clicked(gint row,gint column,GdkEvent *event);

	void entry_virtual_device_name_changed();
	void entry_bank_name_changed();
	void entry_bank_patchname_changed();
	void entry_controller_name_changed();
	
	void spinbutton_bank_lsb_adj_value_changed ();
	void spinbutton_bank_msb_adj_value_changed ();
	
	void radio_bsm_option1_pressed();
	void radio_bsm_option2_pressed();
	void radio_bsm_option3_pressed();
	//song speed and  info
	
	void spinbutton_song_rpq_value_changed ();
	void spinbutton_song_tempo_value_changed ();
	
	//system
	void clist_drivers_list_select_row(gint row,gint column,GdkEvent *event);
	void checkbutton_drivers_disable_pressed();
	void spinbutton_system_preprocess_changed();
	void button_system_font_change();
	//player callbacks

	void player_row_changed(int pattern, int row);

	void player_started() {


		player_active_dangerous_devices_enabled(false);
	}

	void player_stopped() {


		player_active_dangerous_devices_enabled(true);
	}


// INTERFACE - UPDATE
//-=-=-=-=-=-=-=-=-
        /* track properties */
	//-=-=-=-=-=-=-=-=-=-=-
	void request_update_track_properties(int track_number);

	void request_update_combobox_devices(int track_number);
        void request_update_combobox_banks(int track_number);
	void request_update_clist_patches(int track_number);
        void request_update_controller_spinbuttons();

	/* virtual devices */
	//-=-=-=-=-=-=-=-=-=-
	void request_update_virtual_devices(int device_number);
        void request_update_bank_info(int device_number,int bank_number);
	void request_update_patchnames_info(int device_number,int bank_number,int patch_number);
	void request_update_controllers_info(int device_number);

        void update_combobox_hardware_devices();
	void update_entry_virtual_device_name (int device_number);
	void update_clist_aviable_banks (int device_number);
	void update_clist_bank_patchnames(int device_number,int bank_number);
	void update_entry_bank_name(int device_number,int bank_number);
	void update_clist_bank_controller_names(int device_number);

	//system & midiout

	void update_midiout_drivers();
	void update_system_status_box();

	// misc interface variables


	int selected_track;
	int selected_device;
	int selected_bank;
	int selected_patch;
	int selected_controller;
	int selected_midiout;

	bool track_properties_updating_in_progress;
	bool virtual_device_updating_in_progress;
	bool virtual_device_banks_updating_in_progress;
	bool virtual_device_patches_updating_in_progress;
	bool virtual_device_controllers_updating_in_progress;
	bool midiout_drivers_updating_in_progress;
	bool song_speed_and_info_updating_in_progress;
	/* song speed & info */

//DISABLING/ENABLING WIDGETS
//****************

	void track_properties_set_enabled(bool sensitive);
	void virtual_devices_bank_properties_set_enabled(bool sensitive);
	void virtual_devices_enabled(bool sensitive);
	void player_active_dangerous_devices_enabled(bool sensitive);
// MISC  utilities:
//****************	


	unsigned int main_notebook_current_page;

	string return_string_with_number(int number,string instring);
	int string_to_int(string inputstring);
// Player engine notification

	MidiOutDeviceManager *midiout;
	Song *song;
	Player *player;
	File_Operation file_operation;

	gint delete_event_impl(GdkEventAny* p_event) {

		quit_requested=true;
		player->reset();
		return 1;
	}

	bool quit_requested;
	bool key_is_pressed(int key);
	
	int update_info_counter;	
	string current_filename;
	
	void show_help(int p_page);
	
	void load_icons();

	Midi_Client *midi_client;
	
public:

	void set_midi_client(Midi_Client *p_client);
	void set_midiout(MidiOutDeviceManager *p_midiout);
	void set_song(Song *p_song);
	void set_player(Player *p_player);
	void update_info_widgets();
	bool is_quit_requested() { return quit_requested;}

	Gtk::Label *GenericLabel;

      //dependence tree of widgets:
	Gtk::VBox main_vbox;
		//upper frame
	Interface_Status_Widget info_frame;
		//lower frame
	Gtk::Notebook main_notebook;
		
	
	
        void update_midi_input();
	void update_track_list();
	void update_clist_virtual_devices ();
	void request_song_info_speed_update();
	void update_clist_driver_list();

	Tracker tracker;

	Interface();
	Interface(Song *songptr,Player *playerptr,MidiOutDeviceManager *p_midiout);
	~Interface();

       void reset_interface();

};

#endif
   