#!/bin/sh

# $Id: glue.sh,v 1.6 2004/03/28 07:59:15 jason Exp $

TYPE=$1
GLUE=src/glue_${TYPE}s.c
shift

rm -f "$GLUE"

echo "/*  This file is automatically generated by the  */" >> "$GLUE"
echo "/*  utils/glue.sh script.  Do not edit by hand!  */" >> "$GLUE"
echo "" >> "$GLUE"
echo "#include \"shntool.h\"" >> "$GLUE"
echo "" >> "$GLUE"

for module in "$@"; do
  module_name=`echo $module | sed -e 's/\.c//g'`;
  echo "extern ${TYPE}_module ${module_name};" >> "$GLUE"
done

echo "" >> "$GLUE"
echo "${TYPE}_module *${TYPE}s[] = {" >> "$GLUE"

for module in "$@"; do
  module_name=`echo $module | sed -e 's/\.c//g'`;
  echo "  &${module_name}," >> "$GLUE"
done

echo "  NULL" >> "$GLUE"
echo "};" >> "$GLUE"
