#!/bin/sh
# Script used by maintainer when rolling a release tarball.

set -e

major=`echo $1 | sed "s/\..*//g"`
minor=`echo $1 | sed "s/^[0-9]*\.\(.*\)\.[0-9]*$/\1/g"`
rel=`echo $1 | sed "s/^.*\./\1/g"`
version=$1

./.update-po.sh $version

# Generate docs for Xsitecopy
cd gnome/doc
db2html -o `pwd` xsitecopy.sgml
# Remove generated images dir
rm xsitecopy/stylesheet-images/*.gif
rmdir -p xsitecopy/stylesheet-images

