/* # skkinput (Simple Kana-Kanji Input)
 * SkkInputP.h --- Private Header file for SkkInputWidget.
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef _SkkInputP_h
#define _SkkInputP_h

#include "skkmain.h"
#include "skkkey.h"
#include "SkkInput.h"
#include <X11/CoreP.h>

typedef struct {
  Pixel		puppixel ;	/* foreground pixel */
  /* ѤƤեȡΤʤ */
  XFontStruct	*fs_roman ;
  XFontStruct	*fs_kanji ;
  /* ̤褹ΤѤ GC */
  GC roman_ngc, kanji_ngc ;
  GC roman_rgc, kanji_rgc ;
  /* եȤξȴФƤΤϤɤΤǡ*/
  int font_height, font_ascent ;
  int roman_width, kanji_width ;
  /* ȿžɽ뤫ݤ */
  Boolean reverse_video ;
  /* ɽֵڤӥ*/
  String  geo_metry ;
  /* åȥץ⡼ɤݤ*/
  int chat_adapter ;
  /* ɽ֡νɬפݤ*/
  int iposflag ;
  /* Widget Ȥ٤ݤƿƤȤĤΤڤ *
   * ȻפΤɡ 䡢ҶŪ˽λ륳ޥɤ *
   * ФȤΤɡ*/
  int will_be_destroyed ;
  /* (eggߴ) newline */
  int egg_like_newline ;
  int prev_eggnl ;
  /* SKK ˤäѿġ*/
  int date_ad, number_style ;
  int delete_implies_kakutei ;
  int use_numeric_conversion ;
  Boolean compatible_close_skkinputkey ;
  /* եäƤ뤫ɤ*/
  int is_focus ;
  /* ϤѤʬ*/
  unsigned char keybuf[ 3 ] ;
  int keybuf_use ;
  /* ХɤѤʬ*/
  int *skkmap ;
  int *abbrevmap ;
  struct skkinputTwoKeys *twokeymap ;
  /* ϥ٥ȥꡣ*/
  unsigned char **skk_input_vector ;
  unsigned char **skk_zenkaku_vector ;
  /* ޻̾Υ롼ꥹȡĤ줬빽λ˵㤭ˤʤ *
   * ޤưƤ褦ʡ*/
  struct skk_rom_kana_rule *rom_kana_rule_list ;
  /* tab */
  int tab_width ;
  /* ؤΥ٥Ȥ򵭲ơĥ򲡤᤹ΤѤ롣*/
  XEvent xevent ;
  /* ʬѤХåե빽äƤ*/
  unsigned char pwrite_string[ TEXTBUFSIZE ] ;
  unsigned char pmtextbuffer[ TEXTBUFSIZE ] ;
  int prev_modeline ;
  int jisyo_dirty, prev_jisyo_dirty ;
  int prev_chat_adapter ;
  /* åȥХåե*/
  unsigned char cutbuffer[ TEXTBUFSIZE ] ;
  /* ϤФƤҥȥХåեäʸꤷ */
  /* ƱϤäɤפɬסĺɬפɤ */
  /* ʬʤɡ*/
  unsigned char historybuffer[ TEXTBUFSIZE ] ;
  unsigned char histcurbackbuffer[ TEXTBUFSIZE ] ;
  int hist_start, hist_end, hist_cur ;
  /* Callback Ĥʤ˰դġ*/
  XtCallbackList endcallback ;	/* Widget ˲ѡ*/
  XtCallbackList fixcallback ;	/* ѴʸΤѡ*/
  XtCallbackList keybackcallback ;	/* 򲡤᤹Τѡ*/
  XtCallbackList jhenkancallback ;	/* Ѵϻ˸ƤФ롣*/
  XtCallbackList jhenkanendcallback ;	/* Ѵλ˸ƤФ롣*/
  XtCallbackList jsavejisyocallback ;	/* Υ֤ǸƤФ롣*/
  XtCallbackList jtangotourokucallback ;
  XtCallbackList jtangosakujocallback ;
  XtCallbackList jcompletioncallback ;
  XtCallbackList jcompletionclosecallback ;
  XtCallbackList notmodifiedcallback ;
  /* ѴѤХåեԽȤϤΥХåեǹԤ롣*/
  struct SKKInputNode *topbuffer ;
  /* ֺǸΥХåեminibuffer ǤֺǿΤΤǻ *
   * 롣*/
  struct SKKInputNode *lastbuffer ;

} SkkInputPart ;

/* դ뤤󤹤󤹡 */
typedef struct _SkkInputRec {
  CorePart 	core ;
  SkkInputPart	skkinput ;
} SkkInputRec ;

/* New fields for the My widget class record */
typedef struct {
  int dummy ;
} SkkInputClassPart ;

/* դ뤯餹 */
typedef struct _EyesClassRec {
  CoreClassPart		core_class ;
  SkkInputClassPart	skkinput_class ;
} SkkInputClassRec ;

/* 餹ݤ󤿡 */
extern SkkInputClassRec skkinputClassRec ;

#endif
