/* # skkinput (Simple Kana-Kanji Input)
 * skkel.c --- Emacs-lisp -> C
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * ΥϡSkkInput.c ΰǤꡢSkkInputWidget ΰǤ
 * äơȤδؿϳϷ褷ƸƤӤʤ褦 static
 */
#include "table.h"
#include "skkel.h"
#if 0
#include "mytime.h"
#endif

/*
 * ץȥ
 */
/* skkel.c */
static int delete_char
( struct SKKInputNode *node, int pos, int count ) ;
static int j_insert_str
( struct SKKInputNode *node, int pos, char *str ) ;
static void j_n_convert_to_kana( struct SKKInputNode *node ) ;
static int j_set_okurigana
( Widget gw, struct SKKInputNode *node, int j_okuri_chara ) ;
static void j_set_henkan_point_subr
( Widget gw, struct SKKInputNode *node, int chara ) ;
static void j_input_by_code_or_menu_jmp_showCandidate
( struct SKKInputNode *node, int code ) ;
static int j_compute_numeric_henkan_key
( unsigned char *dptr, unsigned char *sptr, unsigned char *j_num_list ) ;
static int j_insert_word
( Widget gw, struct SKKInputNode *node, int pos, unsigned char *word ) ;
static int j_start_henkan_sub( Widget gw, struct SKKInputNode *node ) ;
static int j_numeric_convert
( struct SKKInputNode *node, unsigned char *sptr, unsigned char *dptr ) ;
static int j_concat
( struct SKKInputNode *node, unsigned char *sptr, unsigned char *dptr ) ;
static unsigned char *j_num_exp
( unsigned char *j_num_list_ptr, int type, unsigned char *dptr ) ;
static int rom_kana_rule_list_check
( Widget gw, struct SKKInputNode *node, int chara ) ;
static int j_self_insert
( Widget gw, struct SKKInputNode *node, int chara ) ;
#if 0
static struct my_tm my_localtime( unsigned long long int sec ) ;
#endif
static int j_quote_char( unsigned char *word ) ;
static int save_ringbuffer
( unsigned char *buffer, int bufsize, int *startpos, int *endpos,
  unsigned char *string ) ;
static void j_keyboard_quit_henkanrestart
( Widget gw, struct SKKInputNode *node, int flag ) ;

/* skkmbuf.c */
static int j_read_string
( Widget gw, struct SKKInputNode *node, char *string, int minibuff_usage ) ;
/* SkkInput.c */
static int skkinput_j_henkan_in_minibuff_init
( Widget gw, struct SKKInputNode *node ) ;
static void free_Minibuffer
( Widget gw, struct SKKInputNode *node ) ;
/* skkwin.c */
static void skkinput_ClearMinibuffer( Widget gw ) ;
/* skksvect.c */
extern int copyCandidate
( char *dest, SkkinpSearchVector *sNode, int position, int length ) ;
/* skkmarker.c */
static int move_marker_ByInsert
( struct SKKInputNode *node, int startpoint, int effect ) ;
static int move_marker_ByDeleteRegion
( struct SKKInputNode *node, int startpoint, int endpoint ) ;
static int set_marker_ByGeqPosition
( struct SKKInputNode *node, int startpos, int setpos ) ;

/*
 * Хѿ
 */
/* ִȤκݤѤ٤ƥݥΥХåե*/
unsigned char temporary_buffer[ TEXTBUFSIZE * 2 ] ;
/* ʸΥХȿ*/
static const int j_kanji_length = 2 ;
static const int j_input_by_code_or_menu_jump_default = 161 ;

static char *j_input_by_code_menu_keys1 = "asdfghqwerty" ;
static char *j_input_by_code_menu_keys2 = "asdfghjklqwertyu" ;
static unsigned char j_input_by_code_menu1_codes[] =
{ 161, 177, 193, 209, 225, 241 } ;
static int j_code_n1_min = 161, j_code_n1_max = 244 ;
static int j_code_n2_min = 161, j_code_n2_max = 254 ;

/*
 * 顼ɽؿľˤ⤦äȤޤʤΤѲ뤳ȤǤ餦
 */
void err_msg( struct SKKInputNode *node, char *fmt, ... )
{
  va_list valist ;
  va_start( valist, fmt ) ;
  vsprintf( node->mtextbuffer, fmt, valist ) ;
  va_end( valist ) ;
  return ;
}

/*
 * ʸʸľ֤ؿĤäơǤʤɬפʤΡ Ȥ
 * 줽
 */
static char *charaToString( int chara )
{
  static char cbuf[ 4 ] ;
  const char dispChara[] = "[\\]^_" ;

  /* ʬϡؾ󹩳زĸ漼θƣΥѥåǤ*/
  /*-----  -----  -----  -----  -----*/
  if( chara == 0x1b ) {/*ESC"ESC"Ȥ*/
    cbuf[ 0 ] = 'E';
    cbuf[ 1 ] = 'S';
    cbuf[ 2 ] = 'C';
    cbuf[ 3 ] = '\0';
  } else if( chara < 0x20 || chara == 0x7F ){
  /*----- ޤ ----- ޤ ----- ޤ ----- ޤ -----*/
    cbuf[ 0 ] = 'C' ;
    cbuf[ 1 ] = '-' ;
    cbuf[ 3 ] = '\0' ;
    if( chara == 0 ){
      /* Del key ξ硣*/
      cbuf[ 2 ] = '@' ;
    } else if( chara == 0x7F ){
      /* Del key ξ硣*/
      cbuf[ 2 ] = '?' ;
    } else if( chara >= 0x1b ){
      /* ʳΥȥ륳ɤξǥե٥åȤʤ*/
      cbuf[ 2 ] = dispChara[ chara - 0x1b ] ;
    } else {
      /* ե٥åȤɽǤ륳ȥ륳ɤξ硣*/
      cbuf[ 2 ] = ( 'a' - 1 ) + chara ;
    }
  } else {
    cbuf[ 0 ] = chara ;
    cbuf[ 1 ] = '\0' ;
  }
  return cbuf ;
}

static void j_n_convert_to_kana( struct SKKInputNode *node )
{
  delete_char( node, node->j_kana_start_point, 1 ) ;
  if( node->j_katakana_mode ){
    j_insert_str( node, node->j_kana_start_point, "" ) ;
  } else {
    j_insert_str( node, node->j_kana_start_point, "" ) ;
  }
  return ;
}

static int last_character_of( unsigned char *prefix )
{
  int length = strlen( prefix ) ;
  if( length > 0 ){
    return prefix[ length - 1 ] ;
  } 
  return '\0' ;
}

/*
 * 겾̾⡼ɤ˰ܹԤƤ褤ɤȽǤؿ
 */
static int is_okurigana_start_ok( struct SKKInputNode *node )
{
  unsigned int pchara, ppchara ;
  int pos ;
  /* ֤ˤʤʸäƤ줿Τʤɤɡǽ *
   * ʸƼʸ겾̾ʤƸ줿ˤϡ̾ *
   * ϳϰ֤鸫ʤܤ顣*/
  pos = ( node->j_kana_mode )? node->j_kana_start_point : node->cur_pos ;
  /* ֤Ѵϰ֤ܤǤ롣*/
  if( pos == node->j_henkan_start_point )
    return False ;
  if( pos < j_kanji_length )
    return False ;
  /* Ϥ줿ʸǤ뤫ˤʤ롣*/
  pchara = node->textbuffer[ pos - 1 ] ;
  if( pchara & 0x80 ){
    /* ʸ "" Τɤ줫ʤ겾 *
     * ̾⡼ɤˤϤʤʤ*/
    ppchara = node->textbuffer[ pos - 2 ] ;
    if( ppchara == 0xA3 && ( pchara >= 0xB0 && pchara <= 0xB9 ) )
      return False ;
  } else {
    /* ʸ "0123456789><?" Τɤ줫ʤ겾̾⡼*
     * ˤϤʤʤ*/
    if( pchara >= '0' && pchara <= '9' )
      return False ;
    if( pchara == '>' || pchara == '<' || pchara == '?' )
      return False ;
  }
  return True ;
}

/*
 * ĶŬѴ롼Ҥؿ
 */
static struct skk_rom_kana_rule *j_assoc_rule
( Widget gw, unsigned char *prefix )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  struct skk_rom_kana_rule *element = w->skkinput.rom_kana_rule_list ;
  /* ꤵƤʤä顢Ҥʤ*/
  if( element == NULL )
    return NULL ;
  /* 㤢õޤ礦*/
  while( element->state != NULL ){
    if( !strcmp( element->state, prefix ) )
      return element ;
    element ++ ;
  }
  return NULL ;
}

/*
 * ꤵ줿ʸʤΤɤȽǤؿ
 */
static int is_hatsuon_ok( unsigned char *j_prefix, int rchara )
{
  int lchara, schara ;
  /* ʸȾʸѴˤɤʤΤƤ*/
  lchara = ( rchara >= 'a' && rchara <= 'z' )?
    rchara + ( 'A' - 'a' ) : rchara ;
  schara = ( rchara >= 'A' && rchara <= 'Z' )?
    rchara + ( 'a' - 'A' ) : rchara ;
  /* ե٥åȤ³ʤǡǤ*/
  if( schara < 'a' || schara > 'z' )
    return False ;
  /* "X" äƤȤϤʤȻפɤ͡*/
  if( schara == 'x' )
    return False ;
  /* ʸʤä顢ܤǤ硩 */
  if( j_prefix[ 1 ] != '\0' )
    return False ;
  if( j_prefix[ 0 ] != lchara && j_prefix[ 0 ] != schara )
    return False ;
  return True ;
}

/*
 * ֤ʸؿ
 */
static int j_insert_str( struct SKKInputNode *node, int pos, char *str )
{
  int len_txt = strlen( node->textbuffer ) ;
  int len_str = strlen( str ) ;
  int count ;
  char *sptr, *dptr ;

  /* ξ꤫ʸȡǥХåե̤Ķ硣*/
  if( pos + len_str > TEXTMAXLEN ){
    strncpy( node->textbuffer + pos, str, TEXTMAXLEN - pos ) ;
    node->textbuffer[ TEXTMAXLEN ] = '\0' ;
    /* ξ硢֤Ͼ \0 ǤʤȤʤ*/
    move_marker_ByInsert( node, pos, TEXTMAXLEN - pos ) ;
    /* cur_pos = TEXTMAXLEN ; */
    return 0 ;
  }
  if( pos != len_txt ){
    if( len_txt + len_str > TEXTMAXLEN ){
      /* ʸǥȡʸʸХåե̤Ķ硣*/
      count = TEXTMAXLEN - len_str - pos ;
      sptr  = node->textbuffer + TEXTMAXLEN - len_str ;
      dptr  = node->textbuffer + TEXTMAXLEN ; /* = '\0' */
    } else {
      /* ʸʸХåեդʤ硣*/
      count = len_txt - pos ;
      sptr  = node->textbuffer + len_txt ;
      dptr  = node->textbuffer + len_txt + len_str ;
    }
    /* ʬʸư롣*/
    while( count >= 0 ){
      *dptr -- = *sptr -- ;
      count -- ;
    }
    /* ʸԤ*/
    dptr = node->textbuffer + pos ;
    sptr = str ;
    while( *sptr != '\0' )
      *dptr ++ = *sptr ++ ;
  } else {
    /* ʸԤ*/
    dptr = node->textbuffer + pos ;
    sptr = str ;
    while( *sptr != '\0' )
      *dptr ++ = *sptr ++ ;
    *dptr = '\0' ;
  }
  /* ʸʬޡư롣*/
  move_marker_ByInsert( node, pos, len_str ) ;
  return 0 ;
}

/*
 * ꤵ줿֤ʸޡưؿ
 */
static int j_insert_chara
( struct SKKInputNode *node, int pos, int chara )
{
  int i ;
  int len = strlen( node->textbuffer ) ;
  char *ptr ;

  /* ϥƥȤΰֺǸؤƤΤʡ */
  if( node->textbuffer[ pos ] == '\0' ){
    if( pos < TEXTMAXLEN ){
      /* ʤǤֺǸ­餤Ǥϥޡϰưʤ*/
      node->textbuffer[ pos ++ ] = chara ;
      node->textbuffer[ pos    ] = '\0' ;
      node->cur_pos ++ ;
    }
    return 0 ;
  }
  if( len >= TEXTMAXLEN ){
    len = TEXTMAXLEN ;
    ptr = node->textbuffer + TEXTMAXLEN ;
  } else {
    ptr = node->textbuffer + len + 1 ;
  }
  *ptr -- = '\0' ;
  for( i = len ; i > pos ; i -- ){
    *ptr = *( ptr - 1 ) ;
    ptr -- ;
  }
  *ptr = chara ;
  /* ޡΰư*/
  move_marker_ByInsert( node, pos, 1 ) ;
  /* cur_pos ++ ; */
  return 0 ;
}

/*
 * Ϥ줿ʸ¸ߤ prefix ǤСTrue 򡢤Ǥʤ
 * False ֤ؿ
 */
static int j_kana_prefix_check( unsigned char *str, int chara )
{
  int i, length = strlen( str ) ;
#ifdef DEBUG_LV1
  fprintf( stderr, "Prefix Check : \"%s\".\n", str ) ;
#endif
  for( i = 0 ; skk_prefix_list[ i ] != NULL ; i ++ ){
    /* ץեʤΤǤ礦 */
    if( !strncmp( skk_prefix_list[ i ], str, length ) ){
      /* ٤äǸϤ줿ʸΤȰפˤ *
       * ̵뤹롣*/
      if( ( skk_prefix_list[ i ] )[ length + 0 ] != chara )
	continue ;
      /* Ϥ줿ʸäơ٤ʤäܤ */
      if( ( skk_prefix_list[ i ] )[ length + 1 ] != '\0' )
	continue ;
      return True ;
    }
  }
  return False ;
}

/*
 * j_prefix Ϥ줿ʸ­ؿ
 */
static int j_prefix_add( unsigned char *j_prefix, int chara )
{
  while( *j_prefix != '\0' )
    j_prefix ++ ;
  *j_prefix ++ = chara ;
  *j_prefix ++ = '\0' ;
  return True ;
}

/*
 * ꤵ줿ΰؿ
 */
static int j_delete_region
( struct SKKInputNode *node, int startpoint, int endpoint )
{
  char *sptr, *dptr ;

  if( startpoint == endpoint || startpoint > endpoint )
    return 0 ;
#ifdef DEBUG_LV1
  fprintf( stderr, "j-delete-region : \"" ) ;
#endif
  /* ΰκԤ*/
  dptr = node->textbuffer + startpoint ;
  sptr = node->textbuffer + endpoint ;
  while( *sptr != '\0' ){
#ifdef DEBUG_LV1
    fprintf( stderr, "%c", *dptr ) ;
#endif
    *dptr ++ = *sptr ++ ;
  }
  *dptr = '\0' ;
#ifdef DEBUG_LV1
  fprintf( stderr, "\"\n" ) ;
#endif
  /* ޡ(ߡ)ΰư*/
  move_marker_ByDeleteRegion( node, startpoint, endpoint ) ;
  return 0 ;
}

/*
 * ꤵ줿֤饫̤ʸäؿ
 *-----
 * delete_region ޤΤȤǤ衣
 */
static int delete_char( struct SKKInputNode *node, int pos, int count )
{
  int i, j ;
  j = pos ;
  /* ̤ʸäȤȤϤɤΤ餤ΥХȥʤΤʡ*/
  for( i = 0 ; i < count ; i ++ ){
    if( node->textbuffer[ j ] & 0x80 ){
      /* ɤǤäˤ 2ХȷǤ*/
      if( node->textbuffer[ j ] == '\0' ){
	/* ʾξõԲǽǤ硣*/
	node->textbuffer[ pos ] = '\0' ;
	/* õ褦ȤƤ֤鱦Υޡƾõ֤ء*/
	set_marker_ByGeqPosition( node, pos, pos ) ;
	return 0 ;
      }
      /* ޤޤäȤǽʾ硣*/
      j ++ ;
    }
    /* ʸ򥹥åס*/
    if( node->textbuffer[ j ] == '\0' ){
      node->textbuffer[ pos ] = '\0' ;
      /* õ褦ȤƤ֤鱦Υޡƾõ֤ء*/
      set_marker_ByGeqPosition( node, pos, pos ) ;
      return 0 ;
    }
    j ++ ;
  }
  /* ʸá*/
  strcpy( temporary_buffer,       node->textbuffer + j   ) ;
  strcpy( node->textbuffer + pos, temporary_buffer ) ;
  /* ޡΰư*/
  move_marker_ByDeleteRegion( node, pos, j ) ;
  return 0 ;
}

/*
 * Ϳ줿֤饫̤ưΥ
 * ؿ
 */
static int calc_forward_char( struct SKKInputNode *node, int pos, int count )
{
  int i, j ;
  /* ư롣*/
  j = pos ;
  for( i = 0 ; i < count ; i ++ ){
    if( node->textbuffer[ j ] == '\0' )
      break ;
    if( node->textbuffer[ j ] & 0x80 ){
      j ++ ;
      if( node->textbuffer[ j ] == '\0' ){
	err_msg( node, "WARNING : Illegal character in text.\n" ) ;
	break ;
      }
    }
    j ++ ;
  }
  return j ;
}

/*
 * Emacs-Lisp  Looking-At ؿ
 *-----
 * ͡äˤʤǤ졣
 */
static int looking_at( struct SKKInputNode *node, int pos, char *str )
{
  return !strncmp( node->textbuffer + pos, str, strlen( str ) ) ;
}

static int j_kakutei_kana_mode
( Widget gw, struct SKKInputNode *node, int chara )
{
  if( !node->j_kana_mode )
    return False ;
  /* ԥʤɡrom-kana-rule-list 줿ʤ˻Ȥ '\0' */
  if( chara != '\0' ){
    if( rom_kana_rule_list_check( gw, node, chara ) ){
      /* 겾̾ϤǥҥåȤ顢̾γˤѴ *
       * ʤФʤʤ*/
      if( node->j_henkan_mode && !node->j_henkan_on &&
	  node->j_okurigana_mode ){
	j_set_okurigana( gw, node, node->j_okuri_chara ) ;
      }
      return True ;
    }
  }
  /* Ǹ "n" äƤơ줬ѤϤ ""ˤʤä顩 */
  if( node->j_prefix[ 0 ] == 'n' && node->j_prefix[ 1 ] == '\0' ){
    j_n_convert_to_kana( node ) ;
    node->j_kana_mode = False ;
    node->j_prefix[ 0 ] = '\0' ;
    if( node->j_henkan_mode && !node->j_henkan_on &&
	node->j_okurigana_mode ){
      j_set_okurigana( gw, node, 'n' ) ;
    }
    return False ;
  }
  j_delete_region( node, node->j_kana_start_point, node->cur_pos ) ;
  node->j_kana_mode = False ;
  node->j_prefix[ 0 ] = '\0' ;
  return False ;
}

/*
 * ̾ѴγȤԤؿʤΤǤ롣
 */
static int j_kakutei
( Widget gw, struct SKKInputNode *node )
{
  int pos ;
  struct SKKTangoInfo jtango ;
  unsigned char j_toroku_string[ TEXTBUFSIZE ] ;

  node->j_mode    = True ;
  node->j_zenkaku = False ;
  node->j_abbrev  = False ;
  node->j_henkan_show_candidate_mode = False ;

  node->j_num_list[ 0 ] = '\0' ;

  /* Ѵ⡼ɤäƤΤɤǧ롣ΥȤ active  *
   * on β᤬դˤʤäƤ롣                                          */
  if( node->j_henkan_mode ){
    if( node->j_henkan_on && ( node->j_henkan_count > 0 ) ){
      /* ǡιʤ뤬...ޤưʡ */
      if( node->j_current_henkan_vector_index != NULL ){
	jtango.henkankey = ( node->j_okurigana_mode )? 
	  node->j_henkan_key : node->j_search_key ; 
	/* ΤޤϿƤޤȤޤã뤫⤷ʤΤ *
	 * 롣*/
	copyCandidate
	  ( j_toroku_string,
	   node->j_current_henkan_vector_index->node,
	   node->j_current_henkan_vector_index->position,
	   node->j_current_henkan_vector_index->length ) ;
	if( j_quote_char( j_toroku_string ) ){
	  /* ʸνä顢ʤĤʤϿ *
	   * ʤʸϿ롣*/
	  jtango.tangotype = 0 ;
	  jtango.string    = j_toroku_string ;
	} else {
	  /* ʸνʤäˤϡ list Τޤ޻Ȥ *
	   * 뤫list ĤʤϿ롣*/
	  jtango.tangotype = 1 ;
	  jtango.vector    = node->j_current_henkan_vector_index ;
	  jtango.vectortop = &node->j_henkan_vector_index_top ;
	}
	jtango.okuri     = node->j_okurigana_mode ;
	XtCallCallbacks( gw, XtNjtangotourokuNotify, &jtango ) ;
      }
      /* ѴλƽФ*/
      XtCallCallbacks( gw, XtNjhenkanendNotify, node ) ;
    }
    pos = node->j_henkan_start_point - j_kanji_length ;	/* goto-char */
    if( node->j_henkan_on ){
      /* Ѵϰ֤ˡ֢פϤΤ ̵ä顢ѡ*/
      if( looking_at( node, pos, "" ) ){
	delete_char( node, pos, 1 ) ;
      } else {
	err_msg( node, "It seems that you have deleted ." ) ;
      }
    } else {
      if( looking_at( node, pos, "" ) ){
	delete_char( node, pos, 1 ) ;
      } else {
	err_msg( node, "It seems that you have deleted ." ) ;
      }
    }
    /* ư겾̾⡼ɤäν*/
    if( node->j_okurigana_mode ){
      /* 겾̾ϰ֤ˤ "*" ¸ߤȦʤǤɡġ*/
      pos = node->j_okurigana_start_point ;
      if( looking_at( node, pos, "*" ) ){
	delete_char( node, pos, 1 ) ;
      }
      /* Ȥ櫓ǡ겾̾⡼ɤߤˤʤ櫓Ǥ*/
      node->j_okurigana_mode = False ;
      node->j_okuri_chara = '\0' ;
    }
    /* j_abbrev = False ; */
  }
  node->j_henkan_mode      = False ;
  node->j_henkan_on        = False ;
  node->j_okurigana_mode   = False ;
  node->j_okuri_chara      = '\0' ;
  node->j_henkan_count     = 0 ;
  return 0 ;
}

/*
 * skkinput-rom-kana-rule-list ŬѤؿ
 */
static int rom_kana_rule_list_check
( Widget gw, struct SKKInputNode *node, int chara )
{
  struct skk_rom_kana_rule *element ;
  int length = strlen( node->j_prefix ) ;
  /* ʸäޤ*/
  node->j_prefix[ length + 0 ] = chara ;
  node->j_prefix[ length + 1 ] = '\0' ;
  /* ޤߤΥץեǥơ֥Ҥޤ*/
  element = j_assoc_rule( gw, node->j_prefix ) ;
  /* ҥåȤޤ */
  if( element == NULL ){
    /* j-prefix ϸᤷƤޤ*/
    node->j_prefix[ length + 0 ] = '\0' ;
    return False ;
  }
  /* ̾ץե롣*/
  j_delete_region( node, node->j_kana_start_point, node->cur_pos ) ;
  node->j_prefix[ 0 ] = '\0' ;
  /* ̾⡼ɤǤϤʤʤġ*/
  node->j_kana_mode = False ;
  /* ҥåȤʸ롣*/
  if( node->j_katakana_mode ){
    if( element->koutput != NULL )
      j_insert_str( node, node->cur_pos, element->koutput ) ;
  } else {
    if( element->houtput != NULL )
      j_insert_str( node, node->cur_pos, element->houtput ) ;
  }
  if( element->next != NULL ){
    /* ֤¸ߤʤ顢롣*/
    node->j_kana_start_point = node->cur_pos ;
    j_insert_str( node, node->cur_pos, element->next ) ;
    strcpy( node->j_prefix, element->next ) ;
    node->j_kana_mode = True ;
  }
  /* ŬѤǤȤȤϲ̾γ꤬ä顢ѴϤ¾ *
   * ̣Ȥ롣*/
  return True ;
}

/*
 * ʸե٥åȤϤ褦ȤƤνԤؿ
 *----
 * ʸե٥åȤϡϲ̾Ϥ褦ȤƤִ֤̣
 * ΤǤ롣
 */
static int j_kana_input
( Widget gw, struct SKKInputNode *node, int chara )
{
  /* skkinput ֤ȴФ*/
  int status = ( node->j_henkan_mode << 3 ) | ( node->j_henkan_on << 2 ) |
    ( node->j_kana_mode << 1 ) | ( node->j_okurigana_mode ) ;
  /* int length ;*/

#ifdef DEBUG_LV0
  fprintf( stderr, "K( j_henkan_mode, j_henkan_on, j_kana_mode,\
j_okurigana_mode ) = (%d,%d,%d,%d)\n", node->j_henkan_mode, 
	   node->j_henkan_on, node->j_kana_mode, node->j_okurigana_mode ) ;
#endif

  /* ɽ*/
  switch( status ){
    /* ѴԤƤǡ̾Ϥʤ겾̾äƤ硣*/
  case J_HENKAN_MODE_ON | J_HENKAN_ON | J_KANA_MODE_OFF | J_OKURIGANA_ON :
    /* 겾̾ѴˤäѴԤ줿ľˡʸϤä硣*
     * ޤꤷƤ顢Ϥ줿ʸɽ롣*/
    j_kakutei( gw, node ) ;
#if 0
    j_kakutei_kana( node, chara ) ;
#endif
    goto j_kana_input_label1 ;

    /* ѴԤƤǡ̾Ϥʤ硣*/
  case J_HENKAN_MODE_ON | J_HENKAN_ON | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    /* ȤԤ롣 OFF ξƱ*/
    j_kakutei( gw, node ) ;
#if 0
    j_kakutei_kana( node, chara ) ;
#endif

  case J_HENKAN_MODE_ON | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_ON :

    /* ̤˽ФƤβ̾ϡǤ⡢Ĥ...ȴʤΤ *
     * 顢J_HENKAN_MODE_OFF λƱJ_HENKAN_MODE ΤѲ  *
     * ʤפǤ礦                                        */
  case J_HENKAN_MODE_ON | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_OFF :

    /* ϤƤʤ֤β̾ϡ*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    j_kana_input_label1 : ;
    /* ֤˲̾Ѵϥޡꤹ롣*/
    node->j_kana_start_point = node->cur_pos ;
    /* Ϥ饯ɽ롣ĤǤˡưƤ*
     * */
    j_insert_chara( node, node->cur_pos, chara ) ;
    /* ̾Ϥ顢j-prefix ͭˤʤĤΥߥ󥰤 *
     * ɤΡ */
    node->j_prefix[ 0 ] = chara ;
    node->j_prefix[ 1 ] = '\0' ;
    /* ̾⡼ɤˤʤ롣*/
    node->j_kana_mode = True ;
    break ;

    /* ֢*sפȤ褦ʾ֤Ǥ롣Ѵ⡼ɤǤꡢ겾̾⡼ *
     * Ǥꡢ̾⡼ɤǤȤΤϡ                                 */
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_ON :
#if 0
    /* ѴԤƤǡ̾prefixϡ겾̾ϤΤ硣*/
  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_ON :
    /* ξϳꤷƤϤʤ겾̾⡼ɤĤƤȤȤ *
     * 겾̾ʤΤꤷƤʤȤȤ顣                 */
#endif
    /* Ѵ⡼ɤǤꡢ˲̾ϤƤ硣*/
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_OFF :

    /* ̾Ϥ褦ȤƤ硣*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
    j_kana_input_label2 :
    /* 롼ꥹȤҤޤǡj-prefix Ϲޤ*/
    if( rom_kana_rule_list_check( gw, node, chara ) ){
      /* 겾̾ϤǤꡢ 'n' Ϥˤä *
       * ̾Ǥä 'n' ꤷƤޤν*/
      if( node->j_henkan_mode && node->j_okurigana_mode )
	j_set_okurigana( gw, node, node->j_okuri_chara ) ;
      break ;
    }
    /* ̤ơ prefix ¸ߤǤޤΡ 䤵*/
    if( !j_kana_prefix_check( node->j_prefix, chara ) ){
      /* äѤꡢ¸ߤǤޤΤ͡פä̤Ǥ*/
#if 0
      /*
      if( node->textbuffer[ node->j_kana_start_point ] == 'n' &&
	  node->cur_pos == ( node->j_kana_start_point + 1 ) ){
	  */
#else
      if( node->j_prefix[ 0 ] == 'n' && node->j_prefix[ 1 ] == '\0' ){
#endif
	/* ̾ϰ֤ɽƤnפä*/
	j_n_convert_to_kana( node ) ;
	/* ̾ϳϰ֤򤺤餹*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸ򥫡֤롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	/* ̾Ϥ顢j-prefix ͭˤʤĤΥߥ *
	 * ɤΡ */
	node->j_prefix[ 0 ] = chara ;
	node->j_prefix[ 1 ] = '\0' ;
	/* j_kana_mode = True */
	break ;
      }
      /* ɤåΤǤ롣*/
      if( is_hatsuon_ok( node->j_prefix, chara ) ){
	/* ɽƤʸäޤ礦*/
	delete_char( node, node->j_kana_start_point, 1 ) ;
	/* ¥ؤޤ礦*/
	/* ΤȤcur_pos == j_kana_start_point ȦǤ롣*/
	if( node->j_katakana_mode ){
	  j_insert_str( node, node->j_kana_start_point, "" ) ;
	} else {
	  j_insert_str( node, node->j_kana_start_point, "" ) ;
	}
	/* ̾ϰ֤򤺤餷ޤȡ*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸ򥫡֤롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	node->j_prefix[ 0 ] = chara ;
	node->j_prefix[ 1 ] = '\0' ;
	/* j_kana_mode = True */
	break ;
      }
      /* פʤ prefix ϾõޤƤ衣*/
      delete_char( node, node->j_kana_start_point,
		   node->cur_pos - node->j_kana_start_point ) ;
      /* ̾Ѵϰ֤ѹޤ͡*/
      node->j_kana_start_point = node->cur_pos ;
      /* Ϥʸ˽ޤ*/
      node->j_prefix[ 0 ] = '\0' ;
    }
    /* Ϥʸɽ*/
    j_insert_chara( node, node->cur_pos, chara ) ;
    j_prefix_add( node->j_prefix, chara ) ;
    break ;

    /* Ĥɤ롢ɤʤ롢ܿ
     * ɤäƲ褹Τ */
  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_ON :
    /* 겾̾ѴˤäѴԤ줿ľˡʸϤä硣*
     * ޤꤷƤ顢Ϥ줿ʸɽ롣*/
    /* ޤǰ̾γ꤬äɤȽǤʤܡ*/
    if( ( node->j_okurigana_start_point + 1 ) <
	node->j_kana_start_point ){
      j_kakutei( gw, node ) ;
      goto j_kana_input_label2 ;
    }
    /* 롼ꥹȤҤޤǡj-prefix Ϲޤ*/
    if( rom_kana_rule_list_check( gw, node, chara ) ){
      break ;
    }
    /* ǳȤԤ*/
    j_kakutei( gw, node ) ;
    /* ̤ơ prefix ¸ߤǤޤΡ 䤵*/
    if( !j_kana_prefix_check( node->j_prefix, chara ) ){
      if( node->j_prefix[ 0 ] == 'n' && node->j_prefix[ 1 ] == '\0' ){
	/* ̾ϰ֤ɽƤnפä*/
	j_n_convert_to_kana( node ) ;
	/* ̾ϳϰ֤򤺤餹*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸ򥫡֤롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	/* ̾Ϥ顢j-prefix ͭˤʤĤΥߥ *
	 * ɤΡ */
	node->j_prefix[ 0 ] = chara ;
	node->j_prefix[ 1 ] = '\0' ;
	/* j_kana_mode = True */
	break ;
      }
      /* ɤåΤǤ롣*/
      if( is_hatsuon_ok( node->j_prefix, chara ) ){
	/* ɽƤʸäޤ礦*/
	delete_char( node, node->j_kana_start_point, 1 ) ;
	/* ¥ؤޤ礦*/
	/* ΤȤcur_pos == j_kana_start_point ȦǤ롣*/
	if( node->j_katakana_mode ){
	  j_insert_str( node, node->j_kana_start_point, "" ) ;
	} else {
	  j_insert_str( node, node->j_kana_start_point, "" ) ;
	}
	/* ̾ϰ֤򤺤餷ޤȡ*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸ򥫡֤롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	node->j_prefix[ 0 ] = chara ;
	node->j_prefix[ 1 ] = '\0' ;
	/* j_kana_mode = True */
	break ;
      }
      /* פʤ prefix ϾõޤƤ衣*/
      delete_char( node, node->j_kana_start_point,
		   node->cur_pos - node->j_kana_start_point ) ;
      /* ̾Ѵϰ֤ѹޤ͡*/
      node->j_kana_start_point = node->cur_pos ;
      /* Ϥʸ˽ޤ*/
      node->j_prefix[ 0 ] = '\0' ;
    }
    /* Ϥʸɽ*/
    j_insert_chara( node, node->cur_pos, chara ) ;
    j_prefix_add( node->j_prefix, chara ) ;
    break ;

    /* ʲä㤤ʤ֤󤫤ʡ */
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_ON :
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_ON :

    /* νϡѴ⡼ɤˤʤäƤʤΤˡѴƤ뤫顣*/
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_ON :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_ON :

  default :
    /* λ֤ϤꤨʤΤǡ顼*/
    err_msg( node, "ERROR : Illegal status %d\n", status ) ;
    break ;
  }
  return 0 ;
}

/*
 * ޡѲؿ
 *-----
 * Ϥϥޡΰ֤Ǥ˥ޡ̵ä顢顼֤ޤ
 */
static int j_change_marker( struct SKKInputNode *node, int pos )
{
  if( !looking_at( node, pos, "" ) )
    return 1 ;
  node->textbuffer[ pos ++ ] = 0xA2 ;
  node->textbuffer[ pos ++ ] = 0xA7 ;
  return 0 ;
}

/*
 * ޡѲؿ
 *-----
 * Ϥϥޡΰ֤Ǥ˥ޡ̵ä顢顼֤ޤ
 */
static int j_change_marker_to_write( struct SKKInputNode *node, int pos )
{
  if( !looking_at( node, pos, "" ) )
    return 1 ;
  node->textbuffer[ pos ++ ] = 0xA2 ;
  node->textbuffer[ pos ++ ] = 0xA6 ;
  return 0 ;
}

/* Show candidates in the minibuffer */
VectorIndex *j_henkan_show_candidates
( Widget gw, struct SKKInputNode *node, int *count )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  int i, restnum, mojisuu, h_count ;
  static char *j_henkan_show_candidates_keys[ 7 ] = {
    "A:", "S:", "D:", "F:", "J:", "K:", "L:",
  } ;
  VectorIndex *vNode ;
  /* 󡢤ˤ⤳ʤǤäХåեɬפˤʤää(;_;) */
  unsigned char buffer[ TEXTBUFSIZE * 2 ], *rptr ;

  vNode                  = node->j_current_henkan_vector_index ;
  h_count                = node->j_henkan_count ; 
  node->mtextbuffer[ 0 ] = '\0' ;

  /* ĸ䤬ĤäƤΤʡ */
  restnum = node->j_henkan_vector_index_length - h_count + 1 ;

  /* ɽǽʸꡢʾȥХåեդ롣*/
  mojisuu = TEXTMAXLEN ;

  /* 󤷤ޤ*/
  for( i = 0 ; i < 7 && vNode != NULL ; i ++, restnum -- ){
    /* 򥭡դä롣*/
    strncat( node->mtextbuffer, j_henkan_show_candidates_keys[ i ],
	     mojisuu ) ;
    mojisuu -= 2 ;
    if( mojisuu <= 0 )
      break ;

    /* դä롣*/
    copyCandidate
      ( temporary_buffer, vNode->node, vNode->position, TEXTMAXLEN ) ;
    rptr = temporary_buffer ;
    if( node->j_num_list[ 0 ] != '\0' &&
	w->skkinput.use_numeric_conversion ){
      j_numeric_convert( node, temporary_buffer, buffer ) ;
      rptr = buffer ;
    }
    /* θؤ褦ꤹ롣*/
    vNode = vNode->next ;

    /* ܤθ䤫ꤹ롣*/
    h_count ++ ;
    strncat( node->mtextbuffer, rptr, mojisuu ) ;
    mojisuu -= strlen( rptr ) ;
    if( mojisuu <= 0 )
      break ;
    /* ä롣*/
    strncat( node->mtextbuffer, " ", mojisuu ) ;
    mojisuu -- ;
    if( mojisuu <= 0 )
      break ;
  }
  /* ޤʸХåե;͵ޤ */
  if( mojisuu > 0 ){
    sprintf( temporary_buffer, "[Ĥ %d]", restnum ) ;
    strncat( node->mtextbuffer, temporary_buffer, mojisuu ) ;
  }
  /* ʸȤƽü롣*/
  node->mtextbuffer[ TEXTMAXLEN ] = '\0' ;
  node->j_henkan_show_candidate_mode = True ;

  /* ºݡɤޤǸɽδ֤ơ */
  if( count != NULL )
    *count = h_count ;

  /* ݥ󥿤֤*/
  return vNode ;
}

/*
 * ѴưԤؿ
 *-----
 * δؿ j_start_henkan ƤФƤɬפޤ衣
 */
static int j_henkan( Widget gw, struct SKKInputNode *node )
{
  int found = False ;
#if 0
  SkkInputWidget w = ( SkkInputWidget )gw ;
#endif

  /* 줬ǽѴäˤϡ*/
  if( node->j_henkan_on != True ){
    /* ֢פ֢פѴ... */
    if ( j_change_marker
	 ( node, node->j_henkan_start_point - j_kanji_length ) ){
      err_msg( node, "It seems that you have deleted ." ) ;
      node->j_henkan_mode    = False ;
      node->j_okurigana_mode = False ;
      node->j_kana_mode      = False ;
      return 0 ;
    }
    /* Ѵե饰ΩƤΤǤ롣*/
    node->j_henkan_on    = True ;
    node->j_henkan_count = 0 ;
  }
  /* ѴꤵƤʤΤѴ褦Ȥ顢ꤷƤޤ*/
  if( !strlen( node->j_henkan_key ) ){
    j_kakutei( gw, node ) ;
    return 0 ;
  }
  /* 줬ǽѴäˤ Σ */
  if( node->j_henkan_count == 0 ){
    /* Ѵγ׵ȯԤ롣*/
    XtCallCallbacks( gw, XtNjhenkanNotify, node ) ;

    /* η̡j_henkan_vector ¾Ѵ̤ȥꥹȤˤʤ*
     * ΤǤ롣*/

    /* Ѵη̤ϤɤäΤʡ */
    if( node->j_henkan_count ){
      found = True ;
    } else {
      found = False ;
    }
  } else {
    if( node->j_henkan_count < 4 ){
      /* ϻͲʾˤʤä顢ɽڤؤȤ롣*/
      if( ( node->j_current_henkan_vector_index )->next != NULL ){
	node->j_current_henkan_vector_index =
	  ( node->j_current_henkan_vector_index )->next ;
	node->j_henkan_count ++ ;
	found = True ;
      }
    } else {
      /* Ͳʾˤʤä顢ɽڤؤ롣*/
      if( ( node->j_current_henkan_vector_index )->next != NULL ){
	/* Ͳʾˤʤäִ֤ NULL Ȥäơ䤬⤦̵ *
	 * ʤäƤ뤳ȤʤȤǧ롣*/
	node->j_current_henkan_vector_index =
	  ( node->j_current_henkan_vector_index )->next ;

	/* ǣĤȤȤˤʤ롣*/
	node->j_henkan_count ++ ;

	node->j_henkan_show_candidate_mode = True ;
	/* Ѵäޤ*/
	j_delete_region( node,
			 node->j_henkan_start_point,
			 node->j_henkan_end_point ) ;
	/* ΰɽޤȡ*/
	j_henkan_show_candidates( gw, node, NULL ) ;
	/* ǡ򤤤ʤȴޤ*/
	return 0 ;
      }
    }
  }
  if( found ){
#if 1
    if( node->j_henkan_vector_index_top == NULL ){
      fprintf( stderr, "found, but no candidates exist.\n" ) ;
      fflush( stderr ) ;
    } else {
#endif
      /* Ѵäޤ*/
      node->cur_pos2 = node->j_kana_start_point ;
      node->cur_pos3 = node->j_okurigana_start_point ;
      j_delete_region
	( node, node->j_henkan_start_point, node->j_henkan_end_point ) ;
      copyCandidate
	( temporary_buffer, ( node->j_current_henkan_vector_index )->node,
	  ( node->j_current_henkan_vector_index )->position,
	  TEXTMAXLEN ) ;
      node->j_kana_start_point = node->cur_pos ;
      /* Ѵλ֤Ĵ*/
      node->cur_pos_backup = node->cur_pos ;
      node->cur_pos        = node->j_henkan_start_point ;
      /* ʸ*/
#if 0
      j_insert_str( node, node->j_henkan_start_point, temporary_buffer ) ;
#else
      j_insert_word
	( gw, node, node->j_henkan_start_point, temporary_buffer ) ;
#endif
      node->j_henkan_end_point = node->cur_pos ;
      node->j_kana_start_point = node->cur_pos2 ;
      node->j_okurigana_start_point = node->cur_pos3 ;
      node->cur_pos = node->cur_pos_backup ;
    }
  } else {
    /* minibuffer 򳫤ƤѴȤ˰ư롣*/
    skkinput_j_henkan_in_minibuff_init( gw, node ) ;
  }
  return 0 ;
}

/*
 * ʸΥե٥åȤϤ줿ȤˤꡢѴϰ֤ꤵ
 * Ѵ⡼ɤؤȰܹԤȤԤؿ
 * -----
 * 첻ϤͤƤʤϤΤϻҲ
 * ȤȤ򤷤ĺ첻Ϥ줿ξܤ
 * δؿ˵Ҥ뤳Ȥˤʤ롣
 * -----
 * Ҳ ....
 *   1. ̾ϤƤ ... ̾prefixΥå¥֤פΥå
 *   2. ɽȲ̾,Ѵꤹ롣
 *   3. 겾̾⡼ɤɬפ
 */
static int j_set_henkan_point_ByConsonat
( Widget gw, struct SKKInputNode *node, int chara )
{
  /* skkinput ֤ȴФ*/
  int status = ( node->j_henkan_mode << 3 ) | ( node->j_henkan_on << 2 ) |
    ( node->j_kana_mode << 1 ) | ( node->j_okurigana_mode ) ;
  int rchara, tchara, ret ;

#ifdef DEBUG_LV0
  fprintf( stderr, "C( j_henkan_mode, j_henkan_on, j_kana_mode,\
j_okurigana_mode ) = (%d,%d,%d,%d)\n", node->j_henkan_mode, 
	   node->j_henkan_on, node->j_kana_mode, node->j_okurigana_mode ) ;
#endif
  /* ʸĤƤ*/
  rchara = chara ;
  /* ʸʸѴ*/
  if( chara >= 'A' && chara <='Z' )
    chara += 'a' - 'A' ;

  /* ɽ*/
  switch( status ){

    /* ϤƤʤ֤Ѵֻꡣ*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    j_set_henkan_point_label1 : ;
    /* ɽơ*/
    j_insert_str( node, node->cur_pos, "" ) ;
    /* Ѵϰ֤򥫡֤˷ꤷơ*/
    node->j_henkan_start_point = node->cur_pos ;
    node->j_kana_start_point   = node->cur_pos ;
    /* Ѵ⡼ɡ̾ϥ⡼ɤ򥪥ˤ롣*/
    node->j_henkan_mode = node->j_kana_mode = True ;
    /* ֤˥饯ɽ롣*/
    j_insert_chara( node, node->cur_pos, chara ) ;
    node->j_prefix[ 0 ] = chara ;
    node->j_prefix[ 1 ] = '\0' ;
    break ;

    /* ѴǤʤΤ겾̾⡼ɤˤʤ뤳ȤϤʤ*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_ON :
    break ;

    /* ˲̾⡼ɤǤäν*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_ON | J_OKURIGANA_OFF :
    /* ǽ˾ʸäƤ顢ʸäĥ롼ꥹ *
     * Ȥ˥ҥåȤˤϡѴϤˤϤʤʤ*/
    if( rom_kana_rule_list_check( gw, node, rchara ) ){
      break ;
    }
    /* 괺Ѵ⡼ɤذܹԤ롣*/
    node->j_henkan_mode = True ;
    /* ("sk" "sk" ("". "")) Ȥ§äˤϡprfix check *
     * ʤäƤϤޤޥ*/
    if( !rom_kana_rule_list_check( gw, node, chara ) ){
      /* ξ硢prefix Ȥ¥νȤޤ롣*/
      if( node->j_prefix[ 0 ] == 'n' && node->j_prefix[ 1 ] == '\0' ){
	/* ̾ϰ֤ɽƤnפä*/
	j_n_convert_to_kana( node ) ;
	/* ޡ*/
	j_insert_str( node, node->cur_pos, "" ) ;
	/* Ѵϰ֤ꡣϡ֢פΰ֤ˤ碌롣*/
	node->j_henkan_start_point = node->cur_pos ;
	node->j_kana_start_point   = node->cur_pos ;
	j_insert_chara( node, node->cur_pos, chara ) ;
	node->j_prefix[ 0 ] = chara ;
	node->j_prefix[ 1 ] = '\0' ;
	node->j_kana_mode = True ;
	break ;
      }
      /* ¥ɤåΤǤ롣*/
      if( node->textbuffer[ node->j_kana_start_point ] == chara &&
	  chara != 'x' ){
	/* ɽƤʸäޤ礦*/
	delete_char( node, node->j_kana_start_point, 1 ) ;
	/* ¥ؤޤ礦*/
	/* ΤȤcur_pos == j_kana_start_point ȦǤ롣*/
	if( node->j_katakana_mode ){
	  j_insert_str( node, node->j_kana_start_point, "" ) ;
	} else {
	  j_insert_str( node, node->j_kana_start_point, "" ) ;
	}
	/* ޡ*/
	j_insert_str( node, node->j_kana_start_point, "" ) ;
	node->j_henkan_start_point =
	  node->j_kana_start_point + j_kanji_length ;
	/* ̾ϰ֤򤺤餷ޤȡ*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸ򥫡֤롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	node->j_prefix[ 0 ] = chara ;
	node->j_prefix[ 1 ] = '\0' ;
#if 0
	fprintf( stderr, "(c,k,h) = ( %d, %d, %d )\n", node->cur_pos,
		 node->j_kana_start_point, node->j_henkan_start_point ) ;
#endif
	/* j_kana_mode = True */
	break ;
      }
      /* ̤ơ prefix ¸ߤǤޤΡ 䤵*/
      if( !j_kana_prefix_check( node->j_prefix, chara ) ){
	/* äѤꡢ¸ߤǤޤΤ͡פä̤Ǥ*/
	/* פʤ prefix ϾõޤƤ衣*/
	delete_char( node, node->j_kana_start_point, 
		     node->cur_pos - node->j_kana_start_point ) ;
	/* ̾Ѵϰ֤ѹޤ͡*/
	node->j_kana_start_point = node->cur_pos ;
      }
      /* Ϥʸɽ*/
      j_insert_chara( node, node->cur_pos, chara ) ;
      node->j_prefix[ 0 ] = chara ;
      node->j_prefix[ 1 ] = '\0' ;
    }
    /* ޡ*/
    j_insert_str( node, node->j_kana_start_point, "" ) ;
    /* Ѵϰ֤ꡣϡ֢פΰ֤ˤ碌롣*/
    node->j_henkan_start_point =
      node->j_kana_start_point + j_kanji_length ;
    node->j_kana_start_point   =
      node->j_henkan_start_point ; /* 2 == strlen( "" ) */
    break ;

    /* ѴǤʤΤ겾̾⡼ɤˤʤ뤳ȤϤʤ*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_ON :

    /* Ѵ⡼ɤ˰ܹԤƤʤΤˡѴǤ뤳ȤϤʤ*/
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_ON  :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_ON  :
    break ;
    
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
    if( rom_kana_rule_list_check( gw, node, rchara ) ){
      break ;
    }
    /* ξ硢prefix Ȥ¥νȤޤ롣*/
    if( node->j_prefix[ 0 ] == 'n' &&
	node->j_prefix[ 1 ] == '\0' ){
      if( node->j_henkan_start_point == node->j_kana_start_point ){
	/* ̾ϰ֤ɽƤnפä*/
	j_n_convert_to_kana( node ) ;
	if( chara == 'n' ){
	  node->j_kana_mode = False ;
	  node->j_prefix[ 0 ] = '\0' ;
	} else {
	  /* ֤ꡣ*/
	  node->j_kana_start_point = node->cur_pos ;
	  /* ̾ϥ⡼ɤذܹԡ*/
	  node->j_kana_mode = True ;
	  /* Ϥʸɽ롣*/
	  j_insert_chara( node, node->cur_pos, chara ) ;
	  node->j_prefix[ 0 ] = chara ;
	  node->j_prefix[ 1 ] = '\0' ;
	}
      } else {
	/* ̾ϰ֤ɽƤnפä*/
	j_n_convert_to_kana( node ) ;
	/* ֤겾̾γϥݥȡ*/
	node->j_okurigana_start_point = node->cur_pos ;
	/* 겾̾γϥݥȤˡ*פ롣*/
	j_insert_chara( node, node->cur_pos, '*' ) ;
	/* 겾̾⡼ɤذܹԤ롣*/
	node->j_okurigana_mode = True ;
	node->j_okuri_chara = chara ;
	/* ֤ꡣ*/
	node->j_kana_start_point = node->cur_pos ;
	/* ̾ϥ⡼ɤذܹԡ*/
	node->j_kana_mode = True ;
	/* Ϥʸɽ롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	node->j_prefix[ 0 ] = chara ;
	node->j_prefix[ 1 ] = '\0' ;
      }
      break ;
    }
    /* Ϥ "n" Ǥäν*/
    if( chara == 'n' ){
      /*
       * ξϴǼ¹ԤƤΤǡǤϤʤ
       * if( textbuffer[ j_kana_start_point ] == 'n' ){
       */
      delete_char( node, node->j_kana_start_point, 1 ) ;
      /* ֤ꡣ*/
      node->j_kana_start_point = node->cur_pos ;
      /* ̾ϥ⡼ɤذܹԡ*/
      node->j_kana_mode = True ;
      /* Ϥʸɽ롣*/
      j_insert_chara( node, node->cur_pos, chara ) ;
      node->j_prefix[ 0 ] = chara ;
      node->j_prefix[ 1 ] = '\0' ;
      break ;
    }
    /* ¥ɤåΤǤ롣*/
    if( node->textbuffer[ node->j_kana_start_point ] == chara &&
	chara != 'x' ){
      /* ɽƤʸäޤ礦*/
      delete_char( node, node->j_kana_start_point, 1 ) ;
      /* ¥ؤޤ礦*/
      /* ΤȤcur_pos == j_kana_start_point ȦǤ롣*/
      if( node->j_katakana_mode ){
	j_insert_str( node, node->j_kana_start_point, "" ) ;
      } else {
	j_insert_str( node, node->j_kana_start_point, "" ) ;
      }
      /* ֤겾̾γϥݥȡ*/
      node->j_okurigana_start_point = node->cur_pos ;
      /* 겾̾γϥݥȤˡ*פ롣*/
      j_insert_chara( node, node->cur_pos, '*' ) ;
      /* 겾̾⡼ɤذܹԤ롣*/
      node->j_okurigana_mode = True ;
      node->j_okuri_chara = chara ;
      /* ֤ꡣ*/
      node->j_kana_start_point = node->cur_pos ;
      /* Ϥʸɽ롣*/
      j_insert_chara( node, node->cur_pos, chara ) ;
      node->j_prefix[ 0 ] = chara ;
      node->j_prefix[ 1 ] = '\0' ;
      /* j_kana_mode = True */
      break ;
    }
    /* rom-kana-rule-list Ƥޤä顢j-prefix Ͻ *
     *   Ƥޤ⤷ޤ*/
    /* ֤ƤäȡȤϤ餫ФƤФäƤȤʡ*/
    /* ֤îޡ*/
    tchara = node->j_prefix[ 0 ] ;
    /* ("sk" "sk" ("". "")) Ȥ§äˤϡprfix check *
     * ʤäƤϤޤ*/
    if( rom_kana_rule_list_check( gw, node, chara ) ){
      /* ְãǤʤˤꤤޤΤˡġQskK ʤ *
       *   Ϥʤʤơġ */
      node->cur_pos_backup = node->cur_pos ;
      node->cur_pos = node->j_kana_start_point ;
      ret = is_okurigana_start_ok( node ) ;
      node->cur_pos = node->cur_pos_backup ;
      /* ֤ۤۤ顢ͤͤ"QskK"  "Ӥ" äƽФ *
       *   衣Ƹơġ */
      /* 餱ޤ(ϥХ) */
      if( ret ){
	/* ֤겾̾γϥݥȡ*/
	node->j_okurigana_start_point = node->j_kana_start_point ;
	node->cur_pos2 = node->j_kana_start_point ;
	/* 겾̾γϥݥȤˡ*פ롣*/
	j_insert_chara( node, node->j_okurigana_start_point, '*' ) ;
	node->j_kana_start_point = node->cur_pos2 ;
	/* 겾̾⡼ɤذܹԤ롣*/
	node->j_okurigana_mode = True ;
	node->j_okuri_chara = tchara ;
	j_set_okurigana( gw, node, node->j_okuri_chara ) ;
      }
      break ;
    }
    /* ̤ơ prefix ¸ߤǤޤΡ 䤵*/
    if( !j_kana_prefix_check( node->j_prefix, chara ) ){
      /* פʤ prefix ϾõޤƤ衣*/
      delete_char( node, node->j_kana_start_point,
		   node->cur_pos - node->j_kana_start_point ) ;
      /* äѤꡢ¸ߤǤޤΤ͡פä̤Ǥ*/
      if( node->j_prefix[ 0 ] == 'n' && node->j_prefix[ 1 ] == '\0' ){
	/* nפ֤פѴʤȤʤΤɤå*/
	/* ̾ϰ֤ɽƤnפä*/
	j_n_convert_to_kana( node ) ;
	/* ̾ϳϰ֤򤺤餹*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸ򥫡֤롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	node->j_prefix[ 0 ] = chara ;
	node->j_prefix[ 1 ] = '\0' ;
	/* j_kana_mode = True */
	break ;
      }
      if( is_okurigana_start_ok( node ) ){
	/* ֤겾̾γϥݥȡ*/
	node->j_okurigana_start_point = node->cur_pos ;
	/* 겾̾γϥݥȤˡ*פ롣*/
	j_insert_chara( node, node->cur_pos, '*' ) ;
	/* 겾̾⡼ɤذܹԤ롣*/
	node->j_okurigana_mode = True ;
	node->j_okuri_chara = chara ;
      }
      node->j_kana_start_point = node->cur_pos ;
      node->j_prefix[ 0 ] = '\0' ;
    } else {
      if( node->j_prefix[ 0 ] != '\0' && 
	  is_okurigana_start_ok( node ) ){
	/* ޤʸõ롣*/
	j_delete_region
	  ( node, node->j_kana_start_point, node->cur_pos ) ;
	/* ֤겾̾γϥݥȡ*/
	node->j_okurigana_start_point = node->cur_pos ;
	/* 겾̾γϥݥȤˡ*פ롣*/
	j_insert_chara( node, node->cur_pos, '*' ) ;
	/* 겾̾⡼ɤذܹԤ롣*/
	node->j_okurigana_mode = True ;
	/* ʤȡ줿ΤǰߤĤ*/
	node->j_okuri_chara = chara ;
	node->j_kana_start_point = node->cur_pos ;
      }
    }
    /* ̾ϥ⡼ɤذܹԡ*/
    node->j_kana_mode = True ;
    /* Ϥʸɽ롣*/
    j_insert_chara( node, node->cur_pos, chara ) ;
    j_prefix_add( node->j_prefix, chara ) ;
    break ;

    /* Ѵ⡼ɤʸե٥åȤϤ줿ˤ겾̾⡼ɤ */
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    /* ǥ֤ 0 礭ȤƤޤɡ *
     * ͳϴñƬѴ򳫻ϤƤ⡢2 ˤʤ뤫顣*/
    if( is_okurigana_start_ok( node ) ){
      /* ֤겾̾γϥݥȡ*/
      node->j_okurigana_start_point = node->cur_pos ;
      /* 겾̾γϥݥȤˡ*פ롣*/
      j_insert_chara( node, node->cur_pos, '*' ) ;
      /* 겾̾⡼ɤذܹԤ롣*/
      node->j_okurigana_mode = True ;
      node->j_okuri_chara = chara ;
    }
    /* ֤ꡣ*/
    node->j_kana_start_point = node->cur_pos ;
    /* ̾ϥ⡼ɤذܹԡ*/
    node->j_kana_mode = True ;
    /* Ϥʸɽ롣*/
    j_insert_chara( node, node->cur_pos, chara ) ;
    node->j_prefix[ 0 ] = chara ;
    node->j_prefix[ 1 ] = '\0' ;
    break ;

    /* ֢*sפȤ褦ʾ֤Ǥ롣Ѵ⡼ɤǤꡢ겾̾⡼ *
     * Ǥꡢ̾⡼ɤǤȤΤϡ̾⡼ɤǤʤʤ   *
     * 겾̾⡼ɤȦϤʤΤǡξ֤¸ߤʤ             */
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_ON  :
    break ;

    /* ֢*sפȤ褦ʾ֤Ǥ롣Ѵ⡼ɤǤꡢ겾̾⡼ *
     * Ǥꡢ̾⡼ɤǤȤΤϡ                                 */
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_ON  :
    if( rom_kana_rule_list_check( gw, node, rchara ) ){
      break ;
    }
    /* ξʸϤ⾮ʸϤطʤʸλν롣*/
#if 0
    /* if( node->textbuffer[ node->j_kana_start_point ] == 'n' ){ */
#else
    if( node->j_prefix[ 0 ] == 'n' && node->j_prefix[ 1 ] == '\0' ){
#endif
      /* nפ֤פѴʤȤʤΤɤå*/
      /* ̾ϰ֤ɽƤnפä*/
      j_n_convert_to_kana( node ) ;
      /* ̾ϳϰ֤򤺤餹*/
      node->j_kana_start_point = node->cur_pos ;
      /* Ϥʸ򥫡֤롣*/
      j_insert_chara( node, node->cur_pos, chara ) ;
      node->j_prefix[ 0 ] = chara ;
      node->j_prefix[ 1 ] = '\0' ;
      /* j_kana_mode = True */
      /* äȡ֤פ˳ꤷƤޤȤȤѴȤɬפˤʤ롣*/
      /* ȻפäɡǤʤߤ*/
      break ;
    }
    /* ¥ɤåΤǤ롣*/
    if( node->textbuffer[ node->j_kana_start_point ] == chara &&
	chara != 'x' ){
      /* ɽƤʸäޤ礦*/
      delete_char( node, node->j_kana_start_point, 1 ) ;
      /* ¥ؤޤ礦*/
      /* ΤȤcur_pos == j_kana_start_point ȦǤ롣*/
      if( node->j_katakana_mode ){
	j_insert_str( node, node->j_kana_start_point, "" ) ;
      } else {
	j_insert_str( node, node->j_kana_start_point, "" ) ;
      }
      /* ̾ϰ֤򤺤餷ޤȡ*/
      node->j_kana_start_point = node->cur_pos ;
      /* Ϥʸ򥫡֤롣*/
      j_insert_chara( node, node->cur_pos, chara ) ;
      node->j_prefix[ 0 ] = chara ;
      node->j_prefix[ 1 ] = '\0' ;
      /* j_kana_mode = True */
      break ;
    }
    /* ̤ơ prefix ¸ߤǤޤΡ 䤵*/
    if( !j_kana_prefix_check( node->j_prefix, chara ) ){
      /* äѤꡢ¸ߤǤޤΤ͡פä̤Ǥ*/
      /* פʤ prefix ϾõޤƤ衣*/
      delete_char( node, node->j_kana_start_point,
		   node->cur_pos - node->j_kana_start_point ) ;
      /* ̾Ѵϰ֤ѹޤ͡*/
      node->j_kana_start_point = node->cur_pos ;
      node->j_prefix[ 0 ] = '\0' ;
    }
    /* Ϥʸɽ*/
    j_insert_chara( node, node->cur_pos, chara ) ;
    j_prefix_add( node->j_prefix, chara ) ;
    break ;
    
  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    /* ξˤϳȤԤ줿塢not_active, henkan_off Ʊ*/
    j_kakutei( gw, node ) ;
#if 0
    j_kakutei_kana( node, chara ) ;
#endif
    goto j_set_henkan_point_label1 ;

    /* ѴԤƤǡ̾prefixϤʤ겾̾ϤΤ硣*/
  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_ON  :
    /* ξˤϳȤԤ줿塢not_active, henkan_off, okuri_off */
    j_kakutei( gw, node ) ;
#if 0
    j_kakutei_kana( node, chara ) ;
#endif
    goto j_set_henkan_point_label1 ;

  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
    /* Ѵ kana_prefix ä顢ꤷƤޤΤǡξϤʤ*/
    break ;

  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_ON  :
    /* Ѵ⡼ɤ겾̾ꤷơѴȤʤä֤ǲ̾prefix   *
     * 뤳ȤϤʤ                                                     */
    break ;
  }
  return 0 ;
}

/*
 * ʴѴơ֥ơ̤֤ؿ
 */
static char *my_assoc_table_search
( struct SKKInputNode *node, struct roma_kana_table *table, char *key )
{
  struct roma_kana_table *ptr = table ;
  /* ơ֥Ҥ*/
  while( ptr->prefix != NULL ){
    if( !strcmp( ptr->prefix, key ) ){
      if( node->j_katakana_mode ){
	/* Ҳ̾äν*/
	return ptr->katakana ;
      } else {
	/* ʿ̾äν*/
	return ptr->kana ;
      }
    }
    ptr ++ ;
  }
  return NULL ;
}

/*
 * 겾̾ꤷѴȤؤȰưؿ
 *-----
 * Ĥޤꡢ֢ߡפξ֤ʸ "R" Ϥˡ֢*פ
 * ʤä ֢פؤѲȤԤ
 */
static int j_set_okurigana
( Widget gw, struct SKKInputNode *node, int j_okuri_chara )
{
  int i, j, stpos, enpos, usage ;
  /* Ѵλ֤ꡣ*/
  node->j_henkan_end_point = node->j_okurigana_start_point ;
  /* '*' ¸ߤ뤫ɤΥå*/
  if( !looking_at( node, node->j_okurigana_start_point, "*" ) ){
    j_insert_chara( node, node->j_okurigana_start_point, '*' ) ;
  }
  /* ñϿλɽʸ¸Ƥ*/
  usage = node->j_okurigana_start_point - node->j_henkan_start_point ;
  /* Хåե򤢤դ뤳Ȥʤ̵Ȼפɤ͡*/
  if( usage > 0 ){
    strncpy( node->j_henkan_key2, node->textbuffer +
	   node->j_henkan_start_point, usage ) ;
    node->j_henkan_key2[ usage ++ ] = '*' ;
  } else {
    usage = 0 ;
  }
  node->j_henkan_key2[ usage ] = '\0' ;
  /* 겾̾ȴФƲä롣*/
  stpos = ( node->j_okurigana_start_point < TEXTMAXLEN )?
    node->j_okurigana_start_point + 1 : node->j_okurigana_start_point ;
  if( node->j_kana_mode ){
    enpos = node->j_kana_start_point ;
  } else {
    enpos = node->cur_pos ;
  }
  /* ɤΰ̤ʸȴФΡ */
  j = enpos - stpos ;
  /* 羮طդäνǤ͡*/
  if( j < 0 ){
    int tmp ;
    /* 羮طҤä꤫ޤ*/
    j = -j ;
    /* ϰ֤λ֤򴹤ޤ*/
    tmp   = stpos ;
    stpos = enpos ;
    enpos = tmp ;
  }
  /* ȡХåե줵뤳Ȥ̵褦ꤷޤ*/
  if( j + usage > TEXTMAXLEN ){
    j = TEXTMAXLEN - usage ;
  }
  /* ȡʸäޤ*/
  strncat( node->j_henkan_key2, node->textbuffer + stpos, j ) ;
  node->j_henkan_key2[ j + usage ] = '\0' ;
#if 0
  fprintf( stderr, "j-henkan-key2 : \"%s\"\n", tmpbuf ) ;
#endif
  i = node->j_henkan_end_point - node->j_henkan_start_point ;
  /* Ѵꡣ*/
  strncpy( node->j_henkan_key,
	   node->textbuffer + node->j_henkan_start_point, i ) ;
  node->j_okurigana_offset   = i ;
  node->j_henkan_key[ i ++ ] = j_okuri_chara ;
  node->j_henkan_key[ i ++ ] = '\0' ;
#if 0
  node->j_prefix[ 0 ] = '\0' ;
#endif
  /* `*' õ롣*/
  j_delete_region
    ( node, 
      node->j_okurigana_start_point, node->j_okurigana_start_point + 1 ) ;
#if 0
  fprintf( stderr, "j-set-okurigana : \"%s\".\n", textbuffer ) ;
  fprintf( stderr, "( c, hs, he ) = ( %d, %d, %d )\n",
	   cur_pos, j_henkan_start_point, j_henkan_end_point ) ;
#endif
  /* ѴȤԤ*/
  j_henkan( gw, node ) ;
#if 0
  fprintf( stderr, "j-set-okurigana : \"%s\".\n", textbuffer ) ;
  fprintf( stderr, "( c, hs, he ) = ( %d, %d, %d )\n",
	   cur_pos, j_henkan_start_point, j_henkan_end_point ) ;
  /* ϰ¹ԤƤߤʤΤľäȤɤʤ롩 */
  node->j_okurigana_mode = False ;
  node->j_okuri_chara = '\0' ;
#endif
  return 0 ;
}

/*
 * ʤꤹؿ
 *----
 * kana inserting functions.
 */
static int j_kanakakutei
( Widget gw, struct SKKInputNode *node, struct roma_kana_table *table,
  int chara )
{
  unsigned char *str ;
  int j_okuri_chara ;

  /* ̾ϤǤ */
  if( !node->j_kana_mode ){
    /* ̾ϤǤʤν*/
#ifdef DEBUG_LV0
    fprintf( stderr, "Now not kana input mode\n" ) ;
#endif
    /* ̾Ϥγϰ֤롣*/
    node->j_kana_start_point = node->cur_pos ;
    /* ̾ prefix ϲ̾γˤäƶˤʤ롣*/
    node->j_prefix[ 0 ] = '\0' ;
    j_okuri_chara = node->j_okuri_chara ;
  } else {
    /* ̾ϤξνĤǤ⡢rule-list ⤢ꡣ*/
    if( rom_kana_rule_list_check( gw, node, chara ) )
      goto j_kanakakutei_rom_kana_rulelist_hit ;

    j_okuri_chara = node->j_okuri_chara ;
  }
  /* ̾ prefix 򸫤ơ޻̾ѴԤ*/
  str = my_assoc_table_search( node, table, node->j_prefix ) ;
#ifdef DEBUG_LV1
  fprintf( stderr, "j-kanakakutei : prefix is \"%s\".\n",
	   node->j_prefix ) ;
  fprintf( stderr, "j-kanakakutei : ( j-kana-start-point,\
cursor-position ) is ( %d, %d ).\n", node->j_kana_start_point,
	   node->cur_pos ) ;
#endif
  /* ޻̾Ѵޤ */
  if( str == NULL ){
    /* ޻̾Ѵ˼Ԥν*/
    node->j_prefix[ 0 ] = '\0' ;
    /* j_okuri_chara = '\0' ; */
    str = my_assoc_table_search( node, table, node->j_prefix ) ;
  }
  /* ꤷƤޤ*/
  /* if( j_kakutei_early && j_henkan_mode ) */
  if( node->j_henkan_on ){
    j_kakutei( gw, node ) ;
  }
  if( node->j_kana_mode ){
    /* kana prefix Ĺʬʸä*/
    j_delete_region( node, node->j_kana_start_point, node->cur_pos ) ;
    node->j_kana_mode = False ;
    node->j_prefix[ 0 ] = '\0' ;
  }
  /* ä˲̾Ϥ롣*/
  j_insert_str( node, node->cur_pos, str ) ;
  /* 겾̾⡼ɤäˤϡ겾̾ꤹ롣*/
  /* Ĥޤꡢ겾̾ꤷѴ˰ܤΤ͡*/
  if( node->j_okurigana_mode ){
    j_set_okurigana( gw, node, j_okuri_chara ) ;
  }
  return 0 ;

j_kanakakutei_rom_kana_rulelist_hit:
  if( node->j_henkan_on )
    j_kakutei( gw, node ) ;
  if( node->j_okurigana_mode )
    j_set_okurigana( gw, node, node->j_okuri_chara ) ;
  return 0 ;
}

/* 첻Ϥ줿ˤϡ̾ϤγȤ롣*/
static int j_insert_a
( Widget gw, struct SKKInputNode *node, int chara )
{
  return j_kanakakutei( gw, node, skk_roma_kana_a, chara ) ;
}

/* 첻Ϥ줿ˤϡ̾ϤγȤ롣*/
static int j_insert_i
( Widget gw, struct SKKInputNode *node, int chara )
{
  return j_kanakakutei( gw, node, skk_roma_kana_i, chara ) ;
}

/* 첻Ϥ줿ˤϡ̾ϤγȤ롣*/
static int j_insert_u
( Widget gw, struct SKKInputNode *node, int chara )
{
  return j_kanakakutei( gw, node, skk_roma_kana_u, chara ) ;
}

/* 첻Ϥ줿ˤϡ̾ϤγȤ롣*/
static int j_insert_e
( Widget gw, struct SKKInputNode *node, int chara )
{
  return j_kanakakutei( gw, node, skk_roma_kana_e, chara ) ;
}

/* 첻Ϥ줿ˤϡ̾ϤγȤ롣*/
static int j_insert_o
( Widget gw, struct SKKInputNode *node, int chara )
{
  return j_kanakakutei( gw, node, skk_roma_kana_o, chara ) ;
}

/*
 * ʸΥե٥åȤϤ줿ȤˤꡢѴϰ֤ꤵ
 * Ѵ⡼ɤؤȰܹԤȤԤؿ
 * -----
 * 첻Ϥ줿νԤ
 * -----
 * 첻 ....
 *   1. ̾ϤƤ ... ޻̾ѴԤ
 *   2. ɽȲ̾,Ѵꤹ롣
 *   3. 겾̾⡼ɤɬפ
 */
static int j_set_henkan_point_ByVowel
( Widget gw, struct SKKInputNode *node,
  struct roma_kana_table *table, int chara )
{
  /* skkinput ֤ȴФ*/
  int status = ( node->j_henkan_mode << 3 ) | ( node->j_henkan_on << 2 ) |
    ( node->j_kana_mode << 1 ) | ( node->j_okurigana_mode ) ;
  int pos, rchara, pchara ;

#ifdef DEBUG
  fprintf( stderr, "V( j_henkan_mode, j_henkan_on, j_kana_mode,\
j_okurigana_mode ) = (%d,%d,%d,%d)\n", node->j_henkan_mode,
	   node->j_henkan_on, node->j_kana_mode,
	   node->j_okurigana_mode ) ;
#endif

  /* ʸʸѴ*/
  rchara = chara ;
  if( chara >= 'A' && chara <='Z' )
    chara += 'a' - 'A' ;

  /* ɽ*/
  switch( status ){

    /* ϤƤʤ֤Ѵֻꡣ*/
    /* ξ첻餤ʤ겾̾ѴɤΤǡ̾⡼ɤϥ *
     * ΤޤޤʤΤǤ롣                                                 */
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    j_set_henkan_point_label1 : ;
    /* ɽơ*/
    j_insert_str( node, node->cur_pos, "" ) ;
    /* Ѵϰ֤򥫡֤˷ꤷơ*/
    node->j_henkan_start_point = node->cur_pos ;
    /* Ѵ⡼ɤ򥪥ˤ롣*/
    node->j_henkan_mode = True ;
    /* ޻̾ѴԤ*/
    j_kanakakutei( gw, node, table, chara ) ;
#if 0
    /* ʤ顢̾⡼ɤϥա*/
    node->j_kana_mode   = False ;
#endif
    break ;

  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
    pchara = last_character_of( node->j_prefix ) ;
    /* 롼ꥹȤҤ*/
    if( rom_kana_rule_list_check( gw, node, rchara ) ){
      break ;
    }
    /* 겾̾ѴˤפʤΤʡ */
    if( is_okurigana_start_ok( node ) ){
      node->cur_pos_backup = node->cur_pos ;
      /* ֤겾̾γϥݥȡ*/
      node->cur_pos = node->j_okurigana_start_point =
	node->j_kana_start_point ;
      /* 겾̾γϥݥȤˡ*פ롣*/
      j_insert_chara( node, node->j_okurigana_start_point, '*' ) ;
      /* ̾ϰ֤ν*/
      node->j_kana_start_point = node->cur_pos ;
      /* ֤򸵤᤹*/
      node->cur_pos = node->cur_pos_backup ;
      /* 겾̾⡼ɤذܹԤ롣*/
      node->j_okurigana_mode = True ;
      node->j_okuri_chara = pchara ;
    }
    /* ޻̾ѴԤ*/
    j_kanakakutei( gw, node, table, chara ) ;
    /* ʤ顢̾⡼ɤϥա*/
#if 0
    node->j_kana_mode   = False ;
    node->j_prefix[ 0 ] = '\0' ;
#endif
    break ;
    
    /* ˲̾⡼ɤǤäν*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
    /* 롼ꥹȤҤ*/
    if( rom_kana_rule_list_check( gw, node, rchara ) ){
      break ;
    }
    /* β̾ϰ֤򵭲Ƥ*/
    pos = node->j_kana_start_point ;
#if 0
    /* if( node->textbuffer[ pos ] == 'n' ){*/
#else
    if( node->j_prefix[ 0 ] == 'n' && node->j_prefix[ 1 ] == '\0' ){
#endif
      j_n_convert_to_kana( node ) ;
      node->j_kana_mode = False ;
      node->j_prefix[ 0 ] = '\0' ;
      pos = node->cur_pos ;
    }
    /* ޻̾ѴԤ*/
    j_kanakakutei( gw, node, table, chara ) ;
    /* ɽơ*/
    j_insert_str( node, pos, "" ) ;
    /* Ѵ⡼ɤ򥪥ˤ롣*/
    node->j_henkan_mode = True ;
    /* Ѵϰ֤ꤷơ*/
    node->j_henkan_start_point = pos + j_kanji_length ;
#if 0
    /* ʤ顢̾⡼ɤϥա*/
    node->j_kana_mode   = False ;
#endif
    break ;

    /* ѴǤʤΤ겾̾⡼ɤˤʤ뤳ȤϤʤ*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_ON :
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_ON :
    break ;

    /* Ѵ⡼ɤ˰ܹԤƤʤΤˡѴǤ뤳ȤϤʤ*/
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_ON  :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_ON  :
    break ;
    
    /* Ѵ⡼ɤʸե٥åȤϤ줿ˤ겾̾⡼ɤ */
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    if( is_okurigana_start_ok( node ) ){
      /* ֤겾̾γϥݥȡ*/
      node->j_okurigana_start_point = node->cur_pos ;
      /* 겾̾γϥݥȤˡ*פ롣*/
      j_insert_chara( node, node->cur_pos, '*' ) ;
      /* 겾̾⡼ɤذܹԤ롣*/
      node->j_okurigana_mode = True ;
      node->j_okuri_chara = chara ;
    }
    /* Ϥ첻ˤĤƥ޻̾ѴԤ*/
    j_kanakakutei( gw, node, table, chara ) ;
    break ;

    /* ֢*sפȤ褦ʾ֤Ǥ롣Ѵ⡼ɤǤꡢ겾̾⡼ *
     * Ǥꡢ̾⡼ɤǤȤΤϡ̾⡼ɤǤʤʤ   *
     * 겾̾⡼ɤȦϤʤΤǡξ֤¸ߤʤ             */
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_ON  :
    break ;

    /* ֢*sפȤ褦ʾ֤Ǥ롣Ѵ⡼ɤǤꡢ겾̾⡼ *
     * Ǥꡢ̾⡼ɤǤȤΤϡ                                 */
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_ON  :
    /* 롼ꥹȤҤ*/
    if( rom_kana_rule_list_check( gw, node, rchara ) ){
      break ;
    }
    /* ξʸϤ⾮ʸϤطʤʸλν롣*/
    /* ޻̾ѴԤ*/
    j_kanakakutei( gw, node, table, chara ) ;
#if 0
    /* ̾⡼ɤϽλ롣*/
    node->j_kana_mode = False ;
    node->j_prefix[ 0 ] = '\0' ;
#endif
    break ;
	
  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    /* ξˤϳȤԤ줿塢not_active, henkan_off Ʊ*/
    j_kakutei( gw, node ) ;
#if 0
    j_kakutei_kana( node, chara ) ;
#endif
    goto j_set_henkan_point_label1 ;

    /* ѴԤƤǡ̾prefixϤʤ겾̾ϤΤ硣*/
  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_ON  :
    /* ξˤϳȤԤ줿塢not_active, henkan_off, okuri_off */
    j_kakutei( gw, node ) ;
#if 0
    j_kakutei_kana( node, chara ) ;
#endif
    goto j_set_henkan_point_label1 ;

  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
    /* Ѵ kana_prefix ä顢ꤷƤޤΤǡξϤʤ*/
    break ;

  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_ON  :
    /* Ѵ⡼ɤ겾̾ꤷơѴȤʤä֤ǲ̾prefix   *
     * 뤳ȤϤʤ                                                     */
    break ;
  }
  return 0 ;
}

/*
 * üʸФʸˤäѴϰ֤ꤹν
 */
static int j_set_henkan_point_by_special_midashi_char
( Widget gw, struct SKKInputNode *node, int chara )
{
  /* ̾椫"n"ʤ""ˤƤޤ*/
  if( node->j_kana_mode ){
    /* 롼ꥹȤҤ*/
    if( rom_kana_rule_list_check( gw, node, chara ) ){
      return 0 ;
    }
    if( node->j_prefix[ 0 ] == 'n' && node->j_prefix[ 1 ] == '\0' ){
      j_n_convert_to_kana( node ) ;
    } else {
      delete_char( node, node->j_kana_start_point,
		   node->cur_pos - node->j_kana_start_point ) ;
    }
    /* ̾ʤ饭󥻥뤷Ƥޤ*/
    node->j_kana_mode = False ;
    node->j_prefix[ 0 ] = '\0' ;
  }
  /* ơѴ⡼ɤѴưʤΤʤ */
  if( node->j_henkan_mode == False || node->j_henkan_on == True ){
    if( node->j_henkan_mode ){
      /* Ѵϰ֤Ǥ뤽ʡ*/
      j_set_henkan_point_subr( gw, node, chara ) ;
      /* Τ ϡġ*/
      j_insert_chara( node, node->cur_pos, chara ) ;
    } else if( node->j_henkan_on ){
      /* ꥸʥΥޥåפ򥨥ߥ졼Ȥ뤽ʡ*/
#if 0
      j_insert_chara( node, node->cur_pos, chara ) ;
#else
      j_self_insert( gw, node, chara ) ;
#endif
    } else {
      /* ʸ뤽ʡ*/
#if 0
      j_insert_chara( node, node->cur_pos, chara ) ;
#else
      j_self_insert( gw, node, chara ) ;
#endif
    }
  } else {
    /* Ѵν*/
    j_start_henkan_sub( gw, node ) ;
    /* üʸ롣*/
    j_insert_chara( node, node->cur_pos, chara ) ;
    /* Ѵλ֤ꤹ롣*/
    node->j_henkan_end_point = node->cur_pos ;
    /* ѴڤФ*/
    strncpy( node->j_henkan_key,
	     node->textbuffer + node->j_henkan_start_point,
	     node->j_henkan_end_point - node->j_henkan_start_point ) ;
    node->j_henkan_key[ node->j_henkan_end_point -
		      node->j_henkan_start_point ] = '\0' ;
    /*
     *֤⤷ơ겾̾⡼ɤȤȤϤޤǤ礦
     */
    if( node->j_okurigana_mode ){
      /* ԹˤƤʤȤ򵧤äƤΤġ*/
      if( node->j_okurigana_start_point > node->j_henkan_start_point ){
	node->j_okurigana_offset =
	  node->j_okurigana_start_point - node->j_henkan_start_point ;
      } else {
	node->j_okurigana_offset =
	  node->j_henkan_end_point - node->j_henkan_start_point ;
      }
    } else {
      node->j_okurigana_offset =
	node->j_henkan_end_point - node->j_henkan_start_point ;
    }
    /* ñϿλ˻Ȥ¸Ƥ*/
    strcpy( node->j_henkan_key2, node->j_henkan_key ) ;
    strcpy( node->j_search_key, node->j_henkan_key ) ;
    /* ơѴԤޤ*/
    j_henkan( gw, node ) ;
  }
  return 0 ;
}


/*
 * ֤ʸؿ
 * ----
 * skkήʸΤǤꡢ줬 j_insert ȰۤʤäƤ롣
 * j_insert  emacs-lisp  insert ǰƬ֤ƺäؿʤΤǤ롣
 */
static int j_self_insert
( Widget gw, struct SKKInputNode *node, int chara )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;

  if( chara < 0 || chara > 128 || w->skkinput.skk_input_vector == NULL )
    return 1 ;

  /* Ѵưʤꤹ롣*/
  if( node->j_henkan_on == True )
    j_kakutei( gw, node ) ;
  /* Ϥˤ겾̾prefixγȤȤ롣*/
  if( j_kakutei_kana_mode( gw, node, chara ) )
    return 0 ;

  /* Ѵơ֥˵ҤʤСѤ롣*/
  if( w->skkinput.skk_input_vector[ chara ] != NULL ){
    j_insert_str( node, node->cur_pos,
		  w->skkinput.skk_input_vector[ chara ] ) ;
  } else {
    /* ʳ default  keymap ˽ȤΤȤǤ롣*/
    j_insert_chara( node, node->cur_pos, chara ) ;
  }
  return 0 ;
}

static int j_insert_zenkaku
( Widget gw, struct SKKInputNode *node, int pos, int chara )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;

  if( chara < 0 || chara > 128 || w->skkinput.skk_zenkaku_vector == NULL )
    return 1 ;
  /* Ѵơ֥˵ҤʤСѤ롣*/
  if( w->skkinput.skk_zenkaku_vector[ chara ] != NULL ){
    j_insert_str( node, node->cur_pos,
		  w->skkinput.skk_zenkaku_vector[ chara ] ) ;
  }
  return 0 ;
}

/*
 * Ϥ client ĤȤԤ( = ԡ )
 */
static int j_newline( Widget gw, struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  struct SKKInputNode *pNode = node->parentbuffer ;
  int len ;
  unsigned char buffer[ 3 ] ;
  unsigned char j_toroku_string[ TEXTBUFSIZE ] ;
  struct SKKTangoInfo jtango ;

  /* Ѵ⤷ϲ̾ϤǤʤСꤹ롣  *
   * Хȷϥɤϥ⡼ɤʤ顢ưϤʤ*/
  if( node->j_mode ){
    int flag = node->j_henkan_mode ;
    j_kakutei( gw, node ) ;
    /*  "n" ʤƤΤäƤ顢""˳ꤷʤܡ   *
     * Ǥ⡢"nn" Ȥ rom-kana-rule-list ҤɬפϤʤ¿ʬ *
     * äơ "\0" ˤʤäƤ롣*/
    j_kakutei_kana_mode( gw, node, '\0' ) ;
    /* Τߤ j_newline ¸ߤΤʤ顢Ѵ⡼ɤˤϤä *
     * 顢Ƥ˳ѤޤꤹĤäơäƿƤǤäߤ  *
     *  */
    if( flag && w->skkinput.egg_like_newline )
      return 0 ;
  }
  /*  newline ϰֿƤΥΡɤǼ¹Ԥ줿ΤǤ */
  if( pNode == NULL ){
    /* Window  Active Ǥä硣*/

    /* ʸ򵭲ƤפʲԤղäΤ˻ߤ */
    /* 뤿ˤ chatadapter mode Ƚ˹Ԥ*/
    save_ringbuffer
      ( w->skkinput.historybuffer, TEXTBUFSIZE,
        &w->skkinput.hist_start, &w->skkinput.hist_end,
        node->textbuffer ) ;
    w->skkinput.hist_cur = -1 ;

    /* ʸϤƤʤ֤ǤβԥǤ뤫⤷ *
     * åȥץ⡼ɤʤСԥɤղä롣*/
    if( strlen( node->textbuffer ) <= 0 || w->skkinput.chat_adapter ){
      strcat( node->textbuffer, "\n" ) ;
    }
#if 1
    /* ʸ롣ʤΤǡcallback Ȥ*/
    XtCallCallbacks( gw, XtNfixNotify, ( XtPointer )node->textbuffer ) ;
#endif
    /* ƥȥХåե롣*/
    node->textbuffer[ 0 ] = '\0' ;
    /* ƬؤȰư롣*/
    node->cur_pos = 0 ;
    node->j_okurigana_start_point = -1 ;
    node->j_kana_start_point      = -1 ;
    node->j_henkan_start_point    = -1 ;
    node->j_henkan_end_point      = -1 ;
    return 0 ;
  }

  /*  newline ϲ褾Υߥ˥ХåեǼ¹Ԥ줿ΤǤ(羸) */

  switch( node->j_minibuff_usage ){
    /* ߥ˥ХåեǤѴ˰ܤäƤġ*/
  case J_HENKAN_IN_MINIBUFF_MODE :
    /* ߥ˥ХåեǲʸϤƤΤʤ顢Ƥؤ *
     * ֤ʤФʤʤ⤷ϤƤʤΤʤ顢 * 
     * ϤĤƤʤȤʤ*/
    if( node->textbuffer[ node->cur_pos_top ] != '\0' ){
      j_delete_region( pNode,
		       pNode->j_henkan_start_point,
		       pNode->j_henkan_end_point ) ;
      /* mini-buffer Ρ֢礦 װʲʸ򽦤äơ *
       * ؤ֤*/
      strcpy( temporary_buffer, node->textbuffer + node->cur_pos_top ) ;
#if 0
      j_insert_str( pNode, pNode->j_henkan_start_point,
		    node->textbuffer + node->cur_pos_top ) ;
#else
      j_insert_word
	( gw, pNode, pNode->j_henkan_start_point, temporary_buffer ) ;
#endif
      pNode->j_henkan_end_point = pNode->cur_pos ;

      /* ǡιʤ뤬...ޤưʡ */
      jtango.tangotype = 0 ;
      jtango.henkankey = ( pNode->j_okurigana_mode )? 
	pNode->j_henkan_key : pNode->j_search_key ;
      /* ΤޤϿƤޤȤޤã뤫⤷ʤΤǽ *
       * 롣*/
      strcpy( j_toroku_string, node->textbuffer + node->cur_pos_top ) ;
      j_quote_char( j_toroku_string ) ;
      jtango.string    = j_toroku_string ;
      jtango.okuri     = pNode->j_okurigana_mode ;
      XtCallCallbacks( gw, XtNjtangotourokuNotify, &jtango ) ;
      pNode->j_current_henkan_vector_index = NULL ;
      /* Ƹ椵ϳꤷޤ*/
      j_kakutei( gw, pNode ) ;
    } else {
      /* ߥ˥ХåեǤѴ⡼ɤäƤʤ顢äȤҥå *
       * Τ̵äν*/
      if( pNode->j_henkan_count == 0 && pNode->j_henkan_mode &&
	  pNode->j_henkan_on ){
	/* ΤޤޤǤϤʤؤȾܤ롣*/
	j_keyboard_quit_henkanrestart
	  ( gw, pNode, pNode->j_okurigana_mode ) ;
      }
    }
    break ;
  case J_INPUT_BY_CODE_OR_MENU_MODE :
    len = strlen( node->textbuffer + node->cur_pos_top ) ;
  /* ʸ­ʤСȴ롣*/
    if( len && len < 4 ){
      pNode->j_input_by_code_or_menu_mode = False ;
      break ;
    }
    /* ԥɤʤ˥塼ϳμ¡*/
    if( len ){
      unsigned char *ptr = node->textbuffer + node->cur_pos_top ;
      /* Ϥ줿Τ֤ʤΤĴ٤롣*/
      buffer[ 0 ] = j_char_to_hex( ptr[ 0 ] ) * 0x10 
	+ j_char_to_hex( ptr[ 1 ] ) ;
      buffer[ 1 ] = j_char_to_hex( ptr[ 2 ] ) * 0x10 
	+ j_char_to_hex( ptr[ 3 ] ) ;
      buffer[ 2 ] = '\0' ;

      /* ʸ̵¿Ƥ̵뤷Ƥ뤫͡ */
      if( buffer[ 0 ] ){
	/* EUC ɤѴ롣*/
	buffer[ 0 ] |= 0x80 ;
	buffer[ 1 ] |= 0x80 ;
	/* ξʸƤޤġ*/
	pNode->j_input_by_code_or_menu_mode = False ;
	j_insert_str( pNode, pNode->j_input_by_code_or_menu_point,
		      buffer ) ;
	break ;
      }
      /* ϡ '00nn' Τǥ˥塼⡼ɤˤʤ롣*/
      buffer[ 1 ] |= 0x80 ;
      if( buffer[ 1 ] < j_code_n1_min )
	buffer[ 1 ] = j_code_n1_min ;
      if( buffer[ 1 ] > j_code_n1_max )
	buffer[ 1 ] = j_code_n1_max ;
    } else {
      buffer[ 1 ] = j_code_n1_min ;
    }
    pNode->j_input_by_code_or_menu_mode = True ;
    pNode->j_input_by_code_current_code = buffer[ 1 ] ;
    j_input_by_code_or_menu_jmp_showCandidate
      ( pNode,  buffer[ 1 ] ) ;
    goto j_newline_exit1 ;
  case J_PURGE_YES_OR_NO_P :
    if( !strcmp( node->textbuffer + node->cur_pos_top, "yes" ) ){
      /* ƤθܤƤѴä롣*/
      XtCallCallbacks( gw, XtNjtangosakujoNotify, pNode ) ; 

      /* ɽƤ֢פõ롣*/
      j_delete_region
	( pNode, pNode->j_henkan_start_point, pNode->j_henkan_end_point ) ;
      pNode->j_henkan_end_point = pNode->cur_pos ;
      pNode->j_current_henkan_vector_index = NULL ;
      /* Ƹ椵ϳꤷޤ*/
      j_kakutei( gw, pNode ) ;
    }
    /* οͤ purge  no äˤϲ⤷ޤ*/
    break ;
  default :
    break ;
  }
  pNode->mtextbuffer[ 0 ] = '\0' ;
j_newline_exit1:
  /* ߥ˥ХåեѤߤΤǡꥢ롣*/
  skkinput_ClearMinibuffer( gw ) ;
  /* Υߥ˥ХåեפˤʤäΤǡޤ*/
  free_Minibuffer( gw, node ) ;
  /* Ƥ˥֤ޤ礦*/
  pNode->cur_exist = True ;
  return 0 ;
}

/*
 * ̾Ϥäˡβ̾ץե򤹤ؿ
 */
static void j_delete_kanaprefix( struct SKKInputNode *node )
{
  /* ѴʤˤƤޤ*/
  if( node->j_kana_mode ){
    /* ̾Ϥ 'n' νĤäƤ硣*/
    /* ̾Ϥ 'n' ǤäƤ⡢*n Ȥ֤¸ߤǤ *
     * Τա */
    if( node->j_prefix[ 0 ] == 'n' && node->j_prefix[ 1 ] == '\0' ){
      j_n_convert_to_kana( node ) ;
    } else {
      delete_char( node, node->j_kana_start_point,
		   node->cur_pos - node->j_kana_start_point ) ;
    }
    /* ̾ʤ饭󥻥뤷Ƥޤ*/
    node->j_kana_mode = False ;
    node->j_prefix[ 0 ] = '\0' ;
  }
  return ;
}

/*
 * 䴰ײߤؿǤϤʤơʸ䴰Ԥؿ
 */
static int j_try_completion( Widget gw, struct SKKInputNode *node )
{
  int length, startpos, endpos ;
  SkkInputWidget w = ( SkkInputWidget )gw ;

  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;

  /* ѴưԤäǤꡢºݤѴڹԤƤʤ *
   * ʤ顢completion Ϥ롣*/
  if( node->j_henkan_mode && !node->j_henkan_on ){
    if( node->cur_pos < node->j_henkan_start_point ){
      startpos = node->cur_pos ;
      endpos   = node->j_henkan_start_point ;
    } else {
      startpos = node->j_henkan_start_point ;
      endpos   = node->cur_pos ;
    }
    length = endpos - startpos ;
    /* 䴰褦ȤʸĹä顣*/
    if( length <= 0 ){
      err_msg( node, "Cannot complete an empty string!" ) ;
      return 1 ;
    }
    /* 괺֤Ѵϰ֤δ֤ʸȴФ*/
    strncpy( node->j_henkan_key,
	     node->textbuffer + startpos, length ) ;
    node->j_henkan_key[ length ] = '\0' ;
    /* completion ˤƤߤĤΥ르ꥺϷ빽äƤ롣*
     * (^^;; */
    XtCallCallbacks( gw, XtNjcompletionNotify, node ) ;
    /* ĤҥåȤޤǤ(^^;;; */
    if( !node->j_completion_mode ){
      err_msg( node, "No completions for \"%s\"", node->j_henkan_key ) ;
      return 1 ;
    }
    /* 괺Ѵϰ֤饫֤ޤǤɽƤʸ *
     * õ롣*/
    j_delete_region( node, startpos, endpos ) ;
    /* 䴰ǤʸȴФ*/
    copyCandidate( temporary_buffer,
		   ( node->j_current_completion_vector_index )->node,
		   ( node->j_current_completion_vector_index )->position,
		   TEXTMAXLEN ) ;
    j_insert_str( node, startpos, temporary_buffer ) ;
  } else {
    /* 롣*/
    for( length = 0 ; length < w->skkinput.tab_width ; length ++ )
      j_insert_chara( node, node->cur_pos, ' ' ) ;
  }
  return 0 ;
}

/*
 * ֤Υɤɽؿ
 *-----
 */
static int j_display_code_for_char_at_point( struct SKKInputNode *node )
{
  j_delete_kanaprefix( node ) ;
  /* Ǥʤ줿硣*/
  if( node->textbuffer[ node->cur_pos ] == '\0' ){
    err_msg( node, "Cursor is at the end of the buffer." ) ;
    return 1 ;
  }
  /* ʤȤ̵ȻפɡϤͤ롣*/
  if( node->cur_pos < node->cur_pos_top ){
    node->cur_pos = node->cur_pos_top ;
    return 0 ;
  }
  /* ɤʤΤʤ ʤΤʤ ۤȤΤȤϤɤ *
   * ʤΤʤ */
  if( node->textbuffer[ node->cur_pos ] & 0x80 ){
    unsigned int c1, c2, c11, c12 ;
    c1 = node->textbuffer[ node->cur_pos     ] ;
    c2 = node->textbuffer[ node->cur_pos + 1 ] ;
    c11 = c1 & (~0x80) ;
    c12 = c2 & (~0x80) ;
    sprintf
      ( node->mtextbuffer,
	"%c%c  EUC: %02x%02x (%3d, %3d), JIS: %02x%02x (%3d, %3d)",
	c1, c2, c1, c2, c1, c2, c11, c12, c11, c12 ) ;
  } else {
    unsigned int c = node->textbuffer[ node->cur_pos ] ;
    sprintf( node->mtextbuffer, "\"%c\"  %02x (%3d)", c, c, c ) ;
  }
  return 0 ;
}

/*
 * ľܥϤԤؿ
 */
static int j_input_by_code_or_menu_start
( Widget gw, struct SKKInputNode *node )
{
  j_delete_kanaprefix( node ) ;
  /* ߤΥ֤򵭲롣*/
  node->j_input_by_code_or_menu_point = node->cur_pos ;
  /* ߥ˥ХåեѤơʸϤ롣*/
  j_read_string( gw, node,
		 "JIS or EUC code (00nn or CR for Jump Menu): ",
		 J_INPUT_BY_CODE_OR_MENU_MODE ) ;
  return 0 ;
}

/*
 * "/" ˤѴ
 */
static int j_abbrev_input
( Widget gw, struct SKKInputNode *node, int rchara )
{
  if( node->j_henkan_mode && !node->j_henkan_on ){
    err_msg( node, "Already in  mode" ) ;
    return 1 ;
  }
  j_kakutei( gw, node ) ;
  j_set_henkan_point_subr( gw, node, rchara ) ;
  node->j_abbrev = True ;
  return 0 ;
}

/*
 * Ϳ줿֤饫̤ưؿ
 * ---------
 * ΤޤޡControl-F νбƤ롣
 */
static int j_forward_char( struct SKKInputNode *node )
{
  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;
  /* ư롣*/
  node->cur_pos = calc_forward_char( node, node->cur_pos, 1 ) ;
  return 0 ;
}

/*
 * Ϳ줿֤饫̤᤹ؿ
 * ---------
 * ΤޤޡControl-B νбƤ롣
 */
static int j_backward_char( struct SKKInputNode *node )
{
  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;
  /* ư롣*/
  if( node->cur_pos > node->cur_pos_top ){
    node->cur_pos -- ;
    if( ( node->textbuffer[ node->cur_pos ] & 0x80 ) &&
	node->cur_pos > node->cur_pos_top )
      node->cur_pos -- ;
  }
  return 0 ;
}

/*
 * ֤ʸäؿ
 *----
 * ͡äˤʤ
 */
static int j_delete_char( struct SKKInputNode *node )
{
  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;
  delete_char( node, node->cur_pos, 1 ) ;
  return 0 ;
}

/*
 * Υäؿ
 */
static int delete_backward_char( Widget gw, struct SKKInputNode *node )
{
  /* ϥХåեƬޤƤΤǤ */
  if( node->cur_pos > node->cur_pos_top ){
    /* ХåեƬޤǤƤޤΤǡ᤻ޤ*/
    node->cur_pos -- ;
    if( node->cur_pos > node->cur_pos_top &&
	( node->textbuffer[ node->cur_pos ] & 0x80 ) )
      node->cur_pos -- ;
    /* ᤷȤǡξɽƤʸäޤ*/
    delete_char( node, node->cur_pos, 1 ) ;
  } else {
    /* ֿƤäꤷˤϡХåڡ򲡤᤹*/
    if( node->parentbuffer == NULL ){
      /* ᤷޤ礦*/
      SKIW_SendbackKeyPress( gw ) ;
    }
  }
  return 0 ;
}

/*
 * comma ؿ
 *-----
 * j_completion ʽΤ󡢤εǽ
 * ͽϤʤΤǡڡ
 */
static int j_insert_comma( Widget gw, struct SKKInputNode *node )
{
  int startpos ;
  /* 䴰ײ¹ʤСġ*/
  if( node->j_completion_mode ){
    /* Ϥ䤳ʾϤʤ*/
    if( node->j_current_completion_vector_index == NULL ){
      err_msg( node, "No previous completions." ) ;
      return 1 ;
    }
    /* θ򤷤ơġ*/
    node->j_current_completion_vector_index = 
      node->j_current_completion_vector_index->prev ;
    startpos = ( node->j_henkan_start_point < node->cur_pos )?
      node->j_henkan_start_point : node->cur_pos ;
    if( node->j_current_completion_vector_index != NULL ){
      j_delete_region
	( node, node->j_henkan_start_point, node->cur_pos ) ;
      /* 䴰ǤʸȴФ*/
      copyCandidate( temporary_buffer,
		     ( node->j_current_completion_vector_index )->node,
		     ( node->j_current_completion_vector_index )->position,
		     TEXTMAXLEN ) ;
      j_insert_str( node, startpos, temporary_buffer ) ;
      return 0 ;
    } else {
      /* 䴰ʸɽġ¤ϤǤԽʬʤΤ*/
      j_delete_region
	( node, node->j_henkan_start_point, node->cur_pos ) ;
      j_insert_str( node, startpos, node->j_henkan_key ) ;
      return 0 ;
    }
  }
  return j_self_insert( gw, node, ',' ) ;
}

static int j_abbrev_comma( Widget gw, struct SKKInputNode *node )
{
  int startpos ;
  /* 䴰ײ¹ʤСġ*/
  if( node->j_completion_mode ){
    /* Ϥ䤳ʾϤʤ*/
    if( node->j_current_completion_vector_index == NULL ){
      err_msg( node, "No previous completions." ) ;
      return 1 ;
    }
    /* θ򤷤ơġ*/
    node->j_current_completion_vector_index = 
      node->j_current_completion_vector_index->prev ;
    startpos = ( node->j_henkan_start_point < node->cur_pos )?
      node->j_henkan_start_point : node->cur_pos ;
    if( node->j_current_completion_vector_index != NULL ){
      j_delete_region
	( node, node->j_henkan_start_point, node->cur_pos ) ;
      /* 䴰ǤʸȴФ*/
      copyCandidate( temporary_buffer,
		     ( node->j_current_completion_vector_index )->node,
		     ( node->j_current_completion_vector_index )->position,
		     TEXTMAXLEN ) ;
      j_insert_str( node, startpos, temporary_buffer ) ;
      return 0 ;
    } else {
      /* 䴰ʸɽġ¤ϤǤԽʬʤΤ*/
      j_delete_region
	( node, node->j_henkan_start_point, node->cur_pos ) ;
      j_insert_str( node, startpos, node->j_henkan_key ) ;
      return 0 ;
    }
  }
  return j_insert_chara( node, node->cur_pos, ',' ) ;
}

/*
 * period ؿ
 *-----
 * j_completion ʽΤ󡢤εǽ
 * ͽϤʤΤǡڡ
 */
static int j_insert_period( Widget gw, struct SKKInputNode *node )
{
  int startpos ;
  /* 䴰ײ¹ʤСġ*/
  if( node->j_completion_mode ){
    /* ƬƬؤƤΤʤ顢ǽ䴰̤ˤ碌롣*/
    if( node->j_current_completion_vector_index == NULL ){
      node->j_current_completion_vector_index =
	node->j_completion_vector_index_top ;
    } else {
      /* ʾ弡θɽ뤳ȤϲǽǤ */
      if( node->j_current_completion_vector_index->next == NULL ){
	err_msg( node, "No more completions." ) ;
	return 1 ;
      }
      /* 䴰̤˰ưޤ礦*/
      node->j_current_completion_vector_index =
	node->j_current_completion_vector_index->next ;
    }
    j_delete_region
      ( node, node->j_henkan_start_point, node->cur_pos ) ;
    /* 䴰ǤʸȴФ*/
    copyCandidate( temporary_buffer,
		   ( node->j_current_completion_vector_index )->node,
		   ( node->j_current_completion_vector_index )->position,
		   TEXTMAXLEN ) ;
    startpos = ( node->j_henkan_start_point < node->cur_pos )?
      node->j_henkan_start_point : node->cur_pos ;
    j_insert_str( node, startpos, temporary_buffer ) ;
    return 0 ;
  }
  return j_self_insert( gw, node, '.' ) ;
}

static int j_abbrev_period( Widget gw, struct SKKInputNode *node )
{
  int startpos ;
  /* 䴰ײ¹ʤСġ*/
  if( node->j_completion_mode ){
    /* ƬƬؤƤΤʤ顢ǽ䴰̤ˤ碌롣*/
    if( node->j_current_completion_vector_index == NULL ){
      node->j_current_completion_vector_index =
	node->j_completion_vector_index_top ;
    } else {
      /* ʾ弡θɽ뤳ȤϲǽǤ */
      if( node->j_current_completion_vector_index->next == NULL ){
	err_msg( node, "No more completions." ) ;
	return 1 ;
      }
      /* 䴰̤˰ưޤ礦*/
      node->j_current_completion_vector_index =
	node->j_current_completion_vector_index->next ;
    }
    j_delete_region
      ( node, node->j_henkan_start_point, node->cur_pos ) ;
    /* 䴰ǤʸȴФ*/
    copyCandidate( temporary_buffer,
		   ( node->j_current_completion_vector_index )->node,
		   ( node->j_current_completion_vector_index )->position,
		   TEXTMAXLEN ) ;
    startpos = ( node->j_henkan_start_point < node->cur_pos )?
      node->j_henkan_start_point : node->cur_pos ;
    j_insert_str( node, startpos, temporary_buffer ) ;
    return 0 ;
  }
  return j_insert_chara( node, node->cur_pos, '.' ) ;
}

/*
 * դϤؿ
 */
static int j_today( Widget gw, struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  static char *skk_week_alist[] = {
    "", "", "", "", "", "", "",
  } ;
  time_t tval ;
  int year ;
  unsigned char buffer[ TEXTBUFSIZE ] ;
  unsigned char *sptr, *dptr ;
#if 0
  struct my_tm lt ;
#else
  struct tm *lt ;
#endif

  j_delete_kanaprefix( node ) ;

  /* 1970/1/1ηв롣*/
  if( time( &tval ) == -1 )
    return 1 ;

  /* time_t  struct tm * Ѵ롣*/
#if 0
  lt = my_localtime( ( unsigned long long int )tval ) ;
#else
  lt = localtime( &tval ) ;
#endif
  /* ǯβǤ뤫롣*/
#if 0
  sprintf( temporary_buffer, "%d", lt.year ) ;
  year = lt.year ;
#else
  sprintf( temporary_buffer, "%d", lt->tm_year + 1900 ) ;
  year = lt->tm_year + 1900 ;
#endif
  if( !w->skkinput.date_ad ){
    /* ǯ롣*/
    if( year <= 1867 ){
      strcpy( buffer, "" ) ;
    } else if( year < 1911 ){
      year -= 1867 ;
      strcpy( buffer,  "" ) ;
    } else if( year < 1925 ){
      year -= 1911 ;
      strcpy( buffer,  "" ) ;
    } else if( year < 1988 ){
      year -= 1925 ;
      strcpy( buffer,  "" ) ;
    } else {
      year -= 1988 ;
      strcpy( buffer,  "ʿ" ) ;
    }
    dptr = buffer + j_kanji_length * 2 ;
    sprintf( temporary_buffer, "%d", year ) ;
  } else {
    /* ǯ̵ˤʤ롣*/
    buffer[ 0 ] = '\0' ;
    dptr = buffer ;
  }
  if( year == 1 && w->skkinput.date_ad ){
    strcat( dptr, "ǯ" ) ;
  } else {
    /* ǯŸ롣*/
    j_num_exp
      ( temporary_buffer, w->skkinput.number_style + '0', dptr ) ;
    strcat( dptr, "ǯ" ) ;
    /* դ­줿ʸΰֺǸؤȰư롣*/
    while( *dptr != '\0' )
      dptr ++ ;
  }
  /* ǯβǤ뤫롣*/
#if 0
  sprintf( temporary_buffer, "%d", lt.month + 1 ) ;
#else
  sprintf( temporary_buffer, "%d", lt->tm_mon + 1 ) ;
#endif
  sptr = temporary_buffer ;
  while( *sptr == 0x20 && *sptr != '\0' )
    sptr ++ ;
  /* Ÿ롣*/
  j_num_exp( sptr, w->skkinput.number_style + '0', dptr ) ;
  strcat( dptr, "" ) ;
  /* դ­줿ʸΰֺǸؤȰư롣*/
  while( *dptr != '\0' )
    dptr ++ ;
#if 0
  sprintf( temporary_buffer, "%d", lt.day + 1 ) ;
#else
  sprintf( temporary_buffer, "%d", lt->tm_mday ) ;
#endif
  sptr = temporary_buffer ;
  while( *sptr == 0x20 && *sptr != '\0' )
    sptr ++ ;
  /* Ÿ롣*/
  j_num_exp( sptr, w->skkinput.number_style + '0', dptr ) ;
  strcat( dptr, "" ) ;
  /* դ­줿ʸΰֺǸؤȰư롣*/
  while( *dptr != '\0' )
    dptr ++ ;
  /* 򼨤*/
  strcat( buffer, "(" ) ;
#if 0
  strcat( buffer, skk_week_alist[ lt.week ] ) ;
#else
  strcat( buffer, skk_week_alist[ lt->tm_wday ] ) ;
#endif
  strcat( buffer, ")" ) ;
  /* ʸ롣*/
  j_insert_str( node, node->cur_pos, buffer ) ;
  return 0 ;
}

/*
 * ꤵ줿ϰʸȾѤѤѴؿ
 */
static int j_zenkaku_region
( struct SKKInputNode *node, int startpoint, int endpoint )
{
  char *sptr, *ptr ;
  int pos ;

  if( startpoint > endpoint ){
    err_msg( node, "Henkan end point must be after henkan start point." ) ;
    return 0 ;
  }
  sptr = node->textbuffer + startpoint ;
  ptr  = temporary_buffer ;
  for( pos = startpoint ; pos < endpoint ; pos ++ ){
    if( *sptr == '\0' )
      break ;
    if( *sptr >= 'a' && *sptr <= 'z' ){
      *ptr ++ = 0xA3 ;
      *ptr ++ = ( *sptr ++ ) - 'a' + 0xE1 ;
      continue ;
    } else if( *sptr >= 'A' && *sptr <= 'Z' ){
      *ptr ++ = 0xA3 ;
      *ptr ++ = ( *sptr ++ ) - 'A' + 0xC1 ;
      continue ;
    }
    *ptr ++ = *sptr ++ ;
  }
  *ptr = '\0' ;
  j_delete_region( node, startpoint, endpoint ) ;
  j_insert_str( node, startpoint, temporary_buffer ) ;
  return 0 ;
}

int j_zenkaku_henkan( Widget gw, struct SKKInputNode *node )
{
  if( node->j_henkan_mode && !node->j_henkan_on ){
    node->j_mode = True ;
    if( node->j_henkan_start_point > node->cur_pos ){
      err_msg( node, "Henkan end point must be after henkan start point." ) ;
      return 1 ;
    }
    j_zenkaku_region( node, node->j_henkan_start_point, node->cur_pos ) ;
    j_kakutei( gw, node ) ;
  }
  return 0 ;
}

/*
 * ꤵ줿ΰʿ̾Ҳ̾ѴؿǤ롣
 * ----
 * arg Ϥ줿οȤΤ emacs-lisp äˤäƤ
 * ǤɡεǽΥݡȤʬǤΤǡ̵뤷ƺޤ
 */
static int j_katakana_region
( struct SKKInputNode *node, int startpoint, int endpoint, int flag )
{
  const unsigned short diff = 256 ;
  char *sptr, *ptr ;
  int pos ;
  unsigned short prev_chara = 0, kanji_code ;
  int kanji_flag ;

#ifdef DEBUG_AGAIN
  fprintf( stderr, "j-katakana-region ( %d, %d )\n", startpoint, endpoint ) ;
#endif

  if( startpoint > endpoint ){
    err_msg( node, "Henkan end point must be after henkan start point." ) ;
    return 0 ;
  }

  sptr = node->textbuffer + startpoint ;
  ptr  = temporary_buffer ;
  kanji_flag = False ;
  for( pos = startpoint ; pos < endpoint ; pos ++ ){
    /* äˤ...*/
    if( 0x80 & ( *sptr ) ){
      if( kanji_flag ){
	kanji_code = ( ( unsigned char )*sptr ) | ( prev_chara << 8 ) ;
	if( kanji_code >= 0xA4A1 && kanji_code <= 0xA4F3 ){
	  kanji_code += ( unsigned short )diff ;
	  *ptr ++ = ( kanji_code >> 8 ) ;
	  *ptr ++ = ( kanji_code & 0x00FF ) ;
	  sptr ++ ;
	} else {
	  *ptr ++ = prev_chara ;
	  *ptr ++ = *sptr ++ ;
	}
	kanji_flag = False ;
      } else {
	prev_chara = ( unsigned char )*sptr ++ ;
	kanji_flag = True ;
      }
    } else {
      *ptr ++ = *sptr ++ ;
      kanji_flag = False ;
    }
  }
  *ptr = '\0' ;

#ifdef DEBUG_AGAIN
  fprintf( stderr, "j-katakana-region : tmp_buffer = \"%s\".\n",
	   temporary_buffer ) ;
#endif

  if( flag == False ){

    /* Ǥϡ֤פ֥פѴԤʤᡢʸĹ *
     * ʤȤ꤬Ω롣äơʤִס       */
    ptr  = node->textbuffer + startpoint ;
    sptr = temporary_buffer ;
    while( *sptr != '\0' )
      *ptr ++ = *sptr ++ ;

  } else {
    ptr  = node->textbuffer + startpoint ;
    sptr = temporary_buffer ;
    kanji_flag = False ;

    pos = 0 ;
    while( *sptr != '\0' ){
      if( ( 0x80 & ( *sptr ) ) && kanji_flag == False ){
	/* äˤդɬפǤ롣*/
	if( !strncmp( sptr, "", 4 ) ){
	  *ptr ++ = 0xA5 ;
	  *ptr ++ = 0xF4 ;
	  sptr += strlen( "" ) ;
	  pos ++ ;
	  pos ++ ;
	  continue ;
	}
	*ptr ++ = *sptr ++ ;
	kanji_flag = True ;

      } else {
	/* 2Хܡ⤷Ϥʳʸ*/
	*ptr ++ = *sptr ++ ;
	kanji_flag = False ;
      }
    }
    /* ºݤûʤäΤɤǧ롣*/
    if( pos == 0 )
      return 0 ;
  
    sptr = node->textbuffer + endpoint ;
    while( *sptr != '\0' )
      *ptr ++ = *sptr ++ ;
    *ptr = '\0' ;

    move_marker_ByDeleteRegion( node, startpoint, startpoint + pos ) ;
  }
  return 0 ;
}

/*
 * ̾⡼ɤҲ̾⡼ɤڤؤؿ
 *-----
 * ΰˤϡESC פˤ륳ޥɤϤ줿ä롣
 * Ǥ⡢ߤεǽ򥵥ݡȤͽϤʤΤǡˤ NULL 
 * ääƤ뤳ȤǤ餦
 */
static int j_toggle_kana
( Widget gw, struct SKKInputNode *node, int arg, int chara )
{
  /* "q" ˳ rule-list ̵ͤ롣*/
  if( j_kakutei_kana_mode( gw, node, chara ) )
    return 0 ;
  if( node->j_henkan_mode && !node->j_henkan_on ){
    /* ѴʤСҲ̾Ѵ֤겾̾⡼ɤʤ̵롣*/
    if( !node->j_katakana_mode ){
      j_katakana_region
	( node, node->j_henkan_start_point, node->cur_pos, True ) ;
      j_kakutei( gw, node ) ;
    }
  } else {
    /* ʳξä顢Ҳ̾⡼ɤȲ̾⡼ɤڤؤ롣*/
    j_kakutei( gw, node ) ;
    node->j_katakana_mode = !node->j_katakana_mode ;
    /* ⡼ɥ饤(ˡݥʡݤȤɽ)ѹϤޤ̵*/
    /* j_change_mode_line() ; */
  }
  return 0 ;
}

/*
 * Ѵ⤷ϲ̾ϤʤгεǽԤѿ⡼ɤʤ
 * ޻̾ϥ⡼ɤؤȰܹԤؿ
 */
static int j_kanainput_mode_on( Widget gw, struct SKKInputNode *node )
{
  /* Ѵ⤷ϲ̾ϤǤʤСꤹ롣*/
  j_kakutei( gw, node ) ;
  j_kakutei_kana_mode( gw, node, '\0' ) ;
  /* ѿ⡼ɤϤޤθƤʤΤǡνϤʤ*/
  return 0 ;
}

static int j_mode_off( Widget gw, struct SKKInputNode *node, int chara )
{
  if( j_kakutei_kana_mode( gw, node, chara ) )
    return 0 ;
  j_kakutei( gw, node ) ;
  node->j_mode    = False ;
  node->j_zenkaku = False ;
  return 0 ;
}

/*
 * ϥ⡼ɤؤȰܹԤԤؿǤ롣
 */
static int j_zenkaku_eiji
( Widget gw, struct SKKInputNode *node, int chara )
{
  if( j_kakutei_kana_mode( gw, node, chara ) )
    return 0 ;
  j_kakutei( gw, node ) ;
  node->j_mode    = False ;
  node->j_zenkaku = True ;
  return 0 ;
}

static int j_start_henkan_sub( Widget gw, struct SKKInputNode *node )
{
  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;
  /* Ѵ褦ȤƤ֤ΤǤ */
  if( node->j_henkan_start_point > node->cur_pos ){
    err_msg( node, "Henkan end point must be after henkan start point." ) ;
    return 1 ;
  }
  return 0 ;
}

/*
 * Ѵϴؿ
 *----
 * ѴˤɬϸƤФͽۤؿǤ롣
 */
static int j_start_henkan
( Widget gw, struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;

  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;

  if( !node->j_henkan_mode ){
    /* Ѵǽʾ֤Ǥʤä顢򵭹ν *
     * ʤ*/
    j_insert_chara( node, node->cur_pos, ' ' ) ;
    return 0 ;
  }
  /* Ѵǽʾ֤ˤʤäƤΤʤСѴ򤹤롣*/
  node->j_mode = True ;
  /* ˰ʾѴԤƤΤǤСθõ*/
  if( node->j_henkan_on ){
    /* ơѴԤޤ*/
    j_henkan( gw, node ) ;
  } else {
    /* Ѵν*/
    if( j_start_henkan_sub( gw, node ) )
      return 1 ;
    /* ߤΥ֤Ѵλ֤Ȥʤ꿽*/
    node->j_henkan_end_point = node->cur_pos ;
    /* ѴڤФ*/
    strncpy( node->j_henkan_key,
	     node->textbuffer + node->j_henkan_start_point,
	     node->j_henkan_end_point - node->j_henkan_start_point ) ;
    node->j_henkan_key[ node->j_henkan_end_point -
		      node->j_henkan_start_point ] = '\0' ;
    /* ñϿλ˻Ȥ¸Ƥ*/

    strcpy( node->j_henkan_key2, node->j_henkan_key ) ;
    /* #ʸѴΤν*/
    if( w->skkinput.use_numeric_conversion ){
      j_compute_numeric_henkan_key
	( node->j_search_key, node->j_henkan_key, node->j_num_list ) ;
    } else {
      strcpy( node->j_search_key, node->j_henkan_key ) ;
      node->j_num_list[ 0 ] = '\0' ;
    }
    /* ơѴԤޤ*/
    j_henkan( gw, node ) ;
  }
  return 0 ;
}

/*
 * θؤѴ᤹ؿ
 *----
 * ܸܲ skk Ʊ̾δؿưʬʤȤ⤢ޤɡ
 * ޤɤǤ͡äȤʬäƤľޤ
 */
static int j_previous_candidate
( Widget gw, struct SKKInputNode *node )
{
  int pos ;

  if( node->j_henkan_mode && node->j_henkan_on ){
    if( node->j_henkan_count == 0 ){
      /* ξ֤ˤʤꤦΤ */
      /* j_henkan_count = 0 ȤƤޤȡj_henkan_on  off ˤʤäƤ *
       * ޤȻפΤ...ޤϤȲꤹ뤱ɡ      */
      return 0 ;
    } else if( node->j_henkan_count == 1 ){
      /* ѴƤʤ֤ذܹԤ롣*/
      node->j_henkan_on     = False ;
      node->j_henkan_count  = 0 ;
      node->j_num_list[ 0 ] = '\0' ;
      /* ѴλƽФ*/
      XtCallCallbacks( gw, XtNjhenkanendNotify, node ) ;

      /* Ѵˤäƽ񤫤Ƥʸõ롣*/
      j_delete_region( node, 
		       node->j_henkan_start_point,
		       node->j_henkan_end_point ) ;
      node->cur_pos = node->j_henkan_end_point ;
      /* Ȥʸ᤹*/
      pos = strlen( node->j_henkan_key ) - 1 ;
      if( node->j_henkan_key[ pos ] >='a' &&
	  node->j_henkan_key[ pos ] <= 'z' &&
	  !node->j_abbrev )
	node->j_henkan_key[ pos ] = '\0' ;
#ifdef DEBUG_LV0
      fprintf( stderr, "j_henkan_key : \"%s\".\n", node->j_henkan_key ) ;
#endif
      j_insert_str( node, node->cur_pos, node->j_henkan_key ) ;
      /* Ѵλ֤򸵤᤹*/
      node->j_henkan_end_point = node->cur_pos ;
      /* ֢פ֢פ᤹*/
      j_change_marker_to_write( node,
				node->j_henkan_start_point -
				j_kanji_length ) ;
    } else {
      /* θФ*/
      if( ( node->j_current_henkan_vector_index )->prev != NULL ){
	node->j_current_henkan_vector_index =
	  ( node->j_current_henkan_vector_index )->prev ;
	node->j_henkan_count -- ;
      }
      /* ߤθä*/
      j_delete_region( node, 
		       node->j_henkan_start_point, 
		       node->j_henkan_end_point ) ;
      /* ФХåեˤĤ*/
      copyCandidate( temporary_buffer,
		     ( node->j_current_henkan_vector_index )->node,
		     ( node->j_current_henkan_vector_index )->position,
		     TEXTMAXLEN ) ;
      node->cur_pos_backup = node->cur_pos ;
      node->cur_pos = node->j_henkan_start_point ;
      /* 񤭹ࡣ*/
#if 0
      j_insert_str( node, node->j_henkan_start_point, temporary_buffer ) ;
#else
      j_insert_word
	( gw, node, node->j_henkan_start_point, temporary_buffer ) ;
#endif
      node->j_henkan_end_point = node->cur_pos ;
      node->cur_pos = node->cur_pos_backup ;
    }
  } else {
    j_kana_input( gw, node, 'x' ) ;
  }
  return 0 ;
}

/*
 * ܡɤ Control-H νԤؿ
 */
static int j_backward_delete_char
( Widget gw, struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;

  if( node->j_henkan_mode && 
      node->cur_pos == node->j_henkan_start_point ){
    /* Ѵ⡼ɤǤꡢѴϰ֤ˤˤϡäƤޤ *
     * ȤˤʤäƤޤΤǡꤹ뤳Ȥˤʤ롣                   */
    node->j_henkan_count = 0 ;
    j_kakutei( gw, node ) ;
  } else if( node->j_henkan_on ){
    /* Ѵ⡼ɤǤꡢʾºݤѴԤƤˤϡ   *
     * θФ⡼ɤ롣                                   */
    if( node->cur_pos == node->j_henkan_end_point &&
	!w->skkinput.delete_implies_kakutei ){
      j_previous_candidate( gw, node ) ;
    } else {
      int p = node->j_henkan_end_point ;
      /*  delete_backward_char  end_point ưƤޤ *
       * cur_pos == end_point äˤϡܤˤʤäƤޤͤ */
      delete_backward_char( gw, node ) ;
      if( node->cur_pos < p )
	j_kakutei( gw, node ) ;
    }
  } else  {
    /* 겾̾ϤƤä顢̵ˤ롣*/
    if( node->j_okurigana_mode ){
      node->j_okurigana_mode = False ;
      node->j_okuri_chara = '\0' ;
      if( node->textbuffer[ node->j_okurigana_start_point ] == '*' ){
	/* ȡ"*äääät"  C-h 򲡤ȤäѤä *
	 * */
	if( node->j_kana_mode == True && 
	    node->j_kana_start_point > node->j_okurigana_start_point ){
	  j_delete_region( node, node->j_okurigana_start_point,
			  node->j_kana_start_point ) ;
	} else {
	  delete_char( node, node->j_okurigana_start_point, 1 ) ;
	}
      }
    }
    /* ̾ϤκʤСβ̾ץեƺ롣*/
    if( node->j_kana_mode ){
      node->j_kana_mode = False ;
      node->j_prefix[ 0 ] = '\0' ;
      /* ̾ץեγϰ֤饫֤ޤǤ롣*/
      j_delete_region( node, node->j_kana_start_point, node->cur_pos ) ;
    } else {
      delete_backward_char( gw, node ) ;
    }
  }
  return 0 ;
}

/*
 * ԤƬذưؿ
 */
static int j_beginning_of_line( struct SKKInputNode *node )
{
  /* ̾Ϥʤ顢Υץե롣*/
  j_delete_kanaprefix( node ) ;
  /* Ƭء*/
  node->cur_pos = node->cur_pos_top ;
  return 0 ;
}

/*
 * ԤκǸذưؿ
 */
static int j_end_of_line( struct SKKInputNode *node )
{
  /* ̾Ϥʤ顢Υץե롣*/
  j_delete_kanaprefix( node ) ;
  /* ء*/
  node->cur_pos = strlen( node->textbuffer ) ;
  return 0 ;
}

/*
 * ְʹߤʸ򥫥åȥХåե˰ưؿ
 */
static int j_kill_line( Widget gw, struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  int last_pos ;
  /* ̾Ϥʤ顢Υץե롣*/
  j_delete_kanaprefix( node ) ;
  last_pos = strlen( node->textbuffer ) ;
  /* åȥХåե˥ԡ롣*/
  strcpy( w->skkinput.cutbuffer, node->textbuffer + node->cur_pos ) ;
  /* ʹߤʸõ롣*/
  j_delete_region( node, node->cur_pos, last_pos ) ;
  return 0 ;
}

/*
 * åȥХåեäƤʸŽդؿ
 */
static int j_yank( Widget gw, struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  j_insert_str( node, node->cur_pos, w->skkinput.cutbuffer ) ;
  return 0 ;
}

/*
 * ֤ΰΥȥ֤Υ򴹤ƥ
 * ĿʤԤؿ
 *-----
 * 뤬äˤϥΰưϤʤ򴹤
 * 륭ϥΰȤ⤦Ǥ롣
 *()
 * EUC-3byte ɤ̵뤷Ƥޤ
 */
static int j_transpose_chars( struct SKKInputNode *node )
{
  int spos, epos, i ;
  /* 5 = j_kanji_length * 2 + 1 */
  unsigned char transpose_buffer[ 5 ] ;

  /* Ƭʤ鲿⤷ʤȴ롣Ƭǲ̾ץե¸ߤ *
   * ֤ϤäȹͤʤǤ*/
  if( node->cur_pos == node->cur_pos_top ){
    err_msg( node, "Beginning of buffer" ) ;
    return 0 ;
  }

  /* ̾Ϥʤ顢Υץե롣*/
  j_delete_kanaprefix( node ) ;

  /* 򴹤륭⡢˶ᤤܤޤλ *
   * ʤȤ node->cur_pos != node->cur_pos_top ʤΤǤ顢-1 *
   * Ƥפʤ櫓Ǥ*/
  if( node->textbuffer[ node->cur_pos ] == '\0' ){
    spos = node->cur_pos - 1 ;
    if( node->textbuffer[ spos ] & 0x80 ){
      /* EUC äˤϡХȷᤦʤΤǤ⤦ *
       * ưޤ*/
      spos = node->cur_pos - j_kanji_length ;
      /* ɤȴФޤ*/
      strncpy( transpose_buffer, node->textbuffer + spos,
	       j_kanji_length ) ;
      i = j_kanji_length ;
    } else {
      transpose_buffer[ 0 ] = node->textbuffer[ spos ] ;
      i = 1 ;
    }
    /* õ֤򵭲Ƥ*/
    epos = node->cur_pos ;
    /* ʤ顢򴹤뤳Ȥˤʤʸκǽ餫饫֤ޤ *
     * ξõˤʤ롣*/
  } else {
    spos = node->cur_pos ;
    if( node->textbuffer[ spos ] & 0x80 ){
      /* ɤȴФޤ*/
      strncpy( transpose_buffer, node->textbuffer + spos,
	       j_kanji_length ) ;
      /* õ֤򵭲Ƥ*/
      epos = node->cur_pos + j_kanji_length ;
      i = j_kanji_length ;
    } else {
      transpose_buffer[ 0 ] = node->textbuffer[ spos ] ;
      /* õ֤򵭲Ƥ*/
      epos = node->cur_pos + 1 ;
      i = 1 ;
    }
    /* ǤʤΤʤ顢ߥ뤬ʸäʤȤ *
     * ʤ */
  }
  /* 򴹤륭⡢˶ᤤ(Ĥޤ¦)򸫤 *
   * ǹƬƤޤäȤȤϡ⤦ιƬ¦Υ *
   * ̵ȤȤˤʤޤ*/
  if( spos <= node->cur_pos_top )
    return 0 ;
  /* ʤä⤦ĤΥ餬¸ߤΤǡä *
   * ޤ*/
  if( node->textbuffer[ spos - 1 ] & 0x80 ){
    spos -= j_kanji_length ;
    /* ɤȴФޤ*/
    strncpy( transpose_buffer + i, node->textbuffer + spos,
	       j_kanji_length ) ;
    i += j_kanji_length ;
  } else {
    spos -- ;
    transpose_buffer[ i ] = node->textbuffer[ spos ] ;
    i ++ ;
  }
  /* ʸü롣*/
  transpose_buffer[ i ] = '\0' ;
  /* ʸõ롣*/
  j_delete_region( node, spos, epos ) ;
  /* 򴹸ʸ롣*/
  j_insert_str( node, node->cur_pos, transpose_buffer ) ;
  return 0 ;
}

/*
 * ιԤĤäơǥʤϤĤäƤ
 * ɽؿ
 *-----
 * Ȥ櫓ǡΤΤϳꤵƤޤҥȥΰֺǸ
 * ¸롣( ʤʤäƤޤä顢äȺ顣)
 */
static int j_previous_line( Widget gw, struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  unsigned char *ptr ;
  int pos, length ;
  /* ֿƤΥХåեǤͭǤʤȤ롣*/
  if( node->parentbuffer != NULL )
    return 1 ;
  /* ҥȥХåեä顢¨ȴ롣*/
  if( w->skkinput.hist_start == w->skkinput.hist_end )
    return 1 ;
  /* ꤹ롣ʤˤʤ롣*/
  j_kakutei( gw, node ) ;
  j_kakutei_kana_mode( gw, node, '\0' ) ;
  /* θѤǽäǤ*/
  if( w->skkinput.hist_cur < 0 ){
    /* ߤʸ¸Ƥ*/
    strcpy( w->skkinput.histcurbackbuffer, node->textbuffer ) ;
    w->skkinput.hist_cur = w->skkinput.hist_end ;
  }
  /* ʾθϤʤΤǡ⤷ʤǵ롣*/
  if( w->skkinput.hist_cur == w->skkinput.hist_start )
    return 0 ;
  /* θ롣*/
  pos = w->skkinput.hist_cur - 1 ;	/* ΰ֤ '\0' */
  do {
    pos -- ;
    if( pos < 0 ){
      pos += TEXTBUFSIZE ;
    }
  } while( w->skkinput.historybuffer[ pos ] != '\0' &&
	   pos != w->skkinput.hist_start ) ;
  /* θγϰ֡*/
  if( pos != w->skkinput.hist_start )
    pos = ( pos + 1 ) % TEXTBUFSIZE ;
  /* ߸Ƥ֤ν*/
  w->skkinput.hist_cur = pos ;
  /* ȴФ*/
  ptr = node->textbuffer ;
  length = 0 ;
  while( w->skkinput.historybuffer[ pos ] != '\0' ){
    *ptr ++ = w->skkinput.historybuffer[ pos ++ ] ;
    length ++ ;
    if( pos >= TEXTBUFSIZE )
      pos = 0 ;
  }
  *ptr = '\0' ;
  /* ֤ν*/
  node->cur_pos = length ;
  return 0 ;
}

static int j_next_line( Widget gw, struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  unsigned char *sptr, *dptr ;
  int pos, length ;
  /* ֿƤΥХåեǤͭǤʤȤ롣*/
  if( node->parentbuffer != NULL )
    return 1 ;
  /* ⤿ɤäƤʤΤˡμ˹Ԥʤ̤ͽ¬ϤǤʤ*/
  if( w->skkinput.hist_cur < 0 ){
    return 1 ;
  }
  /* ֺǸؤƤäƤȤϡ */
  if( w->skkinput.hist_cur == w->skkinput.hist_end ){
    strcpy( node->textbuffer, w->skkinput.histcurbackbuffer ) ;
    node->cur_pos = strlen( node->textbuffer ) ;
    w->skkinput.hist_cur = -1 ;
    return 0 ;
  }
  /* ꤹ롣ʤˤʤ롣*/
  j_kakutei( gw, node ) ;
  j_kakutei_kana_mode( gw, node, '\0' ) ;
  /* θ롣*/
  sptr = w->skkinput.historybuffer + w->skkinput.hist_cur ;
  pos = w->skkinput.hist_cur ;
  while( *sptr != '\0' ){
    sptr ++ ;
    pos ++ ;
    if( pos >= TEXTBUFSIZE ){
      pos = 0 ;
      sptr = w->skkinput.historybuffer ;
    }
  }
  /* Ǥ '\0' Ǥ顢⤦Ŀʤࡣ*/
  sptr ++ ;
  pos ++ ;
  if( pos >= TEXTBUFSIZE ){
    pos = 0 ;
    sptr = w->skkinput.historybuffer ;
  }
  /* ǸޤƤޤ顣*/
  if( pos == w->skkinput.hist_end ){
    strcpy( node->textbuffer, w->skkinput.histcurbackbuffer ) ;
    node->cur_pos = strlen( node->textbuffer ) ;
    w->skkinput.hist_cur = -1 ;
    return 0 ;
  } 
  /* θ򤭤ؤơ*/
  w->skkinput.hist_cur = pos ;

  /* ȴФ*/
  dptr = node->textbuffer ;
  length = 0 ;
  while( *sptr != '\0' ){
    *dptr ++ = *sptr ++ ;
    pos ++ ;
    length ++ ;
    if( pos >= TEXTBUFSIZE ){
      sptr = w->skkinput.historybuffer ;
      pos  = 0 ;
    }
  }
  /* Ǹ򤭤Ƚüơ*/
  *dptr = '\0' ;
  /* ֤*/
  node->cur_pos = length ;
  return 0 ;
}

/*
 * Ѵϰ֤ꤹؿ
 *----
 * ʸϤˤѴϰ֤ꤵ뤳Ȥ˥ǥեȤǤϤʤ
 * Ƥ롣
 */
static void j_set_henkan_point
( Widget gw, struct SKKInputNode *node, int chara )
{
  switch( chara ){
  case 'A' :
    /* 첻Ϥ뤳ȤˤѴϰ֤ꤵν*/
    j_set_henkan_point_ByVowel( gw, node, skk_roma_kana_a, chara ) ;
    break ;
  case 'E' :
    /* 첻Ϥ뤳ȤˤѴϰ֤ꤵν*/
    j_set_henkan_point_ByVowel( gw, node, skk_roma_kana_e, chara ) ;
    break ;
  case 'I' :
    /* 첻Ϥ뤳ȤˤѴϰ֤ꤵν*/
    j_set_henkan_point_ByVowel( gw, node, skk_roma_kana_i, chara ) ;
    break ;
  case 'O' :
    /* 첻Ϥ뤳ȤˤѴϰ֤ꤵν*/
    j_set_henkan_point_ByVowel( gw, node, skk_roma_kana_o, chara ) ;
    break ;
  case 'U' :
    /* 첻Ϥ뤳ȤˤѴϰ֤ꤵν*/
    j_set_henkan_point_ByVowel( gw, node, skk_roma_kana_u, chara ) ;
    break ;
    /* üʸФʸˤäѴγϰ֤ꤵ硣*/
  case '<' :
  case '>' :
  case '?' :
    j_set_henkan_point_by_special_midashi_char
      ( gw, node, chara ) ;
    break ;
  default :
    j_set_henkan_point_ByConsonat( gw, node, chara ) ;
    break ;
  }
  return ;
}

static void j_set_henkan_point_subr
( Widget gw, struct SKKInputNode *node, int rchara )
{
  /* ̾椫"n"ʤ""ˤƤޤ*/
  if( j_kakutei_kana_mode( gw, node, rchara ) )
    return ;
  /* ºݤȰ㤦褦ɡƤǽ褦*/
  if( node->j_henkan_mode )
    j_kakutei( gw, node ) ;
  /* ɽơ*/
  j_insert_str( node, node->cur_pos, "" ) ;
  /* Ѵϰ֤򥫡֤˷ꤷơ*/
  node->j_henkan_start_point = node->cur_pos ;
  node->j_henkan_mode = True ;
  node->j_henkan_on   = False ;
  return ;
}

/*
 * C-g ˤäѴ֢פξ֤֢פξ֤ؤܤν
 * Ԥؿ
 */
static void j_keyboard_quit_henkanrestart
( Widget gw, struct SKKInputNode *node, int flag )
{
  /* ѴƤʤ֤ذܹԤ롣*/
  node->j_henkan_on      = False ;
  node->j_henkan_count   = 0 ;
  node->j_henkan_show_candidate_mode = False ;
  /* ѴλƽФ*/
  XtCallCallbacks( gw, XtNjhenkanendNotify, node ) ;
  /* Ѵäޤ*/
  node->cur_pos2 = node->j_kana_start_point ;
  node->cur_pos3 = node->j_okurigana_start_point ;

  /*
   * ֤ͤͤɤƤ겾̾⡼ɤɤƤΡ
   * ֤ĤϤʡĥ꡼ɤȤʤ
   * 겾̾γϰ֤ĤǤî͡
   * ֤Ƥ櫓ʬä饤ࡩ
   */
  if( node->j_okurigana_mode ){
    /* ɤɤʬʤɡĥɥۥåбɡġ*/
    if( node->textbuffer[ node->j_okurigana_start_point ] != '*' )
      node->j_okurigana_mode = False ;
    node->j_henkan_key[ node->j_okurigana_offset ] = '\0' ;
    j_delete_region
      ( node, node->j_henkan_start_point, node->j_okurigana_start_point ) ;
  } else {
#if 0
    pos = strlen( node->j_henkan_key ) ;
    node->j_henkan_key[ pos ] = '\0' ;
#endif
    j_delete_region
      ( node, node->j_henkan_start_point, node->j_henkan_end_point ) ;
  }
#ifdef DEBUG_LV0
  fprintf( stderr, "j_henkan_key : \"%s\".\n", node->j_henkan_key ) ;
#endif
  if( !flag ){
    node->cur_pos = node->j_henkan_end_point ;
    j_insert_str( node, node->cur_pos, node->j_henkan_key ) ;
    /* Ѵλ֤򸵤᤹*/
    node->j_henkan_end_point = node->cur_pos ;
  } else {
    j_insert_str( node, node->j_henkan_start_point, node->j_henkan_key ) ;
  }
  node->j_kana_start_point = node->cur_pos2 ;
  node->j_okurigana_start_point = node->cur_pos3 ;
  /* ֢פ֢פ᤹*/
  j_change_marker_to_write
    ( node, node->j_henkan_start_point - j_kanji_length ) ;
  return ;
}

/*
 * C-g ˤäѴ֢פξ֤λνԤؿ
 */
static void j_keyboard_quit_henkanclose
( Widget gw, struct SKKInputNode *node )
{
  int pos ;

  /* Ѵ⡼ɤȴФ*/
  node->j_henkan_mode    = False ;
  node->j_henkan_on      = False ;
  node->j_abbrev         = False ;
  node->j_henkan_show_candidate_mode = False ;
  pos = node->j_henkan_start_point - j_kanji_length ;
  /* Ѵϰ֤ˡ֢פϤΤ ̵ä顢ѡ*/
  if( looking_at( node, pos, "" ) ){
    delete_char( node, pos, 1 ) ;
  } else {
    err_msg( node, "It seems that you have deleted ." ) ;
  }
  /* 겾̾⡼ɤäн襳ɡ*/
  if( node->j_okurigana_mode && 
      node->textbuffer[ node->j_okurigana_start_point ] == '*' )
    delete_char( node, node->j_okurigana_start_point, 1 ) ;
  /* Ѵϰ֤饫֤ޤǤõ롣*/
  j_delete_region
    ( node, node->j_henkan_start_point, node->cur_pos ) ;
  node->j_okurigana_mode = False ;
  return ;
}

/*
 * Control-G 򲡤ν
 */
static void j_keyboard_quit
( Widget gw, struct SKKInputNode *node )
{
  /* ̾ʤΥץե򥭥󥻥뤷Ƥޤ*/
  if( node->j_kana_mode ){
    /* β̾ץեä롣*/
    delete_char( node, node->j_kana_start_point,
		 node->cur_pos - node->j_kana_start_point ) ;
    node->j_kana_mode = False ;
    node->j_prefix[ 0 ] = '\0' ;
    return ;
  }
  /* Ѵ⡼ɤ˰ưƤΤǤ */
  if( node->j_henkan_mode ){
    /* ºݤѴϰٰʾԤƤΤǤ */
    if( node->j_henkan_on ){
      /* ֢פ֢פؤȾܤơѴκǽؤ᤹*/
      j_keyboard_quit_henkanrestart( gw, node, False ) ;
      node->j_okurigana_mode = False ;
    } else {
      /* ֢פõѴλ롣*/
      j_keyboard_quit_henkanclose( gw, node ) ;
    }
    return ;
  }

  /* ľܥϥ⡼ɤäν*/
  if( node->j_input_by_code_or_menu_mode ){
    node->j_input_by_code_or_menu_mode = False ;
    node->mtextbuffer[ 0 ] = '\0' ;
    return ;
  }

  /* ʾΤɤǤʤä顢mini-buffer mode ˤʤäɤ *
   * Ƚꤹ롣*/
  if( node->parentbuffer != NULL ){
    struct SKKInputNode *pNode = node->parentbuffer ;
    int usage = node->j_minibuff_usage ;
    /* ߥ˥ХåեѤߤΤǡꥢ롣*/
    skkinput_ClearMinibuffer( gw ) ;
    /* 󥻥ȤȤǡΥΡɤϲƤޤޤ*/
    free_Minibuffer( gw, node ) ;
    /* Ƥ˥֤ޤ礦*/
    pNode->cur_exist = True ;

    /* ǡĿƤ򤷤ƤΤȽǤŬڤʽƤˤ¹Ԥ롣*/
    switch( usage ){
      /* ߥ˥ХåեǤѴ˰ܤäƤġ*/
    case J_HENKAN_IN_MINIBUFF_MODE :
      /* ߥ˥ХåեǤѴ⡼ɤäƤʤ顢äȤҥå *
       * Τ̵äν*/
      if( pNode->j_henkan_count == 0 && pNode->j_henkan_mode &&
	  pNode->j_henkan_on ){
	/* ΤޤޤǤϤʤؤȾܤ롣*/
	j_keyboard_quit_henkanrestart
	  ( gw, pNode, pNode->j_okurigana_mode ) ;
      }
      break ;
    case J_INPUT_BY_CODE_OR_MENU_MODE :
      pNode->j_input_by_code_or_menu_mode = False ;
      pNode->mtextbuffer[ 0 ] = '\0' ;
      break ;
      /* ѡʤäˤ̵ƤǤʤʤġ *
       * ȤܡĤǤɤˤʤΤͤ*/
    case J_PURGE_YES_OR_NO_P :
      pNode->mtextbuffer[ 0 ] = '\0' ;
      break ;
    default :
      break ;
    }
    /* ƤѴɽ⡼ɤǤʤä顢ˤƤ*/
    if( !pNode->j_henkan_show_candidate_mode )
      pNode->mtextbuffer[ 0 ] = '\0' ;
    return ;
  }
#if 0
  XBell( XtDisplay( gw ), 5 ) ;
#endif
  err_msg( node, "Quit" ) ;
  return ;
}

/*
 * νԤäƤΥ٥Ȥνؿ
 *----
 * ϥХɤѹ뤳ȤϤǤʤ skk.el Ǥ⤽ʤ
 * ƤȦ̤ѹǤ褦ˤƤ⹽ʤɤ͡
 */
static int do_Function_jhenkanShowCandidateMode
( Widget gw, struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  VectorIndex *vNode ;
  int h_count, kouho_num, i ;

  /* 顼ɽǾäƤޤäƤ뤫⤷ʤɽ */
  /* Emacs ϼưƤߤɡġ */
  vNode     = j_henkan_show_candidates( gw, node, &h_count ) ;
  kouho_num = h_count - node->j_henkan_count ;

  switch( w->skkinput.keybuf[ 0 ] ){

    /* ֺθ򤹤롣*/
  case 'a' :
    /* ȴФơġ*/
    copyCandidate( temporary_buffer,
		   ( node->j_current_henkan_vector_index )->node,
		   ( node->j_current_henkan_vector_index )->position,
		   TEXTMAXLEN ) ;
    /* Ѵλ֤Ĵ*/
    node->cur_pos_backup = node->cur_pos ;
    node->cur_pos        = node->j_henkan_start_point ;
    /* ʸ*/
#if 0
    j_insert_str( node, node->j_henkan_start_point, temporary_buffer ) ;
#else
    j_insert_word
      ( gw, node, node->j_henkan_start_point, temporary_buffer ) ;
#endif
    node->j_henkan_end_point = node->cur_pos ;
    node->cur_pos = node->cur_pos_backup ;
    /* Υ⡼ɤνλ*/
    j_kakutei( gw, node ) ;
    node->mtextbuffer[ 0 ] = '\0' ;
    break ;

    /* 飲ܤθ򤹤롣*/
  case 's' :
    if( kouho_num < 2 )
      break ;

    node->j_current_henkan_vector_index =
      node->j_current_henkan_vector_index->next ;
    
    /* ȴФơġ*/
    copyCandidate( temporary_buffer,
		   ( node->j_current_henkan_vector_index )->node,
		   ( node->j_current_henkan_vector_index )->position,
		   TEXTMAXLEN ) ;
    /* Ѵλ֤Ĵ*/
    node->cur_pos_backup = node->cur_pos ;
    node->cur_pos        = node->j_henkan_start_point ;
    /* ʸ*/
#if 0
    j_insert_str( node, node->j_henkan_start_point, temporary_buffer ) ;
#else
    j_insert_word
      ( gw, node, node->j_henkan_start_point, temporary_buffer ) ;
#endif
    node->j_henkan_end_point = node->cur_pos ;
    node->cur_pos = node->cur_pos_backup ;
    /* Υ⡼ɤνλ*/
    j_kakutei( gw, node ) ;
    node->mtextbuffer[ 0 ] = '\0' ;
    break ;

    /* 飳ܤθ򤹤롣*/
  case 'd' :
    if( kouho_num < 3 )
      break ;

    node->j_current_henkan_vector_index =
      node->j_current_henkan_vector_index->next->next ;

    /* ȴФơġ*/
    copyCandidate( temporary_buffer,
		   ( node->j_current_henkan_vector_index )->node,
		   ( node->j_current_henkan_vector_index )->position,
		   TEXTMAXLEN ) ;
    /* Ѵλ֤Ĵ*/
    node->cur_pos_backup = node->cur_pos ;
    node->cur_pos        = node->j_henkan_start_point ;
    /* ʸ*/
#if 0
    j_insert_str( node, node->j_henkan_start_point, temporary_buffer ) ;
#else
    j_insert_word
      ( gw, node, node->j_henkan_start_point, temporary_buffer ) ;
#endif
    node->j_henkan_end_point = node->cur_pos ;
    node->cur_pos = node->cur_pos_backup ;
    /* Υ⡼ɤνλ*/
    j_kakutei( gw, node ) ;
    node->mtextbuffer[ 0 ] = '\0' ;
    break ;

    /* 飴ܤθ򤹤롣*/
  case 'f' :
    if( kouho_num < 4 )
      break ;

    node->j_current_henkan_vector_index =
      node->j_current_henkan_vector_index->next->next->next ;

    /* ȴФơġ*/
    copyCandidate( temporary_buffer,
		   ( node->j_current_henkan_vector_index )->node,
		   ( node->j_current_henkan_vector_index )->position,
		   TEXTMAXLEN ) ;
    /* Ѵλ֤Ĵ*/
    node->cur_pos_backup = node->cur_pos ;
    node->cur_pos        = node->j_henkan_start_point ;
    /* ʸ*/
#if 0
    j_insert_str( node, node->j_henkan_start_point, temporary_buffer ) ;
#else
    j_insert_word
      ( gw, node, node->j_henkan_start_point, temporary_buffer ) ;
#endif
    node->j_henkan_end_point = node->cur_pos ;
    node->cur_pos = node->cur_pos_backup ;
    /* Υ⡼ɤνλ*/
    j_kakutei( gw, node ) ;
    node->mtextbuffer[ 0 ] = '\0' ;
    break ;

    /* 飵ܤθ򤹤롣*/
  case 'j' :
    if( kouho_num < 5 )
      break ;

    node->j_current_henkan_vector_index =
      node->j_current_henkan_vector_index->next->next->next->next ;

    /* ȴФơġ*/
    copyCandidate( temporary_buffer,
		   ( node->j_current_henkan_vector_index )->node,
		   ( node->j_current_henkan_vector_index )->position,
		   TEXTMAXLEN ) ;
    /* Ѵλ֤Ĵ*/
    node->cur_pos_backup = node->cur_pos ;
    node->cur_pos        = node->j_henkan_start_point ;
    /* ʸ*/
#if 0
    j_insert_str( node, node->j_henkan_start_point, temporary_buffer ) ;
#else
    j_insert_word
      ( gw, node, node->j_henkan_start_point, temporary_buffer ) ;
#endif
    node->j_henkan_end_point = node->cur_pos ;
    node->cur_pos = node->cur_pos_backup ;
    /* Υ⡼ɤνλ*/
    j_kakutei( gw, node ) ;
    node->mtextbuffer[ 0 ] = '\0' ;
    break ;

    /* 飶ܤθ򤹤롣*/
  case 'k' :
    if( kouho_num < 6 )
      break ;

    node->j_current_henkan_vector_index =
      node->j_current_henkan_vector_index->next->next->next->next->next ;

    /* ȴФơġ*/
    copyCandidate( temporary_buffer,
		   ( node->j_current_henkan_vector_index )->node,
		   ( node->j_current_henkan_vector_index )->position,
		   TEXTMAXLEN ) ;
    /* Ѵλ֤Ĵ*/
    node->cur_pos_backup = node->cur_pos ;
    node->cur_pos        = node->j_henkan_start_point ;
    /* ʸ*/
#if 0
    j_insert_str( node, node->j_henkan_start_point, temporary_buffer ) ;
#else
    j_insert_word
      ( gw, node, node->j_henkan_start_point, temporary_buffer ) ;
#endif
    node->j_henkan_end_point = node->cur_pos ;
    node->cur_pos = node->cur_pos_backup ;
    /* Υ⡼ɤνλ*/
    j_kakutei( gw, node ) ;
    node->mtextbuffer[ 0 ] = '\0' ;
    break ;

    /* 飷ܤθ򤹤롣*/
  case 'l' :
    if( kouho_num < 7 )
      break ;

    node->j_current_henkan_vector_index =
      node->j_current_henkan_vector_index->next->next->next->next->next->next ;

    /* ȴФơġ*/
    copyCandidate( temporary_buffer,
		   ( node->j_current_henkan_vector_index )->node,
		   ( node->j_current_henkan_vector_index )->position,
		   TEXTMAXLEN ) ;
    /* Ѵλ֤Ĵ*/
    node->cur_pos_backup = node->cur_pos ;
    node->cur_pos        = node->j_henkan_start_point ;
    /* ʸ*/
#if 0
    j_insert_str( node, node->j_henkan_start_point, temporary_buffer ) ;
#else
    j_insert_word
      ( gw, node, node->j_henkan_start_point, temporary_buffer ) ;
#endif
    node->j_henkan_end_point = node->cur_pos ;
    node->cur_pos = node->cur_pos_backup ;
    /* Υ⡼ɤνλ*/
    j_kakutei( gw, node ) ;
    node->mtextbuffer[ 0 ] = '\0' ;
    break ;

    /* θɽ롣*/
  case 'x' :
    /* 󤹤⡼ɤλʤФʤʤΤ */
    if( node->j_henkan_count == 5 ){
      /* ϤλʤƤϤʤޤ*/
      node->j_current_henkan_vector_index = 
	( node->j_current_henkan_vector_index )->prev ;
      node->j_henkan_count -- ;
      /* ȴФơġ*/
      copyCandidate( temporary_buffer,
		     ( node->j_current_henkan_vector_index )->node,
		     ( node->j_current_henkan_vector_index )->position,
		     TEXTMAXLEN ) ;
      /* Ѵλ֤Ĵ*/
      node->cur_pos_backup = node->cur_pos ;
      node->cur_pos        = node->j_henkan_start_point ;
      /* ʸ*/
#if 0
      j_insert_str( node, node->j_henkan_start_point, temporary_buffer ) ;
#else
      j_insert_word
	( gw, node, node->j_henkan_start_point, temporary_buffer ) ;
#endif
      node->j_henkan_end_point = node->cur_pos ;
      node->cur_pos = node->cur_pos_backup ;
      /* Υ⡼ɤνλ*/
      node->j_henkan_show_candidate_mode = False ;
      node->mtextbuffer[ 0 ] = '\0' ;
    } else {
      /* λʤƤ⹽ʤǤ*/
      node->j_henkan_count -= 7 ;
      /* θɽ٤᤹*/
      for( i = 0 ; i < 7 ; i ++ )
	node->j_current_henkan_vector_index = 
	  ( node->j_current_henkan_vector_index )->prev ;
      /* ɽľ*/
      j_henkan_show_candidates( gw, node, NULL ) ;
    }
    break ;
    /* θɽ롣*/
  case ' ' :
    if( vNode != NULL ){
      /* ƬθؤƤݥ󥿤ư롣*/
      node->j_current_henkan_vector_index = vNode ;
      node->j_henkan_count                = h_count ;
      /* ɽľ*/
      j_henkan_show_candidates( gw, node, NULL ) ;
    } else {
      /* minibuffer 򳫤ƤѴȤ˰ư롣*/
      skkinput_j_henkan_in_minibuff_init( gw, node ) ;
    }
    break ;
    /* Keyboard-Quit äν*/
  case 0x07 :
    j_keyboard_quit( gw, node ) ;
    node->mtextbuffer[ 0 ] = '\0' ;
    break ;
    /* ̤νľ*/
  case 0x0c :
    /* ɽľ*/
    j_henkan_show_candidates( gw, node, NULL ) ;
    /* ޤ褵Ȥޤ*/
    skkinput_RedrawScreen( gw ) ;
    break ;
    /* ʥϤä硣*/
  default :
    err_msg( node, "`%s' is not valid here!",
	     charaToString( w->skkinput.keybuf[ 0 ] ) ) ;
    break ;
  }
  w->skkinput.keybuf_use  = 0 ;
  w->skkinput.keybuf[ 0 ] = '\0' ;
  return 0 ;
}

static int lookup_at_string( char *string, int chara )
{
  char *ptr = string ;
  int i ;

  for( i = 0 ; *ptr != '\0' ; ptr ++, i ++ ){
    if( *ptr == chara )
      return i ;
  }
  return (-1) ;
}

#define upcase_char(ch)	(((ch)>='a' && (ch)<='z')? ((ch)+('A'-'a')) : (ch))

/*
 * ľܥϤλΥߥ˥Хåեɽؿ
 */
static void j_input_by_code_or_menu_jmp_showCandidate
( struct SKKInputNode *node, int code )
{
  char buffer[ 4 ] ;
  int i ;

  /* ¹ԤɬפΤɤϵ䡣initialize Ǥ *
   * Ƥޤ٤*/
  j_input_by_code_menu1_codes[ 0 ] = j_code_n1_min ;

  temporary_buffer[ 0 ] = '\0' ;
  buffer[ 3 ] = '\0' ;

  /* ϰˤ뤫ɤȽǤ롣*/
  if( code < j_code_n1_min )
    code = j_code_n1_min ;
  buffer[ 1 ] = code ;
  /* ˥塼Ĥ롣*/
  for( i = 0 ; i < 6 ; i ++ ){
    buffer[ 0 ] = upcase_char( j_input_by_code_menu_keys1[ i ] ) ;
    buffer[ 2 ] = j_input_by_code_menu1_codes[ i ] ;
    strcat( temporary_buffer, buffer ) ;
    strcat( temporary_buffer,     "  " ) ;
  }
  code ++ ;
  /* ϰˤ뤫ɤȽǤ롣*/
  buffer[ 1 ] = ( code < j_code_n1_max )? code : j_code_n1_min ;
  /* ˥塼Ĥ롣(ĤŤ)*/
  for( i = 0 ; i < 6 ; i ++ ){
    buffer[ 0 ] = upcase_char( j_input_by_code_menu_keys1[ i + 6 ] ) ;
    buffer[ 2 ] = j_input_by_code_menu1_codes[ i ] ;
    strcat( temporary_buffer + 1, buffer ) ;
    strcat( temporary_buffer,     "  " ) ;
  }
  strcpy( node->mtextbuffer, temporary_buffer ) ;
  return ;
}

static void j_input_by_code_or_menu_1_jmp_showCandidate
( struct SKKInputNode *node, int code )
{
  unsigned int n1, n2, i ;
  unsigned char buffer[ 4 ] ;

  n1 = ( code >> 8 ) ;
  n2 = ( code & 0x00FF ) ;

#if 0
  fprintf( stderr, "code, n1, n2 = %x, %x, %x\n", code, n1, n2 ) ;
#endif
  temporary_buffer[ 0 ] = '\0' ;
  buffer[ 3 ] = '\0' ;

  for( i = 0 ; i < 16 ; i ++ ){
    buffer[ 0 ] = upcase_char( j_input_by_code_menu_keys2[ i ] ) ;
    buffer[ 1 ] = n1 ;
    buffer[ 2 ] = n2 ;
    
    strcat( temporary_buffer, buffer ) ;
    strcat( temporary_buffer, " " ) ;

    n2 ++ ;
    if( n2 > j_code_n2_max )
      n2 = j_code_n2_min ;
    if( n2 == j_code_n2_min ){
      n1 ++ ;
      if( n1 > j_code_n1_max )
	n1 = j_code_n1_min ;
    }
  }
  strcpy( node->mtextbuffer, temporary_buffer ) ;
  return ;
}

int do_function_j_input_by_code_or_menu_jump( Widget gw,
					      struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  unsigned char buffer[ 3 ] ;
  int func_no ;

  /* 顼ɽǾäƤޤäƤ뤫⤷ʤɽ */
  /* Emacs ϼưƤߤɡġ */
  j_input_by_code_or_menu_jmp_showCandidate
    ( node, node->j_input_by_code_current_code ) ;

  func_no = lookup_at_string( j_input_by_code_menu_keys1,
			      w->skkinput.keybuf[ 0 ] ) ;
  
  if( func_no < 0 ){
    switch( w->skkinput.keybuf[ 0 ] ){
      /* θɽ롣*/
    case 'x' :
      node->j_input_by_code_current_code -= 2 ;
      if( node->j_input_by_code_current_code < j_code_n1_min )
	node->j_input_by_code_current_code = j_code_n1_max ;
      break ;
      /* ļθɽ롣*/
    case ' ' :
      node->j_input_by_code_current_code += 2 ;
      if( node->j_input_by_code_current_code > j_code_n1_max )
	node->j_input_by_code_current_code = j_code_n1_min ;
      break ;
      /* C-g ˤ Quit */
    case 0x07 :
      j_keyboard_quit( gw, node ) ;
      goto exit_menu ;
      /* ̤ɽʤ*/
    case 0x0c :
      node->mtextbuffer[ 0 ] = '\0' ;
      j_input_by_code_or_menu_jmp_showCandidate
	( node, node->j_input_by_code_current_code ) ;
      /* ޤ褵Ȥޤ*/
      skkinput_RedrawScreen( gw ) ;
      goto exit_menu ;
      /* ʳΥ̵*/
    default :
      err_msg( node, "`%s' is not valid here!",
	       charaToString( w->skkinput.keybuf[ 0 ] ) ) ;
      goto exit_menu ;
    }
    /* ɽ*/
    j_input_by_code_or_menu_jmp_showCandidate
      ( node, node->j_input_by_code_current_code ) ;
  } else {
    /* 䤬򤵤줿ν*/
    buffer[ 0 ] = node->j_input_by_code_current_code + ( func_no / 6 ) ;
    buffer[ 1 ] = j_input_by_code_menu1_codes[ func_no % 6 ] ;
    buffer[ 2 ] = '\0' ;

    node->j_input_by_code_current_code = buffer[ 0 ] << 8 | buffer[ 1 ] ;
    node->j_input_by_code_or_menu_mode ++ ;

    /* öߥ˥Хåեؤɽ򥯥ꥢ롣*/
    skkinput_ClearMinibuffer( gw ) ;
    /* ɽƤͿ롣*/
    j_input_by_code_or_menu_1_jmp_showCandidate
      ( node, node->j_input_by_code_current_code ) ;
  }
exit_menu:
  /* ʸΥХåեõ롣*/
  w->skkinput.keybuf_use  = 0 ;
  w->skkinput.keybuf[ 0 ] = '\0' ;
  return 0 ;
}

int do_function_j_input_by_code_or_menu_1_jump( Widget gw,
						struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
#if 0
  unsigned char buffer[ 3 ] ;
#endif
  int func_no ;
  unsigned int n1, n2 ;

  /* 顼ɽǾäƤޤäƤ뤫⤷ʤɽ */
  /* Emacs ϼưƤߤɡġ */
  j_input_by_code_or_menu_1_jmp_showCandidate
    ( node, node->j_input_by_code_current_code ) ;

  func_no = lookup_at_string( j_input_by_code_menu_keys2,
			      w->skkinput.keybuf[ 0 ] ) ;
  if( func_no < 0 ){
  /* 'a','s',ĤǤʤäν*/
    n1 = ( node->j_input_by_code_current_code ) >> 8 ;
    n2 = ( node->j_input_by_code_current_code ) & 0x00FF ;
    switch( w->skkinput.keybuf[ 0 ] ){
      /* θؤ롣*/
    case 'x' :
      n2 -= 15 ;
      if( n2 < j_code_n2_min ){
	n2 = j_code_n2_max - ( j_code_n2_min - n2 ) ;
	n1 -- ;
	if( n1 < j_code_n1_min )
	  n1 = j_code_n1_max ;
      }
      break ;
      /* θõ*/
    case ' ' :
      n2 += 17 ;
      if( n2 > j_code_n2_max ){
	n2 = ( n2 - j_code_n2_max ) + j_code_n2_min ;
	n1 ++ ;
	if( n1 > j_code_n1_max )
	  n1 = j_code_n1_min ;
      }
      break ;
      /* j_keyboard quit ξνġ*/
    case 0x07 :
      j_keyboard_quit( gw, node ) ;
      goto exit_menu_1 ;
      /* ̤ɽ롣*/
    case 0x0c :
      node->mtextbuffer[ 0 ] = '\0' ;
      j_input_by_code_or_menu_1_jmp_showCandidate
	( node, node->j_input_by_code_current_code ) ;
      /* ޤ褵Ȥޤ*/
      skkinput_RedrawScreen( gw ) ;
      goto exit_menu_1 ;
      /* ʳΥϥ顼ˤʤ롣*/
    default :
      err_msg( node, "`%s' is not valid here!",
	       charaToString( w->skkinput.keybuf[ 0 ] ) ) ;
      goto exit_menu_1 ;
    }
    node->j_input_by_code_current_code = ( n1 << 8 ) | ( n2 & 0x00FF ) ;
    j_input_by_code_or_menu_1_jmp_showCandidate
      ( node, node->j_input_by_code_current_code ) ;
  } else {
    node->mtextbuffer[ 4 * func_no + 3 ] = '\0' ;
    j_insert_str( node, node->j_input_by_code_or_menu_point,
		  node->mtextbuffer + 4 * func_no + 1 ) ;
    node->j_input_by_code_or_menu_mode = False ;
    node->mtextbuffer[ 0 ] = '\0' ;
  }
exit_menu_1:
  /* ʸΥХåեõ롣*/
  w->skkinput.keybuf_use  = 0 ;
  w->skkinput.keybuf[ 0 ] = '\0' ;
  return 0 ;
}

/*
 * 񤫤ñ()ؿľ꤯ưɤ档
 */
int j_purge_from_jisyo( Widget gw, struct SKKInputNode *node )
{
  if( node->j_henkan_on && node->j_henkan_key[ 0 ] != '\0' ){
    /* ߥ˥ХåեѤơʸϤ롣*/
    j_read_string( gw, node,
		   "Really purge? (yes or no) ",
		   J_PURGE_YES_OR_NO_P ) ;
    /* Ƶ Widget ǤäˤʤäΤǡϤȤʤġ*/
  }
  return 0 ;
}

/*
 * ޡ򥻥åȤؿ
 */
int j_set_mark_command( struct SKKInputNode *node )
{
  node->mark_pos = node->cur_pos ;
  err_msg( node, "Mark set" ) ;
  return 0 ;
}

/*
 * ꤵ줿ϰϤʸȴФcutbufferˤޤؿ
 * õ뤫ɤ flag ͤˤ롣
 */
static int j_kill_region_sub
( Widget gw, struct SKKInputNode *node, int flag  )
{
  int startpos, cutlen ;
#if 0
  int length ;
#endif
  SkkInputWidget w = ( SkkInputWidget )gw ;

  /* ޡåȤƤʤäܡ*/
  if( node->mark_pos < 0 ){
    err_msg( node, "The mark is not set now" ) ;
    return 1 ;
  }
#if 0
  /* ޡ֤ˤä硣*/
  length = strlen( node->textbuffer ) ;
  if( node->mark_pos > length ){
    node->mark_pos = length ;
  }
#endif
  if( node->mark_pos < node->cur_pos ){
    startpos = node->mark_pos ;
    cutlen   = node->cur_pos - node->mark_pos ;
  } else {
    startpos = node->cur_pos ;
    cutlen   = node->mark_pos - node->cur_pos ;
  }
  /* ڤФ̣ʤä顢¨ȴ롣*/
  if( cutlen <= 0 )
    return 1 ;
  /* Ȼꤵ줿̤ȴФ*/
  strncpy( w->skkinput.cutbuffer, node->textbuffer + startpos, cutlen ) ;
  w->skkinput.cutbuffer[ cutlen ] = '\0' ;

  if( flag )
    /* ʹߤʸõ롣*/
    j_delete_region( node, startpos, startpos + cutlen ) ;
  return 0 ;
}

static int j_kill_region( Widget gw, struct SKKInputNode *node )
{
  j_delete_kanaprefix( node ) ;
  return j_kill_region_sub( gw, node, True ) ;
}

static int j_kill_ring_save( Widget gw, struct SKKInputNode *node )
{
  j_delete_kanaprefix( node ) ;
  return j_kill_region_sub( gw, node, False ) ;
}

static int j_exchange_point_and_mark( struct SKKInputNode *node )
{
  int tmp, length ;
  j_delete_kanaprefix( node ) ;
  if( node->mark_pos < 0 ){
    err_msg( node, "No mark set in this buffer" ) ;
    return 1 ;
  }
  /* ޡ֤ˤä硣*/
  length = strlen( node->textbuffer ) ;
  if( node->mark_pos > length ){
    node->mark_pos = length ;
  }
  tmp = node->cur_pos ;
  node->cur_pos  = node->mark_pos ;
  node->mark_pos = tmp ;
  return 0 ;
}

/*
 * ͤڤФؿ
 */
static char *j_skip_numeric_character
( unsigned char *ptr, unsigned char **j_num_list_top )
{
  int kanji_flag = False ;
  unsigned char *j_num_list = *j_num_list_top ;

  /* ʸ󤬽üޤ³*/
  while( *ptr != '\0' ){
    if( *ptr & 0x80 ){
      /* ɤΣХܤν*/
      if( *ptr != 0xA3 && kanji_flag == False )
	break ;
      /* ɤΣХܤν*/
      if( ( *ptr < 0xB0 || *ptr > 0xB9 ) && kanji_flag == True ){
	ptr -- ;
	break ;
      }
      *j_num_list ++ = '0' + *ptr - 0xB0 ;
      /* ɤβХܤǤ뤫򥻥åȤƤ*/
      kanji_flag = ( kanji_flag )? False : True ;
    } else if( *ptr < '0' || *ptr > '9' ){
      break ;
    } else {
      /* 0  9 δ֤äġ*/
      *j_num_list ++ = *ptr ;
      kanji_flag = False ;
    }
    ptr ++ ;
  }
  /* ɤޤѤƤ*/
  *j_num_list_top = j_num_list ;
  return ptr ;
}

static unsigned char *j_identity
( unsigned char *sptr, unsigned char *dptr )
{
  while( *sptr != '\0' && *sptr != '/' ){
    *dptr ++ = *sptr ++ ;
  }
  *dptr   = '\0' ;
  return sptr ;
}

static unsigned char *j_zenkaku_num_str
( unsigned char *sptr, unsigned char *dptr )
{
  while( *sptr != '\0' && *sptr != '/' ){
    *dptr ++ = 0xA3 ;
    *dptr ++ = ( *sptr ++ ) + 0xB0 - '0' ;
  }
  *dptr   = '\0' ;
  return sptr ;
}

static unsigned char *kanji_num_list = "󻰻͸ϻȬ" ;

static unsigned char *j_kanji_num_str
( unsigned char *sptr, unsigned char *dptr )
{
  while( *sptr != '\0' && *sptr != '/' ){
    *dptr ++ = kanji_num_list[ ( ( *sptr ) - '0' ) * 2 + 0 ] ;
    *dptr ++ = kanji_num_list[ ( ( *sptr ) - '0' ) * 2 + 1 ] ;
    sptr ++ ;
  }
  *dptr   = '\0' ;
  return sptr ;
}

static unsigned char *j_kanji_num_str2
( unsigned char *sptr, unsigned char *dptr )
{
  int len = 0, silent, num ;
  static unsigned char *kazu_no_tanni[ 17 ] = {
    "", "", "", "", "Զ", "ٳ", "", "", "", "", 
    "", "", "Ϻ", "ε", "ͳ¾", "ԲĻ׵", "̵",
  } ;
  unsigned char *ptr ;

  /* ޤĹȽ̤롣*/
  while( sptr[ len ] != '\0' && sptr[ len ] != '/' )
    len ++ ;
  /* ƬɽʤΤ̵뤵ɡġ*/
  while( *sptr == '0' ){
    len -- ;
    sptr ++ ;
  }
  if( len == 0 ){
    *dptr ++ = kanji_num_list[ 0 ] ;
    *dptr ++ = kanji_num_list[ 1 ] ;
  } else {
    num = ( ( len - 1 ) / 4 ) - 1 ;
    /* 礭᤮Ǥ */
    if( num >= 17 ){
      /* ʤǤ̵ͤ뤹롣*/
      while( *sptr != '/' && *sptr != '\0' )
	sptr ++ ;
      goto exit_j_kanji_num_str2 ;
    }
    silent = True ;
    while( len > 0 ){
      if( *sptr > '1' || ( *sptr != '0' && ( len % 4 ) == 1 ) ){
	*dptr ++ = kanji_num_list[ ( ( *sptr ) - '0' ) * 2 + 0 ] ;
	*dptr ++ = kanji_num_list[ ( ( *sptr ) - '0' ) * 2 + 1 ] ;
      }
      if( *sptr != '0' ){
	/* ɴΰ̤˰ĤǤ⡻ǤʤΤСۤäƤ *
	 * ġǡۤäƤʤäƤΤϡȤȤɽ   *
	 * äựʤߤˡΰ̤λǤʤä顢Ȥ *
	 * ɽĤʤĤͤ*/
	if( len % 4 == 2 ){
	  *dptr ++ = 0xBD ;
	  *dptr ++ = 0xBD ;
	} else if( len % 4 == 3 ){
	  *dptr ++ = 0xC9 ;
	  *dptr ++ = 0xB4 ;
	} else if( len % 4 == 0 ){
	  *dptr ++ = 0xC0 ;
	  *dptr ++ = 0xE9 ;
	}
	silent = False ;
      }
      if( !silent || *sptr != '0' ){
	num = len - 1 ;
	if( num % 4 == 0 ){
	  num = num / 4 - 1 ;
	  /* ȤȤȤΤɽ롩 */
	  if( num >= 0 ){
	    /* ñ̤򥳥ԡ롣*/
	    ptr = kazu_no_tanni[ num ] ;
	    while( *ptr != '\0' )
	      *dptr ++ = *ptr ++ ;
	    /* ɽۤ뤳Ȥˤ롣*/
	    silent = True ;
	  }
	}
      }
      len -- ;
      sptr ++ ;
    }
  }
exit_j_kanji_num_str2:
  *dptr = '\0' ;
  return sptr ;
}

static unsigned char *j_shogi_num_str
( unsigned char *sptr, unsigned char *dptr )
{
  /* ʸܤϱѿʤɡġ*/
  if( *sptr != '/' && *sptr != '\0' ){
    *dptr ++ = 0xA3 ;
    *dptr ++ = 0xB0 + ( *sptr ) - '0' ;
    *dptr = '\0' ;
    sptr ++ ;
  } else {
    return sptr ;
  }
  /* ʸܤϴˤʤ롣*/
  if( *sptr != '/' && *sptr != '\0' ){
    *dptr ++ = kanji_num_list[ ( ( *sptr ) - '0' ) * 2 + 0 ] ;
    *dptr ++ = kanji_num_list[ ( ( *sptr ) - '0' ) * 2 + 1 ] ;
    *dptr = '\0' ;
    sptr ++ ;
  } else {
    return sptr ;
  }
  /* ڤʸޤʤ롣*/
  while( *sptr != '/' && *sptr != '\0' )
    sptr ++ ;
  return sptr ;
}

/*
 * # Ÿؿ
 */
static unsigned char *j_num_exp
( unsigned char *j_num_list_ptr, int type, unsigned char *dptr )
{
  switch( type ){
  case '0' :
    return j_identity( j_num_list_ptr, dptr ) ;
  case '1' :
    return j_zenkaku_num_str( j_num_list_ptr, dptr ) ;
  case '2' :
    return j_kanji_num_str( j_num_list_ptr, dptr ) ;
  case '3' :
    return j_kanji_num_str2( j_num_list_ptr, dptr ) ;
  case '9' :
    return j_shogi_num_str( j_num_list_ptr, dptr ) ;
  default:
    break ;
  }
  return j_num_list_ptr ;
}

static int j_numeric_convert
( struct SKKInputNode *node, unsigned char *sptr, unsigned char *dptr )
{
  unsigned char *nptr = node->j_num_list ;

  while( *sptr != '\0' ){
    if( *sptr == '#' ){
      sptr ++ ;
      /* # Ÿ롣*/
      nptr = j_num_exp( nptr, *sptr, dptr ) ;
      /* դ­줿ʸΰֺǸؤȰư롣*/
      while( *dptr != '\0' )
	dptr ++ ;
      /* ڤʸФ*/
      if( *nptr == '/' )
	nptr ++ ;
      sptr ++ ;
    } else {
      *dptr ++ = *sptr ++ ;
    }
  }
  *dptr = '\0' ;
  return 0 ;
}

/*
 * ѴʸѴפοڤФ "#" ֤
 * ؿ
 */
static int j_compute_numeric_henkan_key
( unsigned char *dptr, unsigned char *sptr, unsigned char *j_num_list ) 
{
  int kanji_flag = False ;
  while( *sptr != '\0' ){
    /* ɤβХܤȽǤ롣*/
    if( *sptr & 0x80 ){
      kanji_flag = ( kanji_flag )? False : True ;
    } else {
      kanji_flag = False ;
    }
    /* ɤʸʡ */
    if( *sptr >= '0' && *sptr <= '9' ){
      /* 饯 0  9 δ֤ä */
      *dptr ++ = '#' ;
      sptr = j_skip_numeric_character( sptr, &j_num_list ) ;
      /* ڤ국Ƥ*/
      *j_num_list ++ = '/' ;
      continue ;
    } else if( *sptr == 0xA3 && kanji_flag == True ){
      /* EUC ɤ    äġ*/
      sptr ++ ;
      if( *sptr >= 0xB0 && *sptr <= 0xB9 ){
	*dptr ++ = '#' ;
	*j_num_list ++ = *sptr + '0' - 0xB0 ;
	sptr ++ ;
	/* ³¤ꥹåפ롣*/
	sptr = j_skip_numeric_character( sptr, &j_num_list ) ;
	/* ڤ국Ƥ*/
	*j_num_list ++ = '/' ;
      } else {
	/* ʤäġ*/
	*dptr ++ = 0xA3 ;
	*dptr ++ = *sptr ;
      }
      continue ;
    }
    *dptr ++ = *sptr ++ ;
  }
  *dptr = '\0' ;
  *j_num_list = '\0' ;
  return 0 ;
}

/*
 * ֤ͤᤷʸؿ
 */
static int j_insert_word
( Widget gw, struct SKKInputNode *node, int pos, unsigned char *word )
{
  int len = strlen( word ) ;
  SkkInputWidget w = ( SkkInputWidget )gw ;

  /* ΥХåեϾ礭ܤˤȤäƤĥХǤʤ褦ˡ*/
  /* 㤨С"ɴ̵ɴԲĻ׵ɴ *
   * ͳ¾ɴεɴ󹱲Ϻɴ*
   * ɴɴɴɴ*
   * ɴɴ  ɴԶɴ*
   * ɴɴɴɴ*
   * "꤭ʤȤʤĤޤꡢ155 * 2 = 310 bytes */
  unsigned char buffer[ TEXTBUFSIZE * 5 ] ;

  if( node->j_num_list[ 0 ] != '\0' &&
      w->skkinput.use_numeric_conversion ){
    j_numeric_convert( node, word, buffer ) ;
    word = buffer ;
  }
  if( word[ 0 ] == '(' && word[ len - 1 ] == ')' ){
    /* 󡣲¹ԤäƤʤ櫓ʤɤ͡ĤʤΤǤޤͤ
     */
    if( !strncmp( word, "(concat ", 8 ) ){
      j_concat( node, word, buffer ) ;
      word = buffer ;
    }
  }
  j_insert_str( node, pos, word ) ;
  return 0 ;
}

/*
 * 椬 16ʿɽˤդ路ɤ֤ؿ
 */
static int chara_to_hex( int chara )
{
  if( chara >= '0' && chara <= '9' )
    return ( chara - '0' ) ;
  if( chara >= 'a' && chara <= 'f' )
    return ( chara - 'a' + 10 ) ;
  if( chara >= 'A' && chara <= 'F' )
    return ( chara - 'A' + 10 ) ;
  return ( -1 ) ;
}

/*
 * concat ν򤷤ƤȦĤδؿ
 */
static int j_concat
( struct SKKInputNode *node, unsigned char *sptr, unsigned char *dptr )
{
  int num1, num2 ;
  char *s_top = sptr, *d_top = dptr ;

  /* ʸγϰ֤롣*/
  while( *sptr != 0x22 && *sptr != '\0' )
    sptr ++ ;
  /* ʤ꽪ä顢ȴ롣*/
  if( *sptr == '\0' )
    goto err_jconcat ;
  sptr ++ ;
  /* ʸΥԡ򳫻Ϥ롣*/
  while( *sptr != '\0' && *sptr != 0x22 ){
    /* ü쵭Ǥ "\\" 褿ա */
    if( *sptr == '\\' ){
      sptr ++ ;
      /* ȥ륳ɤϤϤͤȤȤ˺ʤȥ *
       * 륳ɤľäƤޤȶ줷ȤˤʤäƤޤ*/
      if( *sptr == 'x' ){
	/* 16 ʿˤľϤߤġ*/
	sptr ++ ;
	/* ʤȤʸڤΤϥ顼*/
	if( *sptr == '\0' )
	  goto err_jconcat ;
	/*  16 ʿɽȤʸʤΡ */
	if( ( num1 = chara_to_hex( *sptr ) ) < 0 ){
	  /* ʤʸäΤǡľϤ롣*/
	  *dptr ++ = *sptr ++ ;
	  continue ;
	}
	sptr ++ ;
	/* ʤȤʸڤΤϥ顼Ĥ *
	 * Ĥ֥륯Ȥʤ顣*/
	if( *sptr == '\0' )
	  goto err_jconcat ;
	/*  16 ʿɽȤʸʤΡ */
	if( ( num2 = chara_to_hex( *sptr ) ) < 0 ){
	  /* ʤʸäΤǡľϤ롣*/
	  /* λʸϥȥ륳ɤʤΤǼΤƤ롣*/
	  *dptr ++ = *sptr ++ ;
	  continue ;
	}
	sptr ++ ;
	num1 = ( num1 << 4 ) | num2 ;
	/* ɥȥ륳ɤäΡ äȡ줫͡ľ *
	 * ϤǴäƤΤϤƤ͡*/
	if( num1 < 0x20 || num1 >= 0x7F )
	  continue ;
	/* ȥ륳ɤʤäߤʤΤǡġ*/
	*dptr ++ = num1 ;
	continue ;
      } else if( *sptr == '0' ){
	/* 8 ʿˤľϤߤġ*/
	sptr ++ ;
	/* ʤȤʸڤΤϥ顼*/
	if( *sptr == '\0' )
	  goto err_jconcat ;
	/*  8 ʿɽȤʸʤΡ */
	if( *sptr < '0' || *sptr > '7' ){
	  /* ʤʸäΤǡľϤ롣*/
	  *dptr ++ = *sptr ++ ;
	  continue ;
	} else {
	  num1 = *sptr - '0' ;
	}
	sptr ++ ;
	/* ʤȤʸڤΤϥ顼Ĥ *
	 * Ĥ֥륯Ȥʤ顣*/
	if( *sptr == '\0' )
	  goto err_jconcat ;
	/*  16 ʿɽȤʸʤΡ */
	if( *sptr < '0' || *sptr > '7' ){
	  /* ʤʸäΤǡľϤ롣*/
	  /* λʸϥȥ륳ɤʤΤǼΤƤ롣*/
	  *dptr ++ = *sptr ++ ;
	  continue ;
	} else {
	  num2 = *sptr - '0' ;
	}
	sptr ++ ;
	num1 = ( num1 << 3 ) | num2 ;
	/* ɥȥ륳ɤäΡ äȡ줫͡ľ *
	 * ϤǴäƤΤϤƤ͡*/
	if( num1 < 0x20 || num1 >= 0x7F )
	  continue ;
	/* ȥ륳ɤʤäߤʤΤǡġ*/
	*dptr ++ = num1 ;
	continue ;
      } else if( ( *sptr >= '1' && *sptr <= '9' ) ||
		 ( *sptr >= 'a' && *sptr <= 'f' ) ||
		 ( *sptr >= 'A' && *sptr <= 'F' ) ){
	/* ȥ륳ɤľȤƤΤ̵롣*/
	sptr ++ ;
	continue ;
      } else {
	/* ʳξˤ³ʸϤ롣*/
	if( *sptr == '\0' )
	  goto err_jconcat ;
	switch( *sptr ){
	case 't' :
	  *dptr ++ = 0x20 ;
	  sptr ++ ;
	  break ;
	case 'n' :
	case 'r' :
	  sptr ++ ;
	  break ;
	default :
	  *dptr ++ = *sptr ++ ;
	  break ;
	}
      }
    } else {
      *dptr ++ = *sptr ++ ;
    }
  }
  /* ֥륯Ȥ򤭤ȸФƽλɤȽǤ롣*/
  if( *sptr == '\0' )
    goto err_jconcat ;
  /* Ĥ̤θФʤ͡ġ*/
  *dptr = '\0' ;
  return True ;

err_jconcat:
  /* ǧ˼ԤޤΤǡĽλĺޤ*/
  strcpy( d_top, s_top ) ;
  return False ;
}

#if 0
/*
 * 1970 ǯηв֤ñ̤Ϥ롣
 */
static struct my_tm my_localtime( unsigned long long int sec )
{
  struct my_tm tmp ;
  /* ǯ 4 ǳڤǯ100 ǳڤ줿ˤϡǯ *
   * ʤǤ⡢400 ǳڤˤϡޤǯ*/
  unsigned long long int day ;
  int year, month ;
  int month_days[] = {
    31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31,
  } ;

  /* 줬в*/
  day = sec / ( 24 * 60 * 60 ) ;
  /* 롣*/
  tmp.week = ( day % 7 + 4 ) % 7 ;
  /* ǯ롣*/
  for( year = 1970 ; day > 0 ; year ++ ){
    if( is_uruudoshi( year ) ){
      if( day < 366 )
	break ;
      day -= 366 ;
    } else {
      if( day < 365 )
	break ;
      day -= 365 ;
    }
  }
  tmp.year  = year ;
  /* 롣*/
  if( is_uruudoshi( year ) )
    month_days[ 1 ] = 29 ;
  for( month = 0 ; day >= month_days[ month ] ; month ++ ){
    day -= month_days[ month ] ;
  }
  tmp.day   = ( int )day ;
  tmp.month = month ;
  return tmp ;
}
#endif

#define is_alphabetic(c)	\
( ( ( (c) >= 'a' && (c) <= 'z' ) || ( (c) >= 'A' && (c) <= 'Z' ) || \
  ( (c) >= '0' && (c) <= '9' ) )? 1 : 0 )

/*
 * Ϳ줿ɸʹ˰ñưȲޤǹԤΤ׻
 * ؿ
 * ֤ͤɤƤʴؿɬפʤΡ ꤵ
 * ֤ upcase-word  downcase-word, capitalize-word ˤ
 *   
 * ֤ա󡣤ʤܥʬä衪
 */
static int j_calc_forward_word( struct SKKInputNode *node, int pos )
{
  /* ư롣*/
  if( !is_alphabetic( node->textbuffer[ pos ] ) ) {
    /* ե٥åȤʤ֤Ϥ󤺤ʤࡣ*/
    while( node->textbuffer[ pos ] != '\0' &&
	   !is_alphabetic( node->textbuffer[ pos ] ) ){
      pos = calc_forward_char( node, pos, 1 ) ;
    }
  }
  /* ⤦ʾ奫ϰưǤʤΤǽλ롣*/
  if( node->textbuffer[ pos ] == '\0' )
    return pos ;
  /* ե٥åȤδ֤Ϥ󤺤ʤࡣ*/
  while( node->textbuffer[ pos ] != '\0' &&
	 is_alphabetic( node->textbuffer[ pos ] ) ){
    pos = calc_forward_char( node, pos, 1 ) ;
  }
  return pos ;
}

/*
 * ñưؿ
 */
static int j_forward_word( struct SKKInputNode *node )
{
  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;
  /* ư롣*/
  node->cur_pos = j_calc_forward_word( node, node->cur_pos ) ;
  return 0 ;
}

/*
 * 
 */
static int j_caseword( struct SKKInputNode *node, int pattern )
{
  int pos ;
  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;

  /* ߤΥ֤ФƤ*/
  pos = node->cur_pos ;
  /* ޤǥϰưΤʡ */
  node->cur_pos = j_calc_forward_word( node, pos ) ;

  /* 뤬ưǤʤäȤȤϡϹ顢*
   * ʸѴʤȤʤʸˤʤȤȤˤʤ*/
  if( pos < node->cur_pos ){ 
    if( pattern == 'c' ){
      /* capitilaize ξ硣*/
      while( pos < node->cur_pos ){
	/* ֺǽ˸դäե٥åȤʸѴơ *
	 * ʹߤϾʸѴ롣*/
	if( ( node->textbuffer[ pos ] >= 'a' &&
	      node->textbuffer[ pos ] <= 'z' ) ){
	  node->textbuffer[ pos ] += ( 'A' - 'a' ) ;
	  pos ++ ;
	  break ;
	}
	/* ֺǽ˸դäե٥åȤʸʤѴ */
	if( ( node->textbuffer[ pos ] >= 'A' &&
	      node->textbuffer[ pos] <= 'Z' ) ){
	  pos ++ ;
	  break ;
	}
	pos ++ ;
      }
      /*  downcase ξƱˤʤ롣*/
      pattern = 'd' ;
    }
    while( pos < node->cur_pos ){ 
      /* ʸѴ롣*/
      if( node->textbuffer[ pos ] >= 'a' &&
	  node->textbuffer[ pos ] <= 'z' &&
	  pattern == 'u' ){
	node->textbuffer[ pos ] += ( 'A' - 'a' ) ;
      } else if( node->textbuffer[ pos ] >= 'A' &&
		 node->textbuffer[ pos ] <= 'Z' &&
		 pattern == 'd' ){
	node->textbuffer[ pos ] += ( 'a' - 'A' ) ;
      }
      pos ++ ;
    }
  }
  return 0 ;
}

/*
 * ñưؿ
 */
static int j_backward_word( struct SKKInputNode *node )
{
  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;
  /* ư롣*/
  if( !is_alphabetic( node->textbuffer[ node->cur_pos ] ) ) {
    /* ե٥åȤʤ֤Ϥ󤺤ʤࡣ*/
    while( node->cur_pos > node->cur_pos_top &&
	   !is_alphabetic( node->textbuffer[ node->cur_pos ] ) ){
      /* ʸ˰ư롣*/
      node->cur_pos -- ;
      if( ( node->textbuffer[ node->cur_pos ] & 0x80 ) && 
	  node->cur_pos > node->cur_pos_top )
	node->cur_pos -- ;
    }
  }
  /* ⤦ʾ奫ϰưǤʤΤǽλ롣*/
  if( node->cur_pos == node->cur_pos_top )
    return 0 ;
  /* ե٥åȤδ֤Ϥ󤺤ʤࡣ*/
  while( node->cur_pos > node->cur_pos_top &&
	 is_alphabetic( node->textbuffer[ node->cur_pos ] ) ){
    /* ʸ˰ư롣*/
    node->cur_pos -- ;
    if( ( node->textbuffer[ node->cur_pos ] & 0x80 ) && 
	node->cur_pos > node->cur_pos_top )
      node->cur_pos -- ;
  }
  return 0 ;
}

/*
 * Τޤ޼ϿƤޤȤޤãѴؿ
 *----
 * Υ֤ɡ
 */
static int j_quote_char_sub( unsigned char *word )
{
  unsigned char *dptr, *sptr ;
  int len, kanji_flag ;
  /* Τޤ¸ߤޤã󤷤Ƥ롣*/
  struct chara_string_pair conv_pattern[] = {
    { '\r', "\\r"   }, { '\n', "\\n"   }, { '/',  "\\057" },
    { '\\', "\\\\"  }, { '[',  "\["    }, { '\"', "\\\""  },
    { '\0', NULL    },
  } ;
  struct chara_string_pair *cptr ;
  /* ޤϤޤʤѰդ롣*/
  strcpy( temporary_buffer, "(concat \"" ) ;
  len  = strlen( temporary_buffer ) ;
  dptr = temporary_buffer + len ;
  sptr = word ;
  /* Ѵ롼ס*/
  kanji_flag = False ;
  while( *sptr != '\0' && len < ( TEXTMAXLEN - 2 ) ){
    /* ɤɤȽꤹĤϸ˽뤱ɤ͡*/
    if( is_euc_kanji( *sptr ) ){
      if( kanji_flag ){
	*dptr ++ = *sptr ++ ;
	len ++ ;
	kanji_flag = False ;
      } else {
	/* ;͵ĤäƤʤν*/
	if( len + j_kanji_length >= ( TEXTMAXLEN - 2 ) ){
	  break ;
	}
	*dptr ++ = *sptr ++ ;
	len ++ ;
	kanji_flag = True ;
      }
    } else {
      /* ʤä硢Ĥޤꥳȥ륳ɤȤä *
       * Ȥǽ櫓*/
      cptr = conv_pattern ;
      while( cptr->chara != '\0' ){
	if( *sptr == cptr->chara ){
	  int tmplen = strlen( cptr->string ) ;
	  if( ( len + tmplen ) >= ( TEXTMAXLEN - 2 ) )
	    goto exit_j_quote_sub ;
	  strcpy( dptr, cptr->string ) ;
	  dptr += tmplen ;
	  len  += tmplen ;
	  sptr ++ ;
	  break ;
	}
	cptr ++ ;
      }
      /* ȡˤҥåȤʤäĤޤ꽤פä硣*/
      if( cptr->chara == '\0' ){
	*dptr ++ = *sptr ++ ;
	len ++ ;
      }
    }
  }
 exit_j_quote_sub:
  /* ǸĤƤνʸ뤿 -2 ʤƤΤ *
   * Ƥ櫓*/
  *dptr ++ = '\"' ;
  *dptr ++ = ')' ;
  *dptr ++ = '\0' ;
  /* Ǹ˽ʸ֤*/
  strcpy( word, temporary_buffer ) ;
  return True ;
}

/*
 * Τޤ޼ϿƤޤȤޤãѴؿ
 *----
 * () temporary_buffer Ѥ롣
 */
static int j_quote_char( unsigned char *word )
{
  unsigned char *ptr ;
  int len ;
  /* ȡlisp ̿äˤϽʤǤ⡢skkinput  *
   * Ǥ lisp ̿äƾʤġ*/
  len = strlen( word ) ;
  if( len > 2 && word[ 0 ] == '(' && word[ 1 ] < 128 &&
     word[ len - 1 ] == ')' ){
    return False ;
  }
  /* ˽ʤȤʤʸäƤ뤫ɤå롣*/
  for( ptr = word ; *ptr != '\0' ; ptr ++ ){
    switch( *ptr ){
    case '/' :
    case '\n' :
    case '\r' :
    case '\\' :
    case '[' :
    case ']' :
      return j_quote_char_sub( word ) ;
    default :
      break ;
    }
  }
  return False ;
}

static int save_ringbuffer
( unsigned char *buffer, int bufsize, int *startpos, int *endpos,
  unsigned char *string )
{
  int spos ;
  unsigned char *ptr ;

  /* ʸäꡢƬԥɤäꤷˤϿʤ*/
  if( string[ 0 ] == '\n' || string[ 0 ] == '\r' ||
      string[ 0 ] == '\0' )
    return 0 ;
  /*  ring buffer ؤ save */
  ptr  = buffer + *endpos ;
  spos = *endpos ;
  do {
    /* ʸ ring buffer ؤȤ롣*/
    *ptr ++ = *string ++ ;
    spos ++ ;
    /* ХåեκǸޤãƤޤäƬ᤹*/
    if( spos >= bufsize ){
      spos = 0 ;
      ptr  = buffer ;
    }
  } while( *string != '\0' ) ;

  *ptr ++ = '\0' ;
  spos ++ ;
  if( spos >= bufsize ){
    spos = 0 ;
    ptr  = buffer ;
  }

  /* Ͽä񤭤Ƥޤä */
  /* ΥåǺѤΤϡring buffer μ¤Ͽʸ */
  /* 礭Ȥˤʤ롣ξƤ롣*/
  if( ( ( *startpos < *endpos ) && ( spos < *endpos ) ) ||
      ( ( *startpos > *endpos ) && ( spos > *startpos ) ) ){
    /* 괺ߤΰ֤ϼθ䤬Ͽˤʤ롣*/
    *endpos = spos ;
    /* θγϰ֤ޤǥåפ롣*/
    do {
      ptr ++ ;
      spos ++ ;
      /* ХåեκǸޤãƤޤäƬ᤹*/
      if( spos >= bufsize ){
	spos = 0 ;
	ptr  = buffer ;
      }
    } while( *ptr != '\0' ) ;
    /* '\0' μ餬*/
    *startpos = ( spos + 1 ) % bufsize ;
  } else {
    *endpos = spos ;
  }
  return 0 ;
}
