/* # skkinput (Simple Kana-Kanji Input)
 * skkmarker.c --- simulate marker.
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * ΥϡSkkInput.c ΰǤꡢSkkInputWidget ΰǤ
 * äơȤδؿϳϷ褷ƸƤӤʤ褦 static
 */
#if 0
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#endif

#include "skkmain.h"

/*
 * ޡνԤؿ
 */
static void markers_init( struct SKKInputNode *node )
{
  int i ;
  for( i = 0 ; i < MAXMARKERNUM ; i ++ ){
    node->markers[ i ].pos = NULL ;
    node->markers[ i ].cf  = False ;
  }
  node->marker_usage = 0 ;
  return ;
}

/*
 * ޡϿؿ
 */
static int make_marker( struct SKKInputNode *node, int *marker, int flag )
{
  int i ;
  /* ߤޤǤλѤƤΤǶƤܤ*/
  for( i = 0 ; i < node->marker_usage ; i ++ ){
    if( ( node->markers[ i ] ).pos == NULL ){
      /* ޡϿ*/
      ( node->markers[ i ] ).pos = marker ;
      ( node->markers[ i ] ).cf  = flag ;
      return 0 ;
    }
  }
  node->marker_usage ++ ;
  /* ޡХåեȤڤäƤޤäƤ硣*/
  if( node->marker_usage >= MAXMARKERNUM )
    return 1 ;
  /* ޡϿ*/
  ( node->markers[ i ] ).pos = marker ;
  ( node->markers[ i ] ).cf  = flag ;
  return 0 ;
}

/*
 * ޡõؿ
 */
static int delete_marker( struct SKKInputNode *node, int *marker )
{
  int i ;
  /* ߤޤǤλѤƤΤ椫顣*/
  for( i = 0 ; i < node->marker_usage ; i ++ ){
    /* õ٤ޡ */
    if( ( node->markers[ i ] ).pos == marker ){
      /* ޡá*/
      ( node->markers[ i ] ).pos = NULL ;
      return 0 ;
    }
  }
  /* ʥޡϿƤʤ*/
  return 1 ;
}

/*
 * ޡưؿ
 *----
 * ƥʸ뤳Ȥˤäơޡΰư
 * Ѥ롣copy_region ʤɤǤ餦
 *----
 * startpoint 걦ˤޡƱƶ롣
 */
static int move_marker_ByInsert
( struct SKKInputNode *node, int startpoint, int effect )
{
  int i ;
  struct Marker *mks = node->markers ;

  /* ߤޤǤλѤƤΤ椫顣*/
  for( i = 0 ; i < node->marker_usage ; i ++ ){
    /* ƶޡ */
    if( *( mks[ i ].pos ) > ( startpoint - mks[ i ].cf ) ){
      /* ޡư롣*/
      *( mks[ i ].pos ) += effect ;
      /* ޡƥȤӽФƤޤ硣*/
      if( *( mks[ i ].pos ) >= TEXTMAXLEN )
	*( mks[ i ].pos ) = TEXTMAXLEN ;
    }
  }
  return 0 ;
}

/*
 * ޡưؿ
 *----
 * ƥ⤫ʸȴФȤˤäޡΰư
 * Ѥ롣delete_region ʤɤǤ餦
 *----
 * startpoint 걦ˤޡƱƶ롣
 */
static int move_marker_ByDeleteRegion
( struct SKKInputNode *node, int startpoint, int endpoint )
{
  int i ;
  int diff = endpoint - startpoint ;
  struct Marker *markers = node->markers ;

  /* ߤޤǤλѤƤΤ椫顣*/
  for( i = 0 ; i < node->marker_usage ; i ++ ){
    /* ƶޡ */
    if( *( markers[ i ].pos ) <= startpoint )
      continue ;
    if( *( markers[ i ].pos ) >= endpoint ){
      /* ޡư롣*/
      *( markers[ i ].pos ) -= diff ;
    } else {
      /* ޡư롣*/
      *( markers[ i ].pos ) = startpoint ;
    }
  }
  return 0 ;
}

/*
 * ޡưؿ
 *----
 * ƥȤθʸڤƤޤäˡؤޡ
 * ƤȤޤΤǡưΤ˻Ȥؿ
 *----
 * startpos 걦ˤޡƱƶ롣
 */
static int set_marker_ByGeqPosition
( struct SKKInputNode *node, int startpos, int setpos )
{
  int i ;
  struct Marker *markers = node->markers ;

  /* ߤޤǤλѤƤΤ椫顣*/
  for( i = 0 ; i < node->marker_usage ; i ++ ){
    /* ƶޡ */
    if( *( markers[ i ].pos ) <= startpos )
      continue ;
    /* ޡư롣*/
    *( markers[ i ].pos ) = setpos ;
  }
  return 0 ;
}
