/***************************************************************************
                          smb4koptionsdlg.h  -  description
                             -------------------
    begin                : Sam Feb 22 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KOPTIONSDLG_H
#define SMB4KOPTIONSDLG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kdialogbase.h>
#include <kurlrequester.h>
#include <kconfig.h>

// application specific includes
#include "smb4kshareoptions.h"
#include "smb4knetworkoptions.h"
#include "smb4kauthoptions.h"
#include "smb4kappearanceoptions.h"
#include "smb4ksambaoptions.h"
#include "smb4ksuperuseroptions.h"


class Smb4KOptionsDlg : public KDialogBase
{
  Q_OBJECT

  friend class Smb4KApp;
  
  public:
    /**
     * The constructor
     */
    Smb4KOptionsDlg( QWidget *parent = 0, const char *name = 0, bool modal = false );
    /**
     * The destructor
     */
    ~Smb4KOptionsDlg();
    
  signals:
    /**
     * This signal informs the rest of the program, that the options have been
     * saved and should be reread. It is emitted by the Smb4KOptionsDlg::slotOk()
     * and Smb4KOptionsDlg::slotApply().
     */
    void read();

  protected:
    /**
     * Saves the options.
     */
    bool saveOptions();
    /**
     * Reads the options.
     */
    void readOptions();

  protected slots:
    /**
     * Is called when the OK button has been pressed.
     */
    void slotOk();
    /**
     * Is called when the Apply button has been pressed.
     */
    void slotApply();
    /**
     * This slot is called, if something went wrong with the super
     * stuff and the checkboxes have to be unchecked.
     */
    void slotNoSUIDProgram();
    /**
     * This slot is called when the SUID entries were written to the files.
     */
    void slotFinishedSUIDWriting();
    //
    // Slots for the widget classes
    //
    /**
     * Enables/disables widgets in the Samba according to the choice
     * of the filesystem (SMBFS/CIFS).
     *
     * This slot is connected to the button that represents the SMB
     * file system.
     *
     * @param on  Describes the toggle state of the SMBFS button.
     */
    void slotSambaFileSystem( bool on );
    /**
     * Enables/disables buttons on the appearance page according to the
     * toggle state of the "Show hidden shares." button.
     *
     * @param state  Describes the toggle state of the "Show hidden shares."  checkbox.
     */
    void slotShowHiddenShares( int state );
    /**
     * Enables/disables buttons on the network option page according to the
     * toggle state of the browse list retrieval method.
     *
     * @param state Describes the toggle state of the browse list radio buttons.
     */
    void slotBrowseListMethod( int state );
    /**
     * Removes the super user entries from either the super.tab or sudoers file
     * according to the choice the user made.
     */
    void slotRemoveSuperUserEntries();

  private:
    /**
     * The KConfig object.
     */
    KConfig *m_config;
    /**
     * Set up the browse options page.
     */
    void setupNetworkOptions();
    /**
     * The browse option page object
     */
    Smb4KNetworkOptions *m_networkPage;

    /**
     * Set up the mount options page.
     */
    void setupShareOptions();
    /**
     * The mount options page object
     */
    Smb4KShareOptions *m_sharePage;

    /**
     * Set up the authentication page.
     */
    void setupAuthOptions();
    /**
     * The authentication page object
     */
    Smb4KAuthOptions *m_authPage;

    /**
     * Set up the appearance page.
     */
    void setupAppearanceOptions();
    /**
     * The appearance page object
     */
    Smb4KAppearanceOptions *m_appearancePage;

    /**
     * Sets up the Samba options page.
     */
    void setupSambaOptions();
    /**
     * The Samba page object
     */
    Smb4KSambaOptions *m_sambaPage;
    
    /**
     * Sets up the misc options page.
     */
    void setupSuperUserOptions();
    /**
     * The misc options page object
     */
    Smb4KSuperUserOptions *m_superPage;
    
    /**
     * This function checks whether all necessary specifications
     * have been provided before applying any changes.
     */
    bool check();
    /**
     * Tells which button has been clicked.
     */
    QString m_button;
    /**
     * The enumeration for the pages.
     */
    enum Pages{ Appearance = 0, Network = 1, Shares = 2, Authentication = 3, Samba = 4, Misc = 5 };
};

#endif
