/***************************************************************************
    smb4kinfotab.h  -  description
                             -------------------
    begin                : Mit Mr 12 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KSHARETAB_H
#define SMB4KSHARETAB_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qwidget.h>

// KDE includes
#include <kprogress.h>
#include <ksqueezedtextlabel.h>

// application specific includes
#include "smb4ksharewidget.h"
#include "../core/smb4kshare.h"

/** This is a widget class. It displays info about a mounted share. */

class Smb4KShareTab : public QWidget
{
  Q_OBJECT
  
  public:
    /** 
     * The constructor.
     */
    Smb4KShareTab( QWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KShareTab();
    /** 
     * Clears the display. 
     */
    void clear();

  protected slots:
    /** 
     * This slot takes the usage info provided by Smb4KCore.
     *
     * @param mountpoint    The objects that represents the share for which the usage should be determined.
     *
     * @param total         The total space that's available on the share.
     *
     * @param used          The space that's used.
     *
     * @param free          The free space.
     *
     * @param percent       The used space in percent.
     *
     * @param dirs          The number of directories present in the root of this share.
     *
     * @param files         The number of files present in the root of this share.
     */
    void slotUsage( const QString &mountpoint, double total, double used, double free, double percent, int dirs, int files );    
    

  private:
    /** 
     * Holds the list view item, that was passed by the mounter
     * widget. 
     */
    QLabel *m_shareLabel;
    KSqueezedTextLabel *m_share;
    QLabel *m_mountpointLabel;
    KSqueezedTextLabel *m_mountpoint;
    QLabel *m_freeLabel;
    KSqueezedTextLabel *m_free;
    QLabel *m_usedLabel;
    KSqueezedTextLabel *m_used;
    QLabel *m_totalLabel;
    KSqueezedTextLabel *m_total;
    QLabel *m_usageLabel;
    QLabel *m_contentsLabel;
    KSqueezedTextLabel *m_contents;
    QLabel *m_userLabel;
    KSqueezedTextLabel *m_user;
    QLabel *m_groupLabel;
    KSqueezedTextLabel *m_group;
    KProgress *m_usage;
};

#endif
