/*
 * dvpump.h -- DV Pump and Sundry Common Implementations
 * Copyright (C) 2002 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _KINO_DV_PUMP_PROVIDER_
#define _KINO_DV_PUMP_PROVIDER_

#include <string>
using std::string;

#include "DVPump.h"
#include "Threader.h"
#include "Diagnostics.h"

class Frame;

/** Most uses of the DVPump are encapsulated by this threaded implementation.
*/

class DVPumpProvider : public DVPump, public Threader
{
	public:
		DVPumpProvider( );		
		virtual string LogId( ) { return "Unknown DVPumpProvider"; }
		void SetBlockable( bool );
		virtual bool IsBlockable( );
		virtual double GetSpeed( );
		virtual bool Seek( int position, double speed = 1 );
	protected:
		virtual bool ReadFrame( Frame &frame ) = 0;
		void Thread( );	
	private:
		bool blockable;
};

#endif

