%define name      snmpkit
%define version   0.9
%define rel       1
%define prefix    /usr

Name: %{name}
Version: %{version}
Release: %{rel}
Summary: Library for doing bulk SNMP queries.
License: GPL
Group: System Environment/Libraries
BuildRoot: /tmp/%{name}-root

Source0: %{name}-%{version}.tar.gz

%package devel
Summary: Headers and additional files to develop programs using snmpkit.
Group: Development/Libraries
Requires: %{name}

%description 
SNMPkit is fundementally a toolkit for doing SNMP queries. There are
three things that differentiate it from other SNMP libraries. First it
is designed to facilitate doing queries across large numbers of hosts
in a time efficient manner. It will quite happily query literally
hundreds of hosts simultaneously. Secondly, it doesn't bother trying
to parse mibs. It assumes that you know the OIDs which you are
interested in. Finally, it is optimied for filling C data structures
with the values you get from SNMP queries. This capability is extended
to make fetching tables very simple.

%description devel
This package contains the header files needed to develop programs
using SNMPKit.

%prep
%setup

%build
./configure --prefix=%{_prefix} \
            --exec-prefix=%{_exec_prefix} \
            --bindir=%{_bindir} \
            --sbindir=%{_sbindir} \
            --sysconfdir=%{_sysconfdir} \
            --datadir=%{_datadir} \
            --includedir=%{_includedir} \
            --libdir=%{_libdir} \
            --libexecdir=%{_libexecdir} \
            --localstatedir=%{_localstatedir} \
            --sharedstatedir=%{_sharedstatedir} \
            --mandir=%{_mandir} \
            --infodir=%{_infodir}
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr
make DESTDIR="$RPM_BUILD_ROOT" install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%{_libdir}/*.so.*

%files devel
%defattr(-, root, root)
%{_libdir}/lib*.so
%{_libdir}/*.a
%{_libdir}/*.la
%{_includedir}/snmpkit.h
%{_includedir}/snmpkit
%{_includedir}/snmpkit_except
%{_includedir}/snmpkit_tags
%{_infodir}/snmpkit.info*
%{_mandir}/man3/SNMP_table.3*
%{_mandir}/man3/sk_new_session.3*
%{_mandir}/man3/snmpstructfiller.3*
%{_mandir}/man3/SNMP_structFiller.3*
%{_mandir}/man3/libsnmpkit.3*
%{_mandir}/man3/snmpsession.3*
%{_mandir}/man3/snmpstructfiller_append.3*
