/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifndef AUDIO_H
#define AUDIO_H

#ifdef ENABLE_AO
#define USE_AUDIO	1
#define USE_ESD		2
#define USE_ARTS	3
#define USE_SUN		4
#define USE_OSS		5
#define USE_ALSA09	6
#define USE_ALSA	7
#define USE_STDOUT	8
#define USE_NULL	9

#define USE_AO		10	/* Generic AO */
#define USE_AO_FILE	11	/* File AO */
#endif

#ifdef ENABLE_SNDFILE
#define USE_WAV		12
#define USE_AIFF	13
#define USE_AU		14
#define USE_RAW		15
#define USE_PAF		16
#define USE_SVX		17
#define USE_NIST	18
#define USE_VOC		19
#define USE_IRCAM	20
#define USE_W64		21
#define USE_MAT4	22
#define USE_MAT5	23
#define USE_PVF		24
#define USE_XI		25
#define USE_HTK		26

#ifdef ENABLE_SNDFILE_MIDI
#define USE_MIDI	27
#endif

#ifdef ENABLE_SNDFILE_AVR
#define USE_AVR		28
#endif

#ifdef ENABLE_SNDFILE_WAVEX
#define USE_WAVEX	29
#endif

#endif

#ifdef ENABLE_STREAMING

#ifdef ENABLE_ICECAST
#define USE_ICECAST	30
#endif

#ifdef ENABLE_ICECAST2
#define USE_ICECAST2	31
#endif

#ifdef ENABLE_SHOUTCAST
#define USE_SHOUTCAST	32
#endif

#endif

#ifdef ENABLE_LAME
#define USE_LAME	33
#endif

#ifdef ENABLE_OGG
#define USE_OGG		34
#endif

#ifdef ENABLE_DAEMON
#define USE_DAEMON	35
#endif

#define USE_MONITOR	36

void audio_init (void);
int audio_type_select (char *);
char *audio_parse_str (char *, int *, int);
int audio_parse_int (char *, int *, int);
void audio_write (int, void *, size_t);

#endif

/* EOF */
