#! /usr/bin/env python

# Songwrite
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software. See README or LICENSE for the license terms.

import os, os.path, sys, glob, distutils.core

if "--no-lang" in sys.argv:
  sys.argv.remove("--no-lang")
  no_lang = 1
else: no_lang = 0

if "sdist" in sys.argv:
  # Compile the doc to html if needed
  import os, os.path
  
  for lang in os.listdir("./doc"):
    if lang == "CVS": continue
    html_file = "./doc/%s/doc.html" % lang
    lyx_file  = "./doc/%s/doc.lyx"  % lang
    if (not os.path.exists(html_file)) or (os.path.getmtime(lyx_file) > os.path.getmtime(html_file)):
      print "Compiling %s doc to html..." % lyx_file
      os.system("./tohtml %s" % lyx_file)
      
data_files = [
  (os.path.join("songwrite", "data"),
  glob.glob(os.path.join(".", "data", "*"))),
  ]
if not no_lang:
  data_files = data_files + [
    (os.path.join(os.path.dirname(mo_file)), [mo_file])
    for mo_file
    in  glob.glob(os.path.join(".", "locale", "*", "LC_MESSAGES", "*"))
    ]

for doc_lang in glob.glob(os.path.join(".", "doc", "*")):
  data_files.append(
    (os.path.join("songwrite", doc_lang),
     glob.glob(os.path.join(".", doc_lang, "*"))),
    )

distutils.core.setup(name         = "Songwrite",
                     version      = "0.12",
                     license      = "GPL",
                     description  = "Tablature editor in Python with Tk, Timidity and Lilypond",
                     author       = "Lamy Jean-Baptiste",
                     author_email = "jiba@tuxfamily.org",
                     url          = "http://oomadness.tuxfamily.org/en/songwrite",
                     
                     package_dir  = {"songwrite" : ""},
                     packages     = ["songwrite"],
                     
                     scripts      = ["songwrite"],
                     
                     data_files   = data_files,
                     )
