#!/usr/local/bin/perl
#
# This object represents a configuration file for a host. This object will
# contain status information about the configuration file and the contents
# of the file it self.
#
#   host          - string FQDN of the machine its associated with
#   name          - string name of the configuration file
#   timestamp       - modification time of the config file (time() format)
#   size          - file size in bytes of the config file
#   lines         - line count of the config confile
#   contents      - the contents of the config file
#
# + new()         - constructor (sets instance vars to arguments passed in)
# + gets/sets()   - magical set/get functions (autoloaded based on func name)
#

use FileHandle;

package Spong::ConfigFile;

# Constructor. 

sub new {
   my( $proto, $host, $name ) = @_;
   my( $class ) = ref($proto) || $proto;
   my $self = {};

   # If file doesn't exist, return undef
   if ( ! -f "$main::SPONGDB/$host/config/$name") {
      return undef;
   }

   $self->{'name'}    = $name;
   $self->{'host'}    = $host;

   my($size, $mtime) = (stat("$main::SPONGDB/$host/config/$name"))[7,9];

   $self->{'size'} = $size;
   $self->{'timestamp'} = $mtime;

   my(@contents);
   $fh = new FileHandle("< $main::SPONGDB/$host/config/$name");
   while (<$fh>) { $contents[$#contents+1] = $_; }
   $self->{'contents'} = \@contents;
   $self->{'lines'} = $#contents+2;

   bless ($self,$class);
   return $self;
}


# Get/Set methods, nothing fancy here...

sub host { return $_[0]->{'host'}; }

sub name{ return $_[0]->{'name'}; }

sub timestamp { return $_[0]->{'timestamp'}; }

sub size { return $_[0]->{'size'}; }

sub lines { return $_[0]->{'lines'}; }

sub contents { return $_[0]->{'contents'}; }

1;
