<?PHP

/* options page for IMAP info plugin 
 * Copyright (c) 1999-2005 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *   
 * This is where it all happens :)
 *
 * Written by: Jason Munro 
 * jason@stdbev.com
 * 
 * $Id: options.php,v 1.6.2.4 2004/12/27 15:03:58 kink Exp $
 * 
 */

define('SM_PATH','../../');

/* SquirrelMail required files. */
require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/page_header.php');
require_once(SM_PATH . 'functions/imap.php');
require_once(SM_PATH . 'functions/forms.php');
require_once(SM_PATH . 'plugins/info/functions.php');

global $username, $color, $folder_prefix, $default_charset;
$default_charset = strtoupper($default_charset);
displayPageHeader($color, 'None');
$mailbox = 'INBOX';

/**
 * testing installation
 *
 * prevent use of plugin if it is not enabled
 */
if (! is_plugin_enabled('info')) {
    echo '<p align="center"><big>'.
        _("Plugin is disabled.").
        '</big></p></body></html>';
    exit;
}

/* GLOBALS */
sqgetGlobalVar('username', $username, SQ_SESSION);     
sqgetGlobalVar('key', $key, SQ_COOKIE);     
sqgetGlobalVar('onetimepad', $onetimepad, SQ_SESSION);  

sqgetGlobalVar('submit', $submit, SQ_POST);

for($i = 0; $i <= 9; $i++){
    $varc = 'CHECK_TEST_'.$i;
    sqgetGlobalVar($varc, $$varc, SQ_POST);
    $vart  = 'TEST_'.$i;
    sqgetGlobalVar($vart, $$vart, SQ_POST);
}

/* END GLOBALS */

$imap_stream = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
$caps_array = get_caps($imap_stream);
$list = array (
               'TEST_0',
               'TEST_1',
               'TEST_2',
               'TEST_3',
               'TEST_4',
               'TEST_5',
               'TEST_6',
               'TEST_7',
               'TEST_8',
               'TEST_9');

print "<BR><CENTER><B>IMAP server information</B></CENTER><BR>\n";
print "<CENTER><TABLE BGCOLOR=".$color[3]." WIDTH=\"100%\" BORDER=1 CELLPADDING=2><TR><TD BGCOLOR=".$color[3]."><BR>\n";
print "<CENTER><TABLE WIDTH=\"95%\" BORDER=1 BGCOLOR=".$color[3].">\n";
print "<TR><TD BGCOLOR=".$color[4]."><B>Server Capability response:</B><BR>\n";

foreach($caps_array[0] as $value) {
    print htmlspecialchars($value);
}

print "</TD></TR><TR><TD>\n";

if (!isset($submit) || $submit == 'default') {
    print "<br><small><font color=".$color[6].">Select the IMAP commands you would like to run.
        Most commands require a selected mailbox so the SELECT-command is already setup.
        You can clear all the commands and test your own IMAP command strings. The
        commands are executed in order. The default values are simple IMAP commands using
        your default_charset and folder_prefix from SquirrelMail when needed.<br><br>
        <b><center>NOTE: These commands are live, any changes made will effect your current
        email account.</b></center></font></small><br>\n";
    if (!isset($submit)) {
        $submit = '';
    }
}
else {
    print 'folder_prefix = ' . htmlspecialchars($folder_prefix) . "<br>\n".
          'default_charset = ' . htmlspecialchars($default_charset) . "\n";
}

print "<BR></TD></TR></TABLE></CENTER><BR>\n";


if ($submit == 'submit') {
    $type = array();
    for ($i=0;$i<count($list);$i++) {
        $type[$list[$i]] = $$list[$i];
    }
}

elseif ($submit == 'clear') {
    for ($i=0;$i<count($list);$i++) {
        $type[$list[$i]] = '';
    }
}

elseif (!$submit || $submit == 'default')  {
    $type = array (
        'TEST_0' => "SELECT $mailbox",
        'TEST_1' => "STATUS $mailbox (MESSAGES RECENT)",
        'TEST_2' => "EXAMINE $mailbox",
        'TEST_3' => "SEARCH CHARSET \"$default_charset\" ALL *",
        'TEST_4' => "THREAD REFERENCES $default_charset ALL",
        'TEST_5' => "SORT (DATE) $default_charset ALL",
        'TEST_6' => "FETCH 1:* (FLAGS BODY[HEADER.FIELDS (FROM DATE TO)])",
        'TEST_7' => "LSUB \"$folder_prefix\" \"*%\"",
        'TEST_8' => "LIST \"$folder_prefix*\" \"*\"",
        'TEST_9' => "");
}

print "<FORM ACTION=\"options.php\" METHOD=POST>\n";
print "<CENTER><TABLE BORDER=1>\n";
print "<TR><TH>Select</TH><TH>Test Name</TH><TH>IMAP command string</TH>\n";
print "</TR><TR><TD>\n";

foreach($type as $index=>$value) {
    print "</TD></TR><TR><TD WIDTH=\"10%\"><INPUT TYPE=CHECKBOX VALUE=1 NAME=CHECK_$index";
    if ($index == 'TEST_0' && ($submit == 'default' || $submit == '')) {
        print " CHECKED";
    }
    $check = "CHECK_".$index;
    if (isset($$check) && $submit != 'clear' && $submit != 'default') {
        print " CHECKED";
    }
    print "></TD><TD WIDTH=\"30%\">$index</TD><TD WIDTH=\"60%\">\n";
    print addInput($index, $value, 60);
}

print "</TD></TR></TABLE></CENTER><BR>\n";
print "<center>".
addSubmit('submit','submit').
addSubmit('clear','submit').
addSubmit('default','submit').
"</center><br>\n";

$tests = array();

if ($submit == 'submit') {
    foreach ($type as $index=>$value) {
        $check = "CHECK_".$index;
        if (isset($$check)) {
            $type[$index] = $$index;
            array_push($tests, $index); 
        }
    }
    for ($i=0;$i<count($tests);$i++) {
        print "<CENTER><TABLE WIDTH=\"95%\" BORDER=0 BGCOLOR=".$color[4].">\n";
        print "<TR><TD><B>".$tests[$i]."</B></TD><TR>";
        print "<TR><TD><SMALL><B><FONT COLOR=".$color[7].
              ">Request:</FONT></SMALL></B></TD></TR>\n";
        $response = imap_test($imap_stream, $type[$tests[$i]]);
        print "<TR><TD><SMALL><B><FONT COLOR=".$color[7].
              ">Response:</FONT></SMALL></B></TD></TR>\n";
        print "<TR><TD>";
        print_response($response);
        print "</TD><TR></TABLE></CENTER><BR>\n";
    }
}
    print "</TD></TR></TABLE></CENTER></BODY></HTML>";
    sqimap_logout($imap_stream);
    do_hook('info_bottom');
?>