/**
 * \file util.h
 * \brief Header file for some GUI utility functions
 */

/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __GUI_UTIL_H__
#define __GUI_UTIL_H__

#include <stdio.h>
#include <gtk/gtk.h>

#include "swamidll.h"

#define FAIL	0
#define OK	1

typedef void (*UtilQuickFunc) (gpointer userdata, GtkWidget *popup);

/* GTK convenience macros */

#define RGB2GDK(c, r, g, b)     G_STMT_START {  \
    c.red = (guint32)r * 65535 / 255;           \
    c.green = (guint32)g * 65535 / 255;         \
    c.blue = (guint32)b * 65535 / 255;          \
} G_STMT_END

gboolean log_viewactive;
gint log_poplevel;

SWAMI_API void swamiui_util_init (void);
SWAMI_API GtkWidget *swamiui_util_quick_popup (gchar * msg, gchar * btn1, ...);
SWAMI_API GtkWidget *swamiui_util_lookup_unique_dialog (gchar *strkey,
							gint key2);
SWAMI_API gboolean swamiui_util_register_unique_dialog (GtkWidget *dialog,
							gchar *strkey,
							gint key2);
SWAMI_API void swamiui_util_unregister_unique_dialog (GtkWidget *dialog);
SWAMI_API gboolean swamiui_util_activate_unique_dialog (gchar *strkey,
							gint key2);

SWAMI_API gpointer swamiui_util_waitfor_widget_action (GtkWidget *widg);
SWAMI_API void swamiui_util_widget_action (GtkWidget *cbwidg, gpointer value);
SWAMI_API GtkWidget *swamiui_util_rip_guts (GtkWidget *widg, char *glade_name);
SWAMI_API GtkWidget *swamiui_util_lookup_widget (GtkWidget *widget,
						 const char *child_name);

SWAMI_API GtkWidget *swamiui_util_create_pixmap (gchar ** xpmdata);
SWAMI_API int swamiui_util_option_menu_index (GtkWidget *opmenu);

// void log_view (gchar * title);

SWAMI_API char *swamiui_util_str_crlf2lf (char *str);
SWAMI_API char *swamiui_util_str_lf2crlf (char *str);
SWAMI_API int swamiui_util_substrcmp (char *sub, char *str);

#endif
