/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.Insets;
import swingwt.awt.LayoutManager;

public class FlowLayout
implements LayoutManager {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    int align;
    int newAlign;
    int hgap;
    int vgap;

    public FlowLayout() {
        this(1, 5, 5);
    }

    public FlowLayout(int align) {
        this(align, 5, 5);
    }

    public FlowLayout(int align, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setAlignment(align);
    }

    public int getAlignment() {
        return this.newAlign;
    }

    public void setAlignment(int align) {
        this.newAlign = align;
        switch (align) {
            case 3: {
                this.align = 0;
                break;
            }
            case 4: {
                this.align = 2;
                break;
            }
            default: {
                this.align = align;
            }
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        boolean firstVisibleComponent = true;
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            dim.height = Math.max(dim.height, d.height);
            if (firstVisibleComponent) {
                firstVisibleComponent = false;
            } else {
                dim.width += this.hgap;
            }
            dim.width += d.width;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + this.hgap * 2;
        dim.height += insets.top + insets.bottom + this.vgap * 2;
        return dim;
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getMinimumSize();
            dim.height = Math.max(dim.height, d.height);
            if (i > 0) {
                dim.width += this.hgap;
            }
            dim.width += d.width;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + this.hgap * 2;
        dim.height += insets.top + insets.bottom + this.vgap * 2;
        return dim;
    }

    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        int maxwidth = target.getWidth() - (insets.left + insets.right + this.hgap * 2);
        int nmembers = target.getComponentCount();
        int x = 0;
        int y = insets.top + this.vgap;
        int rowh = 0;
        int start = 0;
        boolean ltr = target.getComponentOrientation().isLeftToRight();
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            m.setSize(d.width, d.height);
            if (x == 0 || x + d.width <= maxwidth) {
                if (x > 0) {
                    x += this.hgap;
                }
                x += d.width;
                rowh = Math.max(rowh, d.height);
                continue;
            }
            this.setComponentPositions(target, insets.left + this.hgap, y, maxwidth - x, rowh, start, i, ltr);
            x = d.width;
            y += this.vgap + rowh;
            rowh = d.height;
            start = i;
        }
        this.setComponentPositions(target, insets.left + this.hgap, y, maxwidth - x, rowh, start, nmembers, ltr);
    }

    protected void setComponentPositions(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        switch (this.newAlign) {
            case 0: {
                x += ltr ? 0 : width;
                break;
            }
            case 1: {
                x += width / 2;
                break;
            }
            case 2: {
                x += ltr ? width : 0;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                x += width;
            }
        }
        for (int i = rowStart; i < rowEnd; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            if (ltr) {
                m.setBounds(x, y + (height - m.getPreferredSize().height) / 2, m.getPreferredSize().width, m.getPreferredSize().height);
            } else {
                m.setBounds(target.getWidth() - x - m.getPreferredSize().width, y + (height - m.getPreferredSize().height) / 2, m.getPreferredSize().width, m.getPreferredSize().height);
            }
            x += m.getPreferredSize().width + this.hgap;
        }
    }
}

