/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.internal.ui.palette.editparts.SeparatorEditPart;

public class ColumnsLayout
extends FlowLayout {
    private Dimension defaultConstraint = null;
    private Dimension cachedConstraint = null;

    public ColumnsLayout() {
        super(true);
        this.setMinorSpacing(0);
        this.setMajorSpacing(0);
        this.setStretchMinorAxis(true);
        this.setDefaultConstraint(new Dimension(55, 55));
    }

    protected Dimension getChildSize(IFigure child, int wHint, int hHint) {
        if (!(child instanceof SeparatorEditPart.SeparatorFigure)) {
            Dimension hints = this.getMinimumHints(child, wHint, hHint);
            int numOfColumns = (wHint + this.majorSpacing) / (hints.width + this.majorSpacing);
            wHint = numOfColumns == 0 ? hints.width : (wHint - (numOfColumns - 1) * this.majorSpacing) / numOfColumns;
            hHint = hints.height;
        }
        return super.getChildSize(child, wHint, hHint);
    }

    private Dimension getMinimumHints(IFigure figure, int wHint, int hHint) {
        if (this.cachedConstraint == null) {
            this.cachedConstraint = this.defaultConstraint.getCopy();
            List children = figure.getParent().getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                IFigure child = (IFigure)iter.next();
                Dimension childSize = child.getPreferredSize(this.cachedConstraint.width, this.cachedConstraint.height);
                this.cachedConstraint.width = Math.max(this.cachedConstraint.width, childSize.width);
            }
            this.cachedConstraint.height = hHint;
        }
        return this.cachedConstraint;
    }

    public void invalidate() {
        super.invalidate();
        this.cachedConstraint = null;
    }

    private int maxChildrenInRowWith(IFigure figure) {
        int count = 0;
        boolean foundFigure = false;
        List children = figure.getParent().getChildren();
        int i = 0;
        while (i < children.size()) {
            ++count;
            IFigure child = (IFigure)children.get(i);
            if (child == figure) {
                foundFigure = true;
            } else if (child instanceof SeparatorEditPart.SeparatorFigure) {
                if (foundFigure) {
                    --count;
                    break;
                }
                count = 0;
            }
            ++i;
        }
        if (count == 0) {
            count = children.size();
        }
        return count;
    }

    public void setDefaultConstraint(Dimension d) {
        this.defaultConstraint = d;
    }
}

