/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;

public class ToolUtilities {
    public static List getSelectionWithoutDependants(EditPartViewer viewer) {
        List selectedParts = viewer.getSelectedEditParts();
        ArrayList<GraphicalEditPart> result = new ArrayList<GraphicalEditPart>();
        int i = 0;
        while (i < selectedParts.size()) {
            GraphicalEditPart editpart = (GraphicalEditPart)selectedParts.get(i);
            if (!ToolUtilities.isAncestorContainedIn(selectedParts, editpart)) {
                result.add(editpart);
            }
            ++i;
        }
        return result;
    }

    public static List getSelectionWithoutDependants(List selectedParts) {
        ArrayList<GraphicalEditPart> result = new ArrayList<GraphicalEditPart>();
        int i = 0;
        while (i < selectedParts.size()) {
            GraphicalEditPart editpart = (GraphicalEditPart)selectedParts.get(i);
            if (!ToolUtilities.isAncestorContainedIn(selectedParts, editpart)) {
                result.add(editpart);
            }
            ++i;
        }
        return result;
    }

    public static void filterEditPartsUnderstanding(List list, Request request) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            EditPart ep = (EditPart)iter.next();
            if (ep.understandsRequest(request)) continue;
            iter.remove();
        }
    }

    private static boolean isAncestorContainedIn(Collection c, EditPart ep) {
        ep = ep.getParent();
        while (ep != null) {
            if (c.contains(ep)) {
                return true;
            }
            ep = ep.getParent();
        }
        return false;
    }
}

