/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: SwingPropertyChangeSupport.java,v $
   Revision 1.3  2004/10/30 20:11:58  bobintetley
   Code cleanup

   Revision 1.2  2004/04/15 11:24:33  bobintetley
   (Dan Naab) ComponentUI, UIDefaults/UIManager and Accessibility support.
   (Antonio Weber) TableColumnModelListener implementation and support


*/
package swingwtx.swing.event;

import java.beans.*;

/**
 * @author Daniel Spiewak
 * @author Daniel Naab
 */
 public class SwingPropertyChangeSupport
 {
     protected EventListenerList listenerList = new EventListenerList();
 
     // Source object responsible for managing property changes
     private Object source;
 
     /**
      * @param source
      */
     public SwingPropertyChangeSupport(Object source)
     {
         this.source = source;
     }
 
     /**
      * @param propertyName
      * @param oldValue
      * @param newValue
      */
     public void firePropertyChange(String propertyName, Object oldValue, Object newValue)
     {
         PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(source, propertyName, oldValue, newValue);
         PropertyChangeListener[] listeners = (PropertyChangeListener[]) listenerList.
                 getListeners(PropertyChangeListener.class);
         for (int i = 0; i < listeners.length; i += 2)
         {
             listeners[i].propertyChange(propertyChangeEvent);
         }
     }
 
     /**
      * @param listener
      */
     public void addPropertyChangeListener(PropertyChangeListener listener)
     {
         listenerList.add(PropertyChangeListener.class, listener);
     }
 
     /**
      * @param listener
      */
     public void removePropertyChangeListener(PropertyChangeListener listener)
     {
         listenerList.remove(PropertyChangeListener.class, listener);
     }
 
     /**
      * @return
      */
     public PropertyChangeListener[] getPropertyChangeListeners()
     {
         return (PropertyChangeListener[]) listenerList.getListeners(PropertyChangeListener.class);
     }
     
 }