dnl ======================================
dnl GGZ Gaming Zone - Configuration Macros
dnl ======================================
dnl
dnl Copyright (C) 2001, 2002 Josef Spillner, dr_maux@users.sourceforge.net
dnl This file has heavily been inspired by KDE's acinclude :)
dnl It is published under the conditions of the GNU General Public License.
dnl
dnl ======================================
dnl
dnl This file is common to most GGZ modules, and should be kept in sync
dnl between them all.  Currently the following modules use it:
dnl kde-games, kde-client, gtk-games, gtk-client, utils, grubby,
dnl ggz-client-libs, ggzd.
dnl
dnl ======================================
dnl
dnl History:
dnl 2001-05-??: first version to find easysock and ggzcore
dnl 2001-09-09: include libggz[d]mod support, and rename ac_find_file
dnl 2001-11-05: backport from copenhagen, and more macros
dnl 2001-12-16: updated for new ggzmod, imported to gtk-games and gtk-client
dnl 2002-01-12: include libggz support; imported to ggz-client-libs and ggzd
dnl 2002-01-18: remove easysock functions; look in prefix dirs for
dnl             includes and libs

dnl ------------------------------------------------------------------------
dnl Content of this file:
dnl ------------------------------------------------------------------------
dnl AC_GGZ_FIND_FILE - macro for convenience (thanks kde)
dnl AC_GGZ_LIBGGZ - find the libggz headers and libraries
dnl AC_GGZ_GGZCORE - find the ggzcore headers and libraries
dnl AC_GGZ_GGZCOREPP - find any GGZCore++ installation (TODO)
dnl AC_GGZ_CONFIG - find the ggz-config tool and set up configuration
dnl AC_GGZ_GGZMOD - find the ggzmod library
dnl AC_GGZ_GGZDMOD - find the ggzdmod library
dnl AC_GGZ_SERVER - set up game and room path for ggzd game servers
dnl

dnl ------------------------------------------------------------------------
dnl Find a single file
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_FIND_FILE,
[
$3=NO
for i in $2;
do
  for j in $1;
  do
    echo "configure: __oline__: $i/$j" >&AC_FD_CC
    if test -r "$i/$j"; then
      echo "taking that" >&AC_FD_CC
      $3=$i
      break 2
    fi
  done
done
])

dnl ------------------------------------------------------------------------
dnl Try to find the libggz headers and libraries.
dnl $(LIBGGZ_LDFLAGS) will be -L ... (if needed)
dnl and $(LIBGGZ_INCLUDES) will be -I ... (if needed)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_LIBGGZ,
[
AC_MSG_CHECKING([for GGZ library: libggz])

ac_libggz_includes=NO ac_libggz_libraries=NO
libggz_libraries=""
libggz_includes=""

AC_ARG_WITH(libggz-dir,
    [  --with-libggz-dir=DIR       libggz installation prefix ],
    [  ac_libggz_includes="$withval"/include
       ac_libggz_libraries="$withval"/lib
    ])
AC_ARG_WITH(libggz-includes,
    [  --with-libggz-includes=DIR  where the libggz includes are. ],
    [  ac_libggz_includes="$withval"
    ])
AC_ARG_WITH(libggz-libraries,
    [  --with-libggz-libraries=DIR where the libggz libs are. ],
    [  ac_libggz_libraries="$withval"
    ])

AC_CACHE_VAL(ac_cv_have_libggz,
[
if test "x${prefix}" = "xNONE"; then
   prefix_incdir="${ac_default_prefix}/include"
   prefix_libdir="${ac_default_prefix}/lib"
else
   prefix_incdir="${prefix}/include"
   prefix_libdir="${prefix}/lib"
fi
libggz_incdirs="$ac_libggz_includes $prefix_incdir  /usr/local/include /usr/include"
libggz_header=ggz.h

AC_GGZ_FIND_FILE($libggz_header, $libggz_incdirs, libggz_incdir)
ac_libggz_includes="$libggz_incdir"

libggz_libdirs="$ac_libggz_libraries $prefix_libdir /usr/local/lib /usr/lib"

test=NONE
libggz_libdir=NONE
for dir in $libggz_libdirs; do
  try="ls -1 $dir/libggz.*"
  if test -n "`$try 2> /dev/null`"; then libggz_libdir=$dir; break; else echo "tried $dir" >&AC_FD_CC ; fi
done

ac_libggz_libraries="$libggz_libdir"

if test "$ac_libggz_includes" = NO || test "$ac_libggz_libraries" = NO; then
  ac_cv_have_libggz="have_libggz=no"
  ac_libggz_notfound=""

  AC_MSG_ERROR([libggz not found. Please check your installation! ]);
else
  have_libggz="yes"
fi
])

eval "$ac_cv_have_libggz"

if test "$have_libggz" != yes; then
  AC_MSG_RESULT([$have_libggz]);
else
  ac_cv_have_libggz="have_libggz=yes \
    ac_libggz_includes=$ac_libggz_includes ac_libggz_libraries=$ac_libggz_libraries"
  AC_MSG_RESULT([libraries $ac_libggz_libraries, headers $ac_libggz_includes])

  libggz_libraries="$ac_libggz_libraries"
  libggz_includes="$ac_libggz_includes"
fi

AC_SUBST(libggz_libraries)
AC_SUBST(libggz_includes)

LIBGGZ_INCLUDES="-I$libggz_includes"
LIBGGZ_LDFLAGS="-L$libggz_libraries"

AC_SUBST(LIBGGZ_INCLUDES)
AC_SUBST(LIBGGZ_LDFLAGS)

LIB_GGZ='-lggz'
AC_SUBST(LIB_GGZ)

])


dnl ------------------------------------------------------------------------
dnl Try to find the ggzcore headers and libraries.
dnl $(GGZCORE_LDFLAGS) will be -L ... (if needed)
dnl and $(GGZCORE_INCLUDES) will be -I ... (if needed)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_GGZCORE,
[
AC_MSG_CHECKING([for GGZ library: ggzcore])

ac_ggzcore_includes=NO ac_ggzcore_libraries=NO
ggzcore_libraries=""
ggzcore_includes=""

AC_ARG_WITH(ggzcore-dir,
    [  --with-ggzcore-dir=DIR       ggzcore installation prefix ],
    [  ac_ggzcore_includes="$withval"/include
       ac_ggzcore_libraries="$withval"/lib
    ])
AC_ARG_WITH(ggzcore-includes,
    [  --with-ggzcore-includes=DIR  where the ggzcore includes are. ],
    [  ac_ggzcore_includes="$withval"
    ])
AC_ARG_WITH(ggzcore-libraries,
    [  --with-ggzcore-libraries=DIR where the ggzcore libs are. ],
    [  ac_ggzcore_libraries="$withval"
    ])

AC_CACHE_VAL(ac_cv_have_ggzcore,
[
ggzcore_incdirs="$ac_ggzcore_includes /usr/local/include /usr/include"
ggzcore_header=ggzcore.h

AC_GGZ_FIND_FILE($ggzcore_header, $ggzcore_incdirs, ggzcore_incdir)
ac_ggzcore_includes="$ggzcore_incdir"

ggzcore_libdirs="$ac_ggzcore_libraries /usr/local/lib /usr/lib"

test=NONE
ggzcore_libdir=NONE
for dir in $ggzcore_libdirs; do
  try="ls -1 $dir/libggzcore.*"
  if test -n "`$try 2> /dev/null`"; then ggzcore_libdir=$dir; break; else echo "tried $dir" >&AC_FD_CC ; fi
done

ac_ggzcore_libraries="$ggzcore_libdir"

if test "$ac_ggzcore_includes" = NO || test "$ac_ggzcore_libraries" = NO; then
  ac_cv_have_ggzcore="have_ggzcore=no"
  ac_ggzcore_notfound=""

  AC_MSG_ERROR([ggzcore not found. Please check your installation! ]);
else
  have_ggzcore="yes"
fi
])

eval "$ac_cv_have_ggzcore"

if test "$have_ggzcore" != yes; then
  AC_MSG_RESULT([$have_ggzcore]);
else
  ac_cv_have_ggzcore="have_ggzcore=yes \
    ac_ggzcore_includes=$ac_ggzcore_includes ac_ggzcore_libraries=$ac_ggzcore_libraries"
  AC_MSG_RESULT([libraries $ac_ggzcore_libraries, headers $ac_ggzcore_includes])

  ggzcore_libraries="$ac_ggzcore_libraries"
  ggzcore_includes="$ac_ggzcore_includes"
fi

AC_SUBST(ggzcore_libraries)
AC_SUBST(ggzcore_includes)

GGZCORE_INCLUDES="-I$ggzcore_includes"
GGZCORE_LDFLAGS="-L$ggzcore_libraries"

AC_SUBST(GGZCORE_INCLUDES)
AC_SUBST(GGZCORE_LDFLAGS)

LIB_GGZCORE='-lggzcore'
AC_SUBST(LIB_GGZCORE)

])

dnl ------------------------------------------------------------------------
dnl Try to find the ggz-config binary.
dnl Sets GGZ_CONFIG to the path/name of the program.
dnl Sets also: ggz_gamedir, ggz_datadir etc.
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_CONFIG,
[
AC_MSG_CHECKING([for GGZ configuration tool: ggz-config])

ac_ggz_config=NO
ggz_config=""

AC_ARG_WITH(ggzconfig,
    [  --with-ggzconfig=DIR          path to ggz-config ],
    [  ac_ggz_config="$withval"
    ])

AC_CACHE_VAL(ac_cv_have_ggzconfig,
[
ggz_config_dirs="$ac_ggz_config /usr/local/bin /usr/bin"

AC_GGZ_FIND_FILE(ggz-config, $ggz_config_dirs, ggz_config_dir)
ac_ggz_config="$ggz_config_dir"

if test "$ac_ggz_config" = NO; then
  ac_cv_have_ggzcore="have_ggz_config=no"
  ac_ggz_config_notfound=""

  AC_MSG_ERROR([ggz-config not found. Please check your installation! ]);
else
  have_ggz_config="yes"
fi
])

eval "$ac_cv_have_ggz_config"

if test "$have_ggz_config" != yes; then
  AC_MSG_RESULT([$have_ggz_config]);
else
  ac_cv_have_ggz_config="have_ggz_config=yes \
    ac_ggz_config=$ac_ggz_config"
  AC_MSG_RESULT([$ac_ggz_config/ggz-config])

  ggz_config="$ac_ggz_config"
fi

AC_SUBST(ggz_config)

GGZ_CONFIG="${ggz_config}/ggz-config"

AC_SUBST(GGZ_CONFIG)

ggzmoduleconfdir=`$GGZ_CONFIG --configdir`
AC_DEFINE_UNQUOTED(GGZMODULECONFDIR, "${ggzmoduleconfdir}", [Path where the game registry is located])
ggzexecmoddir=`$GGZ_CONFIG --gamedir`
AC_DEFINE_UNQUOTED(GAMEDIR, "${ggzexecmoddir}", [Path where to install the games])
ggzdatadir=`$GGZ_CONFIG --datadir`
AC_DEFINE_UNQUOTED(GGZDATADIR, "${ggzdatadir}", [Path where the games should look for their data files])
packagesrcdir=`cd $srcdir && pwd`
AC_DEFINE_UNQUOTED(PACKAGE_SOURCE_DIR, "${packagesrcdir}", [Path where the source is located])

AC_SUBST(ggzmoduleconfdir)
AC_SUBST(ggzexecmoddir)
AC_SUBST(ggzdatadir)
AC_SUBST(packagesrcdir)

])

dnl ------------------------------------------------------------------------
dnl Try to find the ggzmod headers and libraries.
dnl $(GGZMOD_LDFLAGS) will be -L ... (if needed)
dnl and $(GGZMOD_INCLUDES) will be -I ... (if needed)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_GGZMOD,
[
AC_MSG_CHECKING([for GGZ library: ggzmod])

ac_ggzmod_includes=NO ac_ggzmod_libraries=NO
ggzmod_libraries=""
ggzmod_includes=""

AC_ARG_WITH(ggzmod-dir,
    [  --with-ggzmod-dir=DIR        ggzmod installation prefix ],
    [  ac_ggzmod_includes="$withval"/include
       ac_ggzmod_libraries="$withval"/lib
    ])
AC_ARG_WITH(ggzmod-includes,
    [  --with-ggzmod-includes=DIR   where the ggzmod includes are. ],
    [  ac_ggzmod_includes="$withval"
    ])
AC_ARG_WITH(ggzmod-libraries,
    [  --with-ggzmod-libraries=DIR  where the ggzmod libs are. ],
    [  ac_ggzmod_libraries="$withval"
    ])

AC_CACHE_VAL(ac_cv_have_ggzmod,
[
ggzmod_incdirs="$ac_ggzmod_includes /usr/local/include /usr/include"
ggzmod_header=ggzmod.h

AC_GGZ_FIND_FILE($ggzmod_header, $ggzmod_incdirs, ggzmod_incdir)
ac_ggzmod_includes="$ggzmod_incdir"

ggzmod_libdirs="$ac_ggzmod_libraries /usr/local/lib /usr/lib"

test=NONE
ggzmod_libdir=NONE
for dir in $ggzmod_libdirs; do
  try="ls -1 $dir/libggzmod.*"
  if test -n "`$try 2> /dev/null`"; then ggzmod_libdir=$dir; break; else echo "tried $dir" >&AC_FD_CC ; fi
done

ac_ggzmod_libraries="$ggzmod_libdir"

if test "$ac_ggzmod_includes" = NO || test "$ac_ggzmod_libraries" = NO; then
  ac_cv_have_ggzmod="have_ggzmod=no"
  ac_ggzmod_notfound=""

  AC_MSG_ERROR([ggzmod not found. Please check your installation! ]);
else
  have_ggzmod="yes"
fi
])

eval "$ac_cv_have_ggzmod"

if test "$have_ggzmod" != yes; then
  AC_MSG_RESULT([$have_ggzmod]);
else
  ac_cv_have_ggzmod="have_ggzmod=yes \
    ac_ggzmod_includes=$ac_ggzmod_includes ac_ggzmod_libraries=$ac_ggzmod_libraries"
  AC_MSG_RESULT([libraries $ac_ggzmod_libraries, headers $ac_ggzmod_includes])

  ggzmod_libraries="$ac_ggzmod_libraries"
  ggzmod_includes="$ac_ggzmod_includes"
fi

AC_SUBST(ggzmod_libraries)
AC_SUBST(ggzmod_includes)

GGZMOD_INCLUDES="-I$ggzmod_includes"
GGZMOD_LDFLAGS="-L$ggzmod_libraries"

AC_SUBST(GGZMOD_INCLUDES)
AC_SUBST(GGZMOD_LDFLAGS)

LIB_GGZMOD='-lggzmod'
AC_SUBST(LIB_GGZMOD)

])

dnl ------------------------------------------------------------------------
dnl Try to find the ggzdmod headers and libraries.
dnl $(GGZDMOD_LDFLAGS) will be -L ... (if needed)
dnl and $(GGZDMOD_INCLUDES) will be -I ... (if needed)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_GGZDMOD,
[
AC_MSG_CHECKING([for GGZ library: ggzdmod])

ac_ggzdmod_includes=NO ac_ggzdmod_libraries=NO
ggzdmod_libraries=""
ggzdmod_includes=""

AC_ARG_WITH(ggzdmod-dir,
    [  --with-ggzdmod-dir=DIR        ggzdmod installation prefix ],
    [  ac_ggzdmod_includes="$withval"/include
       ac_ggzdmod_libraries="$withval"/lib
    ])
AC_ARG_WITH(ggzdmod-includes,
    [  --with-ggzdmod-includes=DIR   where the ggzdmod includes are. ],
    [  ac_ggzdmod_includes="$withval"
    ])
AC_ARG_WITH(ggzdmod-libraries,
    [  --with-ggzdmod-libraries=DIR  where the ggzdmod libs are. ],
    [  ac_ggzdmod_libraries="$withval"
    ])

AC_CACHE_VAL(ac_cv_have_ggzdmod,
[
ggzdmod_incdirs="$ac_ggzdmod_includes /usr/local/include /usr/include"
ggzdmod_header=ggzdmod.h

AC_GGZ_FIND_FILE($ggzdmod_header, $ggzdmod_incdirs, ggzdmod_incdir)
ac_ggzdmod_includes="$ggzdmod_incdir"

ggzdmod_libdirs="$ac_ggzdmod_libraries /usr/local/lib /usr/lib"

test=NONE
ggzdmod_libdir=NONE
for dir in $ggzdmod_libdirs; do
  try="ls -1 $dir/libggzdmod.*"
  if test -n "`$try 2> /dev/null`"; then ggzdmod_libdir=$dir; break; else echo "tried $dir" >&AC_FD_CC ; fi
done

ac_ggzdmod_libraries="$ggzdmod_libdir"

if test "$ac_ggzdmod_includes" = NO || test "$ac_ggzdmod_libraries" = NO; then
  ac_cv_have_ggzdmod="have_ggzdmod=no"
  ac_ggzdmod_notfound=""

  AC_MSG_ERROR([ggzdmod not found. Please check your installation! ]);
else
  have_ggzdmod="yes"
fi
])

eval "$ac_cv_have_ggzdmod"

if test "$have_ggzdmod" != yes; then
  AC_MSG_RESULT([$have_ggzdmod]);
else
  ac_cv_have_ggzdmod="have_ggzdmod=yes \
    ac_ggzdmod_includes=$ac_ggzdmod_includes ac_ggzdmod_libraries=$ac_ggzdmod_libraries"
  AC_MSG_RESULT([libraries $ac_ggzdmod_libraries, headers $ac_ggzdmod_includes])

  ggzdmod_libraries="$ac_ggzdmod_libraries"
  ggzdmod_includes="$ac_ggzdmod_includes"
fi

AC_SUBST(ggzdmod_libraries)
AC_SUBST(ggzdmod_includes)

GGZDMOD_INCLUDES="-I$ggzdmod_includes"
GGZDMOD_LDFLAGS="-L$ggzdmod_libraries"

AC_SUBST(GGZDMOD_INCLUDES)
AC_SUBST(GGZDMOD_LDFLAGS)

LIB_GGZDMOD='-lggzdmod'
AC_SUBST(LIB_GGZDMOD)

])

dnl ------------------------------------------------------------------------
dnl Setup the game server configuration.
dnl Sets ggzdconfdir (ggzd configuration).
dnl Sets ggzddatadir (for game server data).
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_SERVER,
[
AC_MSG_CHECKING([for GGZ server: ggzd])
AC_ARG_WITH(ggzd-confdir,
[  --with-ggzd-confdir=DIR       directory for room/game data],
[ ac_ggzd_confdir="$withval"
])

AC_CACHE_VAL(ac_cv_have_ggzdconf,
[
	ggzdconfdirs="$ac_ggzd_confdir /usr/local/etc/ggzd /etc/ggzd"

	ggzdconfdir=NONE
	for dir in $ggzdconfdirs; do
		if test -n "`ls -d $dir/rooms 2> /dev/null`"; then
			if test -n "`ls -d $dir/rooms 2> /dev/null`"; then
				ggzdconfdir=$dir; break;
			else
				echo "tried $dir" >&AC_FD_CC;
			fi
		else
			echo "tried $dir" >&AC_FD_CC;
		fi
	done

	if test "$ggzd_confdir" = NO; then
		AC_MSG_ERROR([ggz server configuration not found. Please check your installation! ])
	else
		have_ggzdconf="yes"
	fi
])

eval "$ac_cv_have_ggzdconf"

if test "$have_ggzdconf" != yes; then
	AC_MSG_RESULT([$have_ggzdconf])
else
	AC_MSG_RESULT([$ggzdconfdir])
fi

AC_SUBST(ggzdconfdir)

ggzddatadir=${prefix}/share/${PACKAGE}
AC_DEFINE_UNQUOTED(GGZDDATADIR, "${ggzddatadir}", [Game server data directory])
AC_SUBST(ggzddatadir)
])

