/* -*- mode: c; c-file-style: "gnu" -*-
 * thy.h -- Global definitions for Thy
 * Copyright (C) 2002, 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file thy.h
 * Global definitions for Thy.
 */

#ifndef _THY_H
#define _THY_H 1 /**< thy.h multi-inclusion guard. */

#include <syslog.h>

#include "compat/compat.h"
#include "options.h"
#include "system.h"
#include "types.h"

extern long int _THY_MAXCONN;
extern int thy_default_port;
extern thy_listener_ssl_t thy_default_tls;
extern size_t thy_active_cgis;

#define __THY__ "Thy" /**< The name Thy identifies herself. */
/** Default Thy version string.
 */
#define _THY_VERSION "0.9." PATCHLEVEL EXTRAVERSION

void thy_servername_init (void);
const char *thy_servername (char *name);

#define _THY_PKGLIBDIR LIBDIR "/thy" /**< Default location of private
					executables. */
#define _THY_CONFDIR SYSCONFDIR "/thy" /**< Default location of
					  configuration data. */
#define _THY_WEBROOT "/var/www" /**< Default web root. */
/** Default Content-Type to report.
 * This is the content-type that will be reported for unknown files,
 * unless specified otherwise.
 */
#define _THY_DEFTYPE "application/octet-stream"
#define _THY_PORT 80 /**< Default HTTP port to listen on. */
#define _THY_PORT_SSL 443 /**< Default HTTPS port to listen on. */
/** Default user ID to setuid() to.
 * By default, this is the UID Thy was started as.
 */
#define _THY_UID getuid ()
/** Default user directory.
 * This is the directory under the users $HOME from which ~user/
 * documents will be served from, unless specified otherwise.
 */
#define _THY_USERDIR "public_html"
#define _THY_DEFINDEX "index.html" /**< Default directory index. */
#define _THY_DEFCGI ".cgi" /**< Default CGI extension. */
#define _THY_PIDFILE "/var/run/thy.pid" /**< Default PID file. */
/** Default buffer size.
 * By default, requests are served in chunks, and this constant is the
 * default size of a chunk. It is also used for various other stuff...
 */
#define _THY_BUFSIZE 256 * 1024
#define _THY_LRUSIZE 512 /**< Default size of LRU caches. */
#define _THY_LRUEXPIRE 7200 /**< Default expiration age of LRU cache
			       entries, in seconds. */
#define _THY_MAXACCEPT 25 /**< Maximum number of connections to accept
			     in one go. */
#define _THY_AUTH_PROTOCOL_VERSION 2 /**< Authentication protocol
					version. */
#define _THY_WORKER_PROTOCOL_VERSION 1 /**< Worker protocol
					  version. */

#ifndef __DOXYGEN__
#if SIZEOF_SIZE_T == 4
# if defined(__s390__)
#  define SIZET_FORMAT "%ld"
# else
#  define SIZET_FORMAT "%u"
# endif
#elif SIZEOF_SIZE_T == 8
#define SIZET_FORMAT "%ld"
#else
#error Unsupported size_t size
#endif
#endif /* !__DOXYGEN__ */

#endif /* !_THY_H */
