// ti990_cmds.c - Commands for TI-990 Minicomputer System.
//
// Copyright (c) 2002, Timothy M. Stark
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// TIMOTHY M STARK BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
// IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name of Timothy M Stark shall not
// be used in advertising or otherwise to promote the sale, use or other 
// dealings in this Software without prior written authorization from
// Timothy M Stark.

#include "ti990/ti990.h"

int ti990_CmdRom(void *dptr, int argc, char **argv)
{
	TI990_CPU *ti99cpu = (TI990_CPU *)dptr;
	struct stat st;
	uint16    sAddr = ROM_BASE;
	int       romFile;
	int       idx;

	if (argc != 2) {
		printf("%s: Usage: %s <filename>\n",
			ti99cpu->cpu.devName, argv[0]);
		return TI99_ARG;
	} else if (romFile = open(argv[1], O_RDONLY)) {
		fstat(romFile, &st);

		ti99cpu->ROM     = (uint16 *)malloc(st.st_size);
		ti99cpu->BaseROM = sAddr;
		ti99cpu->EndROM  = (sAddr + st.st_size) - 1;
		ti99cpu->SizeROM = st.st_size;
		ti99cpu->MaskROM = st.st_size - 1;

		for (idx = 0; idx < st.st_size; idx += 8192)
			read(romFile, &ti99cpu->ROM[idx], 8192);

		// For little endians only
		swab(ti99cpu->ROM, ti99cpu->ROM, st.st_size);

		close (romFile);

		printf("%s: File '%s' had been load.\n",
			ti99cpu->cpu.devName, argv[1]);
		printf("%s:   ROM Base = %04X  Length = %d bytes\n",
			ti99cpu->cpu.devName, ti99cpu->BaseROM, ti99cpu->SizeROM);
	} else {
		printf("%s: No such file %s.\n",
			ti99cpu->cpu.devName, argv[1]);
		return TI99_OPENERR;
	}

	return TI99_OK;
}

COMMAND ti990_Commands[] =
{
	{ "rom",  "<filename> <address>", ti990_CmdRom },
	{ NULL,   NULL,                   NULL }
};
