// dev_mba.c - VAX Massbus Interface
//
// Written by
//  Timothy Stark <sword7@speakeasy.org>
//
// This file is part of the TS10 Emulator.
// See ReadMe for copyright notice.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "dev/mba/mba.h"
#include "vax/mba.h"

void vaxmba_Read(MBA_DEVICE *mba, uint32 pAddr, uint32 *data)
{
	pAddr &= NEX_SIZE - 1;
	switch (pAddr >> 10) {
		case 0:  // 0000 - 03FF - Nexus/Massbus Registers
			break;

		case 1:  // 0400 - 07FF - Drive Registers
			drv = (pAddr >> MBA_PDRV) & MBA_NDRV;
			reg = (pAddr >> MBA_PREG) & MBA_NREG;
			mba_ReadIO(mba, drv, reg, &data16);
			*data = data16;
			break;

		case 2:  // 0800 - 0BFF - Map Registers
			*data = mba->map[pAddr >> MBA_PREG];
			break;

		default: // 0C00 - 1FFF - Unused Area
			*data = 0;
	}
}

void vaxmba_Write(MBA_DEVICE *mba, uint32 pAddr, uint32 data)
{
	switch ((paddr & (NEX_SIZE-1)) >> 10) {
		case 0:  // 0000 - 03FF - Nexus/Massbus Registers
			break;

		case 1:  // 0400 - 07FF - Drive Registers
			drv = (pAddr >> MBA_PDRV) & MBA_NDRV;
			reg = (pAddr >> MBA_PREG) & MBA_NREG;
			mba_WriteIO(mba, drv, reg, data);
			break;

		case 2:  // 0800 - 0BFF - Map Registers
			mba->map[pAddr >> MBA_PREG] = data;
			break;

		default: // 0C00 - 1FFF - Unused Area
			// Do nothing here
	}
}
