#include "SignalNetinfo.hh"
#include "SourceInfo.hh"
#include "SourceData.hh"
#include <iostream>
#include "UniversalBoolean.hh"
#include "FanDest.hh"

SignalNetinfo::SignalNetinfo() {
  // Create new signal identifier
  id = globalSignalId++;
  source = NULL;
  driver_added_flag = false;
  downTypeConversionFnList.reset();
  sourcebase_delete_flag = true ;
  additionalDriverList = NULL;
  additionalDriverListDeleteFlag = true;
}

SignalNetinfo::~SignalNetinfo() {
  if ((get_sourcebase_delete_flag() == true) && (source != NULL)) {
    delete source ;
    source = NULL;
  }
  if ( additionalDriverListDeleteFlag == true ){
    delete additionalDriverList;
  }
}

SignalNetinfo::SignalNetinfo( SignalNetinfo* ptr ){
  // Copy signal identifier
  id = ptr->id;

  Add(*ptr);

  source = ptr->source;
  driver_added_flag = false;
  sourcebase_delete_flag = true;
  // copy the additionalDriverList also
  cerr << "SignalNetinfo::SignalNetinfo(SignalNetinfo *) -> Warning constructor taking SignalNetinfo * is copying also the additionalDriverList;" << endl;
  if ( ptr->getAdditionalDriverList() != NULL ){
    additionalDriverList = new Block();
    *additionalDriverList = *(ptr->getAdditionalDriverList());
  }
}

SignalNetinfo&
SignalNetinfo::Add( const SignalNetinfo* ptr ){
  return Add(*ptr);
}

SignalNetinfo &
SignalNetinfo::Add( const SignalNetinfo &sig ){
  for( int i = 0; i < sig.getFanOut(); i++ ){
    Add( sig.fanoutTable[i]->getProcessName(), sig.fanoutTable[i]->getSigId() );
  }
  return *this;
}

SignalNetinfo&
SignalNetinfo::Add( VHDLKernel *objid ){
  return Add( objid, id );
}

SignalNetinfo&
SignalNetinfo::Add( VHDLKernel *objid, int  sigid ){
  return Add( objid->getName(), sigid );
}

SignalNetinfo&
SignalNetinfo::Add( const string &processName, int  sigid ){
  int present = 0;
  for(unsigned int j = 0; j< fanoutTable.size(); j++ ){
    if( fanoutTable[j]->getProcessName() == processName && fanoutTable[j]->getSigId() == sigid ){
      present = 1;
      break;
    }
  }
  if( present == 0 ){
    fanoutTable.push_back( new FanDest( processName, sigid ));
  }
  return *this;
}

void 
SignalNetinfo::setResolutionFunctionId(int resolutionFnId) {
  if(source == NULL) {
    source = new SourceInfo;
  }
  else if(source->get_kind() == SourceBase::SOURCE_DATA) {
    SourceBase *temp_src = new SourceInfo;
    temp_src->addChild(source);
    source = temp_src;
  }
  source->setResolutionFnId(resolutionFnId);
}

void 
SignalNetinfo::setTypeConversionFunctionId(int typeConversionFnId) {
  if(source == NULL) {
    source = new SourceInfo;
  }
  else if(source->get_kind() == SourceBase::SOURCE_DATA) {
    SourceBase *temp_src = new SourceInfo;
    temp_src->addChild(source);
    source = temp_src;
  }
  source->setUpTypeConversionFnId(typeConversionFnId);
}

void 
SignalNetinfo::print(ostream& os) const {
  os << "info id  " << id << "\n";
  os << "fanout is " << getFanOut() << endl;
  for(unsigned int i = 0; i< fanoutTable.size(); i++ ) {
    os << fanoutTable[i] << endl;
  }
  os << endl;
}

bool 
SignalNetinfo::_is_signal() const {
  cerr << "ERROR: _is_signal() called from SignalNetinfo." << endl;
  abort();
  return false;		// Just to keep CC from shouting.
}

const VHDLData& 
SignalNetinfo::readVal() const {
  cerr << "ERROR: SignalNetinfo::readVal called." << endl;
  abort();
  return *(new UniversalBoolean(false)); // Just to keep CC from shouting.
}

void
SignalNetinfo::updateVal(const VHDLData&) {
  cerr << "ERROR: SignalNetinfo::updateVal called." << endl;
  abort();
}

ObjectBase& 
SignalNetinfo::operator=(const ObjectBase& s) {
  return operator=((const SignalNetinfo &) s);
}

ObjectBase&
SignalNetinfo::operator=(const SignalNetinfo &s) {
  id      = s.id;
  if( fanoutTable.size() > 0 ){
    fanoutTable.clear();
  }
  for(int i = 0; i < s.getFanOut(); i++) {
    fanoutTable.push_back( s.fanoutTable[i] );
  }
  
  source  = s.source;
  sourcebase_delete_flag = false;
  
  if (((SignalNetinfo &)s).getAdditionalDriverList() != NULL) {
    if ((additionalDriverList != NULL) && (additionalDriverListDeleteFlag == true)) {
      delete additionalDriverList;
    }
    additionalDriverList = new Block;
    *additionalDriverList = *((SignalNetinfo &)s).getAdditionalDriverList();
  }
  else {
    additionalDriverList = NULL;
  }
  
  return (*this);
}

ObjectBase* 
SignalNetinfo::clone() const {
  SignalNetinfo *retval = new SignalNetinfo;
  *retval = *this;
  retval->set_sourcebase_delete_flag(false);
  cout << "retval = " << retval << endl;
  return retval;
}

// Storage place and initialisation of global signal identifier.
int SignalNetinfo::globalSignalId = 0;

void
SignalNetinfo::set_driver_added_flag()
{
  driver_added_flag = true;
}

void
SignalNetinfo::set_driver_added_flag(const bool newValue)
{
  driver_added_flag = newValue;
}

bool
SignalNetinfo::get_driver_added_flag() const
{
  return driver_added_flag;
}

bool
SignalNetinfo::get_sourcebase_delete_flag() const {
  return sourcebase_delete_flag ;
}

void
SignalNetinfo::set_sourcebase_delete_flag( const bool newValue ){
  sourcebase_delete_flag = newValue;
}

void
SignalNetinfo::setAdditionalDriverList(Block *newDriverList){
  if ( additionalDriverList == NULL ){
    additionalDriverList = newDriverList;
    additionalDriverListDeleteFlag = false;
  } else {
    int index ;
    for ( index = 0 ; index < newDriverList->getNumberOfElements() ; index++){
      additionalDriverList->addElement(newDriverList->getElement(index));
    }
  }
}

Block *
SignalNetinfo::getAdditionalDriverList(){
  return additionalDriverList;
}

void
SignalNetinfo::addAdditionalDriver(VHDLType *driver){
  ASSERT(additionalDriverList != NULL);
  additionalDriverList->addElement(driver);
}

void
SignalNetinfo::addAdditionalDriver(Block *newDriverList){
  int index;

  if ( newDriverList == NULL ){
    //nothing to be done here in this case
  } else {
    // if the block additionalDriverList is not already existing, new a block
    if ( additionalDriverList == NULL ){
      additionalDriverList = new Block;
    }
    for ( index = 0 ; index < newDriverList->getNumberOfElements(); index++){
      additionalDriverList->addElement(newDriverList->getElement(index));
    }
  }
}

void
SignalNetinfo::dump_connectivity_info(ofstream& out) {
  out << "Signal id: " << id << endl;
  out << "Signal fanout: " << getFanOut() << endl;
  out << "Fanout dest:   " << endl;
  for( unsigned int i = 0; i < fanoutTable.size(); i++ ){
    out << fanoutTable[i];
    out << endl;
  }
}

void
SignalNetinfo::dump_driver_data(ofstream& out) {
  if (source != NULL) {
    out << "Driver Information:";
    out << ((SourceData*)source->getDriveratIndex(0))->getSourceId();
    out << endl;
  }
}
