#include "SourceData.hh"
#include "SourceBase.hh"

VHDLKernel* SourceBase::ANONYMOUS_PROCESS_ID = (VHDLKernel *) (-2);
VHDLKernel* SourceBase::DEFAULT_ID           = (VHDLKernel *) (-1);

TypeConversionFnId_t SourceBase::DEFAULT_TCF_ID  = -1;
ResolutionFnId_t     SourceBase::DEFAULT_RF_ID   = -2;

void 
SourceBase::setParent(SourceBase *myParent) {
  ASSERT(myParent != NULL);
  parent = myParent;
}

void
SourceBase::setData(VHDLType *) {
  cerr << "Default updateData(VHDLType *) called in " << __FILE__ << ":" 
       << __LINE__ << endl;
}

void
SourceBase::addToRootDriverTable( SourceData* ){
  cerr << "Default addToTable(SourceBase*) called in " << __FILE__ << ":"
       << __LINE__ << endl;
  abort();
}

void 
SourceBase::addDriversToRootDriverTable(SourceBase*) {
  cerr << "Default copyTable(const SourceBase*) called in " << __FILE__ 
       << ":" << __LINE__ << endl;
  abort();
}

VHDLType* 
SourceBase::resolve( VHDLKernel *, SigType ) { return NULL; }
