//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef _SOURCE_TYPE_CONVERT_HH_
#define _SOURCE_TYPE_CONVERT_HH_
#include "tyvis/SourceBase.hh"

class TypeConvert;
class VHDLType;
class VHDLProcess;

/** This class is like SourceData but the difference is that it comes into
    picture only if there is a TypeConversion. It has a pointer to the driver
    and the TypeConvert Node which does the actual TypeConversion. */

class SourceTypeConvert : public SourceBase {
public:
  SourceTypeConvert();
  ~SourceTypeConvert();

  /** When a resolve is called on this node. We in turn call a resolve on
      the TypeConvert node which does the TypeConversion. TypeConvert does
      the type conversion and puts the resultant value in the driver
      pointer to by data.  Once the typeconversion is over, the data
      contains the typeconverted value. */
  VHDLType *resolve( VHDLKernel *, SigType type = EXPLICIT );

  void setData(VHDLType *);

  void setTypeConvert(TypeConvert *);

  virtual SourceBase::SourceKind get_kind() const{ return SourceBase::SOURCE_TYPE_CONVERT;};

private:
  VHDLType *data;
  TypeConvert *conversionNode;
};

#endif

