#ifndef _SAVANT_FILE_OPEN_STATUS_HH
#define _SAVANT_FILE_OPEN_STATUS_HH

#include "tyvis/VHDLData.hh"
#include <warped/SerializedInstance.h>
#include <warped/DeserializerManager.h>
#include <iostream>
using std::cout;

class _savant_file_open_status: public VHDLData {
  friend ostream& operator<<(ostream&, const _savant_file_open_status&);
public:
  enum FileOpenStatus_t { OPEN_OK, STATUS_ERROR, NAME_ERROR, MODE_ERROR };
  
  FileOpenStatus_t val;

  virtual VHDLData::UniversalType getUniversalKind() const{
    return FILE_OPEN_STATUS;
  }

  int getIntValue() const { return val; }
  LONG getInt64Value() const { return (LONG)val; }
  double getDoubleValue() const { return (double)val; }

  _savant_file_open_status() { val = OPEN_OK; }
  _savant_file_open_status(const _savant_file_open_status& s) : VHDLData() { val = s.val; }
  _savant_file_open_status(FileOpenStatus_t s) { val =s; }

  bool operator==( const RValue &compareTo ) const {
    return val == dynamic_cast<const _savant_file_open_status &>( compareTo ).val;
  }

  bool operator!=( const RValue &compareTo ) const {
    return val != dynamic_cast<const _savant_file_open_status &>( compareTo ).val;
  }

  bool operator>( const RValue &compareTo ) const{
    return val > dynamic_cast<const _savant_file_open_status &>( compareTo ).val;
  }

  bool operator>=( const RValue &compareTo ) const {
    return val >= dynamic_cast<const _savant_file_open_status &>( compareTo ).val;
  }

  bool operator<( const RValue &compareTo ) const {
    return val < dynamic_cast<const _savant_file_open_status &>( compareTo ).val;
  }

  bool operator<=( const RValue &compareTo ) const {
    return val <= dynamic_cast<const _savant_file_open_status &>( compareTo ).val;
  }

  void print(ostream& os = cout) const { os <<*this; os.flush();}

  VHDLData *clone() const {
    return new _savant_file_open_status( val );
  }

  static const string &getFileOpenStatusType(){
    static const string FileOpenStatusType = "FileOpenStatus";
    return FileOpenStatusType;
  }

  const string &getDataType() const {
    return getFileOpenStatusType();
  }

  void serialize( SerializedInstance *addTo ) const {
    addTo->addInt( val );
  }

  static Serializable *deserialize( SerializedInstance *si ){
    return new _savant_file_open_status( FileOpenStatus_t( si->getInt() ));
  }

  static void registerDeserializer(){
    DeserializerManager::instance()->registerDeserializer( getFileOpenStatusType(),
							   &_savant_file_open_status::deserialize );
  }



};
  
inline ostream& operator<<(ostream& os, const _savant_file_open_status& fos) {
  switch (fos.val) {
  case _savant_file_open_status::OPEN_OK:
    os << "OPEN_OK";
    break;
  case _savant_file_open_status::STATUS_ERROR:
    os << "STATUS_ERROR";
    break;
  case _savant_file_open_status::NAME_ERROR:
    os << "NAME_ERROR";
    break;
  case _savant_file_open_status::MODE_ERROR:
    os << "MODE_ERROR";
    break;
  default:
    os << "(invalid FileOpenStatus type)";
    break;
  }
  return os;
}

#endif
