#include <iostream>
#include <ubit/ubit.hpp>
using namespace std;

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

class Demo : public UFrame {
public:
	Demo();

private:
	UColor   color;
	UBgcolor bgcolor;

	void xchangeColors() {
		UColor tmp = color; 	color = bgcolor; bgcolor = tmp;
	}

	void xchangeStrings(UStr* s) {
		if (*s == "Hello")  *s = "Good Bye";  else	*s = "Hello";
	}
};

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

int main(int argc, char* argv[]) {
	UAppli appli(&argc, argv);

	Demo frame;
	appli.add(frame);
	frame.show(true);

	return appli.mainLoop();
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

Demo::Demo() {
	
	bgcolor   = UColor::yellow;
	color     = UColor::red;
	UStr& str = ustr("Hello");	   // Ubit active string
	
	// each button uses its own callback function
	UBox& box1 = uhbox
		(
			ubutton("Yellow/Red"      + ucall(this, &Demo::xchangeColors) )
			+ ubutton("Hello/Good By" + ucall(this, &str, &Demo::xchangeStrings) )
			+ ubutton("Quit"          + ucall(0, &UAppli::quit) )
		);

	UBox& box2 = uhbox
  (
			ulabel(color + bgcolor + str + UFont::bold + " World!")
			+ ulabel(color + bgcolor + str + UColor::blue + " User!")
			+ ulabel(color + bgcolor + str + UPix::bomb
												+ UColor::green + UFont::italic + " Mister X" + UPix::ray)
			);

	addlist(box1 + box2);
}

