#include <ubit/ubit.hpp>
#include <ubit/ext/upersp.hpp>

//================================================================

UPerspbar::UPerspbar(const UArgs& a) {
  // no automatic update:
  colscale.setAutoUpdate(false);

  // add 'colscale' at the beginning of the list!
  addlist(colscale + a);
}

void UPerspbar::setScale(int sc) {
  //NB (in constr): no automatic update:  colscale.setAutoUpdate(false);
  colscale.set(sc);
}

//================================================================

UPersp::UPersp(const UArgs& a) : UPane(a) {
  is_persp_mode = false;
  focus      = 0;
  mag_factor = 2;

  addAttr(uwidth(UWidth::AUTO_RESIZE));
  addAttr(uheight(UHeight::AUTO_RESIZE));

  addlist(bar_container);
}

void UPersp::addBar(UPerspbar& bar, int pos, bool update) {
  // add to subcomponent 'box' not to pane itself
  bar.add(UOn::action / ucall(this, &bar,  &UPersp::goSelf));
  bar.add(UOn::enter  / ucall(this,  &bar, &UPersp::goSelf));
  bar_container.insert(pos, bar, update);
}

void UPersp::goLeft() {
  setFocus(focus-1);
}

void UPersp::goRight() {
  setFocus(focus+1);
}

void UPersp::goSelf(UEvent& e, UPerspbar *bar) {
  if (!is_persp_mode) return;

  int count = 0;
  UBrick **children = bar_container.getChildren(count);
  for (int k = 0; k < count; k++)
    if (children[k] == bar) {
      setFocus(k);
      updateLayout(e);
      return;
    } 
}

bool UPersp::isPerspMode() const {return is_persp_mode;}

void UPersp::setPerspMode(bool state) {
  is_persp_mode = state;
  setFocus(focus);
  update();
}

int UPersp::getFocus() const {return focus;}

void UPersp::setFocus(int new_focus) {
  int count = 0;
  UBrick **children = bar_container.getChildren(count);
  if (count == 0) {
    update();
    return;
  }

  if (new_focus < 0) focus = 0;
  else if (new_focus >= count) focus = count-1;
  else focus = new_focus;

  if (!is_persp_mode) {
    //    setXScroll(0); 
  }

  UPerspbar* bar = null;
  for (int k = 0; k < count; k++)
    if ((bar = dynamic_cast<UPerspbar*>(children[k]))) {
      int sc; 
      if (!is_persp_mode) sc = 0;
      else {
	if (k < focus) sc = (k-focus) * mag_factor;
	else sc = (focus-k) * mag_factor;
      }

      // false = dont update now (to avoid multi-updates and flicking)
      bar->setScale(sc);
    }

  delete[] children;  // dont forget to free memory!
}

void UPersp::updateLayout(UEvent& e) {
  // Pane's view
  UPaneView* pane_view = (UPaneView*)getView(0);
  // Focused Column's View
  UView *view = ((UBox*)bar_container.getChild(focus))->getView(0);

  u_pos x_in_view = e.getX();
  u_pos x_in_win =  e.getXwin();

  //invariants= x_in_win / x_percent
  float x_percent = (float)x_in_view / view->getWidth();
  /*
  cout << "x_in_view= " << x_in_view << "\n";
  cout << "x_in_win= " <<  x_in_win << "\n";
  cout << "x_view= " << view->getX() << "\n";
  cout << "2x_scroll " << pane_view->getXScroll() << "\n\n";
  */
  if (pane_view && view) {
    //if (mode != fixedFocusBar) pane_view->setXScroll(0);
    //else {
      pane_view->setXScroll(0);

      //recompute sizes but do not draw now
      UUpdate upd(UUpdate::LAYOUT);
      this->update(upd);

      x_in_view = int(x_percent * view->getWidth());
      //x_in_view + x_view_in_pane + x_scroll = x_in_pane;
      // int x_scroll = -(x_in_pane - view->getX() - x_in_view);

      //x_in_view + x_view_in_win + x_scroll = x_in_win;
      int x_scroll = -(x_in_win - view->getXwin() - x_in_view);
      /*
      cout << "2x_in_view= " << x_in_view << "\n";
      cout << "2x_view= " << view->getX() << "\n";
      cout << "2x_scroll " << x_scroll << "\n\n";
      */
      pane_view->setXScroll(x_scroll);
      //}

    // redraw everything NOW
    bar_container.update();
  }

  //focus_str.setInt(focus);  
}
