/* ==================================================== ======== ======= *
 *
 *  uboxImpl.hpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _uboxImpl_hpp_
#define	_uboxImpl_hpp_
//pragma ident	"@(#)uboxImpl.hpp	ubit:03.05.05"

// ====[internal implementation]===========================

class UBoxLink : public ULink {
public:
  UBoxLink(class UBox* _child) : ULink(_child), views(null) {}

  class UView* getViews() const {return views;}
  class UView* getView(class UDisp*) const;
  void addView(class UView*);
  
  class UView* getViewInside(class UView* parent_view) const;
  class UView* getViewInsideSize(class UView* parent_view, u_dim *w, u_dim *h) const;
  ///< returns the view that is inside a given parent view

private:
  friend class UBox;
  friend class UWin;
  class UView* views;
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
