/* ==================================================== ======== ======= *
 *
 *  uerror.hh
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _uerror_hh
#define	_uerror_hh
//pragma ident	"@(#)uerror.hh	ubit:03.04.00"


class UError {
public:
  typedef const char* err_mesg;
  static err_mesg
    No_more_memory, 
    Null_argument,
    Null_or_invalid_argument,
    Null_arg_in_addlist,
    Warning_out_of_range,
    Child_not_found,
    Too_many_elements,
    Unexpected_type,
    Not_yet_implemented,

    Null_display,
    Unrealized_window,
    Cant_realize_window,
    Cant_realize_softwin,
    Cant_create_window,
    Cant_open_display,
    Invalid_screen,
    Null_external_window,

    Cant_realize_wingraph,
    Unbalanced_request,
    Cant_retreive_font,
    Invalid_font_size,
    Unknown_color,
    Full_colormap,
    Null_colormap,

    Null_width_or_height,
    Incompatible_depths,
    Unrealized_image,
    Blending_requires_TrueColor,

    Cant_retreive_context,
    Cant_retreive_style,
    Cant_locate_source,
    Should_not_be_realized,
    Wrong_table_child,
    Wrong_row_child;

  const char* id;
  const char* msg;
  char* const arg;

  UError(const char* id, const char* msg, const char* arg);
  ~UError();

  static void error(const char* id, const char* msg);
  static void error(const char* id, const char* msg, long arg);
  static void error(const char* id, const char* msg, const char* arg);
  static void error(const char* id, const char* msg, const UStr& arg);
  static void error(const char* id, const char* msg, const std::string& arg);
  /**<
   * throws an error (and prints an error message).
   * arguments:
   * - 'id' is in the form "class::function" or "type@class::function"
   *        with type being one of: warning, fatal, internal 
   * - 'msg' is the error message
   * See also: UBrick::error()
   */

private:

  static void process_error(const char* id, const char *errmsg, 
			    bool has_arg, const char* arg);
};
#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
