/* ==================================================== ======== ======= *
 *
 *  uscrollbar.hpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _uscrollbar_hpp_
#define	_uscrollbar_hpp_
//pragma ident "@(#)uscrollbar.hpp		ubit:03.06.03"
#include <ubit/ugadgets.hpp>
#include <ubit/uprop.hpp>
#include <ubit/ucolor.hpp>
#include <ubit/uview.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
/** Scrollbar gadget.
 *  UOn::change callbacks are activated when the scrollbar value is changed.
 */
class UScrollbar: public UBox {
public:
  static class UScrollbarStyle *style;

  enum Modes {
    STANDARD = 1, TRANSP= 1<<1, WITH_RAIL = 1<<2 , WITH_FEEDBACK = 1<<3
    //COMPACT_EVENTS = 1<<5
  };

  UScrollbar(const UArgs& = UArgs::none);
  UScrollbar(const class UOrient&, const UArgs& = UArgs::none);
  UScrollbar(UFloat& value, const class UOrient&, const UArgs& = UArgs::none);
  /**< 
   * constructors (default orientation is UOrient::Vertical)
   * constructor: see also shortcut creator uscrollbar() and UGroup::~UGroup().
   * - 'orient' can be UOrient::horizontal or UOrient::vertical.
  */

  ~UScrollbar();

  friend UScrollbar& uscrollbar(const UOrient&, const UArgs& a = UArgs::none);
  ///< shortcut creator: see constructor.

  friend UScrollbar& uhscrollbar(const UArgs& a = UArgs::none);
  ///< shortcut creator: creates a new horizontal scrollbar

  friend UScrollbar& uvscrollbar(const UArgs& a = UArgs::none);
  ///< shortcut creator: creates a new vertical scrollbar

  virtual const UStyle& getStyle(UContext*) const;

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  bool isHorizontal() const;
  bool isVertical() const;

  float getValue() const;
  UFloat& value()  const {return *pvalue;}

  void setValue(const UFloat& percent);
  void setValue(float percent, bool update_pane = true);
  /**< gets/sets scrollbar value (float between 0 and 100).
   * Note: UOn::change callbacks are activated when the value is changed.
   */

  float getScrollerIncrement() const;
  void  setScrollerIncrement(float percent);
  ///< get/sets value increment when clicking on a Scroller (float between 0 and 100).

  float getBackgroundIncrement() const;
  void  setBackgroundIncrement(float percent);
  ///< get/sets value increment when clicking on the background of the scrollbar (float between 0 and 100).

  void setUpdateOnDrag(bool state = true);
  ///< update on drag is the default.

  bool isTransparent() const;
  void setTransparent(bool state);

  void setPane(class UPane*);
  ///< [impl] attaches the scrollbar to a UPane or a UScrollpane.

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // imbricated gadgets

protected:
  class LessScroller: public UButton {
  public:
    static class UStyle* style;
    LessScroller(const UArgs&);
    virtual const UStyle& getStyle(UContext*) const;
  };

  class MoreScroller: public UButton {
  public:
    static class UStyle* style;
    MoreScroller(const UArgs&);
    virtual const UStyle& getStyle(UContext*) const;
  };

  virtual UBox& createRail(const UArgs& = UArgs::none);
  virtual UBox& createSlider(const UArgs& = UArgs::none);
  virtual UBox& createLessScroller(const UArgs& = UArgs::none);
  virtual UBox& createMoreScroller(const UArgs& = UArgs::none);

#ifndef NO_DOC

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // implementation

  friend class UScrollbarView;
  friend class UPane;
  
  UOrient orient;		// orientation
  float scroller_increment, backgd_increment; // increments
  uptr<class UFloat> pvalue;	// scrollbar value (percentage)
  uptr<class UPane>  ppane;	// the pane controlled by this scrollbar

  uptr<UBox> pless_btn, pmore_btn, pslider_btn, pslider_box;
  UBgcolor bgcolor, slider_bgcolor, rail_bgcolor;
  UAlpha slider_alpha, rail_alpha;
  uptr<class UBorder> rail_border;
  UPos slider_pos;		// current position of the slider

  bool pressed, entered;
  bool transparent, with_rail, enter_feedback, drag_feedback, incremental_mode;
  u_pos delta_mouse;
  
  virtual void constructs();

  void setValueImpl(float percent, bool upd);
  ///< [impl] does not update the associated pane.

  virtual void pressSlider(UEvent&);
  virtual void releaseSlider(UEvent&);
  virtual void dragSlider(UEvent&);
  virtual void enterSlider(UEvent&);
  virtual void leaveSlider(UEvent&);
  virtual void pressScroller(UEvent&, int dir);

  virtual void pressSliderBox(UEvent&);
  virtual void releaseSliderBox(UEvent&);
  virtual void dragSliderBox(UEvent&);
  virtual void enterSliderBox(UEvent&);
  virtual void leaveSliderBox(UEvent&);

  virtual float getPercent(UEvent&, UView *slider_btn_view, 
			   UView *slider_box_view, u_dim delta_mouse);
#endif
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

/** Scrollbar View Renderer.
*  used by: UScrollbar
*  - Implementation: clients usually don't need to use this class
*/
class UScrollbarView : public UView {
public:
  static  UViewStyle style;  // renderer
  virtual UViewStyle* getViewStyle() {return &style;}

  UScrollbarView(UBoxLink*, UView* parview, UWinGraph*);
  virtual void setScroll(float percent);

#ifndef NO_DOC
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // implementation

  friend class UScrollbar;
  static UView* makeView(UBoxLink*, UView* parview, UWinGraph*);
  virtual bool doLayout(UContext&, class UViewLayout&);
  virtual void doUpdate(UContext&, URegion r, URegion clip, class UViewUpdate&);

private:
    //int scrollmin, scrollmax;
#endif
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */


