#!/usr/local/bin/perl
# index.cgi
# Just display the current user's quotas

require './quota-lib.pl';
&ui_print_header(undef, $text{'index_title'}, "", undef, 0, 1);

@st = stat($remote_user_info[7]);	# force mount of home dir
$n = &user_filesystems($remote_user);
if ($n) {
	print "<h3>",&text('index_quotas', "<tt>$remote_user</tt>"),"</h3>\n";
	&quotas_table();
	}
else {
	print "<p><b>$text{'index_none'}</b><p>\n";
	}

if (&quotas_supported() >= 2) {
	foreach $gid ($remote_user_info[3], &other_groups($remote_user)) {
		($g = getgrgid($gid)) || next;
		$n = &group_filesystems($g);
		if ($n > 0) {
			print "<h3>",&text('index_gquotas', "<tt>$g</tt>"),"</h3>\n";
			&quotas_table();
			}
		}
	}

&ui_print_footer("/", $text{'index'});

sub quotas_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><br></td>\n";
$cols = 3 + ($config{'show_grace'} ? 1 : 0);
print "<td colspan=$cols align=center><b>$text{'ufilesys_blocks'}</b></td>\n";
print "<td colspan=$cols align=center><b>$text{'ufilesys_files'}</b></td> </tr>\n";
print "<tr $tb> <td><b>$text{'ufilesys_fs'}</b></td>\n";
print "<td><b>$text{'ufilesys_used'}</b></td> <td><b>$text{'ufilesys_soft'}</b></td>\n";
print "<td><b>$text{'ufilesys_hard'}</b></td>\n";
print "<td><b>$text{'ufilesys_grace'}</b></td>\n"
	if ($config{'show_grace'});
print "<td><b>$text{'ufilesys_used'}</b></td> <td><b>$text{'ufilesys_soft'}</b></td>\n";
print "<td><b>$text{'ufilesys_hard'}</b></td>\n";
print "<td><b>$text{'ufilesys_grace'}</b></td>\n"
	if ($config{'show_grace'});
print "</tr>\n";
for($i=0; $i<$n; $i++) {
	$f = $filesys{$i,'filesys'};
	print "<tr $cb>\n";
	print "<td>$f</td>\n";
	print "<td>$filesys{$i,'ublocks'}</td>\n";
	&print_limit($filesys{$i,'sblocks'});
	&print_limit($filesys{$i,'hblocks'});
	&print_grace($filesys{$i,'gblocks'}) if ($config{'show_grace'});
	print "<td>$filesys{$i,'ufiles'}</td>\n";
	&print_limit($filesys{$i,'sfiles'});
	&print_limit($filesys{$i,'hfiles'});
	&print_grace($filesys{$i,'gfiles'}) if ($config{'show_grace'});
	print "</tr>\n";
	}
print "</table><br>\n";
}

