/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2001 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef FILEBLOCK_H
#define FILEBLOCK_H

#include <Types.h>

#include <qlist.h>
#include <qstring.h>
#include <qdatetime.h>

class DataPoint;

class QFile;

class FileBlock
{
public:
  FileBlock();
  virtual ~ FileBlock();
  
  FileBlock( const FileBlock& );
  FileBlock& operator= ( const FileBlock& );
  
  bool openFile( const QString& filename );

  const QString& filename() const;
  QList<DataPoint>& data();
  
  void dump();
  
private:
  void readFile( QFile& );
  void copy( const FileBlock& source );
  
private:
  QString filename_;
  QString extension_;
  QDateTime lastModified_;
  bool isRead_;
  TReal impedance_;
  QList<DataPoint> data_;
};

#endif
