/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <ModifySmithWindow.h>

#include <Setup.h>
#include <Strings.h>
#include <SmithDefinition.h>
#include <MainWindow.h>
#include <NavigationWindow.h>

#include <qlabel.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qapplication.h>
#include <qvalidator.h>

#include <iostream>

//----------------------------------------------------------------------------
ModifySmithWindow::ModifySmithWindow( QWidget* parent, const char* name )
    : QDialog(parent, name, TRUE),
    topLayout_(0),
    smith_(0)
{
  setCaption( name );

  topLayout_ = new QVBoxLayout( this );
  QGridLayout* gridLayout = new QGridLayout ( 0 );
  QHBoxLayout* buttonLayout = new QHBoxLayout( 0 );

  topLayout_->addSpacing( 10 );
  topLayout_->addItem( gridLayout );
  topLayout_->addSpacing( 10 );
  topLayout_->addItem( buttonLayout );

  QString okLabel = Strings::translate( Strings::LabelOk );
  QString cancelLabel = Strings::translate( Strings::LabelCancel );
  QPushButton* ok = new QPushButton( okLabel, this );
  QPushButton* cancel = new QPushButton( cancelLabel, this );

  buttonLayout->addWidget( ok );
  buttonLayout->addWidget( cancel );

  connect ( ok, SIGNAL( clicked() ),
            this, SLOT( ok() ) );
  connect ( cancel, SIGNAL( clicked() ),
            this, SLOT( cancel() ) );

  QStringList labelText;
  labelText += Strings::LabelSmithTitle;

  gridLayout->expand( 4, labelText.count() );
  gridLayout->addColSpacing( 0, 30 );
  gridLayout->addColSpacing( 1, 100 );
  gridLayout->addColSpacing( 2, 10 );
  gridLayout->addColSpacing( 3, 100 );
  gridLayout->addColSpacing( 4, 30 );

  for ( uint n=0; n<labelText.count(); n++ )
    {
      gridLayout->addRowSpacing( n, 35 );
    }

  for ( uint i = 0; i < labelText.count(); i++ )
    {
      QString msg = Strings::translate( labelText[i] );
      QLabel* label = new QLabel( msg, this );
      labelList_.append( label );
      gridLayout->addWidget( label, i, 1 );
      QLineEdit* edit = new QLineEdit( this );
      lineEditMap_[ labelText[i] ] = edit;
      gridLayout->addWidget( edit, i, 3 );
    }

  resize( topLayout_->sizeHint() );
}

//----------------------------------------------------------------------------
ModifySmithWindow::~ModifySmithWindow()
{
  delete topLayout_;
}

//----------------------------------------------------------------------------
void ModifySmithWindow::destroyWidgets()
{
  QMap< QString, QLineEdit* >::Iterator it;
  for( it = lineEditMap_.begin(); it != lineEditMap_.end(); it++ )
    {
      delete (QLineEdit*) it.data();
      it.data() = 0;
    }
  lineEditMap_.clear();
  labelList_.clear();
}

//----------------------------------------------------------------------------
void ModifySmithWindow::ok()
{
  smith_->setTitle( lineEditMap_[Strings::LabelSmithTitle]->text() );
  smith_->reDraw();
  smith_ = 0;
  close();
}

//----------------------------------------------------------------------------
void ModifySmithWindow::cancel()
{
  smith_ = 0;
  close();
}

//----------------------------------------------------------------------------
void ModifySmithWindow::initialize( const QString& name )
{
  smith_ = MainWindow::instance()->findSmith( name );
  ASSERT( smith_ != 0 );
  lineEditMap_[Strings::LabelSmithTitle]->setText( smith_->getTitle() );
}
