/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <SetDimensionValueWindow.h>

#include <Setup.h>
#include <Strings.h>
#include <NavigationWindow.h>

#include <qlabel.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qapplication.h>

#include <iostream>

//----------------------------------------------------------------------------
SetDimensionValueWindow::SetDimensionValueWindow( QWidget* parent, const char* name )
    : QDialog(parent, name, TRUE),
    topLayout_(0),
    label_(0),
    edit_(0)
{
  setCaption( name );

  topLayout_ = new QVBoxLayout( this );
  QGridLayout* gridLayout = new QGridLayout ( 0 );
  QHBoxLayout* buttonLayout = new QHBoxLayout( 0 );

  topLayout_->addSpacing( 10 );
  topLayout_->addItem( gridLayout );
  topLayout_->addSpacing( 10 );
  topLayout_->addItem( buttonLayout );

  QString okLabel = Strings::translate( Strings::LabelOk );
  QString cancelLabel = Strings::translate( Strings::LabelCancel );
  QPushButton* ok = new QPushButton( okLabel, this );
  QPushButton* cancel = new QPushButton( cancelLabel, this );

  buttonLayout->addWidget( ok );
  buttonLayout->addWidget( cancel );

  connect ( ok, SIGNAL( clicked() ),
            this, SLOT( ok() ) );
  connect ( cancel, SIGNAL( clicked() ),
            this, SLOT( cancel() ) );

  label_ = new QLabel( this );
  edit_ = new QComboBox( this );

  gridLayout->expand( 1, 5 );
  gridLayout->addColSpacing( 0, 30 );
  gridLayout->addColSpacing( 1, 100 );
  gridLayout->addColSpacing( 2, 10 );
  gridLayout->addColSpacing( 3, 100 );
  gridLayout->addColSpacing( 4, 30 );

  gridLayout->addWidget( label_, 0, 1 );
  gridLayout->addWidget( edit_, 0, 3 );

  resize( topLayout_->sizeHint() );
}

//----------------------------------------------------------------------------
SetDimensionValueWindow::~SetDimensionValueWindow()
{}

//----------------------------------------------------------------------------
void SetDimensionValueWindow::ok()
{
  close();
  QString name = label_->text();
  QString value = edit_->currentText();
  DimensionDefinition* dimension = Setup::instance()->getDimensionDefinition( name, TRUE );
  ASSERT( dimension != 0 );
  dimension->setActiveValue( value );
  NavigationWindow::instance()->updateDimension( name, value );
  close();
}

//----------------------------------------------------------------------------
void SetDimensionValueWindow::cancel()
{
  close();
}

//----------------------------------------------------------------------------
void SetDimensionValueWindow::initialize( const QString& dimensionName )
{
  edit_->clear();
  label_->setText( dimensionName );
  DimensionDefinition* dimension = Setup::instance()->getDimensionDefinition( dimensionName, TRUE );
  ASSERT( dimension != 0 );
  const QString& currentValue = dimension->getActiveValueName();
  int count = 0;
  int active = 0;
  int nrItems = dimension->nrEntries();
  for( int i = 0; i<nrItems; i++ )
    {
      const QString& value = dimension->entryName( i );
      edit_->insertItem( value );
      if ( value == currentValue )
        {
          active = count;
        }
      count ++;
    }
  edit_->setCurrentItem( active );
  resize( topLayout_->sizeHint() );
}
