// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: MsgAggregatingCommunicationManager.cpp
// 
//---------------------------------------------------------------------------

#include "TimeWarpSimulationManager.h"
#include "MsgAggregatingCommunicationManager.h"

MsgAggregatingCommunicationManager::MsgAggregatingCommunicationManager( PhysicalCommunicationLayer *physicalLayer, 
									TimeWarpSimulationManager *simMgr ) :
  CommunicationManagerImplementationBase(physicalLayer, simMgr),
  waitedWithNoInputMessages(0){
  unsigned int numSimMgrs = mySimulationManager->getNumberOfSimulationManagers();
  myMessageManager = new MessageManager(numSimMgrs, this, mySimulationManager,
					physicalLayer);
};

MsgAggregatingCommunicationManager::~MsgAggregatingCommunicationManager(){};

void
MsgAggregatingCommunicationManager::initializeCommunicationManager(){
  myMessageManager->initMessageManager(getId());
}

void
MsgAggregatingCommunicationManager::sendMessage(KernelMessage *msg,
                                                unsigned int dest){
  myMessageManager->sendMessage(msg, dest);
}

SerializedInstance *
MsgAggregatingCommunicationManager::retrieveMessageFromPhysicalLayer(){
  return myMessageManager->receiveMessage();
}

unsigned int
MsgAggregatingCommunicationManager::checkPhysicalLayerForMessages(int maxNum){
  int numberOfMessagesReceived = 0;
  bool noMessagesLeft = false;
  SerializedInstance *msg = NULL;

  while(numberOfMessagesReceived != maxNum && noMessagesLeft == false){
    msg = retrieveMessageFromPhysicalLayer();
    if(msg == NULL){
      // there are no messages at this time
      noMessagesLeft = true;
      waitedWithNoInputMessages++;
    }
    else {
      // there are messages to pick up
      numberOfMessagesReceived++;
      waitedWithNoInputMessages = 0;
         
      // deserialize the message and route it to the appropriate
      // receiver
      routeMessage(dynamic_cast<KernelMessage *>(msg->deserialize()));
      // since we allocated it, we delete it
      delete [] msg;
    }
  }// end while loop
   
  return numberOfMessagesReceived;
}


