#ifndef DEFAULT_VISUALIZATION_MANAGER_H
#define DEFAULT_VISUALIZATION_MANAGER_H


// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: 
//          
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include <iostream>
#include <string>
#include <map>
#include "VisualizationManager.h"
#include <warped/Socket.h>

using std::string;
using std::map;
using std::cerr;

/** The DefaultVisualizationManager class.

    This is the class for visualization thingies.  More documentation to
    follow... 

        "It Better" -DJ

*/
class DefaultVisualizationManager : public VisualizationManager {
 public:

  /**@name Public Class Methods of DefaultVisualizationManager. */
  //@{

  /** Default constructor.

      @param void
   */
  DefaultVisualizationManager(TimeWarpSimMgrWithVisualization *, 
			      map<const string, string>& configurationMap);

  /// destructor
  ~DefaultVisualizationManager();

  int openVisualizationObject(const char *name, 
			      VisualizationManager::DisplayKind kind, 
			      VisualizationManager::VisualizationTools vizTools);
 
  int openVisualizationObject(const char *name, 
			      VisualizationManager::DisplayKind kind, 
			      VisualizationManager::VisualizationTools vizTools, 
			      VisualizationManager::DataType, void *);


  void closeVisualizationObject(int);

  void addListener(int, void *);
  void updateVisalizationValue(int);

  void receiveData(char *);

protected:

  Socket *server;

private:

};

#endif
