# Functions for parsing the system log for iptables entries

do '../web-lib.pl';
&init_config();
do '../ui-lib.pl';
&foreign_require("firewall", "firewall-lib.pl");
&foreign_require("syslog", "syslog-lib.pl");
&foreign_require("cron", "cron-lib.pl");
&foreign_require("net", "net-lib.pl");

%access = &get_module_acl();

$bandwidth_log = "/var/log/bandwidth";
$hours_dir = "$module_config_directory/hours";
$cron_cmd = "$module_config_directory/rotate.pl";

# list_hours()
# Returns a list of all hours for which traffic is available
sub list_hours
{
opendir(DIR, $hours_dir);
local @rv = grep { $_ ne "." && $_ ne ".." } readdir(DIR);
closedir(DIR);
return @rv;
}

# get_hour(num)
sub get_hour
{
local $file = "$hours_dir/$_[0]";
local %hour;
&read_file($file, \%hour);
return \%hour;
}

# save_hour(hour)
sub save_hour
{
mkdir($hours_dir, 0755);
local $file = "$hours_dir/$_[0]->{'hour'}";
&write_file($file, $_[0]);
}

# find_rule(&table, chain, interface, dir)
sub find_rule
{
local ($table, $chain, $iface, $dir) = @_;
local $r;
local $dd = $dir eq "i" ? "IN" : "OUT";
foreach $r (@{$table->{'rules'}}) {
	next if ($r->{'chain'} ne $chain);
	local $da = $r->{$dir};
	if ($iface) {
		next if ($da->[1] ne $iface);
		}
	else {
		next if (!$da);
		}
	next if ($r->{'j'}->[1] ne 'LOG');
	next if ($r->{'args'} !~ /\-\-log\-prefix\s+BANDWIDTH_\Q$dd\E:/ &&
		 $r->{'args'} !~ /\-\-log\-prefix\s+"BANDWIDTH_\Q$dd\E:"/ &&
		 $r->{'logprefix'}->[1] ne "BANDWIDTH_$dd");
	return $r;
	}
return undef;
}

# find_sysconf(&conf)
# Returns the syslog entry for kernel debug messages to the log file
sub find_sysconf
{
local ($conf) = @_;
local $c;
foreach $c (@$conf) {
	next if (!$c->{'active'});
	next if ($c->{'file'} ne $bandwidth_log);
	next if ($c->{'sel'}->[0] ne "kern.=debug" &&
		 $c->{'sel'}->[0] ne "kern.*=debug");
	return $c;
	}
return undef;
}

# find_cron_job()
# Returns the cron job used for bandwidth counting, or undef
sub find_cron_job
{
local @jobs = &cron::list_cron_jobs();
local ($job) = grep { $_->{'user'} eq 'root' &&
		      $_->{'command'} eq $cron_cmd &&
		      $_->{'active'} } @jobs;
return $job;
}

# date_input(day, month, year, prefix)
sub date_input
{
return &ui_textbox("$_[3]_day", $_[0], 2)."/".
       &ui_select("$_[3]_month", $_[1],
		  [ map { [ $_, $text{"smonth_".$_} ] } (1 .. 12) ])."/". 
       &ui_textbox("$_[3]_year", $_[2], 4).
       &date_chooser_button("$_[3]_day", "$_[3]_month", "$_[3]_year");
}

# hourmin_input(hour, min, prefix)
sub hourmin_input
{
return &ui_textbox("$_[2]_hour", $_[0], 2).":".
       &ui_textbox("$_[2]_min", $_[1], 2);
}

1;

