/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "ipchains.h"
#include "conf.h"


wf_outmodule_ipchains::wf_outmodule_ipchains() :
  wf_outmodule()
{
  conf = new wf_outmodule_ipchains_conf();
}


bool
wf_outmodule_ipchains::print(const wf_logentry* entry, ostream& os) {
  char datestr[32];
  strftime(datestr, sizeof(datestr), "%b %d %H:%M:%S ",
	   localtime(&(entry->start_time)));

  os << datestr << entry->hostname << " kernel: Packet log: " <<
    entry->chainlabel << " " << entry->branchname << " ";
  if (entry->chainlabel == "input")
    os << entry->input_iface;
  else if (entry->chainlabel == "output" || entry->chainlabel == "forward")
    os << entry->output_iface;
  else {
    if (entry->input_iface.empty() == false)
      os << entry->input_iface;
    else if (entry->output_iface.empty() == false)
      os << entry->output_iface;
    else
      return false; /* this shouldn't happen */
  }

  os << " PROTO=" << entry->protocol << " " <<
    entry->sipaddr << ":" <<  entry->sport << " " <<
    entry->dipaddr << ":" <<  entry->dport << " " <<
    "L=" << entry->datalen << " S=0x00 I=0 F=0x0000 T=0";
  if (entry->tcpflags)
    os << entry->tcpflags_tostr();
  os << " (#0)";
  
  return true;
}

/*
bool
wf_outmodule_ipchains::print(const wf_logentries& logentries,
			     ostream& os) const;

  Here we use native (herited) outmodule method.
*/

extern "C" wf_outmodule*
wf_outmodule_ipchains_init() {
  return new wf_outmodule_ipchains();
}
